// stdlib
pub(crate) use std::{
  fmt::{self, Display, Formatter},
  io::Write,
  iter::Peekable,
  process,
  slice::Iter,
  str::Chars,
};

// dependencies
pub(crate) use {
  dirs::home_dir,
  rustyline::Editor,
  snafu::Snafu,
  structopt::StructOpt,
  termcolor::{Color, ColorChoice, ColorSpec, StandardStream, WriteColor},
};

// structs and enums
pub(crate) use crate::{
  error::Error,
  expr::Expr,
  lexer::Lexer,
  op::Op,
  parser::Parser,
  token::Token::{self, *},
};

// type aliases
pub(crate) type Result<T, E = Error> = std::result::Result<T, E>;
