#pragma once

typedef struct {
  uint8_t *input;
  size_t input_len;
  uint8_t tag_256[32];
  uint8_t tag_512[64];
} sha2mb_test_vector;

static uint8_t in0[71] = { 0 };

static uint8_t in1[71] = { 1 };

static uint8_t in2[71] = { 2 };

static uint8_t in3[71] = { 3 };

static uint8_t in4[71] = { 4 };

static uint8_t in5[71] = { 5 };

static uint8_t in6[71] = { 6 };

static uint8_t in7[71] = { 7 };



static sha2mb_test_vector vectors_mb[] = {
  {
    .input = in0,
    .input_len = sizeof(in0),
    .tag_256 = {
      0x08U, 0x05U, 0xdcU, 0xdcU, 0x42U, 0xcaU, 0x47U, 0xabU,
      0xdcU, 0x3dU, 0x8fU, 0xe1U, 0x1fU, 0x8eU, 0x0cU, 0x7aU,
      0x10U, 0x86U, 0x02U, 0x02U, 0x2fU, 0x71U, 0xabU, 0x34U,
      0x96U, 0x48U, 0xcfU, 0xddU, 0x30U, 0xa7U, 0x5aU, 0xa6U
    },
    .tag_512 = {
      0xe1U, 0x40U, 0x30U, 0x27U, 0xc2U, 0xf5U, 0x5dU, 0x2dU,
      0xc4U, 0x97U, 0x2bU, 0x35U, 0xb1U, 0x6eU, 0x94U, 0x01U,
      0xd0U, 0xa9U, 0xb5U, 0xe0U, 0x55U, 0x83U, 0x9eU, 0x65U,
      0x0bU, 0x24U, 0x2fU, 0xb1U, 0x20U, 0x51U, 0x05U, 0x1fU,
      0x72U, 0xefU, 0x76U, 0x02U, 0x14U, 0xbfU, 0x43U, 0x6bU,
      0xa9U, 0xddU, 0x2bU, 0x0dU, 0x67U, 0xdaU, 0xa2U, 0xd5U,
      0x5aU, 0x78U, 0x3eU, 0x78U, 0x27U, 0x17U, 0xd5U, 0x39U,
      0x66U, 0x46U, 0x5bU, 0x8cU, 0x29U, 0x1aU, 0xcbU, 0xfcU
    }
  },
  {
    .input = in1,
    .input_len = sizeof(in1),
    .tag_256 = {
      0x1dU, 0x58U, 0x97U, 0x25U, 0x35U, 0xc7U, 0xf7U, 0x67U,
      0x91U, 0xa4U, 0x82U, 0xb9U, 0xd8U, 0xfcU, 0x23U, 0xefU,
      0x80U, 0x08U, 0x36U, 0x5fU, 0x93U, 0xeeU, 0x67U, 0x06U,
      0xafU, 0x55U, 0xdcU, 0x2cU, 0xd9U, 0xbaU, 0x27U, 0x00U
    },
    .tag_512 = {
      0x97U, 0x01U, 0xf4U, 0xd7U, 0x0cU, 0x51U, 0xf9U, 0x42U,
      0x6eU, 0x3fU, 0xdeU, 0xa6U, 0x33U, 0x7fU, 0x1eU, 0xa9U,
      0x18U, 0xf5U, 0x82U, 0xbfU, 0xceU, 0xd0U, 0x35U, 0x62U,
      0x79U, 0xd0U, 0xf5U, 0x36U, 0xe9U, 0x57U, 0xe4U, 0xaeU,
      0x42U, 0xe9U, 0x59U, 0xc0U, 0x53U, 0x14U, 0xe2U, 0x21U,
      0x6dU, 0x72U, 0x65U, 0xffU, 0x2dU, 0x04U, 0xd3U, 0x70U,
      0xb9U, 0x53U, 0x95U, 0x79U, 0xdaU, 0x0cU, 0x0cU, 0x09U,
      0xd5U, 0x96U, 0x48U, 0x45U, 0x64U, 0x8fU, 0x60U, 0xecU
    }
  },
  {
    .input = in2,
    .input_len = sizeof(in2),
    .tag_256 = {
      0xb9U, 0xc8U, 0xc7U, 0x6fU, 0x77U, 0x4aU, 0x0eU, 0x85U,
      0xffU, 0x69U, 0x3cU, 0x4eU, 0x90U, 0x2aU, 0x93U, 0xdbU,
      0x24U, 0x1cU, 0xcbU, 0x12U, 0xb3U, 0xf1U, 0xf0U, 0xefU,
      0xbeU, 0xaaU, 0x94U, 0x2dU, 0x75U, 0xb4U, 0x05U, 0x18U
    },
    .tag_512 = {
      0xc1U, 0xc1U, 0x9cU, 0x98U, 0x87U, 0x27U, 0xb7U, 0x1fU,
      0x49U, 0x3cU, 0x07U, 0x58U, 0x5aU, 0x9bU, 0x71U, 0x87U,
      0xe0U, 0x61U, 0x5fU, 0x1cU, 0x39U, 0x5aU, 0xe9U, 0x4cU,
      0x23U, 0x4eU, 0xb0U, 0x66U, 0x1aU, 0xd7U, 0x3aU, 0x53U,
      0x7fU, 0x30U, 0x60U, 0xd5U, 0xd4U, 0x7bU, 0xbbU, 0x62U,
      0xf0U, 0x40U, 0x4dU, 0x5cU, 0x8dU, 0x19U, 0x0bU, 0x3fU,
      0x84U, 0xb5U, 0xf2U, 0x46U, 0x21U, 0x57U, 0x59U, 0xcdU,
      0x73U, 0x99U, 0x3aU, 0x22U, 0xf8U, 0x80U, 0xc5U, 0xd2U
    }
  },
  {
    .input = in3,
    .input_len = sizeof(in3),
    .tag_256 = {
      0xf9U, 0xecU, 0x97U, 0xb9U, 0x0aU, 0xa6U, 0x87U, 0xe4U,
      0xb8U, 0x94U, 0x08U, 0x77U, 0x71U, 0x9dU, 0xfdU, 0x34U,
      0xa5U, 0x9dU, 0xd9U, 0xdeU, 0x09U, 0x57U, 0x41U, 0x24U,
      0x0fU, 0x43U, 0x7aU, 0x65U, 0x79U, 0x5dU, 0x77U, 0x0fU
    },
    .tag_512 = {
      0xfeU, 0xf4U, 0x66U, 0x99U, 0x9aU, 0x9eU, 0x27U, 0x66U,
      0xb4U, 0x35U, 0xefU, 0x5bU, 0x1aU, 0x8aU, 0xa9U, 0x88U,
      0xa9U, 0x1aU, 0x56U, 0x25U, 0xd9U, 0x2fU, 0x47U, 0xbfU,
      0x1aU, 0xdcU, 0x56U, 0xf9U, 0x1eU, 0x40U, 0x7fU, 0x0fU,
      0x04U, 0xb9U, 0xa8U, 0xf0U, 0x4aU, 0x9aU, 0x4fU, 0x96U,
      0xdcU, 0x22U, 0xd1U, 0x6fU, 0x66U, 0x5aU, 0x6dU, 0xdaU,
      0x68U, 0x7cU, 0xe7U, 0xbaU, 0x13U, 0xcfU, 0x52U, 0xd5U,
      0x63U, 0x99U, 0xe4U, 0x41U, 0x49U, 0xb7U, 0x58U, 0xafU
    }
  },
  {
    .input = in4,
    .input_len = sizeof(in4),
    .tag_256 = {
      0x57U, 0xbdU, 0x61U, 0xf7U, 0x5eU, 0xdbU, 0x75U, 0x26U,
      0xbeU, 0x85U, 0xa0U, 0x76U, 0x53U, 0xe5U, 0x44U, 0x52U,
      0x6fU, 0x09U, 0xb5U, 0xfbU, 0xd7U, 0x0bU, 0xa2U, 0x68U,
      0x62U, 0xabU, 0x80U, 0xefU, 0x41U, 0x71U, 0xfaU, 0x3eU
    },
    .tag_512 = {
      0xfaU, 0x79U, 0x3cU, 0xf6U, 0x97U, 0x89U, 0xedU, 0xdaU,
      0x03U, 0xc0U, 0xa5U, 0x3dU, 0x7fU, 0x1aU, 0x73U, 0x3dU,
      0x5dU, 0x95U, 0x22U, 0x18U, 0x96U, 0x68U, 0x09U, 0xdaU,
      0x00U, 0xf8U, 0x71U, 0x85U, 0x57U, 0xebU, 0x82U, 0xf2U,
      0x56U, 0x5eU, 0xeeU, 0x98U, 0x55U, 0xe8U, 0x63U, 0x2bU,
      0x38U, 0xe4U, 0x67U, 0x16U, 0x84U, 0x9fU, 0xdfU, 0xd9U,
      0xa8U, 0x6cU, 0x74U, 0x80U, 0x22U, 0xbbU, 0xfcU, 0xb1U,
      0xffU, 0x20U, 0xa1U, 0xd3U, 0x7fU, 0x3aU, 0x29U, 0xfbU
    }
  },
  {
    .input = in5,
    .input_len = sizeof(in5),
    .tag_256 = {
      0x2aU, 0xf1U, 0xa4U, 0xb7U, 0x70U, 0xb7U, 0x89U, 0xbaU,
      0xd2U, 0xf5U, 0xdbU, 0x2fU, 0x0cU, 0xfeU, 0xfbU, 0xd3U,
      0xf2U, 0x2dU, 0xc2U, 0x80U, 0x87U, 0xe2U, 0xf9U, 0x2cU,
      0x80U, 0xbaU, 0xa9U, 0x43U, 0xafU, 0x90U, 0xedU, 0xe8U
    },
    .tag_512 = {
      0x1dU, 0xfeU, 0x4fU, 0x7bU, 0xe8U, 0x4aU, 0x74U, 0x48U,
      0xbbU, 0xf4U, 0xc6U, 0xb2U, 0xc4U, 0x77U, 0x53U, 0xcbU,
      0x73U, 0x7fU, 0x2dU, 0x71U, 0x9bU, 0x4bU, 0x90U, 0x0fU,
      0xb7U, 0x1eU, 0x23U, 0x32U, 0x99U, 0x21U, 0x92U, 0x6cU,
      0x75U, 0x74U, 0x93U, 0x16U, 0xbdU, 0xb2U, 0xffU, 0x32U,
      0x6fU, 0x18U, 0x9fU, 0xd4U, 0x02U, 0x85U, 0x09U, 0x97U,
      0x15U, 0xb3U, 0xe2U, 0xf4U, 0x12U, 0xa4U, 0xb9U, 0x1dU,
      0x09U, 0xbdU, 0x83U, 0x2cU, 0x79U, 0x65U, 0xa2U, 0xa7U
    }
  },
  {
    .input = in6,
    .input_len = sizeof(in6),
    .tag_256 = {
      0xd5U, 0xcbU, 0x76U, 0x70U, 0x2dU, 0x61U, 0x80U, 0x3bU,
      0x87U, 0x8aU, 0xf2U, 0x85U, 0xbcU, 0xb2U, 0xbaU, 0x86U,
      0x4bU, 0x3cU, 0x1bU, 0x43U, 0x75U, 0xf2U, 0x37U, 0xe5U,
      0x85U, 0xa4U, 0xa9U, 0xe6U, 0x9bU, 0x86U, 0xa5U, 0x7bU
    },
    .tag_512 = {
      0x2dU, 0x6aU, 0x29U, 0xa8U, 0xc7U, 0xceU, 0xeeU, 0x40U,
      0x42U, 0x51U, 0x7eU, 0x54U, 0xd9U, 0x19U, 0xc2U, 0xcaU,
      0xd1U, 0xa3U, 0xf4U, 0x7fU, 0x69U, 0x08U, 0x66U, 0xa3U,
      0xf7U, 0xfdU, 0x5aU, 0x68U, 0x66U, 0xbaU, 0xe4U, 0xd4U,
      0x6cU, 0xb6U, 0x05U, 0x34U, 0x77U, 0xebU, 0xf8U, 0x7aU,
      0xd7U, 0x4eU, 0x64U, 0x21U, 0xfeU, 0xacU, 0x88U, 0xc5U,
      0x70U, 0x4fU, 0x4dU, 0xfcU, 0x8eU, 0xb4U, 0x2dU, 0x3eU,
      0x09U, 0x2fU, 0xc1U, 0x90U, 0x3bU, 0x8fU, 0x92U, 0x48U
    }
  },
  {
    .input = in7,
    .input_len = sizeof(in7),
    .tag_256 = {
      0x1cU, 0x61U, 0xabU, 0xafU, 0x54U, 0xc1U, 0x82U, 0x60U,
      0xfaU, 0x1eU, 0xdfU, 0x01U, 0xb0U, 0x5fU, 0xf7U, 0xe7U,
      0xf0U, 0x64U, 0x9fU, 0x3fU, 0xbdU, 0x3eU, 0x46U, 0xebU,
      0x32U, 0xd9U, 0x65U, 0x26U, 0x50U, 0xd1U, 0x11U, 0xb8U
    },
    .tag_512 = {
      0x91U, 0x78U, 0x82U, 0x39U, 0xbaU, 0xc5U, 0xd0U, 0x07U,
      0xb1U, 0x04U, 0x87U, 0x0bU, 0x27U, 0xe8U, 0x7aU, 0x8aU,
      0x83U, 0x8aU, 0x9eU, 0x3cU, 0x1aU, 0xbaU, 0x5eU, 0xf7U,
      0xd1U, 0x33U, 0xc1U, 0x2eU, 0x84U, 0x29U, 0x1fU, 0xceU,
      0x06U, 0x53U, 0x8bU, 0x48U, 0x71U, 0x16U, 0xecU, 0x2bU,
      0x5bU, 0x29U, 0x29U, 0xb2U, 0xa8U, 0x05U, 0x48U, 0xcdU,
      0x7bU, 0xbfU, 0xfbU, 0x38U, 0xe1U, 0xb8U, 0xc5U, 0x70U,
      0xc0U, 0x8dU, 0xcfU, 0x3dU, 0x01U, 0xd6U, 0xdfU, 0x36U
    }
  }
};
