/* MIT License
 *
 * Copyright (c) 2016-2020 INRIA, CMU and Microsoft Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */


#include "internal/Hacl_Kremlib.h"



/* SNIPPET_START: max_uint32 */

static uint32_t max_uint32 = (uint32_t)4294967295U;

/* SNIPPET_END: max_uint32 */

/* SNIPPET_START: resize_ratio */

static uint32_t resize_ratio = (uint32_t)2U;

/* SNIPPET_END: resize_ratio */

/* SNIPPET_START: LowStar_Vector_new_capacity */

uint32_t LowStar_Vector_new_capacity(uint32_t cap)
{
  if (cap >= max_uint32 / resize_ratio)
  {
    return max_uint32;
  }
  if (cap == (uint32_t)0U)
  {
    return (uint32_t)1U;
  }
  return cap * resize_ratio;
}

/* SNIPPET_END: LowStar_Vector_new_capacity */

