#pragma once

#define MACBYTES   16
#define NONCEBYTES 24
#define KEYBYTES   32

typedef struct {
  uint8_t *input;
  size_t input_len;
  uint8_t nonce[NONCEBYTES];
  uint8_t secretkey1[KEYBYTES];
  uint8_t secretkey2[KEYBYTES];
  uint8_t *cipher;
  uint8_t mac[MACBYTES];
} naclbox_test_vector;

static uint8_t input1[72] = {
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
  0x08, 0x09, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
  0x16, 0x17, 0x18, 0x19, 0x20, 0x21, 0x22, 0x23,
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
  0x08, 0x09, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
  0x16, 0x17, 0x18, 0x19, 0x20, 0x21, 0x22, 0x23,
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
  0x08, 0x09, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
  0x16, 0x17, 0x18, 0x19, 0x20, 0x21, 0x22, 0x23
};

static uint8_t cipher1[72] = {
  0x9d, 0x80, 0x21, 0x77, 0x76, 0xf5, 0xdf, 0xf8,
  0x72, 0xc5, 0xd9, 0x8e, 0x5b, 0xe4, 0x66, 0x62,
  0x65, 0x35, 0x07, 0x0e, 0x45, 0x9f, 0x9f, 0x63,
  0x84, 0x0a, 0x8a, 0x8e, 0x67, 0xde, 0x37, 0x3f,
  0x1d, 0xbb, 0x74, 0x4e, 0x8b, 0xd2, 0x08, 0xdc,
  0xa4, 0xd1, 0x6a, 0xf1, 0xbc, 0x3c, 0xe3, 0xaa,
  0xe1, 0xf7, 0x7e, 0xe8, 0x00, 0x6c, 0x01, 0x5f,
  0xe0, 0xc8, 0x22, 0xb4, 0xc2, 0xb9, 0xbb, 0xc0,
  0x7f, 0x1d, 0xd9, 0x8c, 0xee, 0x07, 0x28, 0x77
};

static naclbox_test_vector vectors[] = {
  {
    .input = input1,
    .input_len = sizeof(input1)/sizeof(uint8_t),
    .nonce = {
      0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
      0x08, 0x09, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
      0x16, 0x17, 0x18, 0x19, 0x20, 0x21, 0x22, 0x23
    },
    .secretkey1 = {
      0x85, 0xd6, 0xbe, 0x78, 0x57, 0x55, 0x6d, 0x33,
      0x7f, 0x44, 0x52, 0xfe, 0x42, 0xd5, 0x06, 0xa8,
      0x01, 0x03, 0x80, 0x8a, 0xfb, 0x0d, 0xb2, 0xfd,
      0x4a, 0xbf, 0xf6, 0xaf, 0x41, 0x49, 0xf5, 0x1b
    },
    .secretkey2 = {
      0x85, 0xd6, 0xbe, 0x78, 0x57, 0x55, 0x6d, 0x33,
      0x7f, 0x44, 0x52, 0xfe, 0x42, 0xd5, 0x06, 0xa8,
      0x01, 0x03, 0x80, 0x8a, 0xfb, 0x0d, 0xb2, 0xfd,
      0x4a, 0xbf, 0xf6, 0xaf, 0x41, 0x49, 0xf5, 0x1c
    },
    .cipher = cipher1,
    .mac = {
      0x6c, 0xed, 0xbd, 0xce, 0x10, 0x86, 0xba, 0xf7,
      0xd5, 0x50, 0x6f, 0x1b, 0xbc, 0x52, 0x68, 0xaf
    }
  }
};
