#pragma once

typedef struct 
{
	uint8_t* publicX;
	uint8_t* publicY;
	uint32_t mLen;
	uint8_t* message;
	uint8_t* r;
	uint8_t* s;
	uint64_t flag;	
} 
	ecdsap256_w_i;


//Test vector 0:           "comment" : "signature malleability",

static uint8_t pkx_0  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_0  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen0 6 

static uint8_t msg_0  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_0  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_0  [32] = {
0x4c, 0xd6, 0x0b, 0x85, 0x5d, 0x44, 0x2f, 0x5b, 0x3c, 0x7b, 0x11, 0xeb, 0x6c, 0x4e, 0x0a, 0xe7, 0x52, 0x5f, 0xe7, 0x10, 0xfa, 0xb9, 0xaa, 0x7c, 0x77, 0xa6, 0x7f, 0x79, 0xe6, 0xfa, 0xdd, 0x76
}; 

#define result___0 0

//Test vector 1:           "comment" : "Legacy:ASN encoding of s misses leading 0",

static uint8_t pkx_1  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_1  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen1 6 

static uint8_t msg_1  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_1  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_1  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___1 1

//Test vector 2:           "comment" : "valid",

static uint8_t pkx_2  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_2  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen2 6 

static uint8_t msg_2  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_2  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_2  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___2 0

//Test vector 3:           "comment" : "wrong length of sequence",

static uint8_t pkx_3  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_3  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen3 6 

static uint8_t msg_3  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_3  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_3  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___3 18446744073709551615

//Test vector 4:           "comment" : "wrong length of sequence",

static uint8_t pkx_4  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_4  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen4 6 

static uint8_t msg_4  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_4  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_4  [32] = {
0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47
}; 

#define result___4 18446744073709551615

//Test vector 5:           "comment" : "uint32 overflow in length of sequence",

static uint8_t pkx_5  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_5  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen5 6 

static uint8_t msg_5  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_5  [32] = {

}; 

static uint8_t s_5  [32] = {

}; 

#define result___5 18446744073709551615

//Test vector 6:           "comment" : "uint64 overflow in length of sequence",

static uint8_t pkx_6  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_6  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen6 6 

static uint8_t msg_6  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_6  [32] = {

}; 

static uint8_t s_6  [32] = {

}; 

#define result___6 18446744073709551615

//Test vector 7:           "comment" : "length of sequence = 2**31 - 1",

static uint8_t pkx_7  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_7  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen7 6 

static uint8_t msg_7  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 8:           "comment" : "length of sequence = 2**32 - 1",

static uint8_t pkx_8  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_8  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen8 6 

static uint8_t msg_8  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 9:           "comment" : "length of sequence = 2**40 - 1",

static uint8_t pkx_9  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_9  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen9 6 

static uint8_t msg_9  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 10:           "comment" : "length of sequence = 2**64 - 1",

static uint8_t pkx_10  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_10  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen10 6 

static uint8_t msg_10  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 11:           "comment" : "incorrect length of sequence",

static uint8_t pkx_11  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_11  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen11 6 

static uint8_t msg_11  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_11  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_11  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___11 18446744073709551615

//Test vector 12:           "comment" : "indefinite length without termination",

static uint8_t pkx_12  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_12  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen12 6 

static uint8_t msg_12  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_12  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_12  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___12 18446744073709551615

//Test vector 13:           "comment" : "indefinite length without termination",

static uint8_t pkx_13  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_13  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen13 6 

static uint8_t msg_13  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 14:           "comment" : "indefinite length without termination",

static uint8_t pkx_14  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_14  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen14 6 

static uint8_t msg_14  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_14  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_14  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___14 18446744073709551615

//Test vector 15:           "comment" : "removing sequence",

static uint8_t pkx_15  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_15  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen15 6 

static uint8_t msg_15  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 16:           "comment" : "lonely sequence tag",

static uint8_t pkx_16  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_16  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen16 6 

static uint8_t msg_16  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 17:           "comment" : "appending 0's to sequence",

static uint8_t pkx_17  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_17  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen17 6 

static uint8_t msg_17  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_17  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_17  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___17 18446744073709551615

//Test vector 18:           "comment" : "prepending 0's to sequence",

static uint8_t pkx_18  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_18  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen18 6 

static uint8_t msg_18  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_18  [32] = {

}; 

static uint8_t s_18  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

#define result___18 18446744073709551615

//Test vector 19:           "comment" : "appending unused 0's to sequence",

static uint8_t pkx_19  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_19  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen19 6 

static uint8_t msg_19  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_19  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_19  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___19 18446744073709551615

//Test vector 20:           "comment" : "appending null value to sequence",

static uint8_t pkx_20  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_20  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen20 6 

static uint8_t msg_20  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_20  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_20  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___20 18446744073709551615

//Test vector 21:           "comment" : "including garbage",

static uint8_t pkx_21  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_21  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen21 6 

static uint8_t msg_21  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 22:           "comment" : "including garbage",

static uint8_t pkx_22  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_22  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen22 6 

static uint8_t msg_22  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_22  [32] = {

}; 

static uint8_t s_22  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___22 18446744073709551615

//Test vector 23:           "comment" : "including garbage",

static uint8_t pkx_23  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_23  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen23 6 

static uint8_t msg_23  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 24:           "comment" : "including garbage",

static uint8_t pkx_24  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_24  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen24 6 

static uint8_t msg_24  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_24  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_24  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___24 18446744073709551615

//Test vector 25:           "comment" : "including garbage",

static uint8_t pkx_25  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_25  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen25 6 

static uint8_t msg_25  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_25  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_25  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___25 18446744073709551615

//Test vector 26:           "comment" : "including garbage",

static uint8_t pkx_26  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_26  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen26 6 

static uint8_t msg_26  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_26  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_26  [32] = {
0xde, 0xad, 0xbe, 0xef
}; 

#define result___26 18446744073709551615

//Test vector 27:           "comment" : "including garbage",

static uint8_t pkx_27  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_27  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen27 6 

static uint8_t msg_27  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_27  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_27  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___27 18446744073709551615

//Test vector 28:           "comment" : "including garbage",

static uint8_t pkx_28  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_28  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen28 6 

static uint8_t msg_28  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_28  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_28  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___28 18446744073709551615

//Test vector 29:           "comment" : "including garbage",

static uint8_t pkx_29  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_29  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen29 6 

static uint8_t msg_29  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_29  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_29  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___29 18446744073709551615

//Test vector 30:           "comment" : "including undefined tags",

static uint8_t pkx_30  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_30  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen30 6 

static uint8_t msg_30  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_30  [32] = {

}; 

static uint8_t s_30  [32] = {

}; 

#define result___30 18446744073709551615

//Test vector 31:           "comment" : "including undefined tags",

static uint8_t pkx_31  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_31  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen31 6 

static uint8_t msg_31  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_31  [32] = {
0xaa, 0xbb
}; 

static uint8_t s_31  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___31 18446744073709551615

//Test vector 32:           "comment" : "including undefined tags",

static uint8_t pkx_32  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_32  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen32 6 

static uint8_t msg_32  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_32  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_32  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___32 18446744073709551615

//Test vector 33:           "comment" : "including undefined tags",

static uint8_t pkx_33  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_33  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen33 6 

static uint8_t msg_33  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_33  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_33  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___33 18446744073709551615

//Test vector 34:           "comment" : "including undefined tags",

static uint8_t pkx_34  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_34  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen34 6 

static uint8_t msg_34  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_34  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_34  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___34 18446744073709551615

//Test vector 35:           "comment" : "including undefined tags",

static uint8_t pkx_35  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_35  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen35 6 

static uint8_t msg_35  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_35  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_35  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___35 18446744073709551615

//Test vector 36:           "comment" : "truncated length of sequence",

static uint8_t pkx_36  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_36  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen36 6 

static uint8_t msg_36  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 37:           "comment" : "using composition with indefinite length",

static uint8_t pkx_37  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_37  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen37 6 

static uint8_t msg_37  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_37  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

static uint8_t s_37  [32] = {

}; 

#define result___37 18446744073709551615

//Test vector 38:           "comment" : "using composition with indefinite length",

static uint8_t pkx_38  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_38  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen38 6 

static uint8_t msg_38  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 39:           "comment" : "using composition with indefinite length",

static uint8_t pkx_39  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_39  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen39 6 

static uint8_t msg_39  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_39  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_39  [32] = {
0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00
}; 

#define result___39 18446744073709551615

//Test vector 40:           "comment" : "using composition with wrong tag",

static uint8_t pkx_40  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_40  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen40 6 

static uint8_t msg_40  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_40  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

static uint8_t s_40  [32] = {

}; 

#define result___40 18446744073709551615

//Test vector 41:           "comment" : "using composition with wrong tag",

static uint8_t pkx_41  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_41  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen41 6 

static uint8_t msg_41  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 42:           "comment" : "using composition with wrong tag",

static uint8_t pkx_42  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_42  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen42 6 

static uint8_t msg_42  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_42  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_42  [32] = {
0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00
}; 

#define result___42 18446744073709551615

//Test vector 43:           "comment" : "Replacing sequence with NULL",

static uint8_t pkx_43  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_43  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen43 6 

static uint8_t msg_43  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 44:           "comment" : "changing tag value of sequence",

static uint8_t pkx_44  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_44  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen44 6 

static uint8_t msg_44  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_44  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_44  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___44 18446744073709551615

//Test vector 45:           "comment" : "changing tag value of sequence",

static uint8_t pkx_45  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_45  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen45 6 

static uint8_t msg_45  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_45  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_45  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___45 18446744073709551615

//Test vector 46:           "comment" : "changing tag value of sequence",

static uint8_t pkx_46  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_46  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen46 6 

static uint8_t msg_46  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_46  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_46  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___46 18446744073709551615

//Test vector 47:           "comment" : "changing tag value of sequence",

static uint8_t pkx_47  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_47  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen47 6 

static uint8_t msg_47  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_47  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_47  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___47 18446744073709551615

//Test vector 48:           "comment" : "changing tag value of sequence",

static uint8_t pkx_48  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_48  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen48 6 

static uint8_t msg_48  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_48  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_48  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___48 18446744073709551615

//Test vector 49:           "comment" : "dropping value of sequence",

static uint8_t pkx_49  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_49  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen49 6 

static uint8_t msg_49  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 50:           "comment" : "using composition for sequence",

static uint8_t pkx_50  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_50  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen50 6 

static uint8_t msg_50  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_50  [32] = {
0x02
}; 

static uint8_t s_50  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___50 18446744073709551615

//Test vector 51:           "comment" : "truncated sequence",

static uint8_t pkx_51  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_51  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen51 6 

static uint8_t msg_51  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_51  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_51  [32] = {
0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47
}; 

#define result___51 18446744073709551615

//Test vector 52:           "comment" : "truncated sequence",

static uint8_t pkx_52  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_52  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen52 6 

static uint8_t msg_52  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_52  [32] = {
0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02, 0x21, 0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3
}; 

static uint8_t s_52  [32] = {
0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___52 18446744073709551615

//Test vector 53:           "comment" : "indefinite length",

static uint8_t pkx_53  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_53  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen53 6 

static uint8_t msg_53  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_53  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_53  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___53 18446744073709551615

//Test vector 54:           "comment" : "indefinite length with truncated delimiter",

static uint8_t pkx_54  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_54  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen54 6 

static uint8_t msg_54  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_54  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_54  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___54 18446744073709551615

//Test vector 55:           "comment" : "indefinite length with additional element",

static uint8_t pkx_55  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_55  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen55 6 

static uint8_t msg_55  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_55  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_55  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___55 18446744073709551615

//Test vector 56:           "comment" : "indefinite length with truncated element",

static uint8_t pkx_56  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_56  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen56 6 

static uint8_t msg_56  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_56  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_56  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___56 18446744073709551615

//Test vector 57:           "comment" : "indefinite length with garbage",

static uint8_t pkx_57  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_57  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen57 6 

static uint8_t msg_57  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_57  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_57  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___57 18446744073709551615

//Test vector 58:           "comment" : "indefinite length with nonempty EOC",

static uint8_t pkx_58  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_58  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen58 6 

static uint8_t msg_58  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_58  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_58  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___58 18446744073709551615

//Test vector 59:           "comment" : "prepend empty sequence",

static uint8_t pkx_59  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_59  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen59 6 

static uint8_t msg_59  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_59  [32] = {

}; 

static uint8_t s_59  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

#define result___59 18446744073709551615

//Test vector 60:           "comment" : "append empty sequence",

static uint8_t pkx_60  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_60  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen60 6 

static uint8_t msg_60  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_60  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_60  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___60 18446744073709551615

//Test vector 61:           "comment" : "append garbage with high tag number",

static uint8_t pkx_61  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_61  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen61 6 

static uint8_t msg_61  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_61  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_61  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___61 18446744073709551615

//Test vector 62:           "comment" : "sequence of sequence",

static uint8_t pkx_62  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_62  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen62 6 

static uint8_t msg_62  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 63:           "comment" : "truncated sequence: removed last 1 elements",

static uint8_t pkx_63  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_63  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen63 6 

static uint8_t msg_63  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 64:           "comment" : "repeating element in sequence",

static uint8_t pkx_64  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_64  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen64 6 

static uint8_t msg_64  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_64  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_64  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___64 18446744073709551615

//Test vector 65:           "comment" : "long form encoding of length of integer",

static uint8_t pkx_65  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_65  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen65 6 

static uint8_t msg_65  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 66:           "comment" : "long form encoding of length of integer",

static uint8_t pkx_66  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_66  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen66 6 

static uint8_t msg_66  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_66  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_66  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___66 18446744073709551615

//Test vector 67:           "comment" : "length of integer contains leading 0",

static uint8_t pkx_67  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_67  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen67 6 

static uint8_t msg_67  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 68:           "comment" : "length of integer contains leading 0",

static uint8_t pkx_68  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_68  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen68 6 

static uint8_t msg_68  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_68  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_68  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___68 18446744073709551615

//Test vector 69:           "comment" : "wrong length of integer",

static uint8_t pkx_69  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_69  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen69 6 

static uint8_t msg_69  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_69  [32] = {
0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x02
}; 

static uint8_t s_69  [32] = {

}; 

#define result___69 18446744073709551615

//Test vector 70:           "comment" : "wrong length of integer",

static uint8_t pkx_70  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_70  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen70 6 

static uint8_t msg_70  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_70  [32] = {
0x2e
}; 

static uint8_t s_70  [32] = {
0x21, 0x00
}; 

#define result___70 18446744073709551615

//Test vector 71:           "comment" : "wrong length of integer",

static uint8_t pkx_71  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_71  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen71 6 

static uint8_t msg_71  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_71  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_71  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___71 18446744073709551615

//Test vector 72:           "comment" : "wrong length of integer",

static uint8_t pkx_72  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_72  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen72 6 

static uint8_t msg_72  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_72  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_72  [32] = {
0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47
}; 

#define result___72 18446744073709551615

//Test vector 73:           "comment" : "uint32 overflow in length of integer",

static uint8_t pkx_73  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_73  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen73 6 

static uint8_t msg_73  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 74:           "comment" : "uint32 overflow in length of integer",

static uint8_t pkx_74  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_74  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen74 6 

static uint8_t msg_74  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_74  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_74  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___74 18446744073709551615

//Test vector 75:           "comment" : "uint64 overflow in length of integer",

static uint8_t pkx_75  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_75  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen75 6 

static uint8_t msg_75  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 76:           "comment" : "uint64 overflow in length of integer",

static uint8_t pkx_76  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_76  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen76 6 

static uint8_t msg_76  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_76  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_76  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___76 18446744073709551615

//Test vector 77:           "comment" : "length of integer = 2**31 - 1",

static uint8_t pkx_77  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_77  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen77 6 

static uint8_t msg_77  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 78:           "comment" : "length of integer = 2**31 - 1",

static uint8_t pkx_78  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_78  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen78 6 

static uint8_t msg_78  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_78  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_78  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___78 18446744073709551615

//Test vector 79:           "comment" : "length of integer = 2**32 - 1",

static uint8_t pkx_79  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_79  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen79 6 

static uint8_t msg_79  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 80:           "comment" : "length of integer = 2**32 - 1",

static uint8_t pkx_80  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_80  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen80 6 

static uint8_t msg_80  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_80  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_80  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___80 18446744073709551615

//Test vector 81:           "comment" : "length of integer = 2**40 - 1",

static uint8_t pkx_81  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_81  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen81 6 

static uint8_t msg_81  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 82:           "comment" : "length of integer = 2**40 - 1",

static uint8_t pkx_82  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_82  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen82 6 

static uint8_t msg_82  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_82  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_82  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___82 18446744073709551615

//Test vector 83:           "comment" : "length of integer = 2**64 - 1",

static uint8_t pkx_83  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_83  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen83 6 

static uint8_t msg_83  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 84:           "comment" : "length of integer = 2**64 - 1",

static uint8_t pkx_84  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_84  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen84 6 

static uint8_t msg_84  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_84  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_84  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___84 18446744073709551615

//Test vector 85:           "comment" : "incorrect length of integer",

static uint8_t pkx_85  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_85  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen85 6 

static uint8_t msg_85  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 86:           "comment" : "incorrect length of integer",

static uint8_t pkx_86  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_86  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen86 6 

static uint8_t msg_86  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_86  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_86  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___86 18446744073709551615

//Test vector 87:           "comment" : "removing integer",

static uint8_t pkx_87  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_87  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen87 6 

static uint8_t msg_87  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 88:           "comment" : "lonely integer tag",

static uint8_t pkx_88  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_88  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen88 6 

static uint8_t msg_88  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_88  [32] = {
0x21, 0x00
}; 

static uint8_t s_88  [32] = {
0x47, 0xdb
}; 

#define result___88 18446744073709551615

//Test vector 89:           "comment" : "lonely integer tag",

static uint8_t pkx_89  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_89  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen89 6 

static uint8_t msg_89  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 90:           "comment" : "appending 0's to integer",

static uint8_t pkx_90  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_90  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen90 6 

static uint8_t msg_90  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_90  [32] = {
0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x00, 0x00
}; 

static uint8_t s_90  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___90 18446744073709551615

//Test vector 91:           "comment" : "appending 0's to integer",

static uint8_t pkx_91  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_91  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen91 6 

static uint8_t msg_91  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_91  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_91  [32] = {
0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb, 0x00, 0x00
}; 

#define result___91 18446744073709551615

//Test vector 92:           "comment" : "prepending 0's to integer",

static uint8_t pkx_92  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_92  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen92 6 

static uint8_t msg_92  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_92  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_92  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___92 18446744073709551615

//Test vector 93:           "comment" : "prepending 0's to integer",

static uint8_t pkx_93  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_93  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen93 6 

static uint8_t msg_93  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_93  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_93  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___93 18446744073709551615

//Test vector 94:           "comment" : "appending unused 0's to integer",

static uint8_t pkx_94  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_94  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen94 6 

static uint8_t msg_94  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_94  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_94  [32] = {

}; 

#define result___94 18446744073709551615

//Test vector 95:           "comment" : "appending null value to integer",

static uint8_t pkx_95  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_95  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen95 6 

static uint8_t msg_95  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_95  [32] = {
0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18, 0x05, 0x00
}; 

static uint8_t s_95  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___95 18446744073709551615

//Test vector 96:           "comment" : "appending null value to integer",

static uint8_t pkx_96  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_96  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen96 6 

static uint8_t msg_96  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_96  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_96  [32] = {
0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb, 0x05, 0x00
}; 

#define result___96 18446744073709551615

//Test vector 97:           "comment" : "truncated length of integer",

static uint8_t pkx_97  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_97  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen97 6 

static uint8_t msg_97  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 98:           "comment" : "truncated length of integer",

static uint8_t pkx_98  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_98  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen98 6 

static uint8_t msg_98  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_98  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_98  [32] = {

}; 

#define result___98 18446744073709551615

//Test vector 99:           "comment" : "Replacing integer with NULL",

static uint8_t pkx_99  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_99  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen99 6 

static uint8_t msg_99  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_99  [32] = {

}; 

static uint8_t s_99  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___99 18446744073709551615

//Test vector 100:           "comment" : "Replacing integer with NULL",

static uint8_t pkx_100  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_100  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen100 6 

static uint8_t msg_100  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_100  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_100  [32] = {

}; 

#define result___100 18446744073709551615

//Test vector 101:           "comment" : "changing tag value of integer",

static uint8_t pkx_101  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_101  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen101 6 

static uint8_t msg_101  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_101  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_101  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___101 18446744073709551615

//Test vector 102:           "comment" : "changing tag value of integer",

static uint8_t pkx_102  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_102  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen102 6 

static uint8_t msg_102  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_102  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_102  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___102 18446744073709551615

//Test vector 103:           "comment" : "changing tag value of integer",

static uint8_t pkx_103  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_103  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen103 6 

static uint8_t msg_103  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_103  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_103  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___103 18446744073709551615

//Test vector 104:           "comment" : "changing tag value of integer",

static uint8_t pkx_104  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_104  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen104 6 

static uint8_t msg_104  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_104  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_104  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___104 18446744073709551615

//Test vector 105:           "comment" : "changing tag value of integer",

static uint8_t pkx_105  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_105  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen105 6 

static uint8_t msg_105  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_105  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_105  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___105 18446744073709551615

//Test vector 106:           "comment" : "changing tag value of integer",

static uint8_t pkx_106  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_106  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen106 6 

static uint8_t msg_106  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_106  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_106  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___106 18446744073709551615

//Test vector 107:           "comment" : "changing tag value of integer",

static uint8_t pkx_107  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_107  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen107 6 

static uint8_t msg_107  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_107  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_107  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___107 18446744073709551615

//Test vector 108:           "comment" : "changing tag value of integer",

static uint8_t pkx_108  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_108  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen108 6 

static uint8_t msg_108  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_108  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_108  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___108 18446744073709551615

//Test vector 109:           "comment" : "changing tag value of integer",

static uint8_t pkx_109  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_109  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen109 6 

static uint8_t msg_109  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_109  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_109  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___109 18446744073709551615

//Test vector 110:           "comment" : "changing tag value of integer",

static uint8_t pkx_110  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_110  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen110 6 

static uint8_t msg_110  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_110  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_110  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___110 18446744073709551615

//Test vector 111:           "comment" : "dropping value of integer",

static uint8_t pkx_111  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_111  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen111 6 

static uint8_t msg_111  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_111  [32] = {

}; 

static uint8_t s_111  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___111 18446744073709551615

//Test vector 112:           "comment" : "dropping value of integer",

static uint8_t pkx_112  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_112  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen112 6 

static uint8_t msg_112  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_112  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_112  [32] = {

}; 

#define result___112 18446744073709551615

//Test vector 113:           "comment" : "using composition for integer",

static uint8_t pkx_113  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_113  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen113 6 

static uint8_t msg_113  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_113  [32] = {
0x1f, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_113  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___113 18446744073709551615

//Test vector 114:           "comment" : "using composition for integer",

static uint8_t pkx_114  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_114  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen114 6 

static uint8_t msg_114  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_114  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_114  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___114 18446744073709551615

//Test vector 115:           "comment" : "modify first byte of integer",

static uint8_t pkx_115  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_115  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen115 6 

static uint8_t msg_115  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_115  [32] = {
0x29, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_115  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___115 18446744073709551615

//Test vector 116:           "comment" : "modify first byte of integer",

static uint8_t pkx_116  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_116  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen116 6 

static uint8_t msg_116  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_116  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_116  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___116 18446744073709551615

//Test vector 117:           "comment" : "modify last byte of integer",

static uint8_t pkx_117  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_117  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen117 6 

static uint8_t msg_117  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_117  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x98
}; 

static uint8_t s_117  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___117 18446744073709551615

//Test vector 118:           "comment" : "modify last byte of integer",

static uint8_t pkx_118  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_118  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen118 6 

static uint8_t msg_118  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_118  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_118  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0x5b
}; 

#define result___118 18446744073709551615

//Test vector 119:           "comment" : "truncated integer",

static uint8_t pkx_119  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_119  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen119 6 

static uint8_t msg_119  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_119  [32] = {
0x2e
}; 

static uint8_t s_119  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___119 18446744073709551615

//Test vector 120:           "comment" : "truncated integer",

static uint8_t pkx_120  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_120  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen120 6 

static uint8_t msg_120  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_120  [32] = {
0x18
}; 

static uint8_t s_120  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___120 18446744073709551615

//Test vector 121:           "comment" : "truncated integer",

static uint8_t pkx_121  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_121  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen121 6 

static uint8_t msg_121  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_121  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_121  [32] = {
0x00, 0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47
}; 

#define result___121 18446744073709551615

//Test vector 122:           "comment" : "leading ff in integer",

static uint8_t pkx_122  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_122  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen122 6 

static uint8_t msg_122  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_122  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_122  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___122 18446744073709551615

//Test vector 123:           "comment" : "leading ff in integer",

static uint8_t pkx_123  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_123  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen123 6 

static uint8_t msg_123  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_123  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_123  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___123 18446744073709551615

//Test vector 124:           "comment" : "replaced integer by infinity",

static uint8_t pkx_124  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_124  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen124 6 

static uint8_t msg_124  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_124  [32] = {
0x80
}; 

static uint8_t s_124  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___124 18446744073709551615

//Test vector 125:           "comment" : "replaced integer by infinity",

static uint8_t pkx_125  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_125  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen125 6 

static uint8_t msg_125  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_125  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_125  [32] = {
0x80
}; 

#define result___125 18446744073709551615

//Test vector 126:           "comment" : "replacing integer with zero",

static uint8_t pkx_126  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_126  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen126 6 

static uint8_t msg_126  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_126  [32] = {
0x00
}; 

static uint8_t s_126  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___126 18446744073709551615

//Test vector 127:           "comment" : "replacing integer with zero",

static uint8_t pkx_127  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_127  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen127 6 

static uint8_t msg_127  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_127  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_127  [32] = {
0x00
}; 

#define result___127 18446744073709551615

//Test vector 128:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_128  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_128  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen128 6 

static uint8_t msg_128  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_128  [32] = {
0x2b, 0xa3, 0xa8, 0xbd, 0x6b, 0x94, 0xd5, 0xed, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xbc, 0xcc, 0x08, 0x33, 0x49, 0x06, 0x86, 0xde, 0xac, 0x86, 0x35, 0xbc, 0xb9, 0xbf, 0x53, 0x69
}; 

static uint8_t s_128  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___128 18446744073709551615

//Test vector 129:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_129  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_129  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen129 6 

static uint8_t msg_129  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_129  [32] = {
0x2b, 0xa3, 0xa8, 0xbf, 0x6b, 0x94, 0xd5, 0xeb, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6f, 0x42, 0xfe, 0x12, 0xd7, 0xfa, 0xd7, 0x49, 0xd4, 0xc5, 0x12, 0xa0, 0x36, 0xc0, 0xf9, 0x08, 0xc7
}; 

static uint8_t s_129  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___129 18446744073709551615

//Test vector 130:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_130  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_130  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen130 6 

static uint8_t msg_130  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_130  [32] = {
0xd4, 0x5c, 0x57, 0x41, 0x94, 0x6b, 0x2a, 0x13, 0x7f, 0x59, 0x26, 0x2e, 0xe6, 0xf5, 0xbc, 0x91, 0x00, 0x1a, 0xf2, 0x7a, 0x5e, 0x11, 0x17, 0xa6, 0x47, 0x33, 0x95, 0x06, 0x42, 0xa3, 0xd1, 0xe8
}; 

static uint8_t s_130  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___130 18446744073709551615

//Test vector 131:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_131  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_131  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen131 6 

static uint8_t msg_131  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_131  [32] = {
0xd4, 0x5c, 0x57, 0x40, 0x94, 0x6b, 0x2a, 0x14, 0x7f, 0x59, 0x26, 0x2e, 0xe6, 0xf5, 0xbc, 0x90, 0xbd, 0x01, 0xed, 0x28, 0x05, 0x28, 0xb6, 0x2b, 0x3a, 0xed, 0x5f, 0xc9, 0x3f, 0x06, 0xf7, 0x39
}; 

static uint8_t s_131  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___131 18446744073709551615

//Test vector 132:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_132  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_132  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen132 6 

static uint8_t msg_132  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_132  [32] = {
0xd4, 0x5c, 0x57, 0x42, 0x94, 0x6b, 0x2a, 0x12, 0x7f, 0x59, 0x26, 0x2e, 0xe6, 0xf5, 0xbc, 0x91, 0x43, 0x33, 0xf7, 0xcc, 0xb6, 0xf9, 0x79, 0x21, 0x53, 0x79, 0xca, 0x43, 0x46, 0x40, 0xac, 0x97
}; 

static uint8_t s_132  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___132 18446744073709551615

//Test vector 133:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_133  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_133  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen133 6 

static uint8_t msg_133  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_133  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_133  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___133 18446744073709551615

//Test vector 134:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_134  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_134  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen134 6 

static uint8_t msg_134  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_134  [32] = {
0xd4, 0x5c, 0x57, 0x41, 0x94, 0x6b, 0x2a, 0x13, 0x7f, 0x59, 0x26, 0x2e, 0xe6, 0xf5, 0xbc, 0x91, 0x00, 0x1a, 0xf2, 0x7a, 0x5e, 0x11, 0x17, 0xa6, 0x47, 0x33, 0x95, 0x06, 0x42, 0xa3, 0xd1, 0xe8
}; 

static uint8_t s_134  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___134 18446744073709551615

//Test vector 135:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_135  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_135  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen135 6 

static uint8_t msg_135  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_135  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_135  [32] = {
0xb3, 0x29, 0xf4, 0x78, 0xa2, 0xbb, 0xd0, 0xa6, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x27, 0x6e, 0x0e, 0x4a, 0x53, 0x75, 0x92, 0x8d, 0x6f, 0xcd, 0x16, 0x0c, 0x11, 0xcb, 0x6d, 0x2c
}; 

#define result___135 18446744073709551615

//Test vector 136:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_136  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_136  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen136 6 

static uint8_t msg_136  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_136  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_136  [32] = {
0xb3, 0x29, 0xf4, 0x7a, 0xa2, 0xbb, 0xd0, 0xa4, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0xad, 0xa0, 0x18, 0xef, 0x05, 0x46, 0x55, 0x83, 0x88, 0x59, 0x80, 0x86, 0x19, 0x05, 0x22, 0x8a
}; 

#define result___136 18446744073709551615

//Test vector 137:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_137  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_137  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen137 6 

static uint8_t msg_137  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_137  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_137  [32] = {
0x4c, 0xd6, 0x0b, 0x86, 0x5d, 0x44, 0x2f, 0x5a, 0x3c, 0x7b, 0x11, 0xeb, 0x6c, 0x4e, 0x0a, 0xe7, 0x95, 0x78, 0xec, 0x63, 0x53, 0xa2, 0x0b, 0xf7, 0x83, 0xec, 0xb4, 0xb6, 0xea, 0x97, 0xb8, 0x25
}; 

#define result___137 18446744073709551615

//Test vector 138:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_138  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_138  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen138 6 

static uint8_t msg_138  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_138  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_138  [32] = {
0x4c, 0xd6, 0x0b, 0x87, 0x5d, 0x44, 0x2f, 0x59, 0x3c, 0x7b, 0x11, 0xeb, 0x6c, 0x4e, 0x0a, 0xe7, 0xd8, 0x91, 0xf1, 0xb5, 0xac, 0x8a, 0x6d, 0x72, 0x90, 0x32, 0xe9, 0xf3, 0xee, 0x34, 0x92, 0xd4
}; 

#define result___138 18446744073709551615

//Test vector 139:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_139  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_139  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen139 6 

static uint8_t msg_139  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_139  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_139  [32] = {
0xb3, 0x29, 0xf4, 0x79, 0xa2, 0xbb, 0xd0, 0xa5, 0xc3, 0x84, 0xee, 0x14, 0x93, 0xb1, 0xf5, 0x18, 0x6a, 0x87, 0x13, 0x9c, 0xac, 0x5d, 0xf4, 0x08, 0x7c, 0x13, 0x4b, 0x49, 0x15, 0x68, 0x47, 0xdb
}; 

#define result___139 18446744073709551615

//Test vector 140:           "comment" : "Modified r or s, e.g. by adding or subtracting the order of the group",

static uint8_t pkx_140  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_140  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen140 6 

static uint8_t msg_140  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_140  [32] = {
0x2b, 0xa3, 0xa8, 0xbe, 0x6b, 0x94, 0xd5, 0xec, 0x80, 0xa6, 0xd9, 0xd1, 0x19, 0x0a, 0x43, 0x6e, 0xff, 0xe5, 0x0d, 0x85, 0xa1, 0xee, 0xe8, 0x59, 0xb8, 0xcc, 0x6a, 0xf9, 0xbd, 0x5c, 0x2e, 0x18
}; 

static uint8_t s_140  [32] = {
0x4c, 0xd6, 0x0b, 0x86, 0x5d, 0x44, 0x2f, 0x5a, 0x3c, 0x7b, 0x11, 0xeb, 0x6c, 0x4e, 0x0a, 0xe7, 0x95, 0x78, 0xec, 0x63, 0x53, 0xa2, 0x0b, 0xf7, 0x83, 0xec, 0xb4, 0xb6, 0xea, 0x97, 0xb8, 0x25
}; 

#define result___140 18446744073709551615

//Test vector 141:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_141  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_141  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen141 6 

static uint8_t msg_141  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_141  [32] = {
0x00
}; 

static uint8_t s_141  [32] = {
0x00
}; 

#define result___141 18446744073709551615

//Test vector 142:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_142  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_142  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen142 6 

static uint8_t msg_142  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_142  [32] = {
0x00
}; 

static uint8_t s_142  [32] = {
0x01
}; 

#define result___142 18446744073709551615

//Test vector 143:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_143  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_143  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen143 6 

static uint8_t msg_143  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_143  [32] = {
0x00
}; 

static uint8_t s_143  [32] = {
0xff
}; 

#define result___143 18446744073709551615

//Test vector 144:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_144  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_144  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen144 6 

static uint8_t msg_144  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_144  [32] = {
0x00
}; 

static uint8_t s_144  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

#define result___144 18446744073709551615

//Test vector 145:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_145  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_145  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen145 6 

static uint8_t msg_145  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_145  [32] = {
0x00
}; 

static uint8_t s_145  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

#define result___145 18446744073709551615

//Test vector 146:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_146  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_146  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen146 6 

static uint8_t msg_146  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_146  [32] = {
0x00
}; 

static uint8_t s_146  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

#define result___146 18446744073709551615

//Test vector 147:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_147  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_147  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen147 6 

static uint8_t msg_147  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_147  [32] = {
0x00
}; 

static uint8_t s_147  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

#define result___147 18446744073709551615

//Test vector 148:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_148  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_148  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen148 6 

static uint8_t msg_148  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_148  [32] = {
0x00
}; 

static uint8_t s_148  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

#define result___148 18446744073709551615

//Test vector 149:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_149  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_149  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen149 6 

static uint8_t msg_149  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_149  [32] = {
0x00
}; 

static uint8_t s_149  [32] = {
0x80, 0xfe, 0x01
}; 

#define result___149 18446744073709551615

//Test vector 150:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_150  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_150  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen150 6 

static uint8_t msg_150  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_150  [32] = {
0x00
}; 

static uint8_t s_150  [32] = {
0x42
}; 

#define result___150 18446744073709551615

//Test vector 151:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_151  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_151  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen151 6 

static uint8_t msg_151  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_151  [32] = {
0x01
}; 

static uint8_t s_151  [32] = {
0x00
}; 

#define result___151 18446744073709551615

//Test vector 152:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_152  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_152  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen152 6 

static uint8_t msg_152  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_152  [32] = {
0x01
}; 

static uint8_t s_152  [32] = {
0x01
}; 

#define result___152 18446744073709551615

//Test vector 153:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_153  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_153  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen153 6 

static uint8_t msg_153  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_153  [32] = {
0x01
}; 

static uint8_t s_153  [32] = {
0xff
}; 

#define result___153 18446744073709551615

//Test vector 154:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_154  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_154  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen154 6 

static uint8_t msg_154  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_154  [32] = {
0x01
}; 

static uint8_t s_154  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

#define result___154 18446744073709551615

//Test vector 155:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_155  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_155  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen155 6 

static uint8_t msg_155  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_155  [32] = {
0x01
}; 

static uint8_t s_155  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

#define result___155 18446744073709551615

//Test vector 156:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_156  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_156  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen156 6 

static uint8_t msg_156  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_156  [32] = {
0x01
}; 

static uint8_t s_156  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

#define result___156 18446744073709551615

//Test vector 157:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_157  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_157  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen157 6 

static uint8_t msg_157  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_157  [32] = {
0x01
}; 

static uint8_t s_157  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

#define result___157 18446744073709551615

//Test vector 158:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_158  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_158  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen158 6 

static uint8_t msg_158  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_158  [32] = {
0x01
}; 

static uint8_t s_158  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

#define result___158 18446744073709551615

//Test vector 159:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_159  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_159  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen159 6 

static uint8_t msg_159  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_159  [32] = {
0x01
}; 

static uint8_t s_159  [32] = {
0x80, 0xfe, 0x01
}; 

#define result___159 18446744073709551615

//Test vector 160:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_160  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_160  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen160 6 

static uint8_t msg_160  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_160  [32] = {
0x01
}; 

static uint8_t s_160  [32] = {
0x42
}; 

#define result___160 18446744073709551615

//Test vector 161:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_161  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_161  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen161 6 

static uint8_t msg_161  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_161  [32] = {
0xff
}; 

static uint8_t s_161  [32] = {
0x00
}; 

#define result___161 18446744073709551615

//Test vector 162:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_162  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_162  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen162 6 

static uint8_t msg_162  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_162  [32] = {
0xff
}; 

static uint8_t s_162  [32] = {
0x01
}; 

#define result___162 18446744073709551615

//Test vector 163:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_163  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_163  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen163 6 

static uint8_t msg_163  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_163  [32] = {
0xff
}; 

static uint8_t s_163  [32] = {
0xff
}; 

#define result___163 18446744073709551615

//Test vector 164:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_164  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_164  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen164 6 

static uint8_t msg_164  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_164  [32] = {
0xff
}; 

static uint8_t s_164  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

#define result___164 18446744073709551615

//Test vector 165:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_165  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_165  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen165 6 

static uint8_t msg_165  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_165  [32] = {
0xff
}; 

static uint8_t s_165  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

#define result___165 18446744073709551615

//Test vector 166:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_166  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_166  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen166 6 

static uint8_t msg_166  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_166  [32] = {
0xff
}; 

static uint8_t s_166  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

#define result___166 18446744073709551615

//Test vector 167:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_167  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_167  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen167 6 

static uint8_t msg_167  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_167  [32] = {
0xff
}; 

static uint8_t s_167  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

#define result___167 18446744073709551615

//Test vector 168:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_168  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_168  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen168 6 

static uint8_t msg_168  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_168  [32] = {
0xff
}; 

static uint8_t s_168  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

#define result___168 18446744073709551615

//Test vector 169:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_169  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_169  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen169 6 

static uint8_t msg_169  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_169  [32] = {
0xff
}; 

static uint8_t s_169  [32] = {
0x80, 0xfe, 0x01
}; 

#define result___169 18446744073709551615

//Test vector 170:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_170  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_170  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen170 6 

static uint8_t msg_170  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_170  [32] = {
0xff
}; 

static uint8_t s_170  [32] = {
0x42
}; 

#define result___170 18446744073709551615

//Test vector 171:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_171  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_171  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen171 6 

static uint8_t msg_171  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_171  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

static uint8_t s_171  [32] = {
0x00
}; 

#define result___171 18446744073709551615

//Test vector 172:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_172  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_172  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen172 6 

static uint8_t msg_172  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_172  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

static uint8_t s_172  [32] = {
0x01
}; 

#define result___172 18446744073709551615

//Test vector 173:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_173  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_173  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen173 6 

static uint8_t msg_173  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_173  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

static uint8_t s_173  [32] = {
0xff
}; 

#define result___173 18446744073709551615

//Test vector 174:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_174  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_174  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen174 6 

static uint8_t msg_174  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_174  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

static uint8_t s_174  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

#define result___174 18446744073709551615

//Test vector 175:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_175  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_175  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen175 6 

static uint8_t msg_175  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_175  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

static uint8_t s_175  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

#define result___175 18446744073709551615

//Test vector 176:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_176  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_176  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen176 6 

static uint8_t msg_176  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_176  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

static uint8_t s_176  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

#define result___176 18446744073709551615

//Test vector 177:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_177  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_177  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen177 6 

static uint8_t msg_177  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_177  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

static uint8_t s_177  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

#define result___177 18446744073709551615

//Test vector 178:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_178  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_178  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen178 6 

static uint8_t msg_178  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_178  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

static uint8_t s_178  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

#define result___178 18446744073709551615

//Test vector 179:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_179  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_179  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen179 6 

static uint8_t msg_179  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_179  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

static uint8_t s_179  [32] = {
0x80, 0xfe, 0x01
}; 

#define result___179 18446744073709551615

//Test vector 180:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_180  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_180  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen180 6 

static uint8_t msg_180  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_180  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

static uint8_t s_180  [32] = {
0x42
}; 

#define result___180 18446744073709551615

//Test vector 181:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_181  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_181  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen181 6 

static uint8_t msg_181  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_181  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

static uint8_t s_181  [32] = {
0x00
}; 

#define result___181 18446744073709551615

//Test vector 182:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_182  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_182  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen182 6 

static uint8_t msg_182  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_182  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

static uint8_t s_182  [32] = {
0x01
}; 

#define result___182 18446744073709551615

//Test vector 183:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_183  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_183  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen183 6 

static uint8_t msg_183  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_183  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

static uint8_t s_183  [32] = {
0xff
}; 

#define result___183 18446744073709551615

//Test vector 184:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_184  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_184  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen184 6 

static uint8_t msg_184  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_184  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

static uint8_t s_184  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

#define result___184 18446744073709551615

//Test vector 185:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_185  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_185  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen185 6 

static uint8_t msg_185  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_185  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

static uint8_t s_185  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

#define result___185 18446744073709551615

//Test vector 186:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_186  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_186  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen186 6 

static uint8_t msg_186  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_186  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

static uint8_t s_186  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

#define result___186 18446744073709551615

//Test vector 187:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_187  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_187  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen187 6 

static uint8_t msg_187  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_187  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

static uint8_t s_187  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

#define result___187 18446744073709551615

//Test vector 188:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_188  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_188  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen188 6 

static uint8_t msg_188  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_188  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

static uint8_t s_188  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

#define result___188 18446744073709551615

//Test vector 189:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_189  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_189  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen189 6 

static uint8_t msg_189  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_189  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

static uint8_t s_189  [32] = {
0x80, 0xfe, 0x01
}; 

#define result___189 18446744073709551615

//Test vector 190:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_190  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_190  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen190 6 

static uint8_t msg_190  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_190  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

static uint8_t s_190  [32] = {
0x42
}; 

#define result___190 18446744073709551615

//Test vector 191:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_191  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_191  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen191 6 

static uint8_t msg_191  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_191  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

static uint8_t s_191  [32] = {
0x00
}; 

#define result___191 18446744073709551615

//Test vector 192:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_192  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_192  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen192 6 

static uint8_t msg_192  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_192  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

static uint8_t s_192  [32] = {
0x01
}; 

#define result___192 18446744073709551615

//Test vector 193:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_193  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_193  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen193 6 

static uint8_t msg_193  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_193  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

static uint8_t s_193  [32] = {
0xff
}; 

#define result___193 18446744073709551615

//Test vector 194:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_194  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_194  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen194 6 

static uint8_t msg_194  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_194  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

static uint8_t s_194  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

#define result___194 18446744073709551615

//Test vector 195:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_195  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_195  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen195 6 

static uint8_t msg_195  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_195  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

static uint8_t s_195  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

#define result___195 18446744073709551615

//Test vector 196:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_196  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_196  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen196 6 

static uint8_t msg_196  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_196  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

static uint8_t s_196  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

#define result___196 18446744073709551615

//Test vector 197:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_197  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_197  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen197 6 

static uint8_t msg_197  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_197  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

static uint8_t s_197  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

#define result___197 18446744073709551615

//Test vector 198:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_198  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_198  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen198 6 

static uint8_t msg_198  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_198  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

static uint8_t s_198  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

#define result___198 18446744073709551615

//Test vector 199:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_199  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_199  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen199 6 

static uint8_t msg_199  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_199  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

static uint8_t s_199  [32] = {
0x80, 0xfe, 0x01
}; 

#define result___199 18446744073709551615

//Test vector 200:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_200  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_200  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen200 6 

static uint8_t msg_200  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_200  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

static uint8_t s_200  [32] = {
0x42
}; 

#define result___200 18446744073709551615

//Test vector 201:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_201  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_201  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen201 6 

static uint8_t msg_201  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_201  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

static uint8_t s_201  [32] = {
0x00
}; 

#define result___201 18446744073709551615

//Test vector 202:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_202  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_202  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen202 6 

static uint8_t msg_202  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_202  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

static uint8_t s_202  [32] = {
0x01
}; 

#define result___202 18446744073709551615

//Test vector 203:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_203  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_203  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen203 6 

static uint8_t msg_203  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_203  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

static uint8_t s_203  [32] = {
0xff
}; 

#define result___203 18446744073709551615

//Test vector 204:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_204  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_204  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen204 6 

static uint8_t msg_204  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_204  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

static uint8_t s_204  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

#define result___204 18446744073709551615

//Test vector 205:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_205  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_205  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen205 6 

static uint8_t msg_205  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_205  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

static uint8_t s_205  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

#define result___205 18446744073709551615

//Test vector 206:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_206  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_206  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen206 6 

static uint8_t msg_206  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_206  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

static uint8_t s_206  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

#define result___206 18446744073709551615

//Test vector 207:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_207  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_207  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen207 6 

static uint8_t msg_207  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_207  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

static uint8_t s_207  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

#define result___207 18446744073709551615

//Test vector 208:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_208  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_208  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen208 6 

static uint8_t msg_208  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_208  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

static uint8_t s_208  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

#define result___208 18446744073709551615

//Test vector 209:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_209  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_209  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen209 6 

static uint8_t msg_209  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_209  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

static uint8_t s_209  [32] = {
0x80, 0xfe, 0x01
}; 

#define result___209 18446744073709551615

//Test vector 210:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_210  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_210  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen210 6 

static uint8_t msg_210  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_210  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

static uint8_t s_210  [32] = {
0x42
}; 

#define result___210 18446744073709551615

//Test vector 211:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_211  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_211  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen211 6 

static uint8_t msg_211  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_211  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_211  [32] = {
0x00
}; 

#define result___211 18446744073709551615

//Test vector 212:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_212  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_212  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen212 6 

static uint8_t msg_212  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_212  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_212  [32] = {
0x01
}; 

#define result___212 18446744073709551615

//Test vector 213:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_213  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_213  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen213 6 

static uint8_t msg_213  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_213  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_213  [32] = {
0xff
}; 

#define result___213 18446744073709551615

//Test vector 214:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_214  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_214  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen214 6 

static uint8_t msg_214  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_214  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_214  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x51
}; 

#define result___214 18446744073709551615

//Test vector 215:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_215  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_215  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen215 6 

static uint8_t msg_215  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_215  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_215  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50
}; 

#define result___215 18446744073709551615

//Test vector 216:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_216  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_216  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen216 6 

static uint8_t msg_216  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_216  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_216  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x52
}; 

#define result___216 18446744073709551615

//Test vector 217:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_217  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_217  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen217 6 

static uint8_t msg_217  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_217  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_217  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
}; 

#define result___217 18446744073709551615

//Test vector 218:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_218  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_218  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen218 6 

static uint8_t msg_218  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_218  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_218  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

#define result___218 18446744073709551615

//Test vector 219:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_219  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_219  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen219 6 

static uint8_t msg_219  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_219  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_219  [32] = {
0x80, 0xfe, 0x01
}; 

#define result___219 18446744073709551615

//Test vector 220:           "comment" : "Signature with special case values for r and s",

static uint8_t pkx_220  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_220  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen220 6 

static uint8_t msg_220  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_220  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_220  [32] = {
0x42
}; 

#define result___220 18446744073709551615

//Test vector 221:           "comment" : "Signature encoding contains wrong types.",

static uint8_t pkx_221  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_221  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen221 6 

static uint8_t msg_221  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_221  [32] = {
0x01
}; 

static uint8_t s_221  [32] = {
0x30
}; 

#define result___221 18446744073709551615

//Test vector 222:           "comment" : "Signature encoding contains wrong types.",

static uint8_t pkx_222  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_222  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen222 6 

static uint8_t msg_222  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_222  [32] = {
0x01
}; 

static uint8_t s_222  [32] = {

}; 

#define result___222 18446744073709551615

//Test vector 223:           "comment" : "Signature encoding contains wrong types.",

static uint8_t pkx_223  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_223  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen223 6 

static uint8_t msg_223  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_223  [32] = {
0x25, 0x73
}; 

static uint8_t s_223  [32] = {
0x73, 0x25, 0x73
}; 

#define result___223 18446744073709551615

//Test vector 224:           "comment" : "Signature encoding contains wrong types.",

static uint8_t pkx_224  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_224  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen224 6 

static uint8_t msg_224  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_224  [32] = {
0x01
}; 

static uint8_t s_224  [32] = {
0x02, 0x01, 0x00
}; 

#define result___224 18446744073709551615

//Test vector 225:           "comment" : "Signature encoding contains wrong types.",

static uint8_t pkx_225  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_225  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen225 6 

static uint8_t msg_225  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

//Test vector 226:           "comment" : "Signature encoding contains wrong types.",

static uint8_t pkx_226  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_226  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen226 6 

static uint8_t msg_226  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_226  [32] = {
0x01
}; 

static uint8_t s_226  [32] = {
0x00
}; 

#define result___226 18446744073709551615

//Test vector 227:           "comment" : "Edge case for Shamir multiplication",

static uint8_t pkx_227  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_227  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen227 5 

static uint8_t msg_227  [5] = {
0x36, 0x39, 0x38, 0x31, 0x39
}; 

static uint8_t r_227  [32] = {
0x64, 0xa1, 0xaa, 0xb5, 0x00, 0x0d, 0x0e, 0x80, 0x4f, 0x3e, 0x2f, 0xc0, 0x2b, 0xde, 0xe9, 0xbe, 0x8f, 0xf3, 0x12, 0x33, 0x4e, 0x2b, 0xa1, 0x6d, 0x11, 0x54, 0x7c, 0x97, 0x71, 0x1c, 0x89, 0x8e
}; 

static uint8_t s_227  [32] = {
0x6a, 0xf0, 0x15, 0x97, 0x1c, 0xc3, 0x0b, 0xe6, 0xd1, 0xa2, 0x06, 0xd4, 0xe0, 0x13, 0xe0, 0x99, 0x77, 0x72, 0xa2, 0xf9, 0x1d, 0x73, 0x28, 0x6f, 0xfd, 0x68, 0x3b, 0x9b, 0xb2, 0xcf, 0x4f, 0x1b
}; 

#define result___227 0

//Test vector 228:           "comment" : "special case hash",

static uint8_t pkx_228  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_228  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen228 9 

static uint8_t msg_228  [9] = {
0x34, 0x32, 0x36, 0x34, 0x37, 0x39, 0x37, 0x32, 0x34
}; 

static uint8_t r_228  [32] = {
0x16, 0xae, 0xa9, 0x64, 0xa2, 0xf6, 0x50, 0x6d, 0x6f, 0x78, 0xc8, 0x1c, 0x91, 0xfc, 0x7e, 0x8b, 0xde, 0xd7, 0xd3, 0x97, 0x73, 0x84, 0x48, 0xde, 0x1e, 0x19, 0xa0, 0xec, 0x58, 0x0b, 0xf2, 0x66
}; 

static uint8_t s_228  [32] = {
0x25, 0x2c, 0xd7, 0x62, 0x13, 0x0c, 0x66, 0x67, 0xcf, 0xe8, 0xb7, 0xbc, 0x47, 0xd2, 0x7d, 0x78, 0x39, 0x1e, 0x8e, 0x80, 0xc5, 0x78, 0xd1, 0xcd, 0x38, 0xc3, 0xff, 0x03, 0x3b, 0xe9, 0x28, 0xe9
}; 

#define result___228 0

//Test vector 229:           "comment" : "special case hash",

static uint8_t pkx_229  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_229  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen229 10 

static uint8_t msg_229  [10] = {
0x37, 0x31, 0x33, 0x38, 0x36, 0x38, 0x34, 0x38, 0x39, 0x31
}; 

static uint8_t r_229  [32] = {
0x9c, 0xc9, 0x8b, 0xe2, 0x34, 0x7d, 0x46, 0x9b, 0xf4, 0x76, 0xdf, 0xc2, 0x6b, 0x9b, 0x73, 0x3d, 0xf2, 0xd2, 0x6d, 0x6e, 0xf5, 0x24, 0xaf, 0x91, 0x7c, 0x66, 0x5b, 0xac, 0xcb, 0x23, 0xc8, 0x82
}; 

static uint8_t s_229  [32] = {
0x09, 0x34, 0x96, 0x45, 0x9e, 0xff, 0xe2, 0xd8, 0xd7, 0x07, 0x27, 0xb8, 0x24, 0x62, 0xf6, 0x1d, 0x0e, 0xc1, 0xb7, 0x84, 0x79, 0x29, 0xd1, 0x0e, 0xa6, 0x31, 0xda, 0xcb, 0x16, 0xb5, 0x6c, 0x32
}; 

#define result___229 0

//Test vector 230:           "comment" : "special case hash",

static uint8_t pkx_230  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_230  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen230 11 

static uint8_t msg_230  [11] = {
0x31, 0x30, 0x33, 0x35, 0x39, 0x33, 0x33, 0x31, 0x36, 0x36, 0x38
}; 

static uint8_t r_230  [32] = {
0x73, 0xb3, 0xc9, 0x0e, 0xcd, 0x39, 0x00, 0x28, 0x05, 0x81, 0x64, 0x52, 0x4d, 0xde, 0x89, 0x27, 0x03, 0xdc, 0xe3, 0xde, 0xa0, 0xd5, 0x3f, 0xa8, 0x09, 0x39, 0x99, 0xf0, 0x7a, 0xb8, 0xaa, 0x43
}; 

static uint8_t s_230  [32] = {
0x2f, 0x67, 0xb0, 0xb8, 0xe2, 0x06, 0x36, 0x69, 0x5b, 0xb7, 0xd8, 0xbf, 0x0a, 0x65, 0x1c, 0x80, 0x2e, 0xd2, 0x5a, 0x39, 0x53, 0x87, 0xb5, 0xf4, 0x18, 0x8c, 0x0c, 0x40, 0x75, 0xc8, 0x86, 0x34
}; 

#define result___230 0

//Test vector 231:           "comment" : "special case hash",

static uint8_t pkx_231  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_231  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen231 10 

static uint8_t msg_231  [10] = {
0x33, 0x39, 0x34, 0x39, 0x34, 0x30, 0x31, 0x32, 0x31, 0x35
}; 

static uint8_t r_231  [32] = {
0xbf, 0xab, 0x30, 0x98, 0x25, 0x28, 0x47, 0xb3, 0x28, 0xfa, 0xdf, 0x2f, 0x89, 0xb9, 0x5c, 0x85, 0x1a, 0x7f, 0x0e, 0xb3, 0x90, 0x76, 0x33, 0x78, 0xf3, 0x7e, 0x90, 0x11, 0x9d, 0x5b, 0xa3, 0xdd
}; 

static uint8_t s_231  [32] = {
0xbd, 0xd6, 0x4e, 0x23, 0x4e, 0x83, 0x2b, 0x10, 0x67, 0xc2, 0xd0, 0x58, 0xcc, 0xb4, 0x4d, 0x97, 0x81, 0x95, 0xcc, 0xeb, 0xb6, 0x5c, 0x2a, 0xaf, 0x1e, 0x2d, 0xa9, 0xb8, 0xb4, 0x98, 0x7e, 0x3b
}; 

#define result___231 0

//Test vector 232:           "comment" : "special case hash",

static uint8_t pkx_232  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_232  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen232 10 

static uint8_t msg_232  [10] = {
0x31, 0x33, 0x34, 0x34, 0x32, 0x39, 0x33, 0x30, 0x37, 0x39
}; 

static uint8_t r_232  [32] = {
0x20, 0x4a, 0x97, 0x84, 0x07, 0x4b, 0x24, 0x6d, 0x8b, 0xf8, 0xbf, 0x04, 0xa4, 0xce, 0xb1, 0xc1, 0xf1, 0xc9, 0xaa, 0xab, 0x16, 0x8b, 0x15, 0x96, 0xd1, 0x70, 0x93, 0xc5, 0xcd, 0x21, 0xd2, 0xcd
}; 

static uint8_t s_232  [32] = {
0x51, 0xcc, 0xe4, 0x16, 0x70, 0x63, 0x67, 0x83, 0xdc, 0x06, 0xa7, 0x59, 0xc8, 0x84, 0x78, 0x68, 0xa4, 0x06, 0xc2, 0x50, 0x6f, 0xe1, 0x79, 0x75, 0x58, 0x2f, 0xe6, 0x48, 0xd1, 0xd8, 0x8b, 0x52
}; 

#define result___232 0

//Test vector 233:           "comment" : "special case hash",

static uint8_t pkx_233  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_233  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen233 10 

static uint8_t msg_233  [10] = {
0x33, 0x37, 0x30, 0x36, 0x32, 0x31, 0x31, 0x37, 0x31, 0x32
}; 

static uint8_t r_233  [32] = {
0xed, 0x66, 0xdc, 0x34, 0xf5, 0x51, 0xac, 0x82, 0xf6, 0x3d, 0x4a, 0xa4, 0xf8, 0x1f, 0xe2, 0xcb, 0x00, 0x31, 0xa9, 0x1d, 0x13, 0x14, 0xf8, 0x35, 0x02, 0x7b, 0xca, 0x0f, 0x1c, 0xee, 0xaa, 0x03
}; 

static uint8_t s_233  [32] = {
0x99, 0xca, 0x12, 0x3a, 0xa0, 0x9b, 0x13, 0xcd, 0x19, 0x4a, 0x42, 0x2e, 0x18, 0xd5, 0xfd, 0xa1, 0x67, 0x62, 0x3c, 0x3f, 0x6e, 0x5d, 0x4d, 0x6a, 0xbb, 0x89, 0x53, 0xd6, 0x7c, 0x0c, 0x48, 0xc7
}; 

#define result___233 0

//Test vector 234:           "comment" : "special case hash",

static uint8_t pkx_234  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_234  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen234 9 

static uint8_t msg_234  [9] = {
0x33, 0x34, 0x33, 0x36, 0x38, 0x38, 0x37, 0x31, 0x32
}; 

static uint8_t r_234  [32] = {
0x06, 0x0b, 0x70, 0x0b, 0xef, 0x66, 0x5c, 0x68, 0x89, 0x9d, 0x44, 0xf2, 0x35, 0x6a, 0x57, 0x8d, 0x12, 0x6b, 0x06, 0x20, 0x23, 0xcc, 0xc3, 0xc0, 0x56, 0xbf, 0x0f, 0x60, 0xa2, 0x37, 0x01, 0x2b
}; 

static uint8_t s_234  [32] = {
0x8d, 0x18, 0x6c, 0x02, 0x78, 0x32, 0x96, 0x5f, 0x4f, 0xcc, 0x78, 0xa3, 0x36, 0x6c, 0xa9, 0x5d, 0xed, 0xbb, 0x41, 0x0c, 0xbe, 0xf3, 0xf2, 0x6d, 0x6b, 0xe5, 0xd5, 0x81, 0xc1, 0x1d, 0x36, 0x10
}; 

#define result___234 0

//Test vector 235:           "comment" : "special case hash",

static uint8_t pkx_235  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_235  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen235 10 

static uint8_t msg_235  [10] = {
0x31, 0x33, 0x35, 0x31, 0x35, 0x33, 0x30, 0x33, 0x37, 0x30
}; 

static uint8_t r_235  [32] = {
0x9f, 0x6a, 0xdf, 0xe8, 0xd5, 0xeb, 0x5b, 0x2c, 0x24, 0xd7, 0xaa, 0x79, 0x34, 0xb6, 0xcf, 0x29, 0xc9, 0x3e, 0xa7, 0x6c, 0xd3, 0x13, 0xc9, 0x13, 0x2b, 0xb0, 0xc8, 0xe3, 0x8c, 0x96, 0x83, 0x1d
}; 

static uint8_t s_235  [32] = {
0xb2, 0x6a, 0x9c, 0x9e, 0x40, 0xe5, 0x5e, 0xe0, 0x89, 0x0c, 0x94, 0x4c, 0xf2, 0x71, 0x75, 0x6c, 0x90, 0x6a, 0x33, 0xe6, 0x6b, 0x5b, 0xd1, 0x5e, 0x05, 0x15, 0x93, 0x88, 0x3b, 0x5e, 0x99, 0x02
}; 

#define result___235 0

//Test vector 236:           "comment" : "special case hash",

static uint8_t pkx_236  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_236  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen236 10 

static uint8_t msg_236  [10] = {
0x36, 0x35, 0x35, 0x33, 0x32, 0x30, 0x33, 0x31, 0x32, 0x36
}; 

static uint8_t r_236  [32] = {
0xa1, 0xaf, 0x03, 0xca, 0x91, 0x67, 0x7b, 0x67, 0x3a, 0xd2, 0xf3, 0x36, 0x15, 0xe5, 0x61, 0x74, 0xa1, 0xab, 0xf6, 0xda, 0x16, 0x8c, 0xeb, 0xfa, 0x88, 0x68, 0xf4, 0xba, 0x27, 0x3f, 0x16, 0xb7
}; 

static uint8_t s_236  [32] = {
0x20, 0xaa, 0x73, 0xff, 0xe4, 0x8a, 0xfa, 0x64, 0x35, 0xcd, 0x25, 0x8b, 0x17, 0x3d, 0x0c, 0x23, 0x77, 0xd6, 0x90, 0x22, 0xe7, 0xd0, 0x98, 0xd7, 0x5c, 0xaf, 0x24, 0xc8, 0xc5, 0xe0, 0x6b, 0x1c
}; 

#define result___236 0

//Test vector 237:           "comment" : "special case hash",

static uint8_t pkx_237  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_237  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen237 10 

static uint8_t msg_237  [10] = {
0x31, 0x35, 0x36, 0x34, 0x33, 0x34, 0x36, 0x36, 0x30, 0x33
}; 

static uint8_t r_237  [32] = {
0xfd, 0xc7, 0x06, 0x02, 0x76, 0x6f, 0x8e, 0xed, 0x11, 0xa6, 0xc9, 0x9a, 0x71, 0xc9, 0x73, 0xd5, 0x65, 0x93, 0x55, 0x50, 0x7b, 0x84, 0x3d, 0xa6, 0xe3, 0x27, 0xa2, 0x8c, 0x11, 0x89, 0x3d, 0xb9
}; 

static uint8_t s_237  [32] = {
0x3d, 0xf5, 0x34, 0x96, 0x88, 0xa0, 0x85, 0xb1, 0x37, 0xb1, 0xea, 0xcf, 0x45, 0x6a, 0x9e, 0x9e, 0x0f, 0x6d, 0x15, 0xec, 0x00, 0x78, 0xca, 0x60, 0xa7, 0xf8, 0x3f, 0x2b, 0x10, 0xd2, 0x13, 0x50
}; 

#define result___237 0

//Test vector 238:           "comment" : "special case hash",

static uint8_t pkx_238  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_238  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen238 10 

static uint8_t msg_238  [10] = {
0x34, 0x34, 0x32, 0x39, 0x35, 0x33, 0x39, 0x31, 0x31, 0x37
}; 

static uint8_t r_238  [32] = {
0xb5, 0x16, 0xa3, 0x14, 0xf2, 0xfc, 0xe5, 0x30, 0xd6, 0x53, 0x7f, 0x6a, 0x6c, 0x49, 0x96, 0x6c, 0x23, 0x45, 0x6f, 0x63, 0xc6, 0x43, 0xcf, 0x8e, 0x0d, 0xc7, 0x38, 0xf7, 0xb8, 0x76, 0xe6, 0x75
}; 

static uint8_t s_238  [32] = {
0xd3, 0x9f, 0xfd, 0x03, 0x3c, 0x92, 0xb6, 0xd7, 0x17, 0xdd, 0x53, 0x6f, 0xbc, 0x5e, 0xfd, 0xf1, 0x96, 0x7c, 0x4b, 0xd8, 0x09, 0x54, 0x47, 0x9b, 0xa6, 0x6b, 0x01, 0x20, 0xcd, 0x16, 0xff, 0xf2
}; 

#define result___238 0

//Test vector 239:           "comment" : "special case hash",

static uint8_t pkx_239  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_239  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen239 11 

static uint8_t msg_239  [11] = {
0x31, 0x30, 0x39, 0x35, 0x33, 0x32, 0x36, 0x31, 0x33, 0x35, 0x31
}; 

static uint8_t r_239  [32] = {
0x3b, 0x2c, 0xbf, 0x04, 0x6e, 0xac, 0x45, 0x84, 0x2e, 0xcb, 0x79, 0x84, 0xd4, 0x75, 0x83, 0x15, 0x82, 0x71, 0x7b, 0xeb, 0xb6, 0x49, 0x2f, 0xd0, 0xa4, 0x85, 0xc1, 0x01, 0xe2, 0x9f, 0xf0, 0xa8
}; 

static uint8_t s_239  [32] = {
0x4c, 0x9b, 0x7b, 0x47, 0xa9, 0x8b, 0x0f, 0x82, 0xde, 0x51, 0x2b, 0xc9, 0x31, 0x3a, 0xaf, 0x51, 0x70, 0x10, 0x99, 0xca, 0xc5, 0xf7, 0x6e, 0x68, 0xc8, 0x59, 0x5f, 0xc1, 0xc1, 0xd9, 0x92, 0x58
}; 

#define result___239 0

//Test vector 240:           "comment" : "special case hash",

static uint8_t pkx_240  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_240  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen240 10 

static uint8_t msg_240  [10] = {
0x35, 0x39, 0x38, 0x37, 0x33, 0x35, 0x30, 0x30, 0x34, 0x31
}; 

static uint8_t r_240  [32] = {
0x30, 0xc8, 0x7d, 0x35, 0xe6, 0x36, 0xf5, 0x40, 0x84, 0x1f, 0x14, 0xaf, 0x54, 0xe2, 0xf9, 0xed, 0xd7, 0x9d, 0x03, 0x12, 0xcf, 0xa1, 0xab, 0x65, 0x6c, 0x3f, 0xb1, 0x5b, 0xfd, 0xe4, 0x8d, 0xcf
}; 

static uint8_t s_240  [32] = {
0x47, 0xc1, 0x5a, 0x5a, 0x82, 0xd2, 0x4b, 0x75, 0xc8, 0x5a, 0x69, 0x2b, 0xd6, 0xec, 0xaf, 0xeb, 0x71, 0x40, 0x9e, 0xde, 0x23, 0xef, 0xd0, 0x8e, 0x0d, 0xb9, 0xab, 0xf6, 0x34, 0x06, 0x77, 0xed
}; 

#define result___240 0

//Test vector 241:           "comment" : "special case hash",

static uint8_t pkx_241  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_241  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen241 10 

static uint8_t msg_241  [10] = {
0x33, 0x34, 0x36, 0x33, 0x30, 0x30, 0x36, 0x38, 0x37, 0x38
}; 

static uint8_t r_241  [32] = {
0x38, 0x68, 0x6f, 0xf0, 0xfd, 0xa2, 0xce, 0xf6, 0xbc, 0x43, 0xb5, 0x8c, 0xfe, 0x66, 0x47, 0xb9, 0xe2, 0xe8, 0x17, 0x6d, 0x16, 0x8d, 0xec, 0x3c, 0x68, 0xff, 0x26, 0x21, 0x13, 0x76, 0x0f, 0x52
}; 

static uint8_t s_241  [32] = {
0x06, 0x7e, 0xc3, 0xb6, 0x51, 0xf4, 0x22, 0x66, 0x96, 0x01, 0x66, 0x21, 0x67, 0xfa, 0x87, 0x17, 0xe9, 0x76, 0xe2, 0xdb, 0x5e, 0x6a, 0x4c, 0xf7, 0xc2, 0xdd, 0xab, 0xb3, 0xfd, 0xe9, 0xd6, 0x7d
}; 

#define result___241 0

//Test vector 242:           "comment" : "special case hash",

static uint8_t pkx_242  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_242  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen242 10 

static uint8_t msg_242  [10] = {
0x39, 0x38, 0x31, 0x37, 0x33, 0x32, 0x30, 0x32, 0x38, 0x37
}; 

static uint8_t r_242  [32] = {
0x44, 0xa3, 0xe2, 0x3b, 0xf3, 0x14, 0xf2, 0xb3, 0x44, 0xfc, 0x25, 0xc7, 0xf2, 0xde, 0x8b, 0x6a, 0xf3, 0xe1, 0x7d, 0x27, 0xf5, 0xee, 0x84, 0x4b, 0x22, 0x59, 0x85, 0xab, 0x6e, 0x27, 0x75, 0xcf
}; 

static uint8_t s_242  [32] = {
0x2d, 0x48, 0xe2, 0x23, 0x20, 0x5e, 0x98, 0x04, 0x1d, 0xdc, 0x87, 0xbe, 0x53, 0x2a, 0xbe, 0xd5, 0x84, 0xf0, 0x41, 0x1f, 0x57, 0x29, 0x50, 0x04, 0x93, 0xc9, 0xcc, 0x3f, 0x4d, 0xd1, 0x5e, 0x86
}; 

#define result___242 0

//Test vector 243:           "comment" : "special case hash",

static uint8_t pkx_243  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_243  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen243 10 

static uint8_t msg_243  [10] = {
0x33, 0x32, 0x32, 0x32, 0x30, 0x34, 0x31, 0x30, 0x34, 0x36
}; 

static uint8_t r_243  [32] = {
0x2d, 0xed, 0x5b, 0x7e, 0xc8, 0xe9, 0x0e, 0x7b, 0xf1, 0x1f, 0x96, 0x7a, 0x3d, 0x95, 0x11, 0x0c, 0x41, 0xb9, 0x9d, 0xb3, 0xb5, 0xaa, 0x8d, 0x33, 0x0e, 0xb9, 0xd6, 0x38, 0x78, 0x16, 0x88, 0xe9
}; 

static uint8_t s_243  [32] = {
0x7d, 0x57, 0x92, 0xc5, 0x36, 0x28, 0x15, 0x5e, 0x1b, 0xfc, 0x46, 0xfb, 0x1a, 0x67, 0xe3, 0x08, 0x8d, 0xe0, 0x49, 0xc3, 0x28, 0xae, 0x1f, 0x44, 0xec, 0x69, 0x23, 0x8a, 0x00, 0x98, 0x08, 0xf9
}; 

#define result___243 0

//Test vector 244:           "comment" : "special case hash",

static uint8_t pkx_244  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_244  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen244 10 

static uint8_t msg_244  [10] = {
0x36, 0x36, 0x36, 0x36, 0x33, 0x30, 0x37, 0x31, 0x30, 0x34
}; 

static uint8_t r_244  [32] = {
0xbd, 0xae, 0x7b, 0xcb, 0x58, 0x0b, 0xf3, 0x35, 0xef, 0xd3, 0xbc, 0x3d, 0x31, 0x87, 0x0f, 0x92, 0x3e, 0xac, 0xca, 0xfc, 0xd4, 0x0e, 0xc2, 0xf6, 0x05, 0x97, 0x6f, 0x15, 0x13, 0x7d, 0x8b, 0x8f
}; 

static uint8_t s_244  [32] = {
0xf6, 0xdf, 0xa1, 0x2f, 0x19, 0xe5, 0x25, 0x27, 0x0b, 0x01, 0x06, 0xee, 0xcf, 0xe2, 0x57, 0x49, 0x9f, 0x37, 0x3a, 0x4f, 0xb3, 0x18, 0x99, 0x4f, 0x24, 0x83, 0x81, 0x22, 0xce, 0x7e, 0xc3, 0xc7
}; 

#define result___244 0

//Test vector 245:           "comment" : "special case hash",

static uint8_t pkx_245  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_245  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen245 10 

static uint8_t msg_245  [10] = {
0x31, 0x30, 0x33, 0x35, 0x39, 0x35, 0x31, 0x38, 0x39, 0x38
}; 

static uint8_t r_245  [32] = {
0x50, 0xf9, 0xc4, 0xf0, 0xcd, 0x69, 0x40, 0xe1, 0x62, 0x72, 0x09, 0x57, 0xff, 0xff, 0x51, 0x37, 0x99, 0x20, 0x9b, 0x78, 0x59, 0x69, 0x56, 0xd2, 0x1e, 0xce, 0x25, 0x1c, 0x24, 0x01, 0xf1, 0xc6
}; 

static uint8_t s_245  [32] = {
0xd7, 0x03, 0x3a, 0x0a, 0x78, 0x7d, 0x33, 0x8e, 0x88, 0x9d, 0xef, 0xaa, 0xab, 0xb1, 0x06, 0xb9, 0x5a, 0x43, 0x55, 0xe4, 0x11, 0xa5, 0x9c, 0x32, 0xaa, 0x51, 0x67, 0xdf, 0xab, 0x24, 0x47, 0x26
}; 

#define result___245 0

//Test vector 246:           "comment" : "special case hash",

static uint8_t pkx_246  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_246  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen246 10 

static uint8_t msg_246  [10] = {
0x31, 0x38, 0x34, 0x36, 0x35, 0x39, 0x37, 0x31, 0x39, 0x35
}; 

static uint8_t r_246  [32] = {
0xf6, 0x12, 0x82, 0x06, 0x87, 0x60, 0x4f, 0xa0, 0x19, 0x06, 0x06, 0x6a, 0x37, 0x8d, 0x67, 0x54, 0x09, 0x82, 0xe2, 0x95, 0x75, 0xd0, 0x19, 0xaa, 0xbe, 0x90, 0x92, 0x4e, 0xad, 0x5c, 0x86, 0x0d
}; 

static uint8_t s_246  [32] = {
0x3f, 0x93, 0x67, 0x70, 0x2d, 0xd7, 0xdd, 0x4f, 0x75, 0xea, 0x98, 0xaf, 0xd2, 0x0e, 0x32, 0x8a, 0x1a, 0x99, 0xf4, 0x85, 0x7b, 0x31, 0x65, 0x25, 0x32, 0x82, 0x30, 0xce, 0x29, 0x4b, 0x0f, 0xef
}; 

#define result___246 0

//Test vector 247:           "comment" : "special case hash",

static uint8_t pkx_247  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_247  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen247 10 

static uint8_t msg_247  [10] = {
0x33, 0x31, 0x33, 0x36, 0x30, 0x34, 0x36, 0x31, 0x38, 0x39
}; 

static uint8_t r_247  [32] = {
0x95, 0x05, 0xe4, 0x07, 0x65, 0x7d, 0x6e, 0x8b, 0xc9, 0x3d, 0xb5, 0xda, 0x7a, 0xa6, 0xf5, 0x08, 0x1f, 0x61, 0x98, 0x0c, 0x19, 0x49, 0xf5, 0x6b, 0x0f, 0x2f, 0x50, 0x7d, 0xa5, 0x78, 0x2a, 0x7a
}; 

static uint8_t s_247  [32] = {
0xc6, 0x0d, 0x31, 0x90, 0x4e, 0x36, 0x69, 0x73, 0x8f, 0xfb, 0xec, 0xca, 0xb6, 0xc3, 0x65, 0x6c, 0x08, 0xe0, 0xed, 0x5c, 0xb9, 0x2b, 0x3c, 0xfa, 0x5e, 0x7f, 0x71, 0x78, 0x4f, 0x9c, 0x50, 0x21
}; 

#define result___247 0

//Test vector 248:           "comment" : "special case hash",

static uint8_t pkx_248  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_248  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen248 10 

static uint8_t msg_248  [10] = {
0x32, 0x36, 0x36, 0x33, 0x37, 0x38, 0x34, 0x32, 0x35, 0x34
}; 

static uint8_t r_248  [32] = {
0xbb, 0xd1, 0x6f, 0xbb, 0xb6, 0x56, 0xb6, 0xd0, 0xd8, 0x3e, 0x6a, 0x77, 0x87, 0xcd, 0x69, 0x1b, 0x08, 0x73, 0x5a, 0xed, 0x37, 0x17, 0x32, 0x72, 0x3e, 0x1c, 0x68, 0xa4, 0x04, 0x04, 0x51, 0x7d
}; 

static uint8_t s_248  [32] = {
0x9d, 0x8e, 0x35, 0xdb, 0xa9, 0x60, 0x28, 0xb7, 0x78, 0x7d, 0x91, 0x31, 0x5b, 0xe6, 0x75, 0x87, 0x7d, 0x2d, 0x09, 0x7b, 0xe5, 0xe8, 0xee, 0x34, 0x56, 0x0e, 0x3e, 0x7f, 0xd2, 0x5c, 0x0f, 0x00
}; 

#define result___248 0

//Test vector 249:           "comment" : "special case hash",

static uint8_t pkx_249  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_249  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen249 10 

static uint8_t msg_249  [10] = {
0x31, 0x36, 0x35, 0x32, 0x31, 0x30, 0x30, 0x35, 0x32, 0x34
}; 

static uint8_t r_249  [32] = {
0x2e, 0xc9, 0x76, 0x01, 0x22, 0xdb, 0x98, 0xfd, 0x06, 0xea, 0x76, 0x84, 0x8d, 0x35, 0xa6, 0xda, 0x44, 0x2d, 0x2c, 0xee, 0xf7, 0x55, 0x9a, 0x30, 0xcf, 0x57, 0xc6, 0x1e, 0x92, 0xdf, 0x32, 0x7e
}; 

static uint8_t s_249  [32] = {
0x7a, 0xb2, 0x71, 0xda, 0x90, 0x85, 0x94, 0x79, 0x70, 0x1f, 0xcc, 0xf8, 0x6e, 0x46, 0x2e, 0xe3, 0x39, 0x3f, 0xb6, 0x81, 0x4c, 0x27, 0xb7, 0x60, 0xc4, 0x96, 0x36, 0x25, 0xc0, 0xa1, 0x98, 0x78
}; 

#define result___249 0

//Test vector 250:           "comment" : "special case hash",

static uint8_t pkx_250  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_250  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen250 10 

static uint8_t msg_250  [10] = {
0x35, 0x37, 0x34, 0x38, 0x30, 0x38, 0x31, 0x36, 0x39, 0x36
}; 

static uint8_t r_250  [32] = {
0x54, 0xe7, 0x6b, 0x76, 0x83, 0xb6, 0x65, 0x0b, 0xaa, 0x6a, 0x7f, 0xc4, 0x9b, 0x1c, 0x51, 0xee, 0xd9, 0xba, 0x9d, 0xd4, 0x63, 0x22, 0x1f, 0x7a, 0x4f, 0x10, 0x05, 0xa8, 0x9f, 0xe0, 0x0c, 0x59
}; 

static uint8_t s_250  [32] = {
0x2e, 0xa0, 0x76, 0x88, 0x6c, 0x77, 0x3e, 0xb9, 0x37, 0xec, 0x1c, 0xc8, 0x37, 0x4b, 0x79, 0x15, 0xcf, 0xd1, 0x1b, 0x1c, 0x1a, 0xe1, 0x16, 0x61, 0x52, 0xf2, 0xf7, 0x80, 0x6a, 0x31, 0xc8, 0xfd
}; 

#define result___250 0

//Test vector 251:           "comment" : "special case hash",

static uint8_t pkx_251  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_251  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen251 10 

static uint8_t msg_251  [10] = {
0x36, 0x33, 0x34, 0x33, 0x39, 0x31, 0x33, 0x34, 0x36, 0x38
}; 

static uint8_t r_251  [32] = {
0x52, 0x91, 0xde, 0xaf, 0x24, 0x65, 0x9f, 0xfb, 0xbc, 0xe6, 0xe3, 0xc2, 0x6f, 0x60, 0x21, 0x09, 0x7a, 0x74, 0xab, 0xdb, 0xb6, 0x9b, 0xe4, 0xfb, 0x10, 0x41, 0x9c, 0x0c, 0x49, 0x6c, 0x94, 0x66
}; 

static uint8_t s_251  [32] = {
0x65, 0xd6, 0xfc, 0xf3, 0x36, 0xd2, 0x7c, 0xc7, 0xcd, 0xb9, 0x82, 0xbb, 0x4e, 0x4e, 0xce, 0xf5, 0x82, 0x7f, 0x84, 0x74, 0x2f, 0x29, 0xf1, 0x0a, 0xbf, 0x83, 0x46, 0x92, 0x70, 0xa0, 0x3d, 0xc3
}; 

#define result___251 0

//Test vector 252:           "comment" : "special case hash",

static uint8_t pkx_252  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_252  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen252 10 

static uint8_t msg_252  [10] = {
0x31, 0x35, 0x34, 0x31, 0x31, 0x30, 0x33, 0x35, 0x39, 0x38
}; 

static uint8_t r_252  [32] = {
0x20, 0x7a, 0x32, 0x41, 0x81, 0x2d, 0x75, 0xd9, 0x47, 0x41, 0x9d, 0xc5, 0x8e, 0xfb, 0x05, 0xe8, 0x00, 0x3b, 0x33, 0xfc, 0x17, 0xeb, 0x50, 0xf9, 0xd1, 0x51, 0x66, 0xa8, 0x84, 0x79, 0xf1, 0x07
}; 

static uint8_t s_252  [32] = {
0xcd, 0xee, 0x74, 0x9f, 0x2e, 0x49, 0x2b, 0x21, 0x3c, 0xe8, 0x0b, 0x32, 0xd0, 0x57, 0x4f, 0x62, 0xf1, 0xc5, 0xd7, 0x07, 0x93, 0xcf, 0x55, 0xe3, 0x82, 0xd5, 0xca, 0xad, 0xf7, 0x59, 0x27, 0x67
}; 

#define result___252 0

//Test vector 253:           "comment" : "special case hash",

static uint8_t pkx_253  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_253  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen253 11 

static uint8_t msg_253  [11] = {
0x31, 0x30, 0x34, 0x37, 0x38, 0x35, 0x38, 0x30, 0x31, 0x32, 0x38
}; 

static uint8_t r_253  [32] = {
0x65, 0x54, 0xe4, 0x9f, 0x82, 0xa8, 0x55, 0x20, 0x43, 0x28, 0xac, 0x94, 0x91, 0x3b, 0xf0, 0x1b, 0xbe, 0x84, 0x43, 0x7a, 0x35, 0x5a, 0x0a, 0x37, 0xc0, 0xde, 0xe3, 0xcf, 0x81, 0xaa, 0x77, 0x28
}; 

static uint8_t s_253  [32] = {
0xae, 0xa0, 0x0d, 0xe2, 0x50, 0x7d, 0xda, 0xf5, 0xc9, 0x4e, 0x1e, 0x12, 0x69, 0x80, 0xd3, 0xdf, 0x16, 0x25, 0x0a, 0x2e, 0xae, 0xbc, 0x8b, 0xe4, 0x86, 0xef, 0xfe, 0x7f, 0x22, 0xb4, 0xf9, 0x29
}; 

#define result___253 0

//Test vector 254:           "comment" : "special case hash",

static uint8_t pkx_254  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_254  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen254 11 

static uint8_t msg_254  [11] = {
0x31, 0x30, 0x35, 0x33, 0x36, 0x32, 0x38, 0x35, 0x35, 0x36, 0x38
}; 

static uint8_t r_254  [32] = {
0xa5, 0x4c, 0x50, 0x62, 0x64, 0x83, 0x39, 0xd2, 0xbf, 0xf0, 0x6f, 0x71, 0xc8, 0x82, 0x16, 0xc2, 0x6c, 0x6e, 0x19, 0xb4, 0xd8, 0x0a, 0x8c, 0x60, 0x29, 0x90, 0xac, 0x82, 0x70, 0x7e, 0xfd, 0xfc
}; 

static uint8_t s_254  [32] = {
0xe9, 0x9b, 0xbe, 0x7f, 0xcf, 0xaf, 0xae, 0x3e, 0x69, 0xfd, 0x01, 0x67, 0x77, 0x51, 0x7a, 0xa0, 0x10, 0x56, 0x31, 0x7f, 0x46, 0x7a, 0xd0, 0x9a, 0xff, 0x09, 0xbe, 0x73, 0xc9, 0x73, 0x1b, 0x0d
}; 

#define result___254 0

//Test vector 255:           "comment" : "special case hash",

static uint8_t pkx_255  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_255  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen255 9 

static uint8_t msg_255  [9] = {
0x39, 0x35, 0x33, 0x39, 0x30, 0x34, 0x31, 0x30, 0x35
}; 

static uint8_t r_255  [32] = {
0x97, 0x5b, 0xd7, 0x15, 0x7a, 0x8d, 0x36, 0x3b, 0x30, 0x9f, 0x1f, 0x44, 0x40, 0x12, 0xb1, 0xa1, 0xd2, 0x30, 0x96, 0x59, 0x31, 0x33, 0xe7, 0x1b, 0x4c, 0xa8, 0xb0, 0x59, 0xcf, 0xf3, 0x7e, 0xaf
}; 

static uint8_t s_255  [32] = {
0x7f, 0xaa, 0x7a, 0x28, 0xb1, 0xc8, 0x22, 0xba, 0xa2, 0x41, 0x79, 0x3f, 0x2a, 0xbc, 0x93, 0x0b, 0xd4, 0xc6, 0x98, 0x40, 0xfe, 0x09, 0x0f, 0x2a, 0xac, 0xc4, 0x67, 0x86, 0xbf, 0x91, 0x96, 0x22
}; 

#define result___255 0

//Test vector 256:           "comment" : "special case hash",

static uint8_t pkx_256  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_256  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen256 9 

static uint8_t msg_256  [9] = {
0x39, 0x37, 0x38, 0x38, 0x34, 0x38, 0x30, 0x33, 0x39
}; 

static uint8_t r_256  [32] = {
0x56, 0x94, 0xa6, 0xf8, 0x4b, 0x8f, 0x87, 0x5c, 0x27, 0x6a, 0xfd, 0x2e, 0xbc, 0xfe, 0x4d, 0x61, 0xde, 0x9e, 0xc9, 0x03, 0x05, 0xaf, 0xb1, 0x35, 0x7b, 0x95, 0xb3, 0xe0, 0xda, 0x43, 0x88, 0x5e
}; 

static uint8_t s_256  [32] = {
0x0d, 0xff, 0xad, 0x9f, 0xfd, 0x0b, 0x75, 0x7d, 0x80, 0x51, 0xde, 0xc0, 0x2e, 0xbd, 0xf7, 0x0d, 0x8e, 0xe2, 0xdc, 0x5c, 0x78, 0x70, 0xc0, 0x82, 0x3b, 0x6c, 0xcc, 0x7c, 0x67, 0x9c, 0xba, 0xa4
}; 

#define result___256 0

//Test vector 257:           "comment" : "special case hash",

static uint8_t pkx_257  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_257  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen257 10 

static uint8_t msg_257  [10] = {
0x33, 0x36, 0x31, 0x30, 0x36, 0x37, 0x32, 0x34, 0x34, 0x32
}; 

static uint8_t r_257  [32] = {
0xa0, 0xc3, 0x0e, 0x80, 0x26, 0xfd, 0xb2, 0xb4, 0xb4, 0x96, 0x8a, 0x27, 0xd1, 0x6a, 0x6d, 0x08, 0xf7, 0x09, 0x8f, 0x1a, 0x98, 0xd2, 0x16, 0x20, 0xd7, 0x45, 0x4b, 0xa9, 0x79, 0x0f, 0x1b, 0xa6
}; 

static uint8_t s_257  [32] = {
0x5e, 0x47, 0x04, 0x53, 0xa8, 0xa3, 0x99, 0xf1, 0x5b, 0xaf, 0x46, 0x3f, 0x9d, 0xec, 0xeb, 0x53, 0xac, 0xc5, 0xca, 0x64, 0x45, 0x91, 0x49, 0x68, 0x8b, 0xd2, 0x76, 0x0c, 0x65, 0x42, 0x43, 0x39
}; 

#define result___257 0

//Test vector 258:           "comment" : "special case hash",

static uint8_t pkx_258  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_258  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen258 10 

static uint8_t msg_258  [10] = {
0x31, 0x30, 0x35, 0x34, 0x32, 0x34, 0x30, 0x37, 0x30, 0x35
}; 

static uint8_t r_258  [32] = {
0x61, 0x4e, 0xa8, 0x4a, 0xcf, 0x73, 0x65, 0x27, 0xdd, 0x73, 0x60, 0x2c, 0xd4, 0xbb, 0x4e, 0xea, 0x1d, 0xfe, 0xbe, 0xbd, 0x5a, 0xd8, 0xac, 0xa5, 0x2a, 0xa0, 0x22, 0x8c, 0xf7, 0xb9, 0x9a, 0x88
}; 

static uint8_t s_258  [32] = {
0x73, 0x7c, 0xc8, 0x5f, 0x5f, 0x2d, 0x2f, 0x60, 0xd1, 0xb8, 0x18, 0x3f, 0x3e, 0xd4, 0x90, 0xe4, 0xde, 0x14, 0x36, 0x8e, 0x96, 0xa9, 0x48, 0x2c, 0x2a, 0x4d, 0xd1, 0x93, 0x19, 0x5c, 0x90, 0x2f
}; 

#define result___258 0

//Test vector 259:           "comment" : "special case hash",

static uint8_t pkx_259  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_259  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen259 10 

static uint8_t msg_259  [10] = {
0x35, 0x31, 0x37, 0x34, 0x34, 0x34, 0x38, 0x31, 0x39, 0x37
}; 

static uint8_t r_259  [32] = {
0xbe, 0xad, 0x67, 0x34, 0xeb, 0xe4, 0x4b, 0x81, 0x0d, 0x3f, 0xb2, 0xea, 0x00, 0xb1, 0x73, 0x29, 0x45, 0x37, 0x73, 0x38, 0xfe, 0xbf, 0xd4, 0x39, 0xa8, 0xd7, 0x4d, 0xfb, 0xd0, 0xf9, 0x42, 0xfa
}; 

static uint8_t s_259  [32] = {
0x6b, 0xb1, 0x8e, 0xae, 0x36, 0x61, 0x6a, 0x7d, 0x3c, 0xad, 0x35, 0x91, 0x9f, 0xd2, 0x1a, 0x8a, 0xf4, 0xbb, 0xe7, 0xa1, 0x0f, 0x73, 0xb3, 0xe0, 0x36, 0xa4, 0x6b, 0x10, 0x3e, 0xf5, 0x6e, 0x2a
}; 

#define result___259 0

//Test vector 260:           "comment" : "special case hash",

static uint8_t pkx_260  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_260  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen260 10 

static uint8_t msg_260  [10] = {
0x31, 0x39, 0x36, 0x37, 0x35, 0x36, 0x31, 0x32, 0x35, 0x31
}; 

static uint8_t r_260  [32] = {
0x49, 0x96, 0x25, 0x47, 0x9e, 0x16, 0x1d, 0xac, 0xd4, 0xdb, 0x9d, 0x9c, 0xe6, 0x48, 0x54, 0xc9, 0x8d, 0x92, 0x2c, 0xbf, 0x21, 0x27, 0x03, 0xe9, 0x65, 0x4f, 0xae, 0x18, 0x2d, 0xf9, 0xba, 0xd2
}; 

static uint8_t s_260  [32] = {
0x42, 0xc1, 0x77, 0xcf, 0x37, 0xb8, 0x19, 0x3a, 0x01, 0x31, 0x10, 0x8d, 0x97, 0x81, 0x9e, 0xdd, 0x94, 0x39, 0x93, 0x60, 0x28, 0x86, 0x4a, 0xc1, 0x95, 0xb6, 0x4f, 0xca, 0x76, 0xd9, 0xd6, 0x93
}; 

#define result___260 0

//Test vector 261:           "comment" : "special case hash",

static uint8_t pkx_261  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_261  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen261 10 

static uint8_t msg_261  [10] = {
0x33, 0x34, 0x34, 0x37, 0x32, 0x35, 0x33, 0x33, 0x34, 0x33
}; 

static uint8_t r_261  [32] = {
0x08, 0xf1, 0x6b, 0x80, 0x93, 0xa8, 0xfb, 0x4d, 0x66, 0xa2, 0xc8, 0x06, 0x5b, 0x54, 0x1b, 0x3d, 0x31, 0xe3, 0xbf, 0xe6, 0x94, 0xf6, 0xb8, 0x9c, 0x50, 0xfb, 0x1a, 0xaa, 0x6f, 0xf6, 0xc9, 0xb2
}; 

static uint8_t s_261  [32] = {
0x9d, 0x64, 0x55, 0xe2, 0xd5, 0xd1, 0x77, 0x97, 0x48, 0x57, 0x3b, 0x61, 0x1c, 0xb9, 0x5d, 0x4a, 0x21, 0xf9, 0x67, 0x41, 0x03, 0x99, 0xb3, 0x9b, 0x53, 0x5b, 0xa3, 0xe5, 0xaf, 0x81, 0xca, 0x2e
}; 

#define result___261 0

//Test vector 262:           "comment" : "special case hash",

static uint8_t pkx_262  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_262  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen262 9 

static uint8_t msg_262  [9] = {
0x33, 0x36, 0x38, 0x32, 0x36, 0x34, 0x33, 0x31, 0x38
}; 

static uint8_t r_262  [32] = {
0xbe, 0x26, 0x23, 0x1b, 0x61, 0x91, 0x65, 0x8a, 0x19, 0xdd, 0x72, 0xdd, 0xb9, 0x9e, 0xd8, 0xf8, 0xc5, 0x79, 0xb6, 0x93, 0x8d, 0x19, 0xbc, 0xe8, 0xee, 0xd8, 0xdc, 0x2b, 0x33, 0x8c, 0xb5, 0xf8
}; 

static uint8_t s_262  [32] = {
0xe1, 0xd9, 0xa3, 0x2e, 0xe5, 0x6c, 0xff, 0xed, 0x37, 0xf0, 0xf2, 0x2b, 0x2d, 0xcb, 0x57, 0xd5, 0xc9, 0x43, 0xc1, 0x4f, 0x79, 0x69, 0x4a, 0x03, 0xb9, 0xc5, 0xe9, 0x69, 0x52, 0x57, 0x5c, 0x89
}; 

#define result___262 0

//Test vector 263:           "comment" : "special case hash",

static uint8_t pkx_263  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_263  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen263 10 

static uint8_t msg_263  [10] = {
0x33, 0x32, 0x36, 0x31, 0x31, 0x39, 0x38, 0x36, 0x30, 0x38
}; 

static uint8_t r_263  [32] = {
0x15, 0xe7, 0x68, 0x80, 0x89, 0x83, 0x16, 0xb1, 0x62, 0x04, 0xac, 0x92, 0x0a, 0x02, 0xd5, 0x80, 0x45, 0xf3, 0x6a, 0x22, 0x9d, 0x4a, 0xa4, 0xf8, 0x12, 0x63, 0x8c, 0x45, 0x5a, 0xbe, 0x04, 0x43
}; 

static uint8_t s_263  [32] = {
0xe7, 0x4d, 0x35, 0x7d, 0x3f, 0xcb, 0x5c, 0x8c, 0x53, 0x37, 0xbd, 0x6a, 0xba, 0x41, 0x78, 0xb4, 0x55, 0xca, 0x10, 0xe2, 0x26, 0xe1, 0x3f, 0x96, 0x38, 0x19, 0x65, 0x06, 0xa1, 0x93, 0x91, 0x23
}; 

#define result___263 0

//Test vector 264:           "comment" : "special case hash",

static uint8_t pkx_264  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_264  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen264 10 

static uint8_t msg_264  [10] = {
0x39, 0x36, 0x37, 0x38, 0x37, 0x38, 0x31, 0x30, 0x39, 0x34
}; 

static uint8_t r_264  [32] = {
0x35, 0x2e, 0xcb, 0x53, 0xf8, 0xdf, 0x2c, 0x50, 0x3a, 0x45, 0xf9, 0x84, 0x6f, 0xc2, 0x8d, 0x1d, 0x31, 0xe6, 0x30, 0x7d, 0x3d, 0xdb, 0xff, 0xc1, 0x13, 0x23, 0x15, 0xcc, 0x07, 0xf1, 0x6d, 0xad
}; 

static uint8_t s_264  [32] = {
0x13, 0x48, 0xdf, 0xa9, 0xc4, 0x82, 0xc5, 0x58, 0xe1, 0xd0, 0x5c, 0x52, 0x42, 0xca, 0x1c, 0x39, 0x43, 0x67, 0x26, 0xec, 0xd2, 0x82, 0x58, 0xb1, 0x89, 0x97, 0x92, 0x88, 0x7d, 0xd0, 0xa3, 0xc6
}; 

#define result___264 0

//Test vector 265:           "comment" : "special case hash",

static uint8_t pkx_265  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_265  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen265 10 

static uint8_t msg_265  [10] = {
0x34, 0x39, 0x35, 0x38, 0x38, 0x32, 0x33, 0x38, 0x32, 0x33
}; 

static uint8_t r_265  [32] = {
0x4a, 0x40, 0x80, 0x1a, 0x7e, 0x60, 0x6b, 0xa7, 0x8a, 0x0d, 0xa9, 0x88, 0x2a, 0xb2, 0x3c, 0x76, 0x77, 0xb8, 0x64, 0x23, 0x49, 0xed, 0x3d, 0x65, 0x2c, 0x5b, 0xfa, 0x5f, 0x2a, 0x95, 0x58, 0xfb
}; 

static uint8_t s_265  [32] = {
0x3a, 0x49, 0xb6, 0x48, 0x48, 0xd6, 0x82, 0xef, 0x7f, 0x60, 0x5f, 0x28, 0x32, 0xf7, 0x38, 0x4b, 0xdc, 0x24, 0xed, 0x29, 0x25, 0x82, 0x5b, 0xf8, 0xea, 0x77, 0xdc, 0x59, 0x81, 0x72, 0x57, 0x82
}; 

#define result___265 0

//Test vector 266:           "comment" : "special case hash",

static uint8_t pkx_266  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_266  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen266 9 

static uint8_t msg_266  [9] = {
0x38, 0x32, 0x34, 0x36, 0x33, 0x37, 0x38, 0x33, 0x37
}; 

static uint8_t r_266  [32] = {
0xea, 0xcc, 0x5e, 0x1a, 0x83, 0x04, 0xa7, 0x4d, 0x2b, 0xe4, 0x12, 0xb0, 0x78, 0x92, 0x4b, 0x3b, 0xb3, 0x51, 0x1b, 0xac, 0x85, 0x5c, 0x05, 0xc9, 0xe5, 0xe9, 0xe4, 0x4d, 0xf3, 0xd6, 0x1e, 0x96
}; 

static uint8_t s_266  [32] = {
0x74, 0x51, 0xcd, 0x8e, 0x18, 0xd6, 0xed, 0x18, 0x85, 0xdd, 0x82, 0x77, 0x14, 0x84, 0x7f, 0x96, 0xec, 0x4b, 0xb0, 0xed, 0x4c, 0x36, 0xce, 0x98, 0x08, 0xdb, 0x8f, 0x71, 0x42, 0x04, 0xf6, 0xd1
}; 

#define result___266 0

//Test vector 267:           "comment" : "special case hash",

static uint8_t pkx_267  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_267  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen267 11 

static uint8_t msg_267  [11] = {
0x31, 0x31, 0x30, 0x32, 0x30, 0x38, 0x33, 0x33, 0x37, 0x37, 0x36
}; 

static uint8_t r_267  [32] = {
0x2f, 0x7a, 0x5e, 0x9e, 0x57, 0x71, 0xd4, 0x24, 0xf3, 0x0f, 0x67, 0xfd, 0xab, 0x61, 0xe8, 0xce, 0x4f, 0x8c, 0xd1, 0x21, 0x48, 0x82, 0xad, 0xb6, 0x5f, 0x7d, 0xe9, 0x4c, 0x31, 0x57, 0x70, 0x52
}; 

static uint8_t s_267  [32] = {
0xac, 0x4e, 0x69, 0x80, 0x83, 0x45, 0x80, 0x9b, 0x44, 0xac, 0xb0, 0xb2, 0xbd, 0x88, 0x91, 0x75, 0xfb, 0x75, 0xdd, 0x05, 0x0c, 0x5a, 0x44, 0x9a, 0xb9, 0x52, 0x8f, 0x8f, 0x78, 0xda, 0xa1, 0x0c
}; 

#define result___267 0

//Test vector 268:           "comment" : "special case hash",

static uint8_t pkx_268  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_268  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen268 9 

static uint8_t msg_268  [9] = {
0x31, 0x33, 0x33, 0x38, 0x37, 0x31, 0x36, 0x34, 0x38
}; 

static uint8_t r_268  [32] = {
0xff, 0xcd, 0xa4, 0x0f, 0x79, 0x2c, 0xe4, 0xd9, 0x3e, 0x7e, 0x0f, 0x0e, 0x95, 0xe1, 0xa2, 0x14, 0x7d, 0xdd, 0xd7, 0xf6, 0x48, 0x76, 0x21, 0xc3, 0x0a, 0x03, 0xd7, 0x10, 0xb3, 0x30, 0x02, 0x19
}; 

static uint8_t s_268  [32] = {
0x79, 0x93, 0x8b, 0x55, 0xf8, 0xa1, 0x7f, 0x7e, 0xd7, 0xba, 0x9a, 0xde, 0x8f, 0x20, 0x65, 0xa1, 0xfa, 0x77, 0x61, 0x8f, 0x0b, 0x67, 0xad, 0xd8, 0xd5, 0x8c, 0x42, 0x2c, 0x24, 0x53, 0xa4, 0x9a
}; 

#define result___268 0

//Test vector 269:           "comment" : "special case hash",

static uint8_t pkx_269  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_269  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen269 9 

static uint8_t msg_269  [9] = {
0x33, 0x32, 0x32, 0x31, 0x34, 0x34, 0x31, 0x36, 0x32
}; 

static uint8_t r_269  [32] = {
0x81, 0xf2, 0x35, 0x9c, 0x4f, 0xab, 0xa6, 0xb5, 0x3d, 0x3e, 0x8c, 0x8c, 0x3f, 0xcc, 0x16, 0xa9, 0x48, 0x35, 0x0f, 0x7a, 0xb3, 0xa5, 0x88, 0xb2, 0x8c, 0x17, 0x60, 0x3a, 0x43, 0x1e, 0x39, 0xa8
}; 

static uint8_t s_269  [32] = {
0xcd, 0x6f, 0x6a, 0x5c, 0xc3, 0xb5, 0x5e, 0xad, 0x0f, 0xf6, 0x95, 0xd0, 0x6c, 0x68, 0x60, 0xb5, 0x09, 0xe4, 0x6d, 0x99, 0xfc, 0xce, 0xfb, 0x9f, 0x7f, 0x9e, 0x10, 0x18, 0x57, 0xf7, 0x43, 0x00
}; 

#define result___269 0

//Test vector 270:           "comment" : "special case hash",

static uint8_t pkx_270  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_270  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen270 11 

static uint8_t msg_270  [11] = {
0x31, 0x30, 0x36, 0x38, 0x36, 0x36, 0x35, 0x35, 0x35, 0x34, 0x36
}; 

static uint8_t r_270  [32] = {
0xdf, 0xc8, 0xbf, 0x52, 0x04, 0x45, 0xcb, 0xb8, 0xee, 0x15, 0x96, 0xfb, 0x07, 0x3e, 0xa2, 0x83, 0xea, 0x13, 0x02, 0x51, 0xa6, 0xfd, 0xff, 0xa5, 0xc3, 0xf5, 0xf2, 0xaa, 0xf7, 0x5c, 0xa8, 0x08
}; 

static uint8_t s_270  [32] = {
0x04, 0x8e, 0x33, 0xef, 0xce, 0x14, 0x7c, 0x9d, 0xd9, 0x28, 0x23, 0x64, 0x0e, 0x33, 0x8e, 0x68, 0xbf, 0xd7, 0xd0, 0xdc, 0x7a, 0x49, 0x05, 0xb3, 0xa7, 0xac, 0x71, 0x1e, 0x57, 0x7e, 0x90, 0xe7
}; 

#define result___270 0

//Test vector 271:           "comment" : "special case hash",

static uint8_t pkx_271  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_271  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen271 8 

static uint8_t msg_271  [8] = {
0x36, 0x32, 0x31, 0x35, 0x35, 0x32, 0x34, 0x36
}; 

static uint8_t r_271  [32] = {
0xad, 0x01, 0x9f, 0x74, 0xc6, 0x94, 0x1d, 0x20, 0xef, 0xda, 0x70, 0xb4, 0x6c, 0x53, 0xdb, 0x16, 0x65, 0x03, 0xa0, 0xe3, 0x93, 0xe9, 0x32, 0xf6, 0x88, 0x22, 0x76, 0x88, 0xba, 0x6a, 0x57, 0x62
}; 

static uint8_t s_271  [32] = {
0x93, 0x32, 0x0e, 0xb7, 0xca, 0x07, 0x10, 0x25, 0x53, 0x46, 0xbd, 0xbb, 0x31, 0x02, 0xcd, 0xcf, 0x79, 0x64, 0xef, 0x2e, 0x09, 0x88, 0xe7, 0x12, 0xbc, 0x05, 0xef, 0xe1, 0x6c, 0x19, 0x93, 0x45
}; 

#define result___271 0

//Test vector 272:           "comment" : "special case hash",

static uint8_t pkx_272  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_272  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen272 10 

static uint8_t msg_272  [10] = {
0x37, 0x30, 0x33, 0x30, 0x38, 0x31, 0x38, 0x37, 0x37, 0x34
}; 

static uint8_t r_272  [32] = {
0xac, 0x80, 0x96, 0x84, 0x2e, 0x8a, 0xdd, 0x68, 0xc3, 0x4e, 0x78, 0xce, 0x11, 0xdd, 0x71, 0xe4, 0xb5, 0x43, 0x16, 0xbd, 0x3e, 0xbf, 0x7f, 0xff, 0xde, 0xb7, 0xbd, 0x5a, 0x3e, 0xbc, 0x18, 0x83
}; 

static uint8_t s_272  [32] = {
0xf5, 0xca, 0x2f, 0x4f, 0x23, 0xd6, 0x74, 0x50, 0x2d, 0x4c, 0xaf, 0x85, 0xd1, 0x87, 0x21, 0x5d, 0x36, 0xe3, 0xce, 0x9f, 0x0c, 0xe2, 0x19, 0x70, 0x9f, 0x21, 0xa3, 0xaa, 0xc0, 0x03, 0xb7, 0xa8
}; 

#define result___272 0

//Test vector 273:           "comment" : "special case hash",

static uint8_t pkx_273  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_273  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen273 10 

static uint8_t msg_273  [10] = {
0x35, 0x39, 0x32, 0x34, 0x35, 0x32, 0x33, 0x37, 0x34, 0x34
}; 

static uint8_t r_273  [32] = {
0x67, 0x7b, 0x2d, 0x3a, 0x59, 0xb1, 0x8a, 0x5f, 0xf9, 0x39, 0xb7, 0x0e, 0xa0, 0x02, 0x25, 0x08, 0x89, 0xdd, 0xcd, 0x7b, 0x7b, 0x9d, 0x77, 0x68, 0x54, 0xb4, 0x94, 0x36, 0x93, 0xfb, 0x92, 0xf7
}; 

static uint8_t s_273  [32] = {
0x6b, 0x4b, 0xa8, 0x56, 0xad, 0xe7, 0x67, 0x7b, 0xf3, 0x03, 0x07, 0xb2, 0x1f, 0x3c, 0xcd, 0xa3, 0x5d, 0x2f, 0x63, 0xae, 0xe8, 0x1e, 0xfd, 0x0b, 0xab, 0x69, 0x72, 0xcc, 0x07, 0x95, 0xdb, 0x55
}; 

#define result___273 0

//Test vector 274:           "comment" : "special case hash",

static uint8_t pkx_274  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_274  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen274 10 

static uint8_t msg_274  [10] = {
0x31, 0x34, 0x39, 0x35, 0x35, 0x38, 0x36, 0x36, 0x32, 0x31
}; 

static uint8_t r_274  [32] = {
0x47, 0x9e, 0x1d, 0xed, 0x14, 0xbc, 0xae, 0xd0, 0x37, 0x9b, 0xa8, 0xe1, 0xb7, 0x3d, 0x31, 0x15, 0xd8, 0x4d, 0x31, 0xd4, 0xb7, 0xc3, 0x0e, 0x1f, 0x05, 0xe1, 0xfc, 0x0d, 0x59, 0x57, 0xcf, 0xb0
}; 

static uint8_t s_274  [32] = {
0x91, 0x8f, 0x79, 0xe3, 0x5b, 0x3d, 0x89, 0x48, 0x7c, 0xf6, 0x34, 0xa4, 0xf0, 0x5b, 0x2e, 0x0c, 0x30, 0x85, 0x7c, 0xa8, 0x79, 0xf9, 0x7c, 0x77, 0x1e, 0x87, 0x70, 0x27, 0x35, 0x5b, 0x24, 0x43
}; 

#define result___274 0

//Test vector 275:           "comment" : "special case hash",

static uint8_t pkx_275  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_275  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen275 10 

static uint8_t msg_275  [10] = {
0x34, 0x30, 0x30, 0x35, 0x33, 0x31, 0x34, 0x34, 0x30, 0x36
}; 

static uint8_t r_275  [32] = {
0x43, 0xdf, 0xcc, 0xd0, 0xed, 0xb9, 0xe2, 0x80, 0xd9, 0xa5, 0x8f, 0x01, 0x16, 0x4d, 0x55, 0xc3, 0xd7, 0x11, 0xe1, 0x4b, 0x12, 0xac, 0x5c, 0xf3, 0xb6, 0x48, 0x40, 0xea, 0xd5, 0x12, 0xa0, 0xa3
}; 

static uint8_t s_275  [32] = {
0x1d, 0xbe, 0x33, 0xfa, 0x8b, 0xa8, 0x45, 0x33, 0xcd, 0x5c, 0x49, 0x34, 0x36, 0x5b, 0x34, 0x42, 0xca, 0x11, 0x74, 0x89, 0x9b, 0x78, 0xef, 0x9a, 0x31, 0x99, 0xf4, 0x95, 0x84, 0x38, 0x97, 0x72
}; 

#define result___275 0

//Test vector 276:           "comment" : "special case hash",

static uint8_t pkx_276  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_276  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen276 10 

static uint8_t msg_276  [10] = {
0x33, 0x30, 0x39, 0x36, 0x34, 0x35, 0x37, 0x35, 0x31, 0x32
}; 

static uint8_t r_276  [32] = {
0x5b, 0x09, 0xab, 0x63, 0x7b, 0xd4, 0xca, 0xf0, 0xf4, 0xc7, 0xc7, 0xe4, 0xbc, 0xa5, 0x92, 0xfe, 0xa2, 0x0e, 0x90, 0x87, 0xc2, 0x59, 0xd2, 0x6a, 0x38, 0xbb, 0x40, 0x85, 0xf0, 0xbb, 0xff, 0x11
}; 

static uint8_t s_276  [32] = {
0x45, 0xb7, 0xeb, 0x46, 0x7b, 0x67, 0x48, 0xaf, 0x61, 0x8e, 0x9d, 0x80, 0xd6, 0xfd, 0xcd, 0x6a, 0xa2, 0x49, 0x64, 0xe5, 0xa1, 0x3f, 0x88, 0x5b, 0xca, 0x81, 0x01, 0xde, 0x08, 0xeb, 0x0d, 0x75
}; 

#define result___276 0

//Test vector 277:           "comment" : "special case hash",

static uint8_t pkx_277  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_277  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen277 10 

static uint8_t msg_277  [10] = {
0x32, 0x37, 0x38, 0x34, 0x30, 0x32, 0x35, 0x36, 0x32, 0x30
}; 

static uint8_t r_277  [32] = {
0x5e, 0x9b, 0x1c, 0x5a, 0x02, 0x80, 0x70, 0xdf, 0x57, 0x28, 0xc5, 0xc8, 0xaf, 0x9b, 0x74, 0xe0, 0x66, 0x7a, 0xfa, 0x57, 0x0a, 0x6c, 0xfa, 0x01, 0x14, 0xa5, 0x03, 0x9e, 0xd1, 0x5e, 0xe0, 0x6f
}; 

static uint8_t s_277  [32] = {
0xb1, 0x36, 0x09, 0x07, 0xe2, 0xd9, 0x78, 0x5e, 0xad, 0x36, 0x2b, 0xb8, 0xd7, 0xbd, 0x66, 0x1b, 0x6c, 0x29, 0xee, 0xff, 0xd3, 0xc5, 0x03, 0x77, 0x44, 0xed, 0xae, 0xb9, 0xad, 0x99, 0x0c, 0x20
}; 

#define result___277 0

//Test vector 278:           "comment" : "special case hash",

static uint8_t pkx_278  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_278  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen278 10 

static uint8_t msg_278  [10] = {
0x32, 0x36, 0x31, 0x38, 0x37, 0x38, 0x37, 0x34, 0x31, 0x38
}; 

static uint8_t r_278  [32] = {
0x06, 0x71, 0xa0, 0xa8, 0x5c, 0x2b, 0x72, 0xd5, 0x4a, 0x2f, 0xb0, 0x99, 0x0e, 0x34, 0x53, 0x8b, 0x48, 0x90, 0x05, 0x0f, 0x5a, 0x57, 0x12, 0xf6, 0xd1, 0xa7, 0xa5, 0xfb, 0x85, 0x78, 0xf3, 0x2e
}; 

static uint8_t s_278  [32] = {
0xdb, 0x18, 0x46, 0xba, 0xb6, 0xb7, 0x36, 0x14, 0x79, 0xab, 0x9c, 0x32, 0x85, 0xca, 0x41, 0x29, 0x18, 0x08, 0xf2, 0x7f, 0xd5, 0xbd, 0x4f, 0xda, 0xc7, 0x20, 0xe5, 0x85, 0x47, 0x13, 0x69, 0x4c
}; 

#define result___278 0

//Test vector 279:           "comment" : "special case hash",

static uint8_t pkx_279  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_279  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen279 10 

static uint8_t msg_279  [10] = {
0x31, 0x36, 0x34, 0x32, 0x36, 0x32, 0x35, 0x32, 0x36, 0x32
}; 

static uint8_t r_279  [32] = {
0x76, 0x73, 0xf8, 0x52, 0x67, 0x48, 0x44, 0x64, 0x77, 0xdb, 0xbb, 0x05, 0x90, 0xa4, 0x54, 0x92, 0xc5, 0xd7, 0xd6, 0x98, 0x59, 0xd3, 0x01, 0xab, 0xba, 0xed, 0xb3, 0x5b, 0x20, 0x95, 0x10, 0x3a
}; 

static uint8_t s_279  [32] = {
0x3d, 0xc7, 0x0d, 0xdf, 0x9c, 0x6b, 0x52, 0x4d, 0x88, 0x6b, 0xed, 0x9e, 0x6a, 0xf0, 0x2e, 0x0e, 0x4d, 0xec, 0x0d, 0x41, 0x7a, 0x41, 0x4f, 0xed, 0x38, 0x07, 0xef, 0x44, 0x22, 0x91, 0x3d, 0x7c
}; 

#define result___279 0

//Test vector 280:           "comment" : "special case hash",

static uint8_t pkx_280  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_280  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen280 10 

static uint8_t msg_280  [10] = {
0x36, 0x38, 0x32, 0x34, 0x31, 0x38, 0x39, 0x34, 0x33, 0x36
}; 

static uint8_t r_280  [32] = {
0x7f, 0x08, 0x54, 0x41, 0x07, 0x0e, 0xcd, 0x2b, 0xb2, 0x12, 0x85, 0x08, 0x9e, 0xbb, 0x1a, 0xa6, 0x45, 0x0d, 0x1a, 0x06, 0xc3, 0x6d, 0x3f, 0xf3, 0x9d, 0xfd, 0x65, 0x7a, 0x79, 0x6d, 0x12, 0xb5
}; 

static uint8_t s_280  [32] = {
0x24, 0x97, 0x12, 0x01, 0x20, 0x29, 0x87, 0x0a, 0x24, 0x59, 0xd1, 0x8d, 0x47, 0xda, 0x9a, 0xa4, 0x92, 0xa5, 0xe6, 0xcb, 0x4b, 0x2d, 0x8d, 0xaf, 0xa9, 0xe4, 0xc5, 0xc5, 0x4a, 0x2b, 0x9a, 0x8b
}; 

#define result___280 0

//Test vector 281:           "comment" : "special case hash",

static uint8_t pkx_281  [32] = { 
0x29, 0x27, 0xb1, 0x05, 0x12, 0xba, 0xe3, 0xed, 0xdc, 0xfe, 0x46, 0x78, 0x28, 0x12, 0x8b, 0xad, 0x29, 0x03, 0x26, 0x99, 0x19, 0xf7, 0x08, 0x60, 0x69, 0xc8, 0xc4, 0xdf, 0x6c, 0x73, 0x28, 0x38}; 

static uint8_t pky_281  [32] = {
0xc7, 0x78, 0x79, 0x64, 0xea, 0xac, 0x00, 0xe5, 0x92, 0x1f, 0xb1, 0x49, 0x8a, 0x60, 0xf4, 0x60, 0x67, 0x66, 0xb3, 0xd9, 0x68, 0x50, 0x01, 0x55, 0x8d, 0x1a, 0x97, 0x4e, 0x73, 0x41, 0x51, 0x3e};

#define mLen281 9 

static uint8_t msg_281  [9] = {
0x34, 0x38, 0x34, 0x32, 0x34, 0x35, 0x34, 0x32, 0x35
}; 

static uint8_t r_281  [32] = {
0x91, 0x4c, 0x67, 0xfb, 0x61, 0xdd, 0x1e, 0x27, 0xc8, 0x67, 0x39, 0x8e, 0xa7, 0x32, 0x2d, 0x5a, 0xb7, 0x6d, 0xf0, 0x4b, 0xc5, 0xaa, 0x66, 0x83, 0xa8, 0xe0, 0xf3, 0x0a, 0x5d, 0x28, 0x73, 0x48
}; 

static uint8_t s_281  [32] = {
0xfa, 0x07, 0x47, 0x40, 0x31, 0x48, 0x1d, 0xda, 0x49, 0x53, 0xe3, 0xac, 0x19, 0x59, 0xee, 0x8c, 0xea, 0x7e, 0x66, 0xec, 0x41, 0x2b, 0x38, 0xd6, 0xc9, 0x6d, 0x28, 0xf6, 0xd3, 0x73, 0x04, 0xea
}; 

#define result___281 0

//Test vector 282:           "comment" : "k*G has a large x-coordinate",

static uint8_t pkx_282  [32] = { 
0x0a, 0xd9, 0x95, 0x00, 0x28, 0x8d, 0x46, 0x69, 0x40, 0x03, 0x1d, 0x72, 0xa9, 0xf5, 0x44, 0x5a, 0x4d, 0x43, 0x78, 0x46, 0x40, 0x85, 0x5b, 0xf0, 0xa6, 0x98, 0x74, 0xd2, 0xde, 0x5f, 0xe1, 0x03}; 

static uint8_t pky_282  [32] = {
0xc5, 0x01, 0x1e, 0x6e, 0xf2, 0xc4, 0x2d, 0xcd, 0x50, 0xd5, 0xd3, 0xd2, 0x9f, 0x99, 0xae, 0x6e, 0xba, 0x2c, 0x80, 0xc9, 0x24, 0x4f, 0x4c, 0x54, 0x22, 0xf0, 0x97, 0x9f, 0xf0, 0xc3, 0xba, 0x5e};

#define mLen282 6 

static uint8_t msg_282  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_282  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x43, 0x19, 0x05, 0x53, 0x58, 0xe8, 0x61, 0x7b, 
	0x0c, 0x46, 0x35, 0x3d, 0x03, 0x9c, 0xda, 0xab
}; 

static uint8_t s_282  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4e
}; 

#define result___282 0

//Test vector 283:           "comment" : "r too large",

static uint8_t pkx_283  [32] = { 
0x0a, 0xd9, 0x95, 0x00, 0x28, 0x8d, 0x46, 0x69, 0x40, 0x03, 0x1d, 0x72, 0xa9, 0xf5, 0x44, 0x5a, 0x4d, 0x43, 0x78, 0x46, 0x40, 0x85, 0x5b, 0xf0, 0xa6, 0x98, 0x74, 0xd2, 0xde, 0x5f, 0xe1, 0x03}; 

static uint8_t pky_283  [32] = {
0xc5, 0x01, 0x1e, 0x6e, 0xf2, 0xc4, 0x2d, 0xcd, 0x50, 0xd5, 0xd3, 0xd2, 0x9f, 0x99, 0xae, 0x6e, 0xba, 0x2c, 0x80, 0xc9, 0x24, 0x4f, 0x4c, 0x54, 0x22, 0xf0, 0x97, 0x9f, 0xf0, 0xc3, 0xba, 0x5e};

#define mLen283 6 

static uint8_t msg_283  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_283  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc
}; 

static uint8_t s_283  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4e
}; 

#define result___283 18446744073709551615

//Test vector 284:           "comment" : "r,s are large",

static uint8_t pkx_284  [32] = { 
0xab, 0x05, 0xfd, 0x9d, 0x0d, 0xe2, 0x6b, 0x9c, 0xe6, 0xf4, 0x81, 0x96, 0x52, 0xd9, 0xfc, 0x69, 0x19, 0x3d, 0x0a, 0xa3, 0x98, 0xf0, 0xfb, 0xa8, 0x01, 0x3e, 0x09, 0xc5, 0x82, 0x20, 0x45, 0x54}; 

static uint8_t pky_284  [32] = {
0x19, 0x23, 0x52, 0x71, 0x22, 0x8c, 0x78, 0x67, 0x59, 0x09, 0x5d, 0x12, 0xb7, 0x5a, 0xf0, 0x69, 0x2d, 0xd4, 0x10, 0x3f, 0x19, 0xf6, 0xa8, 0xc3, 0x2f, 0x49, 0x43, 0x5a, 0x1e, 0x9b, 0x8d, 0x45};

#define mLen284 6 

static uint8_t msg_284  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_284  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4f
}; 

static uint8_t s_284  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x4e
}; 

#define result___284 0

//Test vector 285:           "comment" : "r and s^-1 have a large Hamming weight",

static uint8_t pkx_285  [32] = { 
0x80, 0x98, 0x4f, 0x39, 0xa1, 0xff, 0x38, 0xa8, 0x6a, 0x68, 0xaa, 0x42, 0x01, 0xb6, 0xbe, 0x5d, 0xfb, 0xfe, 0xcf, 0x87, 0x62, 0x19, 0x71, 0x0b, 0x07, 0xba, 0xdf, 0x6f, 0xdd, 0x4c, 0x6c, 0x56}; 

static uint8_t pky_285  [32] = {
0x11, 0xfe, 0xb9, 0x73, 0x90, 0xd9, 0x82, 0x6e, 0x7a, 0x06, 0xdf, 0xb4, 0x18, 0x71, 0xc9, 0x40, 0xd7, 0x44, 0x15, 0xed, 0x3c, 0xac, 0x20, 0x89, 0xf1, 0x44, 0x50, 0x19, 0xbb, 0x55, 0xed, 0x95};

#define mLen285 6 

static uint8_t msg_285  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_285  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_285  [32] = {
0x90, 0x91, 0x35, 0xbd, 0xb6, 0x79, 0x92, 0x86, 0x17, 0x0f, 0x5e, 0xad, 0x2d, 0xe4, 0xf6, 0x51, 0x14, 0x53, 0xfe, 0x50, 0x91, 0x4f, 0x3d, 0xf2, 0xde, 0x54, 0xa3, 0x63, 0x83, 0xdf, 0x8d, 0xd4
}; 

#define result___285 0

//Test vector 286:           "comment" : "r and s^-1 have a large Hamming weight",

static uint8_t pkx_286  [32] = { 
0x42, 0x01, 0xb4, 0x27, 0x29, 0x44, 0x20, 0x1c, 0x32, 0x94, 0xf5, 0xba, 0xa9, 0xa3, 0x23, 0x2b, 0x6d, 0xd6, 0x87, 0x49, 0x5f, 0xcc, 0x19, 0xa7, 0x0a, 0x95, 0xbc, 0x60, 0x2b, 0x4f, 0x7c, 0x05}; 

static uint8_t pky_286  [32] = {
0x95, 0xc3, 0x7e, 0xba, 0x9e, 0xe8, 0x17, 0x1c, 0x1b, 0xb5, 0xac, 0x6f, 0xea, 0xf7, 0x53, 0xbc, 0x36, 0xf4, 0x63, 0xe3, 0xae, 0xf1, 0x66, 0x29, 0x57, 0x2c, 0x0c, 0x0a, 0x8f, 0xb0, 0x80, 0x0e};

#define mLen286 6 

static uint8_t msg_286  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_286  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_286  [32] = {
0x27, 0xb4, 0x57, 0x7c, 0xa0, 0x09, 0x37, 0x6f, 0x71, 0x30, 0x3f, 0xd5, 0xdd, 0x22, 0x7d, 0xce, 0xf5, 0xde, 0xb7, 0x73, 0xad, 0x5f, 0x5a, 0x84, 0x36, 0x06, 0x44, 0x66, 0x9c, 0xa2, 0x49, 0xa5
}; 

#define result___286 0

//Test vector 287:           "comment" : "small r and s",

static uint8_t pkx_287  [32] = { 
0xa7, 0x1a, 0xf6, 0x4d, 0xe5, 0x12, 0x6a, 0x4a, 0x4e, 0x02, 0xb7, 0x92, 0x2d, 0x66, 0xce, 0x94, 0x15, 0xce, 0x88, 0xa4, 0xc9, 0xd2, 0x55, 0x14, 0xd9, 0x10, 0x82, 0xc8, 0x72, 0x5a, 0xc9, 0x57}; 

static uint8_t pky_287  [32] = {
0x5d, 0x47, 0x72, 0x3c, 0x8f, 0xbe, 0x58, 0x0b, 0xb3, 0x69, 0xfe, 0xc9, 0xc2, 0x66, 0x5d, 0x8e, 0x30, 0xa4, 0x35, 0xb9, 0x93, 0x26, 0x45, 0x48, 0x2e, 0x7c, 0x9f, 0x11, 0xe8, 0x72, 0x29, 0x6b};

#define mLen287 6 

static uint8_t msg_287  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_287  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5
}; 

static uint8_t s_287  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1
}; 

#define result___287 0

//Test vector 288:           "comment" : "small r and s",

static uint8_t pkx_288  [32] = { 
0x66, 0x27, 0xce, 0xc4, 0xf0, 0x73, 0x1e, 0xa2, 0x3f, 0xc2, 0x93, 0x1f, 0x90, 0xeb, 0xe5, 0xb7, 0x57, 0x2f, 0x59, 0x7d, 0x20, 0xdf, 0x08, 0xfc, 0x2b, 0x31, 0xee, 0x8e, 0xf1, 0x6b, 0x15, 0x72}; 

static uint8_t pky_288  [32] = {
0x61, 0x70, 0xed, 0x77, 0xd8, 0xd0, 0xa1, 0x4f, 0xc5, 0xc9, 0xc3, 0xc4, 0xc9, 0xbe, 0x7f, 0x0d, 0x3e, 0xe1, 0x8f, 0x70, 0x9b, 0xb2, 0x75, 0xea, 0xf2, 0x07, 0x3e, 0x25, 0x8f, 0xe6, 0x94, 0xa5};

#define mLen288 6 

static uint8_t msg_288  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_288  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x05
}; 

static uint8_t s_288  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x03
}; 

#define result___288 0

//Test vector 289:           "comment" : "small r and s",

static uint8_t pkx_289  [32] = { 
0x5a, 0x7c, 0x88, 0x25, 0xe8, 0x56, 0x91, 0xcc, 0xe1, 0xf5, 0xe7, 0x54, 0x4c, 0x54, 0xe7, 0x3f, 0x14, 0xaf, 0xc0, 0x10, 0xcb, 0x73, 0x13, 0x43, 0x26, 0x2c, 0xa7, 0xec, 0x5a, 0x77, 0xf5, 0xbf}; 

static uint8_t pky_289  [32] = {
0xef, 0x6e, 0xdf, 0x62, 0xa4, 0x49, 0x7c, 0x1b, 0xd7, 0xb1, 0x47, 0xfb, 0x6c, 0x3d, 0x22, 0xaf, 0x3c, 0x39, 0xbf, 0xce, 0x95, 0xf3, 0x0e, 0x13, 0xa1, 0x6d, 0x3d, 0x7b, 0x28, 0x12, 0xf8, 0x13};

#define mLen289 6 

static uint8_t msg_289  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_289  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x05
}; 

static uint8_t s_289  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x05
}; 

#define result___289 0

//Test vector 290:           "comment" : "small r and s",

static uint8_t pkx_290  [32] = { 
0xcb, 0xe0, 0xc2, 0x91, 0x32, 0xcd, 0x73, 0x83, 0x64, 0xfe, 0xdd, 0x60, 0x31, 0x52, 0x99, 0x0c, 0x04, 0x8e, 0x5e, 0x2f, 0xff, 0x99, 0x6d, 0x88, 0x3f, 0xa6, 0xca, 0xca, 0x79, 0x78, 0xc7, 0x37}; 

static uint8_t pky_290  [32] = {
0x70, 0xaf, 0x6a, 0x8c, 0xe4, 0x4c, 0xb4, 0x12, 0x24, 0xb2, 0x60, 0x36, 0x06, 0xf4, 0xc0, 0x4d, 0x18, 0x8e, 0x80, 0xbf, 0xf7, 0xcc, 0x31, 0xad, 0x51, 0x89, 0xd4, 0xab, 0x0d, 0x70, 0xe8, 0xc1};

#define mLen290 6 

static uint8_t msg_290  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_290  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x05
}; 

static uint8_t s_290  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x06
}; 

#define result___290 0

//Test vector 291:           "comment" : "r is larger than n",

static uint8_t pkx_291  [32] = { 
0xcb, 0xe0, 0xc2, 0x91, 0x32, 0xcd, 0x73, 0x83, 0x64, 0xfe, 0xdd, 0x60, 0x31, 0x52, 0x99, 0x0c, 0x04, 0x8e, 0x5e, 0x2f, 0xff, 0x99, 0x6d, 0x88, 0x3f, 0xa6, 0xca, 0xca, 0x79, 0x78, 0xc7, 0x37}; 

static uint8_t pky_291  [32] = {
0x70, 0xaf, 0x6a, 0x8c, 0xe4, 0x4c, 0xb4, 0x12, 0x24, 0xb2, 0x60, 0x36, 0x06, 0xf4, 0xc0, 0x4d, 0x18, 0x8e, 0x80, 0xbf, 0xf7, 0xcc, 0x31, 0xad, 0x51, 0x89, 0xd4, 0xab, 0x0d, 0x70, 0xe8, 0xc1};

#define mLen291 6 

static uint8_t msg_291  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_291  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x56
}; 

static uint8_t s_291  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x06
}; 

#define result___291 18446744073709551615

//Test vector 292:           "comment" : "s is larger than n",

static uint8_t pkx_292  [32] = { 
0x4b, 0xe4, 0x17, 0x80, 0x97, 0x00, 0x2f, 0x0d, 0xea, 0xb6, 0x8f, 0x0d, 0x9a, 0x13, 0x0e, 0x0e, 0xd3, 0x3a, 0x67, 0x95, 0xd0, 0x2a, 0x20, 0x79, 0x6d, 0xb8, 0x34, 0x44, 0xb0, 0x37, 0xe1, 0x39}; 

static uint8_t pky_292  [32] = {
0x20, 0xf1, 0x30, 0x51, 0xe0, 0xee, 0xcd, 0xcf, 0xce, 0x4d, 0xac, 0xea, 0x0f, 0x50, 0xd1, 0xf2, 0x47, 0xca, 0xa6, 0x69, 0xf1, 0x93, 0xc1, 0xb4, 0x07, 0x5b, 0x51, 0xae, 0x29, 0x6d, 0x2d, 0x56};

#define mLen292 6 

static uint8_t msg_292  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_292  [32] = {
0x05
}; 

static uint8_t s_292  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x75, 0xfb, 0xd8
}; 

#define result___292 18446744073709551615

//Test vector 293:           "comment" : "small r and s^-1",

static uint8_t pkx_293  [32] = { 
0xd0, 0xf7, 0x37, 0x92, 0x20, 0x37, 0x16, 0xaf, 0xd4, 0xbe, 0x43, 0x29, 0xfa, 0xa4, 0x8d, 0x26, 0x9f, 0x15, 0x31, 0x3e, 0xbb, 0xba, 0x37, 0x9d, 0x77, 0x83, 0xc9, 0x7b, 0xf3, 0xe8, 0x90, 0xd9}; 

static uint8_t pky_293  [32] = {
0x97, 0x1f, 0x4a, 0x32, 0x06, 0x60, 0x5b, 0xec, 0x21, 0x78, 0x2b, 0xf5, 0xe2, 0x75, 0xc7, 0x14, 0x41, 0x7e, 0x8f, 0x56, 0x65, 0x49, 0xe6, 0xbc, 0x68, 0x69, 0x0d, 0x23, 0x63, 0xc8, 0x9c, 0xc1};

#define mLen293 6 

static uint8_t msg_293  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_293  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x01, 0x00
}; 

static uint8_t s_293  [32] = {
0x8f, 0x1e, 0x3c, 0x78, 0x62, 0xc5, 0x8b, 0x16, 0xbb, 0x76, 0xed, 0xdb, 0xb7, 0x6e, 0xdd, 0xbb, 0x51, 0x6a, 0xf4, 0xf6, 0x3f, 0x2d, 0x74, 0xd7, 0x6e, 0x0d, 0x28, 0xc9, 0xbb, 0x75, 0xea, 0x88
}; 

#define result___293 0

//Test vector 294:           "comment" : "smallish r and s^-1",

static uint8_t pkx_294  [32] = { 
0x48, 0x38, 0xb2, 0xbe, 0x35, 0xa6, 0x27, 0x6a, 0x80, 0xef, 0x9e, 0x22, 0x81, 0x40, 0xf9, 0xd9, 0xb9, 0x6c, 0xe8, 0x3b, 0x7a, 0x25, 0x4f, 0x71, 0xcc, 0xde, 0xbb, 0xb8, 0x05, 0x4c, 0xe0, 0x5f}; 

static uint8_t pky_294  [32] = {
0xfa, 0x9c, 0xbc, 0x12, 0x3c, 0x91, 0x9b, 0x19, 0xe0, 0x02, 0x38, 0x19, 0x8d, 0x04, 0x06, 0x90, 0x43, 0xbd, 0x66, 0x0a, 0x82, 0x88, 0x14, 0x05, 0x1f, 0xcb, 0x8a, 0xac, 0x73, 0x8a, 0x6c, 0x6b};

#define mLen294 6 

static uint8_t msg_294  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_294  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
	0x0, 0x2d, 0x9b, 0x4d, 0x34, 0x79, 0x52, 0xd6
}; 

static uint8_t s_294  [32] = {
0xef, 0x30, 0x43, 0xe7, 0x32, 0x95, 0x81, 0xdb, 0xb3, 0x97, 0x44, 0x97, 0x71, 0x0a, 0xb1, 0x15, 0x05, 0xee, 0x1c, 0x87, 0xff, 0x90, 0x7b, 0xee, 0xba, 0xdd, 0x19, 0x5a, 0x0f, 0xfe, 0x6d, 0x7a
}; 

#define result___294 0

//Test vector 295:           "comment" : "100-bit r and small s^-1",

static uint8_t pkx_295  [32] = { 
0x73, 0x93, 0x98, 0x3c, 0xa3, 0x0a, 0x52, 0x0b, 0xbc, 0x47, 0x83, 0xdc, 0x99, 0x60, 0x74, 0x6a, 0xab, 0x44, 0x4e, 0xf5, 0x20, 0xc0, 0xa8, 0xe7, 0x71, 0x11, 0x9a, 0xa4, 0xe7, 0x4b, 0x0f, 0x64}; 

static uint8_t pky_295  [32] = {
0xe9, 0xd7, 0xbe, 0x1a, 0xb0, 0x1a, 0x0b, 0xf6, 0x26, 0xe7, 0x09, 0x86, 0x3e, 0x6a, 0x48, 0x6d, 0xba, 0xf3, 0x27, 0x93, 0xaf, 0xcc, 0xf7, 0x74, 0xe2, 0xc6, 0xcd, 0x27, 0xb1, 0x85, 0x75, 0x26};

#define mLen295 6 

static uint8_t msg_295  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_295  [32] = {
	0x0, 	0x0, 	0x0, 	0x0, 	0x0, 	0x0, 	0x0, 	0x0,  
	0x0, 	0x0, 	0x0, 	0x0, 	0x0,	0x0, 	0x0, 	0x0, 	
	0x0, 	0x0, 	0x0, 	0x10, 	0x33,	0xe6, 	0x7e, 	0x37,
	0xb3, 	0x2b, 	0x44, 	0x55, 	0x80, 	0xbf, 	0x4e,	0xff
}; 

static uint8_t s_295  [32] = {
0x8b, 0x74, 0x8b, 0x74, 0x00, 0x00, 0x00, 0x00, 0x8b, 0x74, 0x8b, 0x74, 0x8b, 0x74, 0x8b, 0x74, 0x66, 0xe7, 0x69, 0xad, 0x4a, 0x16, 0xd3, 0xdc, 0xd8, 0x71, 0x29, 0xb8, 0xe9, 0x1d, 0x1b, 0x4d
}; 

#define result___295 0

//Test vector 296:           "comment" : "small r and 100 bit s^-1",

static uint8_t pkx_296  [32] = { 
0x5a, 0xc3, 0x31, 0xa1, 0x10, 0x3f, 0xe9, 0x66, 0x69, 0x73, 0x79, 0xf3, 0x56, 0xa9, 0x37, 0xf3, 0x50, 0x58, 0x8a, 0x05, 0x47, 0x7e, 0x30, 0x88, 0x51, 0xb8, 0xa5, 0x02, 0xd5, 0xdf, 0xcd, 0xc5}; 

static uint8_t pky_296  [32] = {
0xfe, 0x99, 0x93, 0xdf, 0x4b, 0x57, 0x93, 0x9b, 0x2b, 0x8d, 0xa0, 0x95, 0xbf, 0x6d, 0x79, 0x42, 0x65, 0x20, 0x4c, 0xfe, 0x03, 0xbe, 0x99, 0x5a, 0x02, 0xe6, 0x5d, 0x40, 0x8c, 0x87, 0x1c, 0x0b};

#define mLen296 6 

static uint8_t msg_296  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_296  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x01, 0x00
}; 

static uint8_t s_296  [32] = {
0xef, 0x9f, 0x6b, 0xa4, 0xd9, 0x7c, 0x09, 0xd0, 0x31, 0x78, 0xfa, 0x20, 0xb4, 0xaa, 0xad, 0x83, 0xbe, 0x3c, 0xf9, 0xcb, 0x82, 0x4a, 0x87, 0x9f, 0xec, 0x32, 0x70, 0xfc, 0x4b, 0x81, 0xef, 0x5b
}; 

#define result___296 0

//Test vector 297:           "comment" : "100-bit r and s^-1",

static uint8_t pkx_297  [32] = { 
0x1d, 0x20, 0x9b, 0xe8, 0xde, 0x2d, 0xe8, 0x77, 0x09, 0x5a, 0x39, 0x9d, 0x39, 0x04, 0xc7, 0x4c, 0xc4, 0x58, 0xd9, 0x26, 0xe2, 0x7b, 0xb8, 0xe5, 0x8e, 0x5e, 0xae, 0x57, 0x67, 0xc4, 0x15, 0x09}; 

static uint8_t pky_297  [32] = {
0xdd, 0x59, 0xe0, 0x4c, 0x21, 0x4f, 0x7b, 0x18, 0xdc, 0xe3, 0x51, 0xfc, 0x2a, 0x54, 0x98, 0x93, 0xa6, 0x86, 0x0e, 0x80, 0x16, 0x3f, 0x38, 0xcc, 0x60, 0xa4, 0xf2, 0xc9, 0xd0, 0x40, 0xd8, 0xc9};

#define mLen297 6 

static uint8_t msg_297  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_297  [32] = {
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
0x0, 0x0, 0x0, 
0x06, 0x25, 0x22, 0xbb, 0xd3, 0xec, 0xbe, 0x7c, 0x39, 0xe9, 0x3e, 0x7c, 0x25
}; 

static uint8_t s_297  [32] = {
0xef, 0x9f, 0x6b, 0xa4, 0xd9, 0x7c, 0x09, 0xd0, 0x31, 0x78, 0xfa, 0x20, 0xb4, 0xaa, 0xad, 0x83, 0xbe, 0x3c, 0xf9, 0xcb, 0x82, 0x4a, 0x87, 0x9f, 0xec, 0x32, 0x70, 0xfc, 0x4b, 0x81, 0xef, 0x5b
}; 

#define result___297 0

//Test vector 298:           "comment" : "r and s^-1 are close to n",

static uint8_t pkx_298  [32] = { 
0x08, 0x35, 0x39, 0xfb, 0xee, 0x44, 0x62, 0x5e, 0x3a, 0xca, 0xaf, 0xa2, 0xfc, 0xb4, 0x13, 0x49, 0x39, 0x2c, 0xef, 0x06, 0x33, 0xa1, 0xb8, 0xfa, 0xbe, 0xce, 0xe0, 0xc1, 0x33, 0xb1, 0x0e, 0x99}; 

static uint8_t pky_298  [32] = {
0x91, 0x5c, 0x1e, 0xbe, 0x7b, 0xf0, 0x0d, 0xf8, 0x53, 0x51, 0x96, 0x77, 0x0a, 0x58, 0x04, 0x7a, 0xe2, 0xa4, 0x02, 0xf2, 0x63, 0x26, 0xbb, 0x7d, 0x41, 0xd4, 0xd7, 0x61, 0x63, 0x37, 0x91, 0x1e};

#define mLen298 6 

static uint8_t msg_298  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_298  [32] = {
0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x24, 0xd5
}; 

static uint8_t s_298  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

#define result___298 0

//Test vector 299:           "comment" : "s == 1",

static uint8_t pkx_299  [32] = { 
0x8a, 0xeb, 0x36, 0x8a, 0x70, 0x27, 0xa4, 0xd6, 0x4a, 0xbd, 0xea, 0x37, 0x39, 0x0c, 0x0c, 0x1d, 0x6a, 0x26, 0xf3, 0x99, 0xe2, 0xd9, 0x73, 0x4d, 0xe1, 0xeb, 0x3d, 0x0e, 0x19, 0x37, 0x38, 0x74}; 

static uint8_t pky_299  [32] = {
0x05, 0xbd, 0x13, 0x83, 0x47, 0x15, 0xe1, 0xdb, 0xae, 0x9b, 0x87, 0x5c, 0xf0, 0x7b, 0xd5, 0x5e, 0x1b, 0x66, 0x91, 0xc7, 0xf7, 0x53, 0x6a, 0xef, 0x3b, 0x19, 0xbf, 0x7a, 0x4a, 0xdf, 0x57, 0x6d};

#define mLen299 6 

static uint8_t msg_299  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_299  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

static uint8_t s_299  [32] = {
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,  
0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x01
}; 

#define result___299 0

//Test vector 300:           "comment" : "s == 0",

static uint8_t pkx_300  [32] = { 
0x8a, 0xeb, 0x36, 0x8a, 0x70, 0x27, 0xa4, 0xd6, 0x4a, 0xbd, 0xea, 0x37, 0x39, 0x0c, 0x0c, 0x1d, 0x6a, 0x26, 0xf3, 0x99, 0xe2, 0xd9, 0x73, 0x4d, 0xe1, 0xeb, 0x3d, 0x0e, 0x19, 0x37, 0x38, 0x74}; 

static uint8_t pky_300  [32] = {
0x05, 0xbd, 0x13, 0x83, 0x47, 0x15, 0xe1, 0xdb, 0xae, 0x9b, 0x87, 0x5c, 0xf0, 0x7b, 0xd5, 0x5e, 0x1b, 0x66, 0x91, 0xc7, 0xf7, 0x53, 0x6a, 0xef, 0x3b, 0x19, 0xbf, 0x7a, 0x4a, 0xdf, 0x57, 0x6d};

#define mLen300 6 

static uint8_t msg_300  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_300  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

static uint8_t s_300  [32] = {
0x00
}; 

#define result___300 18446744073709551615

//Test vector 301:           "comment" : "point at infinity during verify",

static uint8_t pkx_301  [32] = { 
0xb5, 0x33, 0xd4, 0x69, 0x5d, 0xd5, 0xb8, 0xc5, 0xe0, 0x77, 0x57, 0xe5, 0x5e, 0x6e, 0x51, 0x6f, 0x7e, 0x2c, 0x88, 0xfa, 0x02, 0x39, 0xe2, 0x3f, 0x60, 0xe8, 0xec, 0x07, 0xdd, 0x70, 0xf2, 0x87}; 

static uint8_t pky_301  [32] = {
0x1b, 0x13, 0x4e, 0xe5, 0x8c, 0xc5, 0x83, 0x27, 0x84, 0x56, 0x86, 0x3f, 0x33, 0xc3, 0xa8, 0x5d, 0x88, 0x1f, 0x7d, 0x4a, 0x39, 0x85, 0x01, 0x43, 0xe2, 0x9d, 0x4e, 0xaf, 0x00, 0x9a, 0xfe, 0x47};

#define mLen301 6 

static uint8_t msg_301  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_301  [32] = {
0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56, 0xd3, 0x8b, 0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xa8
}; 

static uint8_t s_301  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

#define result___301 18446744073709551615

//Test vector 302:           "comment" : "edge case for signature malleability",

static uint8_t pkx_302  [32] = { 
0xf5, 0x0d, 0x37, 0x1b, 0x91, 0xbf, 0xb1, 0xd7, 0xd1, 0x4e, 0x13, 0x23, 0x52, 0x3b, 0xc3, 0xaa, 0x8c, 0xbf, 0x2c, 0x57, 0xf9, 0xe2, 0x84, 0xde, 0x62, 0x8c, 0x8b, 0x45, 0x36, 0x78, 0x7b, 0x86}; 

static uint8_t pky_302  [32] = {
0xf9, 0x4a, 0xd8, 0x87, 0xac, 0x94, 0xd5, 0x27, 0x24, 0x7c, 0xd2, 0xe7, 0xd0, 0xc8, 0xb1, 0x29, 0x1c, 0x55, 0x3c, 0x97, 0x30, 0x40, 0x53, 0x80, 0xb1, 0x4c, 0xbb, 0x20, 0x9f, 0x5f, 0xa2, 0xdd};

#define mLen302 6 

static uint8_t msg_302  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_302  [32] = {
0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56, 0xd3, 0x8b, 0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xa9
}; 

static uint8_t s_302  [32] = {
0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56, 0xd3, 0x8b, 0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xa8
}; 

#define result___302 0

//Test vector 303:           "comment" : "edge case for signature malleability",

static uint8_t pkx_303  [32] = { 
0x68, 0xec, 0x6e, 0x29, 0x8e, 0xaf, 0xe1, 0x65, 0x39, 0x15, 0x6c, 0xe5, 0x7a, 0x14, 0xb0, 0x4a, 0x70, 0x47, 0xc2, 0x21, 0xba, 0xfc, 0x3a, 0x58, 0x2e, 0xae, 0xb0, 0xd8, 0x57, 0xc4, 0xd9, 0x46}; 

static uint8_t pky_303  [32] = {
0x97, 0xbe, 0xd1, 0xaf, 0x17, 0x85, 0x01, 0x17, 0xfd, 0xb3, 0x9b, 0x23, 0x24, 0xf2, 0x20, 0xa5, 0x69, 0x8e, 0xd1, 0x6c, 0x42, 0x6a, 0x27, 0x33, 0x5b, 0xb3, 0x85, 0xac, 0x8c, 0xa6, 0xfb, 0x30};

#define mLen303 6 

static uint8_t msg_303  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_303  [32] = {
0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56, 0xd3, 0x8b, 0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xa9
}; 

static uint8_t s_303  [32] = {
0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56, 0xd3, 0x8b, 0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xa9
}; 

#define result___303 0

//Test vector 304:           "comment" : "u1 == 1",

static uint8_t pkx_304  [32] = { 
0x69, 0xda, 0x03, 0x64, 0x73, 0x4d, 0x2e, 0x53, 0x0f, 0xec, 0xe9, 0x40, 0x19, 0x26, 0x5f, 0xef, 0xb7, 0x81, 0xa0, 0xf1, 0xb0, 0x8f, 0x6c, 0x88, 0x97, 0xbd, 0xf6, 0x55, 0x79, 0x27, 0xc8, 0xb8}; 

static uint8_t pky_304  [32] = {
0x66, 0xd2, 0xd3, 0xc7, 0xdc, 0xd5, 0x18, 0xb2, 0x3d, 0x72, 0x69, 0x60, 0xf0, 0x69, 0xad, 0x71, 0xa9, 0x33, 0xd8, 0x6e, 0xf8, 0xab, 0xbc, 0xce, 0x8b, 0x20, 0xf7, 0x1e, 0x2a, 0x84, 0x70, 0x02};

#define mLen304 6 

static uint8_t msg_304  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_304  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

static uint8_t s_304  [32] = {
0xbb, 0x5a, 0x52, 0xf4, 0x2f, 0x9c, 0x92, 0x61, 0xed, 0x43, 0x61, 0xf5, 0x94, 0x22, 0xa1, 0xe3, 0x00, 0x36, 0xe7, 0xc3, 0x2b, 0x27, 0x0c, 0x88, 0x07, 0xa4, 0x19, 0xfe, 0xca, 0x60, 0x50, 0x23
}; 

#define result___304 0

//Test vector 305:           "comment" : "u1 == n - 1",

static uint8_t pkx_305  [32] = { 
0xd8, 0xad, 0xc0, 0x00, 0x23, 0xa8, 0xed, 0xc0, 0x25, 0x76, 0xe2, 0xb6, 0x3e, 0x3e, 0x30, 0x62, 0x1a, 0x47, 0x1e, 0x2b, 0x23, 0x20, 0x62, 0x01, 0x87, 0xbf, 0x06, 0x7a, 0x1a, 0xc1, 0xff, 0x32}; 

static uint8_t pky_305  [32] = {
0x33, 0xe2, 0xb5, 0x0e, 0xc0, 0x98, 0x07, 0xac, 0xcb, 0x36, 0x13, 0x1f, 0xff, 0x95, 0xed, 0x12, 0xa0, 0x9a, 0x86, 0xb4, 0xea, 0x96, 0x90, 0xaa, 0x32, 0x86, 0x15, 0x76, 0xba, 0x23, 0x62, 0xe1};

#define mLen305 6 

static uint8_t msg_305  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_305  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

static uint8_t s_305  [32] = {
0x44, 0xa5, 0xad, 0x0a, 0xd0, 0x63, 0x6d, 0x9f, 0x12, 0xbc, 0x9e, 0x0a, 0x6b, 0xdd, 0x5e, 0x1c, 0xbc, 0xb0, 0x12, 0xea, 0x7b, 0xf0, 0x91, 0xfc, 0xec, 0x15, 0xb0, 0xc4, 0x32, 0x02, 0xd5, 0x2e
}; 

#define result___305 0

//Test vector 306:           "comment" : "u2 == 1",

static uint8_t pkx_306  [32] = { 
0x36, 0x23, 0xac, 0x97, 0x3c, 0xed, 0x0a, 0x56, 0xfa, 0x6d, 0x88, 0x2f, 0x03, 0xa7, 0xd5, 0xc7, 0xed, 0xca, 0x02, 0xcf, 0xc7, 0xb2, 0x40, 0x1f, 0xab, 0x36, 0x90, 0xdb, 0xe7, 0x5a, 0xb7, 0x85}; 

static uint8_t pky_306  [32] = {
0x8d, 0xb0, 0x69, 0x08, 0xe6, 0x4b, 0x28, 0x61, 0x3d, 0xa7, 0x25, 0x7e, 0x73, 0x7f, 0x39, 0x79, 0x3d, 0xa8, 0xe7, 0x13, 0xba, 0x06, 0x43, 0xb9, 0x2e, 0x9b, 0xb3, 0x25, 0x2b, 0xe7, 0xf8, 0xfe};

#define mLen306 6 

static uint8_t msg_306  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_306  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

static uint8_t s_306  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

#define result___306 0

//Test vector 307:           "comment" : "u2 == n - 1",

static uint8_t pkx_307  [32] = { 
0xcf, 0x04, 0xea, 0x77, 0xe9, 0x62, 0x25, 0x23, 0xd8, 0x94, 0xb9, 0x3f, 0xf5, 0x2d, 0xc3, 0x02, 0x7b, 0x31, 0x95, 0x95, 0x03, 0xb6, 0xfa, 0x38, 0x90, 0xe5, 0xe0, 0x42, 0x63, 0xf9, 0x22, 0xf1}; 

static uint8_t pky_307  [32] = {
0xe8, 0x52, 0x8f, 0xb7, 0xc0, 0x06, 0xb3, 0x98, 0x3c, 0x8b, 0x84, 0x00, 0xe5, 0x7b, 0x4e, 0xd7, 0x17, 0x40, 0xc2, 0xf3, 0x97, 0x54, 0x38, 0x82, 0x11, 0x99, 0xbe, 0xde, 0xae, 0xca, 0xb2, 0xe9};

#define mLen307 6 

static uint8_t msg_307  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_307  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

static uint8_t s_307  [32] = {
0xaa, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x7d, 0xef, 0x51, 0xc9, 0x1a, 0x0f, 0xbf, 0x03, 0x4d, 0x26, 0x87, 0x2c, 0xa8, 0x42, 0x18, 0xe1
}; 

#define result___307 0

//Test vector 308:           "comment" : "edge case for u1",

static uint8_t pkx_308  [32] = { 
0xdb, 0x7a, 0x2c, 0x8a, 0x1a, 0xb5, 0x73, 0xe5, 0x92, 0x9d, 0xc2, 0x40, 0x77, 0xb5, 0x08, 0xd7, 0xe6, 0x83, 0xd4, 0x92, 0x27, 0x99, 0x6b, 0xda, 0x3e, 0x9f, 0x78, 0xdb, 0xef, 0xf7, 0x73, 0x50}; 

static uint8_t pky_308  [32] = {
0x4f, 0x41, 0x7f, 0x3b, 0xc9, 0xa8, 0x80, 0x75, 0xc2, 0xe0, 0xaa, 0xdd, 0x5a, 0x13, 0x31, 0x17, 0x30, 0xcf, 0x7c, 0xc7, 0x6a, 0x82, 0xf1, 0x1a, 0x36, 0xea, 0xf0, 0x8a, 0x6c, 0x99, 0xa2, 0x06};

#define mLen308 6 

static uint8_t msg_308  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_308  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_308  [32] = {
0xe9, 0x1e, 0x1b, 0xa6, 0x0f, 0xde, 0xdb, 0x76, 0xa4, 0x6b, 0xcb, 0x51, 0xdc, 0x0b, 0x8b, 0x4b, 0x7e, 0x01, 0x9f, 0x0a, 0x28, 0x72, 0x18, 0x85, 0xfa, 0x5d, 0x3a, 0x81, 0x96, 0x62, 0x33, 0x97
}; 

#define result___308 0

//Test vector 309:           "comment" : "edge case for u1",

static uint8_t pkx_309  [32] = { 
0xde, 0xad, 0x11, 0xc7, 0xa5, 0xb3, 0x96, 0x86, 0x2f, 0x21, 0x97, 0x4d, 0xc4, 0x75, 0x2f, 0xad, 0xef, 0xf9, 0x94, 0xef, 0xe9, 0xbb, 0xd0, 0x5a, 0xb4, 0x13, 0x76, 0x5e, 0xa8, 0x0b, 0x6e, 0x1f}; 

static uint8_t pky_309  [32] = {
0x1d, 0xe3, 0xf0, 0x64, 0x0e, 0x8a, 0xc6, 0xed, 0xcf, 0x89, 0xcf, 0xf5, 0x3c, 0x40, 0xe2, 0x65, 0xbb, 0x94, 0x07, 0x8a, 0x34, 0x37, 0x36, 0xdf, 0x07, 0xaa, 0x03, 0x18, 0xfc, 0x7f, 0xe1, 0xff};

#define mLen309 6 

static uint8_t msg_309  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_309  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_309  [32] = {
0xfd, 0xea, 0x58, 0x43, 0xff, 0xeb, 0x73, 0xaf, 0x94, 0x31, 0x3b, 0xa4, 0x83, 0x1b, 0x53, 0xfe, 0x24, 0xf7, 0x99, 0xe5, 0x25, 0xb1, 0xe8, 0xe8, 0xc8, 0x7b, 0x59, 0xb9, 0x5b, 0x43, 0x0a, 0xd9
}; 

#define result___309 0

//Test vector 310:           "comment" : "edge case for u1",

static uint8_t pkx_310  [32] = { 
0xd0, 0xbc, 0x47, 0x2e, 0x0d, 0x7c, 0x81, 0xeb, 0xae, 0xd3, 0xa6, 0xef, 0x96, 0xc1, 0x86, 0x13, 0xbb, 0x1f, 0xea, 0x6f, 0x99, 0x43, 0x26, 0xfb, 0xe8, 0x0e, 0x00, 0xdf, 0xde, 0x67, 0xc7, 0xe9}; 

static uint8_t pky_310  [32] = {
0x98, 0x6c, 0x72, 0x3e, 0xa4, 0x84, 0x3d, 0x48, 0x38, 0x9b, 0x94, 0x6f, 0x64, 0xad, 0x56, 0xc8, 0x3a, 0xd7, 0x0f, 0xf1, 0x7b, 0xa8, 0x53, 0x35, 0x66, 0x7d, 0x1b, 0xb9, 0xfa, 0x61, 0x9e, 0xfd};

#define mLen310 6 

static uint8_t msg_310  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_310  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_310  [32] = {
0x03, 0xff, 0xca, 0xbf, 0x2f, 0x1b, 0x4d, 0x2a, 0x65, 0x19, 0x0d, 0xb1, 0x68, 0x0d, 0x62, 0xbb, 0x99, 0x4e, 0x41, 0xc5, 0x25, 0x1c, 0xd7, 0x3b, 0x3c, 0x3d, 0xfc, 0x5e, 0x5b, 0xaf, 0xc0, 0x35
}; 

#define result___310 0

//Test vector 311:           "comment" : "edge case for u1",

static uint8_t pkx_311  [32] = { 
0xa0, 0xa4, 0x4c, 0xa9, 0x47, 0xd6, 0x6a, 0x2a, 0xcb, 0x73, 0x60, 0x08, 0xb9, 0xc0, 0x8d, 0x1a, 0xb2, 0xad, 0x03, 0x77, 0x6e, 0x02, 0x64, 0x0f, 0x78, 0x49, 0x5d, 0x45, 0x8d, 0xd5, 0x1c, 0x32}; 

static uint8_t pky_311  [32] = {
0x63, 0x37, 0xfe, 0x5c, 0xf8, 0xc4, 0x60, 0x4b, 0x1f, 0x1c, 0x40, 0x9d, 0xc2, 0xd8, 0x72, 0xd4, 0x29, 0x4a, 0x47, 0x62, 0x42, 0x0d, 0xf4, 0x3a, 0x30, 0xa2, 0x39, 0x2e, 0x40, 0x42, 0x6a, 0xdd};

#define mLen311 6 

static uint8_t msg_311  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_311  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_311  [32] = {
0x4d, 0xfb, 0xc4, 0x01, 0xf9, 0x71, 0xcd, 0x30, 0x4b, 0x33, 0xdf, 0xdb, 0x17, 0xd0, 0xfe, 0xd0, 0xfe, 0x4c, 0x1a, 0x88, 0xae, 0x64, 0x8e, 0x0d, 0x28, 0x47, 0xf7, 0x49, 0x77, 0x53, 0x49, 0x89
}; 

#define result___311 0

//Test vector 312:           "comment" : "edge case for u1",

static uint8_t pkx_312  [32] = { 
0xc9, 0xc2, 0x11, 0x52, 0x90, 0xd0, 0x08, 0xb4, 0x5f, 0xb6, 0x5f, 0xad, 0x0f, 0x60, 0x23, 0x89, 0x29, 0x8c, 0x25, 0x42, 0x0b, 0x77, 0x50, 0x19, 0xd4, 0x2b, 0x62, 0xc3, 0xce, 0x8a, 0x96, 0xb7}; 

static uint8_t pky_312  [32] = {
0x38, 0x77, 0xd2, 0x5a, 0x80, 0x80, 0xdc, 0x02, 0xd9, 0x87, 0xca, 0x73, 0x0f, 0x04, 0x05, 0xc2, 0xc9, 0xdb, 0xef, 0xac, 0x46, 0xf9, 0xe6, 0x01, 0xcc, 0x3f, 0x06, 0xe9, 0x71, 0x39, 0x73, 0xfd};

#define mLen312 6 

static uint8_t msg_312  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_312  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_312  [32] = {
0xbc, 0x40, 0x24, 0x76, 0x1c, 0xd2, 0xff, 0xd4, 0x3d, 0xfd, 0xb1, 0x7d, 0x0f, 0xed, 0x11, 0x2b, 0x98, 0x89, 0x77, 0x05, 0x5c, 0xd3, 0xa8, 0xe5, 0x49, 0x71, 0xeb, 0xa9, 0xcd, 0xa5, 0xca, 0x71
}; 

#define result___312 0

//Test vector 313:           "comment" : "edge case for u1",

static uint8_t pkx_313  [32] = { 
0x5e, 0xca, 0x1e, 0xf4, 0xc2, 0x87, 0xdd, 0xdc, 0x66, 0xb8, 0xbc, 0xcf, 0x1b, 0x88, 0xe8, 0xa2, 0x4c, 0x00, 0x18, 0x96, 0x2f, 0x3c, 0x5e, 0x7e, 0xfa, 0x83, 0xbc, 0x1a, 0x5f, 0xf6, 0x03, 0x3e}; 

static uint8_t pky_313  [32] = {
0x5e, 0x79, 0xc4, 0xcb, 0x2c, 0x24, 0x5b, 0x8c, 0x45, 0xab, 0xdc, 0xe8, 0xa8, 0xe4, 0xda, 0x75, 0x8d, 0x92, 0xa6, 0x07, 0xc3, 0x2c, 0xd4, 0x07, 0xec, 0xae, 0xf2, 0x2f, 0x1c, 0x93, 0x4a, 0x71};

#define mLen313 6 

static uint8_t msg_313  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_313  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_313  [32] = {
0x78, 0x80, 0x48, 0xed, 0x39, 0xa5, 0xff, 0xa7, 0x7b, 0xfb, 0x62, 0xfa, 0x1f, 0xda, 0x22, 0x57, 0x74, 0x2b, 0xf3, 0x5d, 0x12, 0x8f, 0xb3, 0x45, 0x9f, 0x2a, 0x0c, 0x90, 0x9e, 0xe8, 0x6f, 0x91
}; 

#define result___313 0

//Test vector 314:           "comment" : "edge case for u1",

static uint8_t pkx_314  [32] = { 
0x5c, 0xaa, 0xa0, 0x30, 0xe7, 0xfd, 0xf0, 0xe4, 0x93, 0x6b, 0xc7, 0xab, 0x5a, 0x96, 0x35, 0x3e, 0x0a, 0x01, 0xe4, 0x13, 0x0c, 0x3f, 0x8b, 0xf2, 0x2d, 0x47, 0x3e, 0x31, 0x70, 0x29, 0xa4, 0x7a}; 

static uint8_t pky_314  [32] = {
0xde, 0xb6, 0xad, 0xc4, 0x62, 0xf7, 0x05, 0x8f, 0x2a, 0x20, 0xd3, 0x71, 0xe9, 0x70, 0x22, 0x54, 0xe9, 0xb2, 0x01, 0x64, 0x20, 0x05, 0xb3, 0xce, 0xda, 0x92, 0x6b, 0x42, 0xb1, 0x78, 0xbe, 0xf9};

#define mLen314 6 

static uint8_t msg_314  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_314  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_314  [32] = {
0x47, 0x6d, 0x91, 0x31, 0xfd, 0x38, 0x1b, 0xd9, 0x17, 0xd0, 0xfe, 0xd1, 0x12, 0xbc, 0x9e, 0x0a, 0x59, 0x24, 0xb5, 0xed, 0x5b, 0x11, 0x16, 0x7e, 0xdd, 0x8b, 0x23, 0x58, 0x2b, 0x3c, 0xb1, 0x5e
}; 

#define result___314 0

//Test vector 315:           "comment" : "edge case for u1",

static uint8_t pkx_315  [32] = { 
0xc2, 0xfd, 0x20, 0xba, 0xc0, 0x6e, 0x55, 0x5b, 0xb8, 0xac, 0x0c, 0xe6, 0x9e, 0xb1, 0xea, 0x20, 0xf8, 0x3a, 0x1f, 0xc3, 0x50, 0x1c, 0x8a, 0x66, 0x46, 0x9b, 0x1a, 0x31, 0xf6, 0x19, 0xb0, 0x98}; 

static uint8_t pky_315  [32] = {
0x62, 0x37, 0x05, 0x07, 0x79, 0xf5, 0x2b, 0x61, 0x5b, 0xd7, 0xb8, 0xd7, 0x6a, 0x25, 0xfc, 0x95, 0xca, 0x2e, 0xd3, 0x25, 0x25, 0xc7, 0x5f, 0x27, 0xff, 0xc8, 0x7a, 0xc3, 0x97, 0xe6, 0xcb, 0xaf};

#define mLen315 6 

static uint8_t msg_315  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_315  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_315  [32] = {
0x83, 0x74, 0x25, 0x3e, 0x3e, 0x21, 0xbd, 0x15, 0x44, 0x48, 0xd0, 0xa8, 0xf6, 0x40, 0xfe, 0x46, 0xfa, 0xfa, 0x8b, 0x19, 0xce, 0x78, 0xd5, 0x38, 0xf6, 0xcc, 0x0a, 0x19, 0x66, 0x2d, 0x36, 0x01
}; 

#define result___315 0

//Test vector 316:           "comment" : "edge case for u1",

static uint8_t pkx_316  [32] = { 
0x3f, 0xd6, 0xa1, 0xca, 0x7f, 0x77, 0xfb, 0x3b, 0x0b, 0xbe, 0x72, 0x6c, 0x37, 0x20, 0x10, 0x06, 0x84, 0x26, 0xe1, 0x1e, 0xa6, 0xae, 0x78, 0xce, 0x17, 0xbe, 0xda, 0xe4, 0xbb, 0xa8, 0x6c, 0xed}; 

static uint8_t pky_316  [32] = {
0x03, 0xce, 0x55, 0x16, 0x40, 0x6b, 0xf8, 0xcf, 0xaa, 0xb8, 0x74, 0x5e, 0xac, 0x1c, 0xd6, 0x90, 0x18, 0xad, 0x6f, 0x50, 0xb5, 0x46, 0x18, 0x72, 0xdd, 0xfc, 0x56, 0xe0, 0xdb, 0x3c, 0x8f, 0xf4};

#define mLen316 6 

static uint8_t msg_316  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_316  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_316  [32] = {
0x35, 0x7c, 0xfd, 0x3b, 0xe4, 0xd0, 0x1d, 0x41, 0x3c, 0x5b, 0x9e, 0xde, 0x36, 0xcb, 0xa5, 0x45, 0x2c, 0x11, 0xee, 0x7f, 0xe1, 0x48, 0x79, 0xe7, 0x49, 0xae, 0x6a, 0x2d, 0x89, 0x7a, 0x52, 0xd6
}; 

#define result___316 0

//Test vector 317:           "comment" : "edge case for u1",

static uint8_t pkx_317  [32] = { 
0x9c, 0xb8, 0xe5, 0x1e, 0x27, 0xa5, 0xae, 0x3b, 0x62, 0x4a, 0x60, 0xd6, 0xdc, 0x32, 0x73, 0x4e, 0x49, 0x89, 0xdb, 0x20, 0xe9, 0xbc, 0xa3, 0xed, 0xe1, 0xed, 0xf7, 0xb0, 0x86, 0x91, 0x11, 0x14}; 

static uint8_t pky_317  [32] = {
0xb4, 0xc1, 0x04, 0xab, 0x3c, 0x67, 0x7e, 0x4b, 0x36, 0xd6, 0x55, 0x6e, 0x8a, 0xd5, 0xf5, 0x23, 0x41, 0x0a, 0x19, 0xf2, 0xe2, 0x77, 0xaa, 0x89, 0x5f, 0xc5, 0x73, 0x22, 0xb4, 0x42, 0x75, 0x44};

#define mLen317 6 

static uint8_t msg_317  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_317  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_317  [32] = {
0x29, 0x79, 0x8c, 0x5c, 0x0e, 0xe2, 0x87, 0xd4, 0xa5, 0xe8, 0xe6, 0xb7, 0x99, 0xfd, 0x86, 0xb8, 0xdf, 0x52, 0x25, 0x29, 0x8e, 0x6f, 0xfc, 0x80, 0x7c, 0xd2, 0xf2, 0xbc, 0x27, 0xa0, 0xa6, 0xd8
}; 

#define result___317 0

//Test vector 318:           "comment" : "edge case for u1",

static uint8_t pkx_318  [32] = { 
0xa3, 0xe5, 0x2c, 0x15, 0x6d, 0xca, 0xf1, 0x05, 0x02, 0x62, 0x0b, 0x79, 0x55, 0xbc, 0x2b, 0x40, 0xbc, 0x78, 0xef, 0x3d, 0x56, 0x9e, 0x12, 0x23, 0xc2, 0x62, 0x51, 0x2d, 0x8f, 0x49, 0x60, 0x2a}; 

static uint8_t pky_318  [32] = {
0x4a, 0x20, 0x39, 0xf3, 0x1c, 0x10, 0x97, 0x02, 0x4a, 0xd3, 0xcc, 0x86, 0xe5, 0x73, 0x21, 0xde, 0x03, 0x23, 0x55, 0x46, 0x34, 0x86, 0x16, 0x4c, 0xf1, 0x92, 0x94, 0x49, 0x77, 0xdf, 0x14, 0x7f};

#define mLen318 6 

static uint8_t msg_318  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_318  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_318  [32] = {
0x0b, 0x70, 0xf2, 0x2c, 0x78, 0x10, 0x92, 0x45, 0x2d, 0xca, 0x1a, 0x57, 0x11, 0xfa, 0x3a, 0x5a, 0x1f, 0x72, 0xad, 0xd1, 0xbf, 0x52, 0xc2, 0xff, 0x7c, 0xae, 0x48, 0x20, 0xb3, 0x00, 0x78, 0xdd
}; 

#define result___318 0

//Test vector 319:           "comment" : "edge case for u1",

static uint8_t pkx_319  [32] = { 
0xf1, 0x9b, 0x78, 0x92, 0x87, 0x20, 0xd5, 0xbe, 0xe8, 0xe6, 0x70, 0xfb, 0x90, 0x01, 0x0f, 0xb1, 0x5c, 0x37, 0xbf, 0x91, 0xb5, 0x8a, 0x51, 0x57, 0xc3, 0xf3, 0xc0, 0x59, 0xb2, 0x65, 0x5e, 0x88}; 

static uint8_t pky_319  [32] = {
0xcf, 0x70, 0x1e, 0xc9, 0x62, 0xfb, 0x4a, 0x11, 0xdc, 0xf2, 0x73, 0xf5, 0xdc, 0x35, 0x7e, 0x58, 0x46, 0x85, 0x60, 0xc7, 0xcf, 0xeb, 0x94, 0x2d, 0x07, 0x4a, 0xbd, 0x43, 0x29, 0x26, 0x05, 0x09};

#define mLen319 6 

static uint8_t msg_319  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_319  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_319  [32] = {
0x16, 0xe1, 0xe4, 0x58, 0xf0, 0x21, 0x24, 0x8a, 0x5b, 0x94, 0x34, 0xae, 0x23, 0xf4, 0x74, 0xb4, 0x3e, 0xe5, 0x5b, 0xa3, 0x7e, 0xa5, 0x85, 0xfe, 0xf9, 0x5c, 0x90, 0x41, 0x66, 0x00, 0xf1, 0xba
}; 

#define result___319 0

//Test vector 320:           "comment" : "edge case for u1",

static uint8_t pkx_320  [32] = { 
0x83, 0xa7, 0x44, 0x45, 0x9e, 0xcd, 0xfb, 0x01, 0xa5, 0xcf, 0x52, 0xb2, 0x7a, 0x05, 0xbb, 0x73, 0x37, 0x48, 0x2d, 0x24, 0x2f, 0x23, 0x5d, 0x7b, 0x4c, 0xb8, 0x93, 0x45, 0x54, 0x5c, 0x90, 0xa8}; 

static uint8_t pky_320  [32] = {
0xc0, 0x5d, 0x49, 0x33, 0x7b, 0x96, 0x49, 0x81, 0x32, 0x87, 0xde, 0x9f, 0xfe, 0x90, 0x35, 0x5f, 0xd9, 0x05, 0xdf, 0x5f, 0x3c, 0x32, 0x94, 0x58, 0x28, 0x12, 0x1f, 0x37, 0xcc, 0x50, 0xde, 0x6e};

#define mLen320 6 

static uint8_t msg_320  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_320  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_320  [32] = {
0x22, 0x52, 0xd6, 0x85, 0x68, 0x31, 0xb6, 0xcf, 0x89, 0x5e, 0x4f, 0x05, 0x35, 0xee, 0xaf, 0x0e, 0x5e, 0x58, 0x09, 0x75, 0x3d, 0xf8, 0x48, 0xfe, 0x76, 0x0a, 0xd8, 0x62, 0x19, 0x01, 0x6a, 0x97
}; 

#define result___320 0

//Test vector 321:           "comment" : "edge case for u1",

static uint8_t pkx_321  [32] = { 
0xdd, 0x13, 0xc6, 0xb3, 0x4c, 0x56, 0x98, 0x2d, 0xda, 0xe1, 0x24, 0xf0, 0x39, 0xdf, 0xd2, 0x3f, 0x4b, 0x19, 0xbb, 0xe8, 0x8c, 0xee, 0x8e, 0x52, 0x8a, 0xe5, 0x1e, 0x5d, 0x6f, 0x3a, 0x21, 0xd7}; 

static uint8_t pky_321  [32] = {
0xbf, 0xad, 0x4c, 0x2e, 0x6f, 0x26, 0x3f, 0xe5, 0xeb, 0x59, 0xca, 0x97, 0x4d, 0x03, 0x9f, 0xc0, 0xe4, 0xc3, 0x34, 0x56, 0x92, 0xfb, 0x53, 0x20, 0xbd, 0xae, 0x4b, 0xd3, 0xb4, 0x2a, 0x45, 0xff};

#define mLen321 6 

static uint8_t msg_321  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_321  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_321  [32] = {
0x81, 0xff, 0xe5, 0x5f, 0x17, 0x8d, 0xa6, 0x95, 0xb2, 0x8c, 0x86, 0xd8, 0xb4, 0x06, 0xb1, 0x5d, 0xab, 0x1a, 0x9e, 0x39, 0x66, 0x1a, 0x3a, 0xe0, 0x17, 0xfb, 0xe3, 0x90, 0xac, 0x09, 0x72, 0xc3
}; 

#define result___321 0

//Test vector 322:           "comment" : "edge case for u2",

static uint8_t pkx_322  [32] = { 
0x67, 0xe6, 0xf6, 0x59, 0xcd, 0xde, 0x86, 0x9a, 0x2f, 0x65, 0xf0, 0x94, 0xe9, 0x4e, 0x5b, 0x4d, 0xfa, 0xd6, 0x36, 0xbb, 0xf9, 0x51, 0x92, 0xfe, 0xee, 0xd0, 0x1b, 0x0f, 0x3d, 0xeb, 0x74, 0x60}; 

static uint8_t pky_322  [32] = {
0xa3, 0x7e, 0x0a, 0x51, 0xf2, 0x58, 0xb7, 0xae, 0xb5, 0x1d, 0xfe, 0x59, 0x2f, 0x5c, 0xfd, 0x56, 0x85, 0xbb, 0xe5, 0x87, 0x12, 0xc8, 0xd9, 0x23, 0x3c, 0x62, 0x88, 0x64, 0x37, 0xc3, 0x8b, 0xa0};

#define mLen322 6 

static uint8_t msg_322  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_322  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_322  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xaa, 0xaa, 0xaa, 0xaa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe9, 0xa2, 0x53, 0x8f, 0x37, 0xb2, 0x8a, 0x2c, 0x51, 0x3d, 0xee, 0x40, 0xfe, 0xcb, 0xb7, 0x1a
}; 

#define result___322 0

//Test vector 323:           "comment" : "edge case for u2",

static uint8_t pkx_323  [32] = { 
0x2e, 0xb6, 0x41, 0x25, 0x05, 0xae, 0xc0, 0x5c, 0x65, 0x45, 0xf0, 0x29, 0x93, 0x20, 0x87, 0xe4, 0x90, 0xd0, 0x55, 0x11, 0xe8, 0xec, 0x1f, 0x59, 0x96, 0x17, 0xbb, 0x36, 0x7f, 0x9e, 0xca, 0xaf}; 

static uint8_t pky_323  [32] = {
0x80, 0x5f, 0x51, 0xef, 0xcc, 0x48, 0x03, 0x40, 0x3f, 0x9b, 0x1a, 0xe0, 0x12, 0x48, 0x90, 0xf0, 0x6a, 0x43, 0xfe, 0xdc, 0xdd, 0xb3, 0x18, 0x30, 0xf6, 0x66, 0x9a, 0xf2, 0x92, 0x89, 0x5c, 0xb0};

#define mLen323 6 

static uint8_t msg_323  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_323  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_323  [32] = {
0xb6, 0x2f, 0x26, 0xb5, 0xf2, 0xa2, 0xb2, 0x6f, 0x6d, 0xe8, 0x6d, 0x42, 0xad, 0x8a, 0x13, 0xda, 0x3a, 0xb3, 0xcc, 0xcd, 0x04, 0x59, 0xb2, 0x01, 0xde, 0x00, 0x9e, 0x52, 0x6a, 0xdf, 0x21, 0xf2
}; 

#define result___323 0

//Test vector 324:           "comment" : "edge case for u2",

static uint8_t pkx_324  [32] = { 
0x84, 0xdb, 0x64, 0x58, 0x68, 0xea, 0xb3, 0x5e, 0x3a, 0x9f, 0xd8, 0x0e, 0x05, 0x6e, 0x2e, 0x85, 0x54, 0x35, 0xe3, 0xa6, 0xb6, 0x8d, 0x75, 0xa5, 0x0a, 0x85, 0x46, 0x25, 0xfe, 0x0d, 0x7f, 0x35}; 

static uint8_t pky_324  [32] = {
0x6d, 0x25, 0x89, 0xac, 0x65, 0x5e, 0xdc, 0x9a, 0x11, 0xef, 0x3e, 0x07, 0x5e, 0xdd, 0xda, 0x9a, 0xbf, 0x92, 0xe7, 0x21, 0x71, 0x57, 0x0e, 0xf7, 0xbf, 0x43, 0xa2, 0xee, 0x39, 0x33, 0x8c, 0xfe};

#define mLen324 6 

static uint8_t msg_324  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_324  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_324  [32] = {
0xbb, 0x1d, 0x9a, 0xc9, 0x49, 0xdd, 0x74, 0x8c, 0xd0, 0x2b, 0xbb, 0xe7, 0x49, 0xbd, 0x35, 0x1c, 0xd5, 0x7b, 0x38, 0xbb, 0x61, 0x40, 0x3d, 0x70, 0x06, 0x86, 0xaa, 0x7b, 0x4c, 0x90, 0x85, 0x1e
}; 

#define result___324 0

//Test vector 325:           "comment" : "edge case for u2",

static uint8_t pkx_325  [32] = { 
0x91, 0xb9, 0xe4, 0x7c, 0x56, 0x27, 0x86, 0x62, 0xd7, 0x5c, 0x09, 0x83, 0xb2, 0x2c, 0xa8, 0xea, 0x6a, 0xa5, 0x05, 0x9b, 0x7a, 0x2f, 0xf7, 0x63, 0x7e, 0xb2, 0x97, 0x5e, 0x38, 0x6a, 0xd6, 0x63}; 

static uint8_t pky_325  [32] = {
0x49, 0xaa, 0x8f, 0xf2, 0x83, 0xd0, 0xf7, 0x7c, 0x18, 0xd6, 0xd1, 0x1d, 0xc0, 0x62, 0x16, 0x5f, 0xd1, 0x3c, 0x3c, 0x03, 0x10, 0x67, 0x9c, 0x14, 0x08, 0x30, 0x2a, 0x16, 0x85, 0x4e, 0xcf, 0xbd};

#define mLen325 6 

static uint8_t msg_325  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_325  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_325  [32] = {
0x66, 0x75, 0x5a, 0x00, 0x63, 0x8c, 0xda, 0xec, 0x1c, 0x73, 0x25, 0x13, 0xca, 0x02, 0x34, 0xec, 0xe5, 0x25, 0x45, 0xda, 0xc1, 0x1f, 0x81, 0x6e, 0x81, 0x8f, 0x72, 0x5b, 0x4f, 0x60, 0xaa, 0xf2
}; 

#define result___325 0

//Test vector 326:           "comment" : "edge case for u2",

static uint8_t pkx_326  [32] = { 
0xf3, 0xec, 0x2f, 0x13, 0xca, 0xf0, 0x4d, 0x01, 0x92, 0xb4, 0x7f, 0xb4, 0xc5, 0x31, 0x1f, 0xb6, 0xd4, 0xdc, 0x6b, 0x0a, 0x9e, 0x80, 0x2e, 0x53, 0x27, 0xf7, 0xec, 0x5e, 0xe8, 0xe4, 0x83, 0x4d}; 

static uint8_t pky_326  [32] = {
0xf9, 0x7e, 0x3e, 0x46, 0x8b, 0x7d, 0x0d, 0xb8, 0x67, 0xd6, 0xec, 0xfe, 0x81, 0xe2, 0xb0, 0xf9, 0x53, 0x1d, 0xf8, 0x7e, 0xfd, 0xb4, 0x7c, 0x13, 0x38, 0xac, 0x32, 0x1f, 0xef, 0xe5, 0xa4, 0x32};

#define mLen326 6 

static uint8_t msg_326  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_326  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_326  [32] = {
0x55, 0xa0, 0x0c, 0x9f, 0xcd, 0xae, 0xbb, 0x60, 0x32, 0x51, 0x3c, 0xa0, 0x23, 0x4e, 0xcf, 0xff, 0xe9, 0x8e, 0xbe, 0x49, 0x2f, 0xdf, 0x02, 0xe4, 0x8c, 0xa4, 0x8e, 0x98, 0x2b, 0xeb, 0x36, 0x69
}; 

#define result___326 0

//Test vector 327:           "comment" : "edge case for u2",

static uint8_t pkx_327  [32] = { 
0xd9, 0x2b, 0x20, 0x0a, 0xef, 0xca, 0xb6, 0xac, 0x7d, 0xaf, 0xd9, 0xac, 0xaf, 0x2f, 0xa1, 0x0b, 0x31, 0x80, 0x23, 0x5b, 0x8f, 0x46, 0xb4, 0x50, 0x3e, 0x46, 0x93, 0xc6, 0x70, 0xfc, 0xcc, 0x88}; 

static uint8_t pky_327  [32] = {
0x5e, 0xf2, 0xf3, 0xae, 0xbf, 0x5b, 0x31, 0x74, 0x75, 0x33, 0x62, 0x56, 0x76, 0x8f, 0x7c, 0x19, 0xef, 0xb7, 0x35, 0x2d, 0x27, 0xe4, 0xcc, 0xca, 0xdc, 0x85, 0xb6, 0xb8, 0xab, 0x92, 0x2c, 0x72};

#define mLen327 6 

static uint8_t msg_327  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_327  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_327  [32] = {
0xab, 0x40, 0x19, 0x3f, 0x9b, 0x5d, 0x76, 0xc0, 0x64, 0xa2, 0x79, 0x40, 0x46, 0x9d, 0x9f, 0xff, 0xd3, 0x1d, 0x7c, 0x92, 0x5f, 0xbe, 0x05, 0xc9, 0x19, 0x49, 0x1d, 0x30, 0x57, 0xd6, 0x6c, 0xd2
}; 

#define result___327 0

//Test vector 328:           "comment" : "edge case for u2",

static uint8_t pkx_328  [32] = { 
0x0a, 0x88, 0x36, 0x1e, 0xb9, 0x2e, 0xcc, 0xa2, 0x62, 0x5b, 0x38, 0xe5, 0xf9, 0x8b, 0xba, 0xbb, 0x96, 0xbf, 0x17, 0x9b, 0x3d, 0x76, 0xfc, 0x48, 0x14, 0x0a, 0x3b, 0xcd, 0x88, 0x15, 0x23, 0xcd}; 

static uint8_t pky_328  [32] = {
0xe6, 0xbd, 0xf5, 0x60, 0x33, 0xf8, 0x4a, 0x50, 0x54, 0x03, 0x55, 0x97, 0x37, 0x5d, 0x90, 0x86, 0x6a, 0xa2, 0xc9, 0x6b, 0x86, 0xa4, 0x1c, 0xcf, 0x6e, 0xde, 0xbf, 0x47, 0x29, 0x8a, 0xd4, 0x89};

#define mLen328 6 

static uint8_t msg_328  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_328  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_328  [32] = {
0xca, 0x02, 0x34, 0xeb, 0xb5, 0xfd, 0xcb, 0x13, 0xca, 0x02, 0x34, 0xec, 0xff, 0xff, 0xff, 0xff, 0xcb, 0x0d, 0xad, 0xbb, 0xc7, 0xf5, 0x49, 0xf8, 0xa2, 0x6b, 0x44, 0x08, 0xd0, 0xdc, 0x86, 0x00
}; 

#define result___328 0

//Test vector 329:           "comment" : "edge case for u2",

static uint8_t pkx_329  [32] = { 
0xd0, 0xfb, 0x17, 0xcc, 0xd8, 0xfa, 0xfe, 0x82, 0x7e, 0x0c, 0x1a, 0xfc, 0x5d, 0x8d, 0x80, 0x36, 0x6e, 0x2b, 0x20, 0xe7, 0xf1, 0x4a, 0x56, 0x3a, 0x2b, 0xa5, 0x04, 0x69, 0xd8, 0x43, 0x75, 0xe8}; 

static uint8_t pky_329  [32] = {
0x68, 0x61, 0x25, 0x69, 0xd3, 0x9e, 0x2b, 0xb9, 0xf5, 0x54, 0x35, 0x55, 0x64, 0x64, 0x6d, 0xe9, 0x9a, 0xc6, 0x02, 0xcc, 0x63, 0x49, 0xcf, 0x8c, 0x1e, 0x23, 0x6a, 0x7d, 0xe7, 0x63, 0x7d, 0x93};

#define mLen329 6 

static uint8_t msg_329  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_329  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_329  [32] = {
0xbf, 0xff, 0xff, 0xff, 0x3e, 0xa3, 0x67, 0x7e, 0x08, 0x2b, 0x93, 0x10, 0x57, 0x26, 0x20, 0xae, 0x19, 0x93, 0x3a, 0x9e, 0x65, 0xb2, 0x85, 0x59, 0x87, 0x11, 0xc7, 0x72, 0x98, 0x81, 0x5a, 0xd3
}; 

#define result___329 0

//Test vector 330:           "comment" : "edge case for u2",

static uint8_t pkx_330  [32] = { 
0x83, 0x6f, 0x33, 0xbb, 0xc1, 0xdc, 0x0d, 0x3d, 0x3a, 0xbb, 0xce, 0xf0, 0xd9, 0x1f, 0x11, 0xe2, 0xac, 0x41, 0x81, 0x07, 0x6c, 0x9a, 0xf0, 0xa2, 0x2b, 0x1e, 0x43, 0x09, 0xd3, 0xed, 0xb2, 0x76}; 

static uint8_t pky_330  [32] = {
0x9a, 0xb4, 0x43, 0xff, 0x6f, 0x90, 0x1e, 0x30, 0xc7, 0x73, 0x86, 0x75, 0x82, 0x99, 0x7c, 0x2b, 0xec, 0x2b, 0x0c, 0xb8, 0x12, 0x0d, 0x76, 0x02, 0x36, 0xf3, 0xa9, 0x5b, 0xbe, 0x88, 0x1f, 0x75};

#define mLen330 6 

static uint8_t msg_330  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_330  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_330  [32] = {
0x26, 0x66, 0x66, 0x66, 0x3b, 0xbb, 0xbb, 0xbb, 0xe6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x5b, 0x37, 0x90, 0x2e, 0x02, 0x3f, 0xab, 0x7c, 0x8f, 0x05, 0x5d, 0x86, 0xe5, 0xcc, 0x41, 0xf4
}; 

#define result___330 0

//Test vector 331:           "comment" : "edge case for u2",

static uint8_t pkx_331  [32] = { 
0x92, 0xf9, 0x9f, 0xbe, 0x97, 0x3e, 0xd4, 0xa2, 0x99, 0x71, 0x9b, 0xae, 0xe4, 0xb4, 0x32, 0x74, 0x12, 0x37, 0x03, 0x4d, 0xec, 0x8d, 0x72, 0xba, 0x51, 0x03, 0xcb, 0x33, 0xe5, 0x5f, 0xee, 0xb8}; 

static uint8_t pky_331  [32] = {
0x03, 0x3d, 0xd0, 0xe9, 0x11, 0x34, 0xc7, 0x34, 0x17, 0x48, 0x89, 0xf3, 0xeb, 0xcf, 0x1b, 0x7a, 0x1a, 0xc0, 0x57, 0x67, 0x28, 0x92, 0x80, 0xee, 0x7a, 0x79, 0x4c, 0xeb, 0xd6, 0xe6, 0x96, 0x97};

#define mLen331 6 

static uint8_t msg_331  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_331  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_331  [32] = {
0xbf, 0xff, 0xff, 0xff, 0x36, 0xdb, 0x6d, 0xb7, 0xa4, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x14, 0x6c, 0x57, 0x3f, 0x4c, 0x6d, 0xfc, 0x8d, 0x08, 0xa4, 0x43, 0xe2, 0x58, 0x97, 0x0b, 0x09
}; 

#define result___331 0

//Test vector 332:           "comment" : "edge case for u2",

static uint8_t pkx_332  [32] = { 
0xd3, 0x5b, 0xa5, 0x8d, 0xa3, 0x01, 0x97, 0xd3, 0x78, 0xe6, 0x18, 0xec, 0x0f, 0xa7, 0xe2, 0xe2, 0xd1, 0x2c, 0xff, 0xd7, 0x3e, 0xbb, 0xb2, 0x04, 0x9d, 0x13, 0x0b, 0xba, 0x43, 0x4a, 0xf0, 0x9e}; 

static uint8_t pky_332  [32] = {
0xff, 0x83, 0x98, 0x6e, 0x68, 0x75, 0xe4, 0x1e, 0xa4, 0x32, 0xb7, 0x58, 0x5a, 0x49, 0xb3, 0xa6, 0xc7, 0x7c, 0xbb, 0x3c, 0x47, 0x91, 0x9f, 0x8e, 0x82, 0x87, 0x4c, 0x79, 0x46, 0x35, 0xc1, 0xd2};

#define mLen332 6 

static uint8_t msg_332  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_332  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_332  [32] = {
0xbf, 0xff, 0xff, 0xff, 0x2a, 0xaa, 0xaa, 0xab, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x15, 0xd0, 0xe6, 0x0b, 0x3e, 0x59, 0x6e, 0xcb, 0x1a, 0xd3, 0xa2, 0x7c, 0xfd, 0x49, 0xc4
}; 

#define result___332 0

//Test vector 333:           "comment" : "edge case for u2",

static uint8_t pkx_333  [32] = { 
0x86, 0x51, 0xce, 0x49, 0x0f, 0x1b, 0x46, 0xd7, 0x3f, 0x3f, 0xf4, 0x75, 0x14, 0x9b, 0xe2, 0x91, 0x36, 0x69, 0x73, 0x34, 0xa5, 0x19, 0xd7, 0xdd, 0xab, 0x07, 0x25, 0xc8, 0xd0, 0x79, 0x32, 0x24}; 

static uint8_t pky_333  [32] = {
0xe1, 0x1c, 0x65, 0xbd, 0x8c, 0xa9, 0x2d, 0xc8, 0xbc, 0x9a, 0xe8, 0x29, 0x11, 0xf0, 0xb5, 0x27, 0x51, 0xce, 0x21, 0xdd, 0x90, 0x03, 0xae, 0x60, 0x90, 0x0b, 0xd8, 0x25, 0xf5, 0x90, 0xcc, 0x28};

#define mLen333 6 

static uint8_t msg_333  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_333  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_333  [32] = {
0x7f, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd3, 0x44, 0xa7, 0x1e, 0x6f, 0x65, 0x14, 0x58, 0xa2, 0x7b, 0xdc, 0x81, 0xfd, 0x97, 0x6e, 0x37
}; 

#define result___333 0

//Test vector 334:           "comment" : "edge case for u2",

static uint8_t pkx_334  [32] = { 
0x6d, 0x8e, 0x1b, 0x12, 0xc8, 0x31, 0xa0, 0xda, 0x87, 0x95, 0x65, 0x0f, 0xf9, 0x5f, 0x10, 0x1e, 0xd9, 0x21, 0xd9, 0xe2, 0xf7, 0x2b, 0x15, 0xb1, 0xcd, 0xac, 0xa9, 0x82, 0x6b, 0x9c, 0xfc, 0x6d}; 

static uint8_t pky_334  [32] = {
0xef, 0x6d, 0x63, 0xe2, 0xbc, 0x5c, 0x08, 0x95, 0x70, 0x39, 0x4a, 0x4b, 0xc9, 0xf8, 0x92, 0xd5, 0xe6, 0xc7, 0xa6, 0xa6, 0x37, 0xb2, 0x04, 0x69, 0xa5, 0x8c, 0x10, 0x6a, 0xd4, 0x86, 0xbf, 0x37};

#define mLen334 6 

static uint8_t msg_334  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_334  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_334  [32] = {
0x3f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xde, 0x73, 0x7d, 0x56, 0xd3, 0x8b, 0xcf, 0x42, 0x79, 0xdc, 0xe5, 0x61, 0x7e, 0x31, 0x92, 0xaa
}; 

#define result___334 0

//Test vector 335:           "comment" : "edge case for u2",

static uint8_t pkx_335  [32] = { 
0x0a, 0xe5, 0x80, 0xba, 0xe9, 0x33, 0xb4, 0xef, 0x29, 0x97, 0xcb, 0xdb, 0xb0, 0x92, 0x23, 0x28, 0xca, 0x9a, 0x41, 0x0f, 0x62, 0x7a, 0x0f, 0x7d, 0xff, 0x24, 0xcb, 0x4d, 0x92, 0x0e, 0x15, 0x42}; 

static uint8_t pky_335  [32] = {
0x89, 0x11, 0xe7, 0xf8, 0xcc, 0x36, 0x5a, 0x8a, 0x88, 0xeb, 0x81, 0x42, 0x1a, 0x36, 0x1c, 0xcc, 0x2b, 0x99, 0xe3, 0x09, 0xd8, 0xdc, 0xd9, 0xa9, 0x8b, 0xa8, 0x3c, 0x39, 0x49, 0xd8, 0x93, 0xe3};

#define mLen335 6 

static uint8_t msg_335  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_335  [32] = {
0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd
}; 

static uint8_t s_335  [32] = {
0x5d, 0x8e, 0xcd, 0x64, 0xa4, 0xee, 0xba, 0x46, 0x68, 0x15, 0xdd, 0xf3, 0xa4, 0xde, 0x9a, 0x8e, 0x6a, 0xbd, 0x9c, 0x5d, 0xb0, 0xa0, 0x1e, 0xb8, 0x03, 0x43, 0x55, 0x3d, 0xa6, 0x48, 0x42, 0x8f
}; 

#define result___335 0

//Test vector 336:           "comment" : "point duplication during verification",

static uint8_t pkx_336  [32] = { 
0x5b, 0x81, 0x2f, 0xd5, 0x21, 0xaa, 0xfa, 0x69, 0x83, 0x5a, 0x84, 0x9c, 0xce, 0x6f, 0xbd, 0xeb, 0x69, 0x83, 0xb4, 0x42, 0xd2, 0x44, 0x4f, 0xe7, 0x0e, 0x13, 0x4c, 0x02, 0x7f, 0xc4, 0x69, 0x63}; 

static uint8_t pky_336  [32] = {
0x83, 0x8a, 0x40, 0xf2, 0xa3, 0x60, 0x92, 0xe9, 0x00, 0x4e, 0x92, 0xd8, 0xd9, 0x40, 0xcf, 0x56, 0x38, 0x55, 0x0c, 0xe6, 0x72, 0xce, 0x8b, 0x8d, 0x4e, 0x15, 0xeb, 0xa5, 0x49, 0x92, 0x49, 0xe9};

#define mLen336 6 

static uint8_t msg_336  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_336  [32] = {
0x6f, 0x23, 0x47, 0xca, 0xb7, 0xdd, 0x76, 0x85, 0x8f, 0xe0, 0x55, 0x5a, 0xc3, 0xbc, 0x99, 0x04, 0x8c, 0x4a, 0xac, 0xaf, 0xdf, 0xb6, 0xbc, 0xbe, 0x05, 0xea, 0x6c, 0x42, 0xc4, 0x93, 0x45, 0x69
}; 

static uint8_t s_336  [32] = {
0xbb, 0x72, 0x66, 0x60, 0x23, 0x57, 0x93, 0xaa, 0x99, 0x57, 0xa6, 0x1e, 0x76, 0xe0, 0x0c, 0x2c, 0x43, 0x51, 0x09, 0xcf, 0x9a, 0x15, 0xdd, 0x62, 0x4d, 0x53, 0xf4, 0x30, 0x10, 0x47, 0x85, 0x6b
}; 

#define result___336 0

//Test vector 337:           "comment" : "duplication bug",

static uint8_t pkx_337  [32] = { 
0x5b, 0x81, 0x2f, 0xd5, 0x21, 0xaa, 0xfa, 0x69, 0x83, 0x5a, 0x84, 0x9c, 0xce, 0x6f, 0xbd, 0xeb, 0x69, 0x83, 0xb4, 0x42, 0xd2, 0x44, 0x4f, 0xe7, 0x0e, 0x13, 0x4c, 0x02, 0x7f, 0xc4, 0x69, 0x63}; 

static uint8_t pky_337  [32] = {
0x7c, 0x75, 0xbf, 0x0c, 0x5c, 0x9f, 0x6d, 0x17, 0xff, 0xb1, 0x6d, 0x27, 0x26, 0xbf, 0x30, 0xa9, 0xc7, 0xaa, 0xf3, 0x1a, 0x8d, 0x31, 0x74, 0x72, 0xb1, 0xea, 0x14, 0x5a, 0xb6, 0x6d, 0xb6, 0x16};

#define mLen337 6 

static uint8_t msg_337  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_337  [32] = {
0x6f, 0x23, 0x47, 0xca, 0xb7, 0xdd, 0x76, 0x85, 0x8f, 0xe0, 0x55, 0x5a, 0xc3, 0xbc, 0x99, 0x04, 0x8c, 0x4a, 0xac, 0xaf, 0xdf, 0xb6, 0xbc, 0xbe, 0x05, 0xea, 0x6c, 0x42, 0xc4, 0x93, 0x45, 0x69
}; 

static uint8_t s_337  [32] = {
0xbb, 0x72, 0x66, 0x60, 0x23, 0x57, 0x93, 0xaa, 0x99, 0x57, 0xa6, 0x1e, 0x76, 0xe0, 0x0c, 0x2c, 0x43, 0x51, 0x09, 0xcf, 0x9a, 0x15, 0xdd, 0x62, 0x4d, 0x53, 0xf4, 0x30, 0x10, 0x47, 0x85, 0x6b
}; 

#define result___337 18446744073709551615

//Test vector 338:           "comment" : "point with x-coordinate 0",

static uint8_t pkx_338  [32] = { 
0x6a, 0xdd, 0xa8, 0x2b, 0x90, 0x26, 0x1b, 0x0f, 0x31, 0x9f, 0xaa, 0x0d, 0x87, 0x86, 0x65, 0xa6, 0xb6, 0xda, 0x49, 0x7f, 0x09, 0xc9, 0x03, 0x17, 0x62, 0x22, 0xc3, 0x4a, 0xcf, 0xef, 0x72, 0xa6}; 

static uint8_t pky_338  [32] = {
0x47, 0xe6, 0xf5, 0x0d, 0xcc, 0x40, 0xad, 0x5d, 0x9b, 0x59, 0xf7, 0x60, 0x2b, 0xb2, 0x22, 0xfa, 0xd7, 0x1a, 0x41, 0xbf, 0x5e, 0x1f, 0x9d, 0xf4, 0x95, 0x9a, 0x36, 0x4c, 0x62, 0xe4, 0x88, 0xd9};

#define mLen338 6 

static uint8_t msg_338  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_338  [32] = {
0x01
}; 

static uint8_t s_338  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

#define result___338 18446744073709551615

//Test vector 339:           "comment" : "point with x-coordinate 0",

static uint8_t pkx_339  [32] = { 
0x2f, 0xca, 0x0d, 0x0a, 0x47, 0x91, 0x4d, 0xe7, 0x7e, 0xd5, 0x6e, 0x7e, 0xcc, 0xc3, 0x27, 0x6a, 0x60, 0x11, 0x20, 0xc6, 0xdf, 0x00, 0x69, 0xc8, 0x25, 0xc8, 0xf6, 0xa0, 0x1c, 0x9f, 0x38, 0x20}; 

static uint8_t pky_339  [32] = {
0x65, 0xf3, 0x45, 0x0a, 0x1d, 0x17, 0xc6, 0xb2, 0x49, 0x89, 0xa3, 0x9b, 0xeb, 0x1c, 0x7d, 0xec, 0xfc, 0xa8, 0x38, 0x4f, 0xbd, 0xc2, 0x94, 0x41, 0x8e, 0x5d, 0x80, 0x7b, 0x3c, 0x6e, 0xd7, 0xde};

#define mLen339 6 

static uint8_t msg_339  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_339  [32] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t s_339  [32] = {
0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x25, 0xc7, 0xcb, 0xbc, 0x54, 0x9e, 0x52, 0xe7, 0x63, 0xf1, 0xf5, 0x5a, 0x32, 0x7a, 0x3a, 0xa9
}; 

#define result___339 18446744073709551615

//Test vector 340:           "comment" : "comparison with point at infinity ",

static uint8_t pkx_340  [32] = { 
0xdd, 0x86, 0xd3, 0xb5, 0xf4, 0xa1, 0x3e, 0x85, 0x11, 0x08, 0x3b, 0x78, 0x00, 0x20, 0x81, 0xc5, 0x3f, 0xf4, 0x67, 0xf1, 0x1e, 0xbd, 0x98, 0xa5, 0x1a, 0x63, 0x3d, 0xb7, 0x66, 0x65, 0xd2, 0x50}; 

static uint8_t pky_340  [32] = {
0x45, 0xd5, 0xc8, 0x20, 0x0c, 0x89, 0xf2, 0xfa, 0x10, 0xd8, 0x49, 0x34, 0x92, 0x26, 0xd2, 0x1d, 0x8d, 0xfa, 0xed, 0x6f, 0xf8, 0xd5, 0xcb, 0x3e, 0x1b, 0x7e, 0x17, 0x47, 0x4e, 0xbc, 0x18, 0xf7};

#define mLen340 6 

static uint8_t msg_340  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_340  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

static uint8_t s_340  [32] = {
0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x25, 0xc7, 0xcb, 0xbc, 0x54, 0x9e, 0x52, 0xe7, 0x63, 0xf1, 0xf5, 0x5a, 0x32, 0x7a, 0x3a, 0xa9
}; 

#define result___340 18446744073709551615

//Test vector 341:           "comment" : "extreme value for k and edgecase s",

static uint8_t pkx_341  [32] = { 
0x4f, 0xea, 0x55, 0xb3, 0x2c, 0xb3, 0x2a, 0xca, 0x0c, 0x12, 0xc4, 0xcd, 0x0a, 0xbf, 0xb4, 0xe6, 0x4b, 0x0f, 0x5a, 0x51, 0x6e, 0x57, 0x8c, 0x01, 0x65, 0x91, 0xa9, 0x3f, 0x5a, 0x0f, 0xbc, 0xc5}; 

static uint8_t pky_341  [32] = {
0xd7, 0xd3, 0xfd, 0x10, 0xb2, 0xbe, 0x66, 0x8c, 0x54, 0x7b, 0x21, 0x2f, 0x6b, 0xb1, 0x4c, 0x88, 0xf0, 0xfe, 0xcd, 0x38, 0xa8, 0xa4, 0xb2, 0xc7, 0x85, 0xed, 0x3b, 0xe6, 0x2c, 0xe4, 0xb2, 0x80};

#define mLen341 6 

static uint8_t msg_341  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_341  [32] = {
0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e, 0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2, 0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78
}; 

static uint8_t s_341  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

#define result___341 0

//Test vector 342:           "comment" : "extreme value for k and s^-1",

static uint8_t pkx_342  [32] = { 
0xc6, 0xa7, 0x71, 0x52, 0x70, 0x24, 0x22, 0x77, 0x92, 0x17, 0x0a, 0x6f, 0x8e, 0xee, 0x73, 0x5b, 0xf3, 0x2b, 0x7f, 0x98, 0xaf, 0x66, 0x9e, 0xad, 0x29, 0x98, 0x02, 0xe3, 0x2d, 0x7c, 0x31, 0x07}; 

static uint8_t pky_342  [32] = {
0xbc, 0x3b, 0x4b, 0x5e, 0x65, 0xab, 0x88, 0x7b, 0xbd, 0x34, 0x35, 0x72, 0xb3, 0xe5, 0x61, 0x92, 0x61, 0xfe, 0x3a, 0x07, 0x3e, 0x2f, 0xfd, 0x78, 0x41, 0x2f, 0x72, 0x68, 0x67, 0xdb, 0x58, 0x9e};

#define mLen342 6 

static uint8_t msg_342  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_342  [32] = {
0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e, 0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2, 0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78
}; 

static uint8_t s_342  [32] = {
0xb6, 0xdb, 0x6d, 0xb6, 0x24, 0x92, 0x49, 0x25, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x62, 0x5b, 0xd7, 0xa0, 0x9b, 0xec, 0x4c, 0xa8, 0x1b, 0xcd, 0xd9, 0xf8, 0xfd, 0x6b, 0x63, 0xcc
}; 

#define result___342 0

//Test vector 343:           "comment" : "extreme value for k and s^-1",

static uint8_t pkx_343  [32] = { 
0x85, 0x1c, 0x2b, 0xba, 0xd0, 0x8e, 0x54, 0xec, 0x7a, 0x9a, 0xf9, 0x9f, 0x49, 0xf0, 0x36, 0x44, 0xd6, 0xec, 0x6d, 0x59, 0xb2, 0x07, 0xfe, 0xc9, 0x8d, 0xe8, 0x5a, 0x7d, 0x15, 0xb9, 0x56, 0xef}; 

static uint8_t pky_343  [32] = {
0xce, 0xe9, 0x96, 0x02, 0x83, 0x04, 0x50, 0x75, 0x68, 0x4b, 0x41, 0x0b, 0xe8, 0xd0, 0xf7, 0x49, 0x4b, 0x91, 0xaa, 0x23, 0x79, 0xf6, 0x07, 0x27, 0x31, 0x9f, 0x10, 0xdd, 0xeb, 0x0f, 0xe9, 0xd6};

#define mLen343 6 

static uint8_t msg_343  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_343  [32] = {
0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e, 0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2, 0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78
}; 

static uint8_t s_343  [32] = {
0xcc, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x97, 0x1f, 0x2e, 0xf1, 0x52, 0x79, 0x4b, 0x9d, 0x8f, 0xc7, 0xd5, 0x68, 0xc9, 0xe8, 0xea, 0xa7
}; 

#define result___343 0

//Test vector 344:           "comment" : "extreme value for k and s^-1",

static uint8_t pkx_344  [32] = { 
0xf6, 0x41, 0x7c, 0x8a, 0x67, 0x05, 0x84, 0xe3, 0x88, 0x67, 0x69, 0x49, 0xe5, 0x3d, 0xa7, 0xfc, 0x55, 0x91, 0x1f, 0xf6, 0x83, 0x18, 0xd1, 0xbf, 0x30, 0x61, 0x20, 0x5a, 0xcb, 0x19, 0xc4, 0x8f}; 

static uint8_t pky_344  [32] = {
0x8f, 0x2b, 0x74, 0x3d, 0xf3, 0x4a, 0xd0, 0xf7, 0x26, 0x74, 0xac, 0xb7, 0x50, 0x59, 0x29, 0x78, 0x47, 0x79, 0xcd, 0x9a, 0xc9, 0x16, 0xc3, 0x66, 0x9e, 0xad, 0x43, 0x02, 0x6a, 0xb6, 0xd4, 0x3f};

#define mLen344 6 

static uint8_t msg_344  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_344  [32] = {
0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e, 0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2, 0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78
}; 

static uint8_t s_344  [32] = {
0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x25, 0xc7, 0xcb, 0xbc, 0x54, 0x9e, 0x52, 0xe7, 0x63, 0xf1, 0xf5, 0x5a, 0x32, 0x7a, 0x3a, 0xaa
}; 

#define result___344 0

//Test vector 345:           "comment" : "extreme value for k and s^-1",

static uint8_t pkx_345  [32] = { 
0x50, 0x14, 0x21, 0x27, 0x7b, 0xe4, 0x5a, 0x5e, 0xef, 0xec, 0x6c, 0x63, 0x99, 0x30, 0xd6, 0x36, 0x03, 0x25, 0x65, 0xaf, 0x42, 0x0c, 0xf3, 0x37, 0x3f, 0x55, 0x7f, 0xaa, 0x7f, 0x8a, 0x06, 0x43}; 

static uint8_t pky_345  [32] = {
0x86, 0x73, 0xd6, 0xcb, 0x60, 0x76, 0xe1, 0xcf, 0xcd, 0xc7, 0xdf, 0xe7, 0x38, 0x4c, 0x8e, 0x5c, 0xac, 0x08, 0xd7, 0x45, 0x01, 0xf2, 0xae, 0x6e, 0x89, 0xca, 0xd1, 0x95, 0xd0, 0xaa, 0x13, 0x71};

#define mLen345 6 

static uint8_t msg_345  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_345  [32] = {
0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e, 0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2, 0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78
}; 

static uint8_t s_345  [32] = {
0x49, 0x24, 0x92, 0x48, 0xdb, 0x6d, 0xb6, 0xdb, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x5a, 0x8b, 0x23, 0x0d, 0x0b, 0x2b, 0x51, 0xdc, 0xd7, 0xeb, 0xf0, 0xc9, 0xfe, 0xf7, 0xc1, 0x85
}; 

#define result___345 0

//Test vector 346:           "comment" : "extreme value for k",

static uint8_t pkx_346  [32] = { 
0x0d, 0x93, 0x5b, 0xf9, 0xff, 0xc1, 0x15, 0xa5, 0x27, 0x73, 0x5f, 0x72, 0x9c, 0xa8, 0xa4, 0xca, 0x23, 0xee, 0x01, 0xa4, 0x89, 0x4a, 0xdf, 0x0e, 0x34, 0x15, 0xac, 0x84, 0xe8, 0x08, 0xbb, 0x34}; 

static uint8_t pky_346  [32] = {
0x31, 0x95, 0xa3, 0x76, 0x2f, 0xea, 0x29, 0xed, 0x38, 0x91, 0x2b, 0xd9, 0xea, 0x6c, 0x4f, 0xde, 0x70, 0xc3, 0x05, 0x08, 0x93, 0xa4, 0x37, 0x58, 0x50, 0xce, 0x61, 0xd8, 0x2e, 0xba, 0x33, 0xc5};

#define mLen346 6 

static uint8_t msg_346  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_346  [32] = {
0x7c, 0xf2, 0x7b, 0x18, 0x8d, 0x03, 0x4f, 0x7e, 0x8a, 0x52, 0x38, 0x03, 0x04, 0xb5, 0x1a, 0xc3, 0xc0, 0x89, 0x69, 0xe2, 0x77, 0xf2, 0x1b, 0x35, 0xa6, 0x0b, 0x48, 0xfc, 0x47, 0x66, 0x99, 0x78
}; 

static uint8_t s_346  [32] = {
0x16, 0xa4, 0x50, 0x2e, 0x27, 0x81, 0xe1, 0x1a, 0xc8, 0x2c, 0xbc, 0x9d, 0x1e, 0xdd, 0x8c, 0x98, 0x15, 0x84, 0xd1, 0x3e, 0x18, 0x41, 0x1e, 0x2f, 0x6e, 0x04, 0x78, 0xc3, 0x44, 0x16, 0xe3, 0xbb
}; 

#define result___346 0

//Test vector 347:           "comment" : "extreme value for k and edgecase s",

static uint8_t pkx_347  [32] = { 
0x5e, 0x59, 0xf5, 0x07, 0x08, 0x64, 0x6b, 0xe8, 0xa5, 0x89, 0x35, 0x50, 0x14, 0x30, 0x8e, 0x60, 0xb6, 0x68, 0xfb, 0x67, 0x01, 0x96, 0x20, 0x6c, 0x41, 0xe7, 0x48, 0xe6, 0x4e, 0x4d, 0xca, 0x21}; 

static uint8_t pky_347  [32] = {
0x5d, 0xe3, 0x7f, 0xee, 0x5c, 0x97, 0xbc, 0xaf, 0x71, 0x44, 0xd5, 0xb4, 0x59, 0x98, 0x2f, 0x52, 0xee, 0xea, 0xfb, 0xdf, 0x03, 0xaa, 0xcb, 0xaf, 0xef, 0x38, 0xe2, 0x13, 0x62, 0x4a, 0x01, 0xde};

#define mLen347 6 

static uint8_t msg_347  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_347  [32] = {
0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96
}; 

static uint8_t s_347  [32] = {
0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x3e, 0xf7, 0xa8, 0xe4, 0x8d, 0x07, 0xdf, 0x81, 0xa6, 0x93, 0x43, 0x96, 0x54, 0x21, 0x0c, 0x70
}; 

#define result___347 0

//Test vector 348:           "comment" : "extreme value for k and s^-1",

static uint8_t pkx_348  [32] = { 
0x16, 0x9f, 0xb7, 0x97, 0x32, 0x58, 0x43, 0xfa, 0xff, 0x2f, 0x7a, 0x5b, 0x54, 0x45, 0xda, 0x9e, 0x2f, 0xd6, 0x22, 0x6f, 0x7e, 0xf9, 0x0e, 0xf0, 0xbf, 0xe9, 0x24, 0x10, 0x4b, 0x02, 0xdb, 0x8e}; 

static uint8_t pky_348  [32] = {
0x7b, 0xbb, 0x8d, 0xe6, 0x62, 0xc7, 0xb9, 0xb1, 0xcf, 0x9b, 0x22, 0xf7, 0xa2, 0xe5, 0x82, 0xbd, 0x46, 0xd5, 0x81, 0xd6, 0x88, 0x78, 0xef, 0xb2, 0xb8, 0x61, 0xb1, 0x31, 0xd8, 0xa1, 0xd6, 0x67};

#define mLen348 6 

static uint8_t msg_348  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_348  [32] = {
0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96
}; 

static uint8_t s_348  [32] = {
0xb6, 0xdb, 0x6d, 0xb6, 0x24, 0x92, 0x49, 0x25, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x62, 0x5b, 0xd7, 0xa0, 0x9b, 0xec, 0x4c, 0xa8, 0x1b, 0xcd, 0xd9, 0xf8, 0xfd, 0x6b, 0x63, 0xcc
}; 

#define result___348 0

//Test vector 349:           "comment" : "extreme value for k and s^-1",

static uint8_t pkx_349  [32] = { 
0x27, 0x1c, 0xd8, 0x9c, 0x00, 0x01, 0x43, 0x09, 0x6b, 0x62, 0xd4, 0xe9, 0xe4, 0xca, 0x88, 0x5a, 0xef, 0x2f, 0x70, 0x23, 0xd1, 0x8a, 0xff, 0xda, 0xf8, 0xb7, 0xb5, 0x48, 0x98, 0x14, 0x87, 0x54}; 

static uint8_t pky_349  [32] = {
0x0a, 0x1c, 0x6e, 0x95, 0x4e, 0x32, 0x10, 0x84, 0x35, 0xb5, 0x5f, 0xa3, 0x85, 0xb0, 0xf7, 0x64, 0x81, 0xa6, 0x09, 0xb9, 0x14, 0x9c, 0xcb, 0x4b, 0x02, 0xb2, 0xca, 0x47, 0xfe, 0x8e, 0x4d, 0xa5};

#define mLen349 6 

static uint8_t msg_349  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_349  [32] = {
0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96
}; 

static uint8_t s_349  [32] = {
0xcc, 0xcc, 0xcc, 0xcc, 0x00, 0x00, 0x00, 0x00, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x97, 0x1f, 0x2e, 0xf1, 0x52, 0x79, 0x4b, 0x9d, 0x8f, 0xc7, 0xd5, 0x68, 0xc9, 0xe8, 0xea, 0xa7
}; 

#define result___349 0

//Test vector 350:           "comment" : "extreme value for k and s^-1",

static uint8_t pkx_350  [32] = { 
0x3d, 0x0b, 0xc7, 0xed, 0x8f, 0x09, 0xd2, 0xcb, 0x7d, 0xdb, 0x46, 0xeb, 0xc1, 0xed, 0x79, 0x9a, 0xb1, 0x56, 0x3a, 0x9a, 0xb8, 0x4b, 0xf5, 0x24, 0x58, 0x7a, 0x22, 0x0a, 0xfe, 0x49, 0x9c, 0x12}; 

static uint8_t pky_350  [32] = {
0xe2, 0x2d, 0xc3, 0xb3, 0xc1, 0x03, 0x82, 0x4a, 0x4f, 0x37, 0x8d, 0x96, 0xad, 0xb0, 0xa4, 0x08, 0xab, 0xf1, 0x9c, 0xe7, 0xd6, 0x8a, 0xa6, 0x24, 0x4f, 0x78, 0xcb, 0x21, 0x6f, 0xa3, 0xf8, 0xdf};

#define mLen350 6 

static uint8_t msg_350  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_350  [32] = {
0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96
}; 

static uint8_t s_350  [32] = {
0x33, 0x33, 0x33, 0x33, 0x00, 0x00, 0x00, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x25, 0xc7, 0xcb, 0xbc, 0x54, 0x9e, 0x52, 0xe7, 0x63, 0xf1, 0xf5, 0x5a, 0x32, 0x7a, 0x3a, 0xaa
}; 

#define result___350 0

//Test vector 351:           "comment" : "extreme value for k and s^-1",

static uint8_t pkx_351  [32] = { 
0xa6, 0xc8, 0x85, 0xad, 0xe1, 0xa4, 0xc5, 0x66, 0xf9, 0xbb, 0x01, 0x0d, 0x06, 0x69, 0x74, 0xab, 0xb2, 0x81, 0x79, 0x7f, 0xa7, 0x01, 0x28, 0x8c, 0x72, 0x1b, 0xcb, 0xd2, 0x36, 0x63, 0xa9, 0xb7}; 

static uint8_t pky_351  [32] = {
0x2e, 0x42, 0x4b, 0x69, 0x09, 0x57, 0x16, 0x8d, 0x19, 0x3a, 0x60, 0x96, 0xfc, 0x77, 0xa2, 0xb0, 0x04, 0xa9, 0xc7, 0xd4, 0x67, 0xe0, 0x07, 0xe1, 0xf2, 0x05, 0x84, 0x58, 0xf9, 0x8a, 0xf3, 0x16};

#define mLen351 6 

static uint8_t msg_351  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_351  [32] = {
0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96
}; 

static uint8_t s_351  [32] = {
0x49, 0x24, 0x92, 0x48, 0xdb, 0x6d, 0xb6, 0xdb, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x5a, 0x8b, 0x23, 0x0d, 0x0b, 0x2b, 0x51, 0xdc, 0xd7, 0xeb, 0xf0, 0xc9, 0xfe, 0xf7, 0xc1, 0x85
}; 

#define result___351 0

//Test vector 352:           "comment" : "extreme value for k",

static uint8_t pkx_352  [32] = { 
0x8d, 0x3c, 0x2c, 0x2c, 0x3b, 0x76, 0x5b, 0xa8, 0x28, 0x9e, 0x6a, 0xc3, 0x81, 0x25, 0x72, 0xa2, 0x5b, 0xf7, 0x5d, 0xf6, 0x2d, 0x87, 0xab, 0x73, 0x30, 0xc3, 0xbd, 0xba, 0xd9, 0xeb, 0xfa, 0x5c}; 

static uint8_t pky_352  [32] = {
0x4c, 0x68, 0x45, 0x44, 0x2d, 0x66, 0x93, 0x5b, 0x23, 0x85, 0x78, 0xd4, 0x3a, 0xec, 0x54, 0xf7, 0xca, 0xa1, 0x62, 0x1d, 0x1a, 0xf2, 0x41, 0xd4, 0x63, 0x2e, 0x0b, 0x78, 0x0c, 0x42, 0x3f, 0x5d};

#define mLen352 6 

static uint8_t msg_352  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_352  [32] = {
0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96
}; 

static uint8_t s_352  [32] = {
0x16, 0xa4, 0x50, 0x2e, 0x27, 0x81, 0xe1, 0x1a, 0xc8, 0x2c, 0xbc, 0x9d, 0x1e, 0xdd, 0x8c, 0x98, 0x15, 0x84, 0xd1, 0x3e, 0x18, 0x41, 0x1e, 0x2f, 0x6e, 0x04, 0x78, 0xc3, 0x44, 0x16, 0xe3, 0xbb
}; 

#define result___352 0

//Test vector 353:           "comment" : "testing point duplication",

static uint8_t pkx_353  [32] = { 
0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96}; 

static uint8_t pky_353  [32] = {
0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f, 0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33, 0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51, 0xf5};

#define mLen353 6 

static uint8_t msg_353  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_353  [32] = {
0xbb, 0x5a, 0x52, 0xf4, 0x2f, 0x9c, 0x92, 0x61, 0xed, 0x43, 0x61, 0xf5, 0x94, 0x22, 0xa1, 0xe3, 0x00, 0x36, 0xe7, 0xc3, 0x2b, 0x27, 0x0c, 0x88, 0x07, 0xa4, 0x19, 0xfe, 0xca, 0x60, 0x50, 0x23
}; 

static uint8_t s_353  [32] = {
0x24, 0x92, 0x49, 0x24, 0x6d, 0xb6, 0xdb, 0x6d, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xad, 0x45, 0x91, 0x86, 0x85, 0x95, 0xa8, 0xee, 0x6b, 0xf5, 0xf8, 0x64, 0xff, 0x7b, 0xe0, 0xc2
}; 

#define result___353 18446744073709551615

//Test vector 354:           "comment" : "testing point duplication",

static uint8_t pkx_354  [32] = { 
0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96}; 

static uint8_t pky_354  [32] = {
0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f, 0x9b, 0x8e, 0xe7, 0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33, 0x57, 0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf, 0x51, 0xf5};

#define mLen354 6 

static uint8_t msg_354  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_354  [32] = {
0x44, 0xa5, 0xad, 0x0a, 0xd0, 0x63, 0x6d, 0x9f, 0x12, 0xbc, 0x9e, 0x0a, 0x6b, 0xdd, 0x5e, 0x1c, 0xbc, 0xb0, 0x12, 0xea, 0x7b, 0xf0, 0x91, 0xfc, 0xec, 0x15, 0xb0, 0xc4, 0x32, 0x02, 0xd5, 0x2e
}; 

static uint8_t s_354  [32] = {
0x24, 0x92, 0x49, 0x24, 0x6d, 0xb6, 0xdb, 0x6d, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xad, 0x45, 0x91, 0x86, 0x85, 0x95, 0xa8, 0xee, 0x6b, 0xf5, 0xf8, 0x64, 0xff, 0x7b, 0xe0, 0xc2
}; 

#define result___354 18446744073709551615

//Test vector 355:           "comment" : "testing point duplication",

static uint8_t pkx_355  [32] = { 
0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96}; 

static uint8_t pky_355  [32] = {
0xb0, 0x1c, 0xbd, 0x1c, 0x01, 0xe5, 0x80, 0x65, 0x71, 0x18, 0x14, 0xb5, 0x83, 0xf0, 0x61, 0xe9, 0xd4, 0x31, 0xcc, 0xa9, 0x94, 0xce, 0xa1, 0x31, 0x34, 0x49, 0xbf, 0x97, 0xc8, 0x40, 0xae, 0x0a};

#define mLen355 6 

static uint8_t msg_355  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_355  [32] = {
0xbb, 0x5a, 0x52, 0xf4, 0x2f, 0x9c, 0x92, 0x61, 0xed, 0x43, 0x61, 0xf5, 0x94, 0x22, 0xa1, 0xe3, 0x00, 0x36, 0xe7, 0xc3, 0x2b, 0x27, 0x0c, 0x88, 0x07, 0xa4, 0x19, 0xfe, 0xca, 0x60, 0x50, 0x23
}; 

static uint8_t s_355  [32] = {
0x24, 0x92, 0x49, 0x24, 0x6d, 0xb6, 0xdb, 0x6d, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xad, 0x45, 0x91, 0x86, 0x85, 0x95, 0xa8, 0xee, 0x6b, 0xf5, 0xf8, 0x64, 0xff, 0x7b, 0xe0, 0xc2
}; 

#define result___355 18446744073709551615

//Test vector 356:           "comment" : "testing point duplication",

static uint8_t pkx_356  [32] = { 
0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc, 0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81, 0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98, 0xc2, 0x96}; 

static uint8_t pky_356  [32] = {
0xb0, 0x1c, 0xbd, 0x1c, 0x01, 0xe5, 0x80, 0x65, 0x71, 0x18, 0x14, 0xb5, 0x83, 0xf0, 0x61, 0xe9, 0xd4, 0x31, 0xcc, 0xa9, 0x94, 0xce, 0xa1, 0x31, 0x34, 0x49, 0xbf, 0x97, 0xc8, 0x40, 0xae, 0x0a};

#define mLen356 6 

static uint8_t msg_356  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_356  [32] = {
0x44, 0xa5, 0xad, 0x0a, 0xd0, 0x63, 0x6d, 0x9f, 0x12, 0xbc, 0x9e, 0x0a, 0x6b, 0xdd, 0x5e, 0x1c, 0xbc, 0xb0, 0x12, 0xea, 0x7b, 0xf0, 0x91, 0xfc, 0xec, 0x15, 0xb0, 0xc4, 0x32, 0x02, 0xd5, 0x2e
}; 

static uint8_t s_356  [32] = {
0x24, 0x92, 0x49, 0x24, 0x6d, 0xb6, 0xdb, 0x6d, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xad, 0x45, 0x91, 0x86, 0x85, 0x95, 0xa8, 0xee, 0x6b, 0xf5, 0xf8, 0x64, 0xff, 0x7b, 0xe0, 0xc2
}; 

#define result___356 18446744073709551615

//Test vector 357:           "comment" : "pseudorandom signature",

static uint8_t pkx_357  [32] = { 
0x04, 0xaa, 0xec, 0x73, 0x63, 0x57, 0x26, 0xf2, 0x13, 0xfb, 0x8a, 0x9e, 0x64, 0xda, 0x3b, 0x86, 0x32, 0xe4, 0x14, 0x95, 0xa9, 0x44, 0xd0, 0x04, 0x5b, 0x52, 0x2e, 0xba, 0x72, 0x40, 0xfa, 0xd5}; 

static uint8_t pky_357  [32] = {
0x87, 0xd9, 0x31, 0x57, 0x98, 0xaa, 0xa3, 0xa5, 0xba, 0x01, 0x77, 0x57, 0x87, 0xce, 0xd0, 0x5e, 0xaa, 0xf7, 0xb4, 0xe0, 0x9f, 0xc8, 0x1d, 0x6d, 0x1a, 0xa5, 0x46, 0xe8, 0x36, 0x5d, 0x52, 0x5d};

#define mLen357 0 

static uint8_t msg_357  [0] = {

}; 

static uint8_t r_357  [32] = {
0xb2, 0x92, 0xa6, 0x19, 0x33, 0x9f, 0x6e, 0x56, 0x7a, 0x30, 0x5c, 0x95, 0x1c, 0x0d, 0xcb, 0xcc, 0x42, 0xd1, 0x6e, 0x47, 0xf2, 0x19, 0xf9, 0xe9, 0x8e, 0x76, 0xe0, 0x9d, 0x87, 0x70, 0xb3, 0x4a
}; 

static uint8_t s_357  [32] = {
0x01, 0x77, 0xe6, 0x04, 0x92, 0xc5, 0xa8, 0x24, 0x2f, 0x76, 0xf0, 0x7b, 0xfe, 0x36, 0x61, 0xbd, 0xe5, 0x9e, 0xc2, 0xa1, 0x7c, 0xe5, 0xbd, 0x2d, 0xab, 0x2a, 0xbe, 0xbd, 0xf8, 0x9a, 0x62, 0xe2
}; 

#define result___357 0

//Test vector 358:           "comment" : "pseudorandom signature",

static uint8_t pkx_358  [32] = { 
0x04, 0xaa, 0xec, 0x73, 0x63, 0x57, 0x26, 0xf2, 0x13, 0xfb, 0x8a, 0x9e, 0x64, 0xda, 0x3b, 0x86, 0x32, 0xe4, 0x14, 0x95, 0xa9, 0x44, 0xd0, 0x04, 0x5b, 0x52, 0x2e, 0xba, 0x72, 0x40, 0xfa, 0xd5}; 

static uint8_t pky_358  [32] = {
0x87, 0xd9, 0x31, 0x57, 0x98, 0xaa, 0xa3, 0xa5, 0xba, 0x01, 0x77, 0x57, 0x87, 0xce, 0xd0, 0x5e, 0xaa, 0xf7, 0xb4, 0xe0, 0x9f, 0xc8, 0x1d, 0x6d, 0x1a, 0xa5, 0x46, 0xe8, 0x36, 0x5d, 0x52, 0x5d};

#define mLen358 3 

static uint8_t msg_358  [3] = {
0x4d, 0x73, 0x67
}; 

static uint8_t r_358  [32] = {
0x53, 0x0b, 0xd6, 0xb0, 0xc9, 0xaf, 0x2d, 0x69, 0xba, 0x89, 0x7f, 0x6b, 0x5f, 0xb5, 0x96, 0x95, 0xcf, 0xbf, 0x33, 0xaf, 0xe6, 0x6d, 0xba, 0xdc, 0xf5, 0xb8, 0xd2, 0xa2, 0xa6, 0x53, 0x8e, 0x23
}; 

static uint8_t s_358  [32] = {
0xd8, 0x5e, 0x48, 0x9c, 0xb7, 0xa1, 0x61, 0xfd, 0x55, 0xed, 0xed, 0xce, 0xdb, 0xf4, 0xcc, 0x0c, 0x09, 0x87, 0xe3, 0xe3, 0xf0, 0xf2, 0x42, 0xca, 0xe9, 0x34, 0xc7, 0x2c, 0xaa, 0x3f, 0x43, 0xe9
}; 

#define result___358 0

//Test vector 359:           "comment" : "pseudorandom signature",

static uint8_t pkx_359  [32] = { 
0x04, 0xaa, 0xec, 0x73, 0x63, 0x57, 0x26, 0xf2, 0x13, 0xfb, 0x8a, 0x9e, 0x64, 0xda, 0x3b, 0x86, 0x32, 0xe4, 0x14, 0x95, 0xa9, 0x44, 0xd0, 0x04, 0x5b, 0x52, 0x2e, 0xba, 0x72, 0x40, 0xfa, 0xd5}; 

static uint8_t pky_359  [32] = {
0x87, 0xd9, 0x31, 0x57, 0x98, 0xaa, 0xa3, 0xa5, 0xba, 0x01, 0x77, 0x57, 0x87, 0xce, 0xd0, 0x5e, 0xaa, 0xf7, 0xb4, 0xe0, 0x9f, 0xc8, 0x1d, 0x6d, 0x1a, 0xa5, 0x46, 0xe8, 0x36, 0x5d, 0x52, 0x5d};

#define mLen359 6 

static uint8_t msg_359  [6] = {
0x31, 0x32, 0x33, 0x34, 0x30, 0x30
}; 

static uint8_t r_359  [32] = {
0xa8, 0xea, 0x15, 0x0c, 0xb8, 0x01, 0x25, 0xd7, 0x38, 0x1c, 0x4c, 0x1f, 0x1d, 0xa8, 0xe9, 0xde, 0x27, 0x11, 0xf9, 0x91, 0x70, 0x60, 0x40, 0x6a, 0x73, 0xd7, 0x90, 0x45, 0x19, 0xe5, 0x13, 0x88
}; 

static uint8_t s_359  [32] = {
0xf3, 0xab, 0x9f, 0xa6, 0x8b, 0xd4, 0x79, 0x73, 0xa7, 0x3b, 0x2d, 0x40, 0x48, 0x0c, 0x2b, 0xa5, 0x0c, 0x22, 0xc9, 0xd7, 0x6e, 0xc2, 0x17, 0x25, 0x72, 0x88, 0x29, 0x32, 0x85, 0x44, 0x9b, 0x86
}; 

#define result___359 0

//Test vector 360:           "comment" : "pseudorandom signature",

static uint8_t pkx_360  [32] = { 
0x04, 0xaa, 0xec, 0x73, 0x63, 0x57, 0x26, 0xf2, 0x13, 0xfb, 0x8a, 0x9e, 0x64, 0xda, 0x3b, 0x86, 0x32, 0xe4, 0x14, 0x95, 0xa9, 0x44, 0xd0, 0x04, 0x5b, 0x52, 0x2e, 0xba, 0x72, 0x40, 0xfa, 0xd5}; 

static uint8_t pky_360  [32] = {
0x87, 0xd9, 0x31, 0x57, 0x98, 0xaa, 0xa3, 0xa5, 0xba, 0x01, 0x77, 0x57, 0x87, 0xce, 0xd0, 0x5e, 0xaa, 0xf7, 0xb4, 0xe0, 0x9f, 0xc8, 0x1d, 0x6d, 0x1a, 0xa5, 0x46, 0xe8, 0x36, 0x5d, 0x52, 0x5d};

#define mLen360 20 

static uint8_t msg_360  [20] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
}; 

static uint8_t r_360  [32] = {
0x98, 0x6e, 0x65, 0x93, 0x3e, 0xf2, 0xed, 0x4e, 0xe5, 0xaa, 0xda, 0x13, 0x9f, 0x52, 0xb7, 0x05, 0x39, 0xaa, 0xf6, 0x3f, 0x00, 0xa9, 0x1f, 0x29, 0xc6, 0x91, 0x78, 0x49, 0x0d, 0x57, 0xfb, 0x71
}; 

static uint8_t s_360  [32] = {
0x3d, 0xaf, 0xed, 0xfb, 0x8d, 0xa6, 0x18, 0x9d, 0x37, 0x23, 0x08, 0xcb, 0xf1, 0x48, 0x9b, 0xbb, 0xda, 0xbf, 0x0c, 0x02, 0x17, 0xd1, 0xc0, 0xff, 0x0f, 0x70, 0x1a, 0xaa, 0x7a, 0x69, 0x4b, 0x9c
}; 

#define result___360 0

//Test vector 361:           "comment" : "x-coordinate of the public key has many trailing 0's",

static uint8_t pkx_361  [32] = { 
0x4f, 0x33, 0x7c, 0xcf, 0xd6, 0x77, 0x26, 0xa8, 0x05, 0xe4, 0xf1, 0x60, 0x0a, 0xe2, 0x84, 0x9d, 0xf3, 0x80, 0x7e, 0xca, 0x11, 0x73, 0x80, 0x23, 0x9f, 0xbd, 0x81, 0x69, 0x00, 0x00, 0x00, 0x00}; 

static uint8_t pky_361  [32] = {
0xed, 0x9d, 0xea, 0x12, 0x4c, 0xc8, 0xc3, 0x96, 0x41, 0x64, 0x11, 0xe9, 0x88, 0xc3, 0x0f, 0x42, 0x7e, 0xb5, 0x04, 0xaf, 0x43, 0xa3, 0x14, 0x6c, 0xd5, 0xdf, 0x7e, 0xa6, 0x06, 0x66, 0xd6, 0x85};

#define mLen361 7 

static uint8_t msg_361  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_361  [32] = {
0xd4, 0x34, 0xe2, 0x62, 0xa4, 0x9e, 0xab, 0x77, 0x81, 0xe3, 0x53, 0xa3, 0x56, 0x5e, 0x48, 0x25, 0x50, 0xdd, 0x0f, 0xd5, 0xde, 0xfa, 0x01, 0x3c, 0x7f, 0x29, 0x74, 0x5e, 0xff, 0x35, 0x69, 0xf1
}; 

static uint8_t s_361  [32] = {
0x9b, 0x0c, 0x0a, 0x93, 0xf2, 0x67, 0xfb, 0x60, 0x52, 0xfd, 0x80, 0x77, 0xbe, 0x76, 0x9c, 0x2b, 0x98, 0x95, 0x31, 0x95, 0xd7, 0xbc, 0x10, 0xde, 0x84, 0x42, 0x18, 0x30, 0x5c, 0x6b, 0xa1, 0x7a
}; 

#define result___361 0

//Test vector 362:           "comment" : "x-coordinate of the public key has many trailing 0's",

static uint8_t pkx_362  [32] = { 
0x4f, 0x33, 0x7c, 0xcf, 0xd6, 0x77, 0x26, 0xa8, 0x05, 0xe4, 0xf1, 0x60, 0x0a, 0xe2, 0x84, 0x9d, 0xf3, 0x80, 0x7e, 0xca, 0x11, 0x73, 0x80, 0x23, 0x9f, 0xbd, 0x81, 0x69, 0x00, 0x00, 0x00, 0x00}; 

static uint8_t pky_362  [32] = {
0xed, 0x9d, 0xea, 0x12, 0x4c, 0xc8, 0xc3, 0x96, 0x41, 0x64, 0x11, 0xe9, 0x88, 0xc3, 0x0f, 0x42, 0x7e, 0xb5, 0x04, 0xaf, 0x43, 0xa3, 0x14, 0x6c, 0xd5, 0xdf, 0x7e, 0xa6, 0x06, 0x66, 0xd6, 0x85};

#define mLen362 7 

static uint8_t msg_362  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_362  [32] = {
0x0f, 0xe7, 0x74, 0x35, 0x5c, 0x04, 0xd0, 0x60, 0xf7, 0x6d, 0x79, 0xfd, 0x7a, 0x77, 0x2e, 0x42, 0x14, 0x63, 0x48, 0x92, 0x21, 0xbf, 0x0a, 0x33, 0xad, 0xd0, 0xbe, 0x9b, 0x19, 0x79, 0x11, 0x0b
}; 

static uint8_t s_362  [32] = {
0x50, 0x0d, 0xcb, 0xa1, 0xc6, 0x9a, 0x8f, 0xbd, 0x43, 0xfa, 0x4f, 0x57, 0xf7, 0x43, 0xce, 0x12, 0x4c, 0xa8, 0xb9, 0x1a, 0x1f, 0x32, 0x5f, 0x3f, 0xac, 0x61, 0x81, 0x17, 0x5d, 0xf5, 0x57, 0x37
}; 

#define result___362 0

//Test vector 363:           "comment" : "x-coordinate of the public key has many trailing 0's",

static uint8_t pkx_363  [32] = { 
0x4f, 0x33, 0x7c, 0xcf, 0xd6, 0x77, 0x26, 0xa8, 0x05, 0xe4, 0xf1, 0x60, 0x0a, 0xe2, 0x84, 0x9d, 0xf3, 0x80, 0x7e, 0xca, 0x11, 0x73, 0x80, 0x23, 0x9f, 0xbd, 0x81, 0x69, 0x00, 0x00, 0x00, 0x00}; 

static uint8_t pky_363  [32] = {
0xed, 0x9d, 0xea, 0x12, 0x4c, 0xc8, 0xc3, 0x96, 0x41, 0x64, 0x11, 0xe9, 0x88, 0xc3, 0x0f, 0x42, 0x7e, 0xb5, 0x04, 0xaf, 0x43, 0xa3, 0x14, 0x6c, 0xd5, 0xdf, 0x7e, 0xa6, 0x06, 0x66, 0xd6, 0x85};

#define mLen363 7 

static uint8_t msg_363  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_363  [32] = {
0xbb, 0x40, 0xbf, 0x21, 0x7b, 0xed, 0x3f, 0xb3, 0x95, 0x0c, 0x7d, 0x39, 0xf0, 0x3d, 0x36, 0xdc, 0x8e, 0x3b, 0x2c, 0xd7, 0x96, 0x93, 0xf1, 0x25, 0xbf, 0xd0, 0x65, 0x95, 0xee, 0x11, 0x35, 0xe3
}; 

static uint8_t s_363  [32] = {
0x54, 0x1b, 0xf3, 0x53, 0x23, 0x51, 0xeb, 0xb0, 0x32, 0x71, 0x0b, 0xdb, 0x6a, 0x1b, 0xf1, 0xbf, 0xc8, 0x9a, 0x1e, 0x29, 0x1a, 0xc6, 0x92, 0xb3, 0xfa, 0x47, 0x80, 0x74, 0x5b, 0xb5, 0x56, 0x77
}; 

#define result___363 0

//Test vector 364:           "comment" : "y-coordinate of the public key has many trailing 0's",

static uint8_t pkx_364  [32] = { 
0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4, 0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff, 0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35}; 

static uint8_t pky_364  [32] = {
0x84, 0xfa, 0x17, 0x4d, 0x79, 0x1c, 0x72, 0xbf, 0x2c, 0xe3, 0x88, 0x0a, 0x89, 0x60, 0xdd, 0x2a, 0x7c, 0x7a, 0x13, 0x38, 0xa8, 0x2f, 0x85, 0xa9, 0xe5, 0x9c, 0xdb, 0xde, 0x80, 0x00, 0x00, 0x00};

#define mLen364 7 

static uint8_t msg_364  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_364  [32] = {
0x66, 0x4e, 0xb7, 0xee, 0x6d, 0xb8, 0x4a, 0x34, 0xdf, 0x3c, 0x86, 0xea, 0x31, 0x38, 0x9a, 0x54, 0x05, 0xba, 0xdd, 0x5c, 0xa9, 0x92, 0x31, 0xff, 0x55, 0x6d, 0x3e, 0x75, 0xa2, 0x33, 0xe7, 0x3a
}; 

static uint8_t s_364  [32] = {
0x59, 0xf3, 0xc7, 0x52, 0xe5, 0x2e, 0xca, 0x46, 0x13, 0x76, 0x42, 0x49, 0x0a, 0x51, 0x56, 0x0c, 0xe0, 0xba, 0xdc, 0x67, 0x87, 0x54, 0xb8, 0xf7, 0x2e, 0x51, 0xa2, 0x90, 0x14, 0x26, 0xa1, 0xbd
}; 

#define result___364 0

//Test vector 365:           "comment" : "y-coordinate of the public key has many trailing 0's",

static uint8_t pkx_365  [32] = { 
0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4, 0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff, 0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35}; 

static uint8_t pky_365  [32] = {
0x84, 0xfa, 0x17, 0x4d, 0x79, 0x1c, 0x72, 0xbf, 0x2c, 0xe3, 0x88, 0x0a, 0x89, 0x60, 0xdd, 0x2a, 0x7c, 0x7a, 0x13, 0x38, 0xa8, 0x2f, 0x85, 0xa9, 0xe5, 0x9c, 0xdb, 0xde, 0x80, 0x00, 0x00, 0x00};

#define mLen365 7 

static uint8_t msg_365  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_365  [32] = {
0x4c, 0xd0, 0x42, 0x9b, 0xba, 0xbd, 0x28, 0x27, 0x00, 0x9d, 0x6f, 0xcd, 0x84, 0x3d, 0x4c, 0xe3, 0x9c, 0x3e, 0x42, 0xe2, 0xd1, 0x63, 0x1f, 0xd0, 0x01, 0x98, 0x5a, 0x79, 0xd1, 0xfd, 0x8b, 0x43
}; 

static uint8_t s_365  [32] = {
0x96, 0x38, 0xbf, 0x12, 0xdd, 0x68, 0x2f, 0x60, 0xbe, 0x7e, 0xf1, 0xd0, 0xe0, 0xd9, 0x8f, 0x08, 0xb7, 0xbc, 0xa7, 0x7a, 0x1a, 0x2b, 0x86, 0x9a, 0xe4, 0x66, 0x18, 0x9d, 0x2a, 0xcd, 0xab, 0xe3
}; 

#define result___365 0

//Test vector 366:           "comment" : "y-coordinate of the public key has many trailing 0's",

static uint8_t pkx_366  [32] = { 
0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4, 0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff, 0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35}; 

static uint8_t pky_366  [32] = {
0x84, 0xfa, 0x17, 0x4d, 0x79, 0x1c, 0x72, 0xbf, 0x2c, 0xe3, 0x88, 0x0a, 0x89, 0x60, 0xdd, 0x2a, 0x7c, 0x7a, 0x13, 0x38, 0xa8, 0x2f, 0x85, 0xa9, 0xe5, 0x9c, 0xdb, 0xde, 0x80, 0x00, 0x00, 0x00};

#define mLen366 7 

static uint8_t msg_366  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_366  [32] = {
0xe5, 0x6c, 0x6e, 0xa2, 0xd1, 0xb0, 0x17, 0x09, 0x1c, 0x44, 0xd8, 0xb6, 0xcb, 0x62, 0xb9, 0xf4, 0x60, 0xe3, 0xce, 0x9a, 0xed, 0x5e, 0x5f, 0xd4, 0x1e, 0x8a, 0xdd, 0xed, 0x97, 0xc5, 0x6c, 0x04
}; 

static uint8_t s_366  [32] = {
0xa3, 0x08, 0xec, 0x31, 0xf2, 0x81, 0xe9, 0x55, 0xbe, 0x20, 0xb4, 0x57, 0xe4, 0x63, 0x44, 0x0b, 0x4f, 0xcf, 0x2b, 0x80, 0x25, 0x80, 0x78, 0x20, 0x7f, 0xc1, 0x37, 0x81, 0x80, 0xf8, 0x9b, 0x55
}; 

#define result___366 0

//Test vector 367:           "comment" : "y-coordinate of the public key has many trailing 1's",

static uint8_t pkx_367  [32] = { 
0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4, 0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff, 0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35}; 

static uint8_t pky_367  [32] = {
0x7b, 0x05, 0xe8, 0xb1, 0x86, 0xe3, 0x8d, 0x41, 0xd3, 0x1c, 0x77, 0xf5, 0x76, 0x9f, 0x22, 0xd5, 0x83, 0x85, 0xec, 0xc8, 0x57, 0xd0, 0x7a, 0x56, 0x1a, 0x63, 0x24, 0x21, 0x7f, 0xff, 0xff, 0xff};

#define mLen367 7 

static uint8_t msg_367  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_367  [32] = {
0x11, 0x58, 0xa0, 0x8d, 0x29, 0x15, 0x00, 0xb4, 0xca, 0xbe, 0xd3, 0x34, 0x6d, 0x89, 0x1e, 0xee, 0x57, 0xc1, 0x76, 0x35, 0x6a, 0x26, 0x24, 0xfb, 0x01, 0x1f, 0x8f, 0xbb, 0xf3, 0x46, 0x68, 0x30
}; 

static uint8_t s_367  [32] = {
0x22, 0x8a, 0x8c, 0x48, 0x6a, 0x73, 0x60, 0x06, 0xe0, 0x82, 0x32, 0x5b, 0x85, 0x29, 0x0c, 0x5b, 0xc9, 0x1f, 0x37, 0x8b, 0x75, 0xd4, 0x87, 0xdd, 0xa4, 0x67, 0x98, 0xc1, 0x8f, 0x28, 0x55, 0x19
}; 

#define result___367 0

//Test vector 368:           "comment" : "y-coordinate of the public key has many trailing 1's",

static uint8_t pkx_368  [32] = { 
0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4, 0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff, 0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35}; 

static uint8_t pky_368  [32] = {
0x7b, 0x05, 0xe8, 0xb1, 0x86, 0xe3, 0x8d, 0x41, 0xd3, 0x1c, 0x77, 0xf5, 0x76, 0x9f, 0x22, 0xd5, 0x83, 0x85, 0xec, 0xc8, 0x57, 0xd0, 0x7a, 0x56, 0x1a, 0x63, 0x24, 0x21, 0x7f, 0xff, 0xff, 0xff};

#define mLen368 7 

static uint8_t msg_368  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_368  [32] = {
0xb1, 0xdb, 0x92, 0x89, 0x64, 0x9f, 0x59, 0x41, 0x0e, 0xa3, 0x6b, 0x0c, 0x0f, 0xc8, 0xd6, 0xaa, 0x26, 0x87, 0xb2, 0x91, 0x76, 0x93, 0x9d, 0xd2, 0x3e, 0x0d, 0xde, 0x56, 0xd3, 0x09, 0xfa, 0x9d
}; 

static uint8_t s_368  [32] = {
0x3e, 0x15, 0x35, 0xe4, 0x28, 0x05, 0x59, 0x01, 0x5b, 0x0d, 0xbd, 0x98, 0x73, 0x66, 0xdc, 0xf4, 0x3a, 0x6d, 0x1a, 0xf5, 0xc2, 0x3c, 0x7d, 0x58, 0x4e, 0x1c, 0x3f, 0x48, 0xa1, 0x25, 0x13, 0x36
}; 

#define result___368 0

//Test vector 369:           "comment" : "y-coordinate of the public key has many trailing 1's",

static uint8_t pkx_369  [32] = { 
0x3c, 0xf0, 0x3d, 0x61, 0x4d, 0x89, 0x39, 0xcf, 0xd4, 0x99, 0xa0, 0x78, 0x73, 0xfa, 0xc2, 0x81, 0x61, 0x8f, 0x06, 0xb8, 0xff, 0x87, 0xe8, 0x01, 0x5c, 0x3f, 0x49, 0x72, 0x65, 0x00, 0x49, 0x35}; 

static uint8_t pky_369  [32] = {
0x7b, 0x05, 0xe8, 0xb1, 0x86, 0xe3, 0x8d, 0x41, 0xd3, 0x1c, 0x77, 0xf5, 0x76, 0x9f, 0x22, 0xd5, 0x83, 0x85, 0xec, 0xc8, 0x57, 0xd0, 0x7a, 0x56, 0x1a, 0x63, 0x24, 0x21, 0x7f, 0xff, 0xff, 0xff};

#define mLen369 7 

static uint8_t msg_369  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_369  [32] = {
0xb7, 0xb1, 0x6e, 0x76, 0x22, 0x86, 0xcb, 0x96, 0x44, 0x6a, 0xa8, 0xd4, 0xe6, 0xe7, 0x57, 0x8b, 0x0a, 0x34, 0x1a, 0x79, 0xf2, 0xdd, 0x1a, 0x22, 0x0a, 0xc6, 0xf0, 0xca, 0x4e, 0x24, 0xed, 0x86
}; 

static uint8_t s_369  [32] = {
0xdd, 0xc6, 0x0a, 0x70, 0x0a, 0x13, 0x9b, 0x04, 0x66, 0x1c, 0x54, 0x7d, 0x07, 0xbb, 0xb0, 0x72, 0x17, 0x80, 0x14, 0x6d, 0xf7, 0x99, 0xcc, 0xf5, 0x5e, 0x55, 0x23, 0x4e, 0xcb, 0x8f, 0x12, 0xbc
}; 

#define result___369 0

//Test vector 370:           "comment" : "x-coordinate of the public key has many trailing 1's",

static uint8_t pkx_370  [32] = { 
0x28, 0x29, 0xc3, 0x1f, 0xaa, 0x2e, 0x40, 0x0e, 0x34, 0x4e, 0xd9, 0x4b, 0xca, 0x3f, 0xcd, 0x05, 0x45, 0x95, 0x6e, 0xbc, 0xfe, 0x8a, 0xd0, 0xf6, 0xdf, 0xa5, 0xff, 0x8e, 0xff, 0xff, 0xff, 0xff}; 

static uint8_t pky_370  [32] = {
0xa0, 0x1a, 0xaf, 0xaf, 0x00, 0x0e, 0x52, 0x58, 0x58, 0x55, 0xaf, 0xa7, 0x67, 0x6a, 0xde, 0x28, 0x41, 0x13, 0x09, 0x90, 0x52, 0xdf, 0x57, 0xe7, 0xeb, 0x3b, 0xd3, 0x7e, 0xbe, 0xb9, 0x22, 0x2e};

#define mLen370 7 

static uint8_t msg_370  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_370  [32] = {
0xd8, 0x2a, 0x7c, 0x27, 0x17, 0x26, 0x11, 0x87, 0xc8, 0xe0, 0x0d, 0x8d, 0xf9, 0x63, 0xff, 0x35, 0xd7, 0x96, 0xed, 0xad, 0x36, 0xbc, 0x6e, 0x6b, 0xd1, 0xc9, 0x1c, 0x67, 0x0d, 0x91, 0x05, 0xb4
}; 

static uint8_t s_370  [32] = {
0x3d, 0xca, 0xbd, 0xda, 0xf8, 0xfc, 0xaa, 0x61, 0xf4, 0x60, 0x3e, 0x7c, 0xba, 0xc0, 0xf3, 0xc0, 0x35, 0x1e, 0xcd, 0x59, 0x88, 0xef, 0xb2, 0x3f, 0x68, 0x0d, 0x07, 0xde, 0xbd, 0x13, 0x99, 0x29
}; 

#define result___370 0

//Test vector 371:           "comment" : "x-coordinate of the public key has many trailing 1's",

static uint8_t pkx_371  [32] = { 
0x28, 0x29, 0xc3, 0x1f, 0xaa, 0x2e, 0x40, 0x0e, 0x34, 0x4e, 0xd9, 0x4b, 0xca, 0x3f, 0xcd, 0x05, 0x45, 0x95, 0x6e, 0xbc, 0xfe, 0x8a, 0xd0, 0xf6, 0xdf, 0xa5, 0xff, 0x8e, 0xff, 0xff, 0xff, 0xff}; 

static uint8_t pky_371  [32] = {
0xa0, 0x1a, 0xaf, 0xaf, 0x00, 0x0e, 0x52, 0x58, 0x58, 0x55, 0xaf, 0xa7, 0x67, 0x6a, 0xde, 0x28, 0x41, 0x13, 0x09, 0x90, 0x52, 0xdf, 0x57, 0xe7, 0xeb, 0x3b, 0xd3, 0x7e, 0xbe, 0xb9, 0x22, 0x2e};

#define mLen371 7 

static uint8_t msg_371  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_371  [32] = {
0x5e, 0xb9, 0xc8, 0x84, 0x5d, 0xe6, 0x8e, 0xb1, 0x3d, 0x5b, 0xef, 0xe7, 0x19, 0xf4, 0x62, 0xd7, 0x77, 0x87, 0x80, 0x2b, 0xaf, 0xf3, 0x0c, 0xe9, 0x6a, 0x5c, 0xba, 0x06, 0x32, 0x54, 0xaf, 0x78
}; 

static uint8_t s_371  [32] = {
0x2c, 0x02, 0x6a, 0xe9, 0xbe, 0x2e, 0x2a, 0x5e, 0x7c, 0xa0, 0xff, 0x9b, 0xbd, 0x92, 0xfb, 0x6e, 0x44, 0x97, 0x21, 0x86, 0x22, 0x8e, 0xe9, 0xa6, 0x2b, 0x87, 0xdd, 0xbe, 0x2e, 0xf6, 0x6f, 0xb5
}; 

#define result___371 0

//Test vector 372:           "comment" : "x-coordinate of the public key has many trailing 1's",

static uint8_t pkx_372  [32] = { 
0x28, 0x29, 0xc3, 0x1f, 0xaa, 0x2e, 0x40, 0x0e, 0x34, 0x4e, 0xd9, 0x4b, 0xca, 0x3f, 0xcd, 0x05, 0x45, 0x95, 0x6e, 0xbc, 0xfe, 0x8a, 0xd0, 0xf6, 0xdf, 0xa5, 0xff, 0x8e, 0xff, 0xff, 0xff, 0xff}; 

static uint8_t pky_372  [32] = {
0xa0, 0x1a, 0xaf, 0xaf, 0x00, 0x0e, 0x52, 0x58, 0x58, 0x55, 0xaf, 0xa7, 0x67, 0x6a, 0xde, 0x28, 0x41, 0x13, 0x09, 0x90, 0x52, 0xdf, 0x57, 0xe7, 0xeb, 0x3b, 0xd3, 0x7e, 0xbe, 0xb9, 0x22, 0x2e};

#define mLen372 7 

static uint8_t msg_372  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_372  [32] = {
0x96, 0x84, 0x3d, 0xd0, 0x3c, 0x22, 0xab, 0xd2, 0xf3, 0xb7, 0x82, 0xb1, 0x70, 0x23, 0x9f, 0x90, 0xf2, 0x77, 0x92, 0x1b, 0xec, 0xc1, 0x17, 0xd0, 0x40, 0x4a, 0x8e, 0x4e, 0x36, 0x23, 0x0c, 0x28
}; 

static uint8_t s_372  [32] = {
0xf2, 0xbe, 0x37, 0x8f, 0x52, 0x6f, 0x74, 0xa5, 0x43, 0xf6, 0x71, 0x65, 0x97, 0x6d, 0xe9, 0xed, 0x9a, 0x31, 0x21, 0x4e, 0xb4, 0xd7, 0xe6, 0xdb, 0x19, 0xe1, 0xed, 0xe1, 0x23, 0xdd, 0x99, 0x1d
}; 

#define result___372 0

//Test vector 373:           "comment" : "x-coordinate of the public key is large",

static uint8_t pkx_373  [32] = { 
0xff, 0xff, 0xff, 0xf9, 0x48, 0x08, 0x1e, 0x6a, 0x04, 0x58, 0xdd, 0x8f, 0x9e, 0x73, 0x8f, 0x26, 0x65, 0xff, 0x90, 0x59, 0xad, 0x6a, 0xac, 0x07, 0x08, 0x31, 0x8c, 0x4c, 0xa9, 0xa7, 0xa4, 0xf5}; 

static uint8_t pky_373  [32] = {
0x5a, 0x8a, 0xbc, 0xba, 0x2d, 0xda, 0x84, 0x74, 0x31, 0x1e, 0xe5, 0x41, 0x49, 0xb9, 0x73, 0xca, 0xe0, 0xc0, 0xfb, 0x89, 0x55, 0x7a, 0xd0, 0xbf, 0x78, 0xe6, 0x52, 0x9a, 0x16, 0x63, 0xbd, 0x73};

#define mLen373 7 

static uint8_t msg_373  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_373  [32] = {
0x76, 0x64, 0x56, 0xdc, 0xe1, 0x85, 0x7c, 0x90, 0x6f, 0x99, 0x96, 0xaf, 0x72, 0x93, 0x39, 0x46, 0x4d, 0x27, 0xe9, 0xd9, 0x8e, 0xdc, 0x2d, 0x0e, 0x3b, 0x76, 0x02, 0x97, 0x06, 0x74, 0x21, 0xf6
}; 

static uint8_t s_373  [32] = {
0x40, 0x23, 0x85, 0xec, 0xad, 0xae, 0x0d, 0x80, 0x81, 0xdc, 0xca, 0xf5, 0xd1, 0x90, 0x37, 0xec, 0x4e, 0x55, 0x37, 0x6e, 0xce, 0xd6, 0x99, 0xe9, 0x36, 0x46, 0xbf, 0xbb, 0xf1, 0x9d, 0x0b, 0x41
}; 

#define result___373 0

//Test vector 374:           "comment" : "x-coordinate of the public key is large",

static uint8_t pkx_374  [32] = { 
0xff, 0xff, 0xff, 0xf9, 0x48, 0x08, 0x1e, 0x6a, 0x04, 0x58, 0xdd, 0x8f, 0x9e, 0x73, 0x8f, 0x26, 0x65, 0xff, 0x90, 0x59, 0xad, 0x6a, 0xac, 0x07, 0x08, 0x31, 0x8c, 0x4c, 0xa9, 0xa7, 0xa4, 0xf5}; 

static uint8_t pky_374  [32] = {
0x5a, 0x8a, 0xbc, 0xba, 0x2d, 0xda, 0x84, 0x74, 0x31, 0x1e, 0xe5, 0x41, 0x49, 0xb9, 0x73, 0xca, 0xe0, 0xc0, 0xfb, 0x89, 0x55, 0x7a, 0xd0, 0xbf, 0x78, 0xe6, 0x52, 0x9a, 0x16, 0x63, 0xbd, 0x73};

#define mLen374 7 

static uint8_t msg_374  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_374  [32] = {
0xc6, 0x05, 0xc4, 0xb2, 0xed, 0xea, 0xb2, 0x04, 0x19, 0xe6, 0x51, 0x8a, 0x11, 0xb2, 0xdb, 0xc2, 0xb9, 0x7e, 0xd8, 0xb0, 0x7c, 0xce, 0xd0, 0xb1, 0x9c, 0x34, 0xf7, 0x77, 0xde, 0x7b, 0x9f, 0xd9
}; 

static uint8_t s_374  [32] = {
0xed, 0xf0, 0xf6, 0x12, 0xc5, 0xf4, 0x6e, 0x03, 0xc7, 0x19, 0x64, 0x7b, 0xc8, 0xaf, 0x1b, 0x29, 0xb2, 0xcd, 0xe2, 0xed, 0xa7, 0x00, 0xfb, 0x1c, 0xff, 0x5e, 0x15, 0x9d, 0x47, 0x32, 0x6d, 0xba
}; 

#define result___374 0

//Test vector 375:           "comment" : "x-coordinate of the public key is large",

static uint8_t pkx_375  [32] = { 
0xff, 0xff, 0xff, 0xf9, 0x48, 0x08, 0x1e, 0x6a, 0x04, 0x58, 0xdd, 0x8f, 0x9e, 0x73, 0x8f, 0x26, 0x65, 0xff, 0x90, 0x59, 0xad, 0x6a, 0xac, 0x07, 0x08, 0x31, 0x8c, 0x4c, 0xa9, 0xa7, 0xa4, 0xf5}; 

static uint8_t pky_375  [32] = {
0x5a, 0x8a, 0xbc, 0xba, 0x2d, 0xda, 0x84, 0x74, 0x31, 0x1e, 0xe5, 0x41, 0x49, 0xb9, 0x73, 0xca, 0xe0, 0xc0, 0xfb, 0x89, 0x55, 0x7a, 0xd0, 0xbf, 0x78, 0xe6, 0x52, 0x9a, 0x16, 0x63, 0xbd, 0x73};

#define mLen375 7 

static uint8_t msg_375  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_375  [32] = {
0xd4, 0x8b, 0x68, 0xe6, 0xca, 0xbf, 0xe0, 0x3c, 0xf6, 0x14, 0x1c, 0x9a, 0xc5, 0x41, 0x41, 0xf2, 0x10, 0xe6, 0x44, 0x85, 0xd9, 0x92, 0x9a, 0xd7, 0xb7, 0x32, 0xbf, 0xe3, 0xb7, 0xeb, 0x8a, 0x84
}; 

static uint8_t s_375  [32] = {
0xfe, 0xed, 0xae, 0x50, 0xc6, 0x1b, 0xd0, 0x0e, 0x19, 0xdc, 0x26, 0xf9, 0xb7, 0xe2, 0x26, 0x5e, 0x45, 0x08, 0xc3, 0x89, 0x10, 0x9a, 0xd2, 0xf2, 0x08, 0xf0, 0x77, 0x23, 0x15, 0xb6, 0xc9, 0x41
}; 

#define result___375 0

//Test vector 376:           "comment" : "x-coordinate of the public key is small",

static uint8_t pkx_376  [32] = { 
	0x0, 0x0, 0x0, 
	0x03, 0xfa, 0x15, 0xf9, 0x63, 0x94, 0x9d, 0x5f, 
	0x03, 0xa6, 0xf5, 0xc7, 0xf8, 0x6f, 0x9e, 0x00, 
	0x15, 0xee, 0xb2, 0x3a, 0xeb, 0xbf, 0xf1, 0x17, 
	0x39, 0x37, 0xba, 0x74, 0x8e
};

static uint8_t pky_376 [32] = {
	0x10, 0x99, 0x87, 0x20, 0x70, 0xe8, 0xe8, 0x7c, 
	0x55, 0x5f, 0xa1, 0x36, 0x59, 0xcc, 0xa5, 0xd7, 
	0xfa, 0xdc, 0xfc, 0xb0, 0x02, 0x3e, 0xa8, 0x89, 
	0x54, 0x8c, 0xa4, 0x8a, 0xf2, 0xba, 0x7e, 0x71
};

#define mLen376 7 

static uint8_t msg_376  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_376  [32] = {
0xb7, 0xc8, 0x14, 0x57, 0xd4, 0xae, 0xb6, 0xaa, 0x65, 0x95, 0x70, 0x98, 0x56, 0x9f, 0x04, 0x79, 0x71, 0x0a, 0xd7, 0xf6, 0x59, 0x5d, 0x58, 0x74, 0xc3, 0x5a, 0x93, 0xd1, 0x2a, 0x5d, 0xd4, 0xc7
}; 

static uint8_t s_376  [32] = {
0xb7, 0x96, 0x1a, 0x0b, 0x65, 0x28, 0x78, 0xc2, 0xd5, 0x68, 0x06, 0x9a, 0x43, 0x2c, 0xa1, 0x8a, 0x1a, 0x91, 0x99, 0xf2, 0xca, 0x57, 0x4d, 0xad, 0x4b, 0x9e, 0x3a, 0x05, 0xc0, 0xa1, 0xcd, 0xb3
}; 

#define result___376 0

//Test vector 377:           "comment" : "x-coordinate of the public key is small",

static uint8_t pkx_377  [32] = { 
	0x0, 0x0, 0x0, 
	0x03, 0xfa, 0x15, 0xf9, 0x63, 0x94, 0x9d, 0x5f, 
	0x03, 0xa6, 0xf5, 0xc7, 0xf8, 0x6f, 0x9e, 0x00, 
	0x15, 0xee, 0xb2, 0x3a, 0xeb, 0xbf, 0xf1, 0x17, 
	0x39, 0x37, 0xba, 0x74, 0x8e
};

static uint8_t pky_377 [32] = {
	0x10, 0x99, 0x87, 0x20, 0x70, 0xe8, 0xe8, 0x7c, 
	0x55, 0x5f, 0xa1, 0x36, 0x59, 0xcc, 0xa5, 0xd7, 
	0xfa, 0xdc, 0xfc, 0xb0, 0x02, 0x3e, 0xa8, 0x89, 
	0x54, 0x8c, 0xa4, 0x8a, 0xf2, 0xba, 0x7e, 0x71
};

#define mLen377 7 

static uint8_t msg_377  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_377  [32] = {
0x6b, 0x01, 0x33, 0x2d, 0xdb, 0x6e, 0xdf, 0xa9, 0xa3, 0x0a, 0x13, 0x21, 0xd5, 0x85, 0x8e, 0x1e, 0xe3, 0xcf, 0x97, 0xe2, 0x63, 0xe6, 0x69, 0xf8, 0xde, 0x5e, 0x96, 0x52, 0xe7, 0x6f, 0xf3, 0xf7
}; 

static uint8_t s_377  [32] = {
0x59, 0x39, 0x54, 0x5f, 0xce, 0xd4, 0x57, 0x30, 0x9a, 0x6a, 0x04, 0xac, 0xe2, 0xbd, 0x0f, 0x70, 0x13, 0x9c, 0x8f, 0x7d, 0x86, 0xb0, 0x2c, 0xb1, 0xcc, 0x58, 0xf9, 0xe6, 0x9e, 0x96, 0xcd, 0x5a
}; 

#define result___377 0

//Test vector 378:           "comment" : "x-coordinate of the public key is small",

static uint8_t pkx_378  [32] = { 
	0x0, 0x0, 0x0, 
	0x03, 0xfa, 0x15, 0xf9, 0x63, 0x94, 0x9d, 0x5f, 
	0x03, 0xa6, 0xf5, 0xc7, 0xf8, 0x6f, 0x9e, 0x00, 
	0x15, 0xee, 0xb2, 0x3a, 0xeb, 0xbf, 0xf1, 0x17, 
	0x39, 0x37, 0xba, 0x74, 0x8e
};

static uint8_t pky_378 [32] = {
	0x10, 0x99, 0x87, 0x20, 0x70, 0xe8, 0xe8, 0x7c, 
	0x55, 0x5f, 0xa1, 0x36, 0x59, 0xcc, 0xa5, 0xd7, 
	0xfa, 0xdc, 0xfc, 0xb0, 0x02, 0x3e, 0xa8, 0x89, 
	0x54, 0x8c, 0xa4, 0x8a, 0xf2, 0xba, 0x7e, 0x71
};


#define mLen378 7 

static uint8_t msg_378  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_378  [32] = {
0xef, 0xdb, 0x88, 0x47, 0x20, 0xea, 0xea, 0xdc, 0x34, 0x9f, 0x9f, 0xc3, 0x56, 0xb6, 0xc0, 0x34, 0x41, 0x01, 0xcd, 0x2f, 0xd8, 0x43, 0x6b, 0x7d, 0x0e, 0x6a, 0x4f, 0xb9, 0x3f, 0x10, 0x63, 0x61
}; 

static uint8_t s_378  [32] = {
0xf2, 0x4b, 0xee, 0x6a, 0xd5, 0xdc, 0x05, 0xf7, 0x61, 0x39, 0x75, 0x47, 0x3a, 0xad, 0xf3, 0xaa, 0xcb, 0xa9, 0xe7, 0x7d, 0xe7, 0xd6, 0x9b, 0x6c, 0xe4, 0x8c, 0xb6, 0x0d, 0x81, 0x13, 0x38, 0x5d
}; 

#define result___378 0

//Test vector 379:           "comment" : "y-coordinate of the public key is small",

static uint8_t pkx_379  [32] = { 
	0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 
	0xaa, 0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 
	0xbe, 0x5d, 0x2d, 0x67, 0x96, 0x70, 0x7d, 0x81, 
	0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15}; 

static uint8_t pky_379  [32] = {
	0x0,  0x0,  0x0,  0x0,  0x13, 0x52, 0xbb, 0x4a, 
	0x0f, 0xa2, 0xea, 0x4c, 0xce, 0xb9, 0xab, 0x63, 
	0xdd, 0x68, 0x4a, 0xde, 0x5a, 0x11, 0x27, 0xbc, 
	0xf3, 0x00, 0xa6, 0x98, 0xa7, 0x19, 0x3b, 0xc2
};

#define mLen379 7 

static uint8_t msg_379  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_379  [32] = {
0x31, 0x23, 0x04, 0x28, 0x40, 0x55, 0x60, 0xdc, 0xb8, 0x8f, 0xb5, 0xa6, 0x46, 0x83, 0x6a, 0xea, 0x9b, 0x23, 0xa2, 0x3d, 0xd9, 0x73, 0xdc, 0xbe, 0x80, 0x14, 0xc8, 0x7b, 0x8b, 0x20, 0xeb, 0x07
}; 

static uint8_t s_379  [32] = {
0x0f, 0x93, 0x44, 0xd6, 0xe8, 0x12, 0xce, 0x16, 0x66, 0x46, 0x74, 0x76, 0x94, 0xa4, 0x1b, 0x0a, 0xaf, 0x97, 0x37, 0x4e, 0x19, 0xf3, 0xc5, 0xfb, 0x8b, 0xd7, 0xae, 0x3d, 0x9b, 0xd0, 0xbe, 0xff
}; 

#define result___379 0

//Test vector 380:           "comment" : "y-coordinate of the public key is small",

static uint8_t pkx_380  [32] = { 
0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa, 0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96, 0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15}; 

static uint8_t pky_380  [32] = {
	0x0,  0x0,  0x0,  0x0,  0x13, 0x52, 0xbb, 0x4a, 
	0x0f, 0xa2, 0xea, 0x4c, 0xce, 0xb9, 0xab, 0x63, 
	0xdd, 0x68, 0x4a, 0xde, 0x5a, 0x11, 0x27, 0xbc, 
	0xf3, 0x00, 0xa6, 0x98, 0xa7, 0x19, 0x3b, 0xc2
};

#define mLen380 7 

static uint8_t msg_380  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_380  [32] = {
0xca, 0xa7, 0x97, 0xda, 0x65, 0xb3, 0x20, 0xab, 0x0d, 0x5c, 0x47, 0x0c, 0xda, 0x0b, 0x36, 0xb2, 0x94, 0x35, 0x9c, 0x7d, 0xb9, 0x84, 0x1d, 0x67, 0x91, 0x74, 0xdb, 0x34, 0xc4, 0x85, 0x57, 0x43
}; 

static uint8_t s_380  [32] = {
0xcf, 0x54, 0x3a, 0x62, 0xf2, 0x3e, 0x21, 0x27, 0x45, 0x39, 0x1a, 0xaf, 0x75, 0x05, 0xf3, 0x45, 0x12, 0x3d, 0x26, 0x85, 0xee, 0x3b, 0x94, 0x1d, 0x3d, 0xe6, 0xd9, 0xb3, 0x62, 0x42, 0xe5, 0xa0
}; 

#define result___380 0

//Test vector 381:           "comment" : "y-coordinate of the public key is small",

static uint8_t pkx_381  [32] = { 
0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa, 0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96, 0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15}; 

static uint8_t pky_381  [32] = {
	0x0,  0x0,  0x0,  0x0,  0x13, 0x52, 0xbb, 0x4a, 
	0x0f, 0xa2, 0xea, 0x4c, 0xce, 0xb9, 0xab, 0x63, 
	0xdd, 0x68, 0x4a, 0xde, 0x5a, 0x11, 0x27, 0xbc, 
	0xf3, 0x00, 0xa6, 0x98, 0xa7, 0x19, 0x3b, 0xc2
};

#define mLen381 7 

static uint8_t msg_381  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_381  [32] = {
0x7e, 0x5f, 0x0a, 0xb5, 0xd9, 0x00, 0xd3, 0xd3, 0xd7, 0x86, 0x76, 0x57, 0xe5, 0xd6, 0xd3, 0x65, 0x19, 0xbc, 0x54, 0x08, 0x45, 0x36, 0xe7, 0xd2, 0x1c, 0x33, 0x6e, 0xd8, 0x00, 0x18, 0x59, 0x45
}; 

static uint8_t s_381  [32] = {
0x94, 0x50, 0xc0, 0x7f, 0x20, 0x1f, 0xae, 0xc9, 0x4b, 0x82, 0xdf, 0xb3, 0x22, 0xe5, 0xac, 0x67, 0x66, 0x88, 0x29, 0x4a, 0xad, 0x35, 0xaa, 0x72, 0xe7, 0x27, 0xff, 0x0b, 0x19, 0xb6, 0x46, 0xaa
}; 

#define result___381 0

//Test vector 382:           "comment" : "y-coordinate of the public key is large",

static uint8_t pkx_382  [32] = { 
0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa, 0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96, 0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15}; 

static uint8_t pky_382  [32] = {
0xff, 0xff, 0xff, 0xfe, 0xec, 0xad, 0x44, 0xb6, 0xf0, 0x5d, 0x15, 0xb3, 0x31, 0x46, 0x54, 0x9c, 0x22, 0x97, 0xb5, 0x22, 0xa5, 0xee, 0xd8, 0x43, 0x0c, 0xff, 0x59, 0x67, 0x58, 0xe6, 0xc4, 0x3d};

#define mLen382 7 

static uint8_t msg_382  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_382  [32] = {
0xd7, 0xd7, 0x0c, 0x58, 0x1a, 0xe9, 0xe3, 0xf6, 0x6d, 0xc6, 0xa4, 0x80, 0xbf, 0x03, 0x7a, 0xe2, 0x3f, 0x8a, 0x1e, 0x4a, 0x21, 0x36, 0xfe, 0x4b, 0x03, 0xaa, 0x69, 0xf0, 0xca, 0x25, 0xb3, 0x56
}; 

static uint8_t s_382  [32] = {
0x89, 0xc4, 0x60, 0xf8, 0xa5, 0xa5, 0xc2, 0xbb, 0xba, 0x96, 0x2c, 0x8a, 0x3e, 0xe8, 0x33, 0xa4, 0x13, 0xe8, 0x56, 0x58, 0xe6, 0x2a, 0x59, 0xe2, 0xaf, 0x41, 0xd9, 0x12, 0x7c, 0xc4, 0x72, 0x24
}; 

#define result___382 0

//Test vector 383:           "comment" : "y-coordinate of the public key is large",

static uint8_t pkx_383  [32] = { 
0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa, 0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96, 0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15}; 

static uint8_t pky_383  [32] = {
0xff, 0xff, 0xff, 0xfe, 0xec, 0xad, 0x44, 0xb6, 0xf0, 0x5d, 0x15, 0xb3, 0x31, 0x46, 0x54, 0x9c, 0x22, 0x97, 0xb5, 0x22, 0xa5, 0xee, 0xd8, 0x43, 0x0c, 0xff, 0x59, 0x67, 0x58, 0xe6, 0xc4, 0x3d};

#define mLen383 7 

static uint8_t msg_383  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_383  [32] = {
0x34, 0x1c, 0x1b, 0x9f, 0xf3, 0xc8, 0x3d, 0xd5, 0xe0, 0xdf, 0xa0, 0xbf, 0x68, 0xbc, 0xdf, 0x4b, 0xb7, 0xaa, 0x20, 0xc6, 0x25, 0x97, 0x5e, 0x5e, 0xee, 0xe3, 0x4b, 0xb3, 0x96, 0x26, 0x6b, 0x34
}; 

static uint8_t s_383  [32] = {
0x72, 0xb6, 0x9f, 0x06, 0x1b, 0x75, 0x0f, 0xd5, 0x12, 0x1b, 0x22, 0xb1, 0x13, 0x66, 0xfa, 0xd5, 0x49, 0xc6, 0x34, 0xe7, 0x77, 0x65, 0xa0, 0x17, 0x90, 0x2a, 0x67, 0x09, 0x9e, 0x0a, 0x44, 0x69
}; 

#define result___383 0

//Test vector 384:           "comment" : "y-coordinate of the public key is large",

static uint8_t pkx_384  [32] = { 
0xbc, 0xbb, 0x29, 0x14, 0xc7, 0x9f, 0x04, 0x5e, 0xaa, 0x6e, 0xcb, 0xbc, 0x61, 0x28, 0x16, 0xb3, 0xbe, 0x5d, 0x2d, 0x67, 0x96, 0x70, 0x7d, 0x81, 0x25, 0xe9, 0xf8, 0x51, 0xc1, 0x8a, 0xf0, 0x15}; 

static uint8_t pky_384  [32] = {
0xff, 0xff, 0xff, 0xfe, 0xec, 0xad, 0x44, 0xb6, 0xf0, 0x5d, 0x15, 0xb3, 0x31, 0x46, 0x54, 0x9c, 0x22, 0x97, 0xb5, 0x22, 0xa5, 0xee, 0xd8, 0x43, 0x0c, 0xff, 0x59, 0x67, 0x58, 0xe6, 0xc4, 0x3d};

#define mLen384 7 

static uint8_t msg_384  [7] = {
0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65
}; 

static uint8_t r_384  [32] = {
0x70, 0xbe, 0xbe, 0x68, 0x4c, 0xdc, 0xb5, 0xca, 0x72, 0xa4, 0x2f, 0x0d, 0x87, 0x38, 0x79, 0x35, 0x9b, 0xd1, 0x78, 0x1a, 0x59, 0x18, 0x09, 0x94, 0x76, 0x28, 0xd3, 0x13, 0xa3, 0x81, 0x4f, 0x67
}; 

static uint8_t s_384  [32] = {
0xae, 0xc0, 0x3a, 0xca, 0x8f, 0x55, 0x87, 0xa4, 0xd5, 0x35, 0xfa, 0x31, 0x02, 0x7b, 0xbe, 0x9c, 0xc0, 0xe4, 0x64, 0xb1, 0xc3, 0x57, 0x7f, 0x4c, 0x2d, 0xcd, 0xe6, 0xb2, 0x09, 0x47, 0x98, 0xa9
}; 

#define result___384 0



static ecdsap256_w_i w_ecdsa_vectors[] = {
	{ 
	 .publicX = pkx_0, 
	 .publicY = pky_0
	 , .mLen = mLen0, 
	 .message = msg_0, 
	 .r = r_0, 
	 .s = s_0, 
	 .flag = result___0 
	}, 
	{ 
	 .publicX = pkx_1, 
	 .publicY = pky_1
	 , .mLen = mLen1, 
	 .message = msg_1, 
	 .r = r_1, 
	 .s = s_1, 
	 .flag = result___1 
	}, 
	{ 
	 .publicX = pkx_2, 
	 .publicY = pky_2,
	 .mLen = mLen2, 
	 .message = msg_2, 
	 .r = r_2, 
	 .s = s_2, 
	 .flag = result___2 
	}, 

//Anna: this tv was banned because it considers a problem in parsing

	// { 
	//  .publicX = pkx_3, 
	//  .publicY = pky_3, 
	//  .message = msg_3, 
	//  .r = r_3, 
	//  .s = s_3, 
	//  .flag = result___3 
	// }, 
	{ 
	 .publicX = pkx_4, 
	 .publicY = pky_4
	 , .mLen = mLen4, 
	 .message = msg_4, 
	 .r = r_4, 
	 .s = s_4, 
	 .flag = result___4 
	}, 
	{ 
	 .publicX = pkx_5, 
	 .publicY = pky_5
	 , .mLen = mLen5, 
	 .message = msg_5, 
	 .r = r_5, 
	 .s = s_5, 
	 .flag = result___5 
	}, 
	// { 
	//  .publicX = pkx_6, 
	//  .publicY = pky_6, 
	//  .message = msg_6, 
	//  .r = r_6, 
	//  .s = s_6, 
	//  .flag = result___6 
	// }, 
	// { 
	//  .publicX = pkx_7, 
	//  .publicY = pky_7, 
	//  .message = msg_7, 
	//  .r = r_7, 
	//  .s = s_7, 
	//  .flag = result___7 
	// }, 
	// { 
	//  .publicX = pkx_8, 
	//  .publicY = pky_8, 
	//  .message = msg_8, 
	//  .r = r_8, 
	//  .s = s_8, 
	//  .flag = result___8 
	// }, 
	// { 
	//  .publicX = pkx_9, 
	//  .publicY = pky_9, 
	//  .message = msg_9, 
	//  .r = r_9, 
	//  .s = s_9, 
	//  .flag = result___9 
	// }, 
	// { 
	//  .publicX = pkx_10, 
	//  .publicY = pky_10, 
	//  .message = msg_10, 
	//  .r = r_10, 
	//  .s = s_10, 
	//  .flag = result___10 
	// }, 

// Anna: banned, parsing
	// { 
	//  .publicX = pkx_11, 
	//  .publicY = pky_11, 
	//  .message = msg_11, 
	//  .r = r_11, 
	//  .s = s_11, 
	//  .flag = result___11 
	// },


// Anna: banned, parsing
	// { 
	//  .publicX = pkx_12, 
	//  .publicY = pky_12, 
	//  .message = msg_12, 
	//  .r = r_12, 
	//  .s = s_12, 
	//  .flag = result___12 
	// }, 


	// // { 
	// //  .publicX = pkx_13, 
	// //  .publicY = pky_13, 
	// //  .message = msg_13, 
	// //  .r = r_13, 
	// //  .s = s_13, 
	// //  .flag = result___13 
	// // }, 
	
// Anna: banned, parsing
	// { 
	//  .publicX = pkx_14, 
	//  .publicY = pky_14, 
	//  .message = msg_14, 
	//  .r = r_14, 
	//  .s = s_14, 
	//  .flag = result___14 
	// }, 
	// // { 
	// //  .publicX = pkx_15, 
	// //  .publicY = pky_15, 
	// //  .message = msg_15, 
	// //  .r = r_15, 
	// //  .s = s_15, 
	// //  .flag = result___15 
	// // }, 
	// // { 
	// //  .publicX = pkx_16, 
	// //  .publicY = pky_16, 
	// //  .message = msg_16, 
	// //  .r = r_16, 
	// //  .s = s_16, 
	// //  .flag = result___16 
	// // }, 


// Anna: banned, parsing
	// { 
	//  .publicX = pkx_17, 
	//  .publicY = pky_17, 
	//  .message = msg_17, 
	//  .r = r_17, 
	//  .s = s_17, 
	//  .flag = result___17 
	// }, 

	{ 
	 .publicX = pkx_18, 
	 .publicY = pky_18
	 , .mLen = mLen18, 
	 .message = msg_18, 
	 .r = r_18, 
	 .s = s_18, 
	 .flag = result___18 
	}, 
	// { 
	//  .publicX = pkx_19, 
	//  .publicY = pky_19, 
	//  .message = msg_19, 
	//  .r = r_19, 
	//  .s = s_19, 
	//  .flag = result___19 
	// }, 
	// { 
	//  .publicX = pkx_20, 
	//  .publicY = pky_20, 
	//  .message = msg_20, 
	//  .r = r_20, 
	//  .s = s_20, 
	//  .flag = result___20 
	// }, 
	// // { 
	// //  .publicX = pkx_21, 
	// //  .publicY = pky_21, 
	// //  .message = msg_21, 
	// //  .r = r_21, 
	// //  .s = s_21, 
	// //  .flag = result___21 
	// // }, 
	// { 
	//  .publicX = pkx_22, 
	//  .publicY = pky_22, 
	//  .message = msg_22, 
	//  .r = r_22, 
	//  .s = s_22, 
	//  .flag = result___22 
	// }, 
	// // { 
	// //  .publicX = pkx_23, 
	// //  .publicY = pky_23, 
	// //  .message = msg_23, 
	// //  .r = r_23, 
	// //  .s = s_23, 
	// //  .flag = result___23 
	// // }, 
	// { 
	//  .publicX = pkx_24, 
	//  .publicY = pky_24, 
	//  .message = msg_24, 
	//  .r = r_24, 
	//  .s = s_24, 
	//  .flag = result___24 
	// }, 
	// { 
	//  .publicX = pkx_25, 
	//  .publicY = pky_25, 
	//  .message = msg_25, 
	//  .r = r_25, 
	//  .s = s_25, 
	//  .flag = result___25 
	// }, 
	// { 
	//  .publicX = pkx_26, 
	//  .publicY = pky_26, 
	//  .message = msg_26, 
	//  .r = r_26, 
	//  .s = s_26, 
	//  .flag = result___26 
	// }, 
	// { 
	//  .publicX = pkx_27, 
	//  .publicY = pky_27, 
	//  .message = msg_27, 
	//  .r = r_27, 
	//  .s = s_27, 
	//  .flag = result___27 
	// }, 
	// { 
	//  .publicX = pkx_28, 
	//  .publicY = pky_28, 
	//  .message = msg_28, 
	//  .r = r_28, 
	//  .s = s_28, 
	//  .flag = result___28 
	// }, 
	// { 
	//  .publicX = pkx_29, 
	//  .publicY = pky_29, 
	//  .message = msg_29, 
	//  .r = r_29, 
	//  .s = s_29, 
	//  .flag = result___29 
	// }, 
	// { 
	//  .publicX = pkx_30, 
	//  .publicY = pky_30, 
	//  .message = msg_30, 
	//  .r = r_30, 
	//  .s = s_30, 
	//  .flag = result___30 
	// }, 
	// { 
	//  .publicX = pkx_31, 
	//  .publicY = pky_31, 
	//  .message = msg_31, 
	//  .r = r_31, 
	//  .s = s_31, 
	//  .flag = result___31 
	// }, 
	// { 
	//  .publicX = pkx_32, 
	//  .publicY = pky_32, 
	//  .message = msg_32, 
	//  .r = r_32, 
	//  .s = s_32, 
	//  .flag = result___32 
	// }, 
	// { 
	//  .publicX = pkx_33, 
	//  .publicY = pky_33, 
	//  .message = msg_33, 
	//  .r = r_33, 
	//  .s = s_33, 
	//  .flag = result___33 
	// }, 
	// { 
	//  .publicX = pkx_34, 
	//  .publicY = pky_34, 
	//  .message = msg_34, 
	//  .r = r_34, 
	//  .s = s_34, 
	//  .flag = result___34 
	// }, 
	// { 
	//  .publicX = pkx_35, 
	//  .publicY = pky_35, 
	//  .message = msg_35, 
	//  .r = r_35, 
	//  .s = s_35, 
	//  .flag = result___35 
	// }, 
	// // { 
	// //  .publicX = pkx_36, 
	// //  .publicY = pky_36, 
	// //  .message = msg_36, 
	// //  .r = r_36, 
	// //  .s = s_36, 
	// //  .flag = result___36 
	// // }, 
	// { 
	//  .publicX = pkx_37, 
	//  .publicY = pky_37, 
	//  .message = msg_37, 
	//  .r = r_37, 
	//  .s = s_37, 
	//  .flag = result___37 
	// }, 
	// // { 
	// //  .publicX = pkx_38, 
	// //  .publicY = pky_38, 
	// //  .message = msg_38, 
	// //  .r = r_38, 
	// //  .s = s_38, 
	// //  .flag = result___38 
	// // }, 
	// { 
	//  .publicX = pkx_39, 
	//  .publicY = pky_39, 
	//  .message = msg_39, 
	//  .r = r_39, 
	//  .s = s_39, 
	//  .flag = result___39 
	// }, 
	// { 
	//  .publicX = pkx_40, 
	//  .publicY = pky_40, 
	//  .message = msg_40, 
	//  .r = r_40, 
	//  .s = s_40, 
	//  .flag = result___40 
	// }, 
	// // { 
	// //  .publicX = pkx_41, 
	// //  .publicY = pky_41, 
	// //  .message = msg_41, 
	// //  .r = r_41, 
	// //  .s = s_41, 
	// //  .flag = result___41 
	// // }, 
	// { 
	//  .publicX = pkx_42, 
	//  .publicY = pky_42, 
	//  .message = msg_42, 
	//  .r = r_42, 
	//  .s = s_42, 
	//  .flag = result___42 
	// }, 
	// // { 
	// //  .publicX = pkx_43, 
	// //  .publicY = pky_43, 
	// //  .message = msg_43, 
	// //  .r = r_43, 
	// //  .s = s_43, 
	// //  .flag = result___43 
	// // }, 
	// { 
	//  .publicX = pkx_44, 
	//  .publicY = pky_44, 
	//  .message = msg_44, 
	//  .r = r_44, 
	//  .s = s_44, 
	//  .flag = result___44 
	// }, 
	// { 
	//  .publicX = pkx_45, 
	//  .publicY = pky_45, 
	//  .message = msg_45, 
	//  .r = r_45, 
	//  .s = s_45, 
	//  .flag = result___45 
	// }, 
	// { 
	//  .publicX = pkx_46, 
	//  .publicY = pky_46, 
	//  .message = msg_46, 
	//  .r = r_46, 
	//  .s = s_46, 
	//  .flag = result___46 
	// }, 
	// { 
	//  .publicX = pkx_47, 
	//  .publicY = pky_47, 
	//  .message = msg_47, 
	//  .r = r_47, 
	//  .s = s_47, 
	//  .flag = result___47 
	// }, 
	// { 
	//  .publicX = pkx_48, 
	//  .publicY = pky_48, 
	//  .message = msg_48, 
	//  .r = r_48, 
	//  .s = s_48, 
	//  .flag = result___48 
	// }, 
	// // { 
	// //  .publicX = pkx_49, 
	// //  .publicY = pky_49, 
	// //  .message = msg_49, 
	// //  .r = r_49, 
	// //  .s = s_49, 
	// //  .flag = result___49 
	// // }, 
	// { 
	//  .publicX = pkx_50, 
	//  .publicY = pky_50, 
	//  .message = msg_50, 
	//  .r = r_50, 
	//  .s = s_50, 
	//  .flag = result___50 
	// }, 
	// { 
	//  .publicX = pkx_51, 
	//  .publicY = pky_51, 
	//  .message = msg_51, 
	//  .r = r_51, 
	//  .s = s_51, 
	//  .flag = result___51 
	// }, 
	// { 
	//  .publicX = pkx_52, 
	//  .publicY = pky_52, 
	//  .message = msg_52, 
	//  .r = r_52, 
	//  .s = s_52, 
	//  .flag = result___52 
	// }, 
	// { 
	//  .publicX = pkx_53, 
	//  .publicY = pky_53, 
	//  .message = msg_53, 
	//  .r = r_53, 
	//  .s = s_53, 
	//  .flag = result___53 
	// }, 
	// { 
	//  .publicX = pkx_54, 
	//  .publicY = pky_54, 
	//  .message = msg_54, 
	//  .r = r_54, 
	//  .s = s_54, 
	//  .flag = result___54 
	// }, 
	// { 
	//  .publicX = pkx_55, 
	//  .publicY = pky_55, 
	//  .message = msg_55, 
	//  .r = r_55, 
	//  .s = s_55, 
	//  .flag = result___55 
	// }, 
	// { 
	//  .publicX = pkx_56, 
	//  .publicY = pky_56, 
	//  .message = msg_56, 
	//  .r = r_56, 
	//  .s = s_56, 
	//  .flag = result___56 
	// }, 
	// { 
	//  .publicX = pkx_57, 
	//  .publicY = pky_57, 
	//  .message = msg_57, 
	//  .r = r_57, 
	//  .s = s_57, 
	//  .flag = result___57 
	// }, 
	// { 
	//  .publicX = pkx_58, 
	//  .publicY = pky_58, 
	//  .message = msg_58, 
	//  .r = r_58, 
	//  .s = s_58, 
	//  .flag = result___58 
	// }, 
	// { 
	//  .publicX = pkx_59, 
	//  .publicY = pky_59, 
	//  .message = msg_59, 
	//  .r = r_59, 
	//  .s = s_59, 
	//  .flag = result___59 
	// }, 
	// { 
	//  .publicX = pkx_60, 
	//  .publicY = pky_60, 
	//  .message = msg_60, 
	//  .r = r_60, 
	//  .s = s_60, 
	//  .flag = result___60 
	// }, 
	// { 
	//  .publicX = pkx_61, 
	//  .publicY = pky_61, 
	//  .message = msg_61, 
	//  .r = r_61, 
	//  .s = s_61, 
	//  .flag = result___61 
	// }, 
	// // { 
	// //  .publicX = pkx_62, 
	// //  .publicY = pky_62, 
	// //  .message = msg_62, 
	// //  .r = r_62, 
	// //  .s = s_62, 
	// //  .flag = result___62 
	// // }, 
	// // { 
	// //  .publicX = pkx_63, 
	// //  .publicY = pky_63, 
	// //  .message = msg_63, 
	// //  .r = r_63, 
	// //  .s = s_63, 
	// //  .flag = result___63 
	// // }, 
	// { 
	//  .publicX = pkx_64, 
	//  .publicY = pky_64, 
	//  .message = msg_64, 
	//  .r = r_64, 
	//  .s = s_64, 
	//  .flag = result___64 
	// }, 
	// // { 
	// //  .publicX = pkx_65, 
	// //  .publicY = pky_65, 
	// //  .message = msg_65, 
	// //  .r = r_65, 
	// //  .s = s_65, 
	// //  .flag = result___65 
	// // }, 
	// { 
	//  .publicX = pkx_66, 
	//  .publicY = pky_66, 
	//  .message = msg_66, 
	//  .r = r_66, 
	//  .s = s_66, 
	//  .flag = result___66 
	// }, 
	// // { 
	// //  .publicX = pkx_67, 
	// //  .publicY = pky_67, 
	// //  .message = msg_67, 
	// //  .r = r_67, 
	// //  .s = s_67, 
	// //  .flag = result___67 
	// // }, 
	// { 
	//  .publicX = pkx_68, 
	//  .publicY = pky_68, 
	//  .message = msg_68, 
	//  .r = r_68, 
	//  .s = s_68, 
	//  .flag = result___68 
	// }, 
	// { 
	//  .publicX = pkx_69, 
	//  .publicY = pky_69, 
	//  .message = msg_69, 
	//  .r = r_69, 
	//  .s = s_69, 
	//  .flag = result___69 
	// }, 
	// { 
	//  .publicX = pkx_70, 
	//  .publicY = pky_70, 
	//  .message = msg_70, 
	//  .r = r_70, 
	//  .s = s_70, 
	//  .flag = result___70 
	// }, 
	// { 
	//  .publicX = pkx_71, 
	//  .publicY = pky_71, 
	//  .message = msg_71, 
	//  .r = r_71, 
	//  .s = s_71, 
	//  .flag = result___71 
	// }, 
	// { 
	//  .publicX = pkx_72, 
	//  .publicY = pky_72, 
	//  .message = msg_72, 
	//  .r = r_72, 
	//  .s = s_72, 
	//  .flag = result___72 
	// }, 
	// // { 
	// //  .publicX = pkx_73, 
	// //  .publicY = pky_73, 
	// //  .message = msg_73, 
	// //  .r = r_73, 
	// //  .s = s_73, 
	// //  .flag = result___73 
	// // }, 
	// { 
	//  .publicX = pkx_74, 
	//  .publicY = pky_74, 
	//  .message = msg_74, 
	//  .r = r_74, 
	//  .s = s_74, 
	//  .flag = result___74 
	// }, 
	// // { 
	// //  .publicX = pkx_75, 
	// //  .publicY = pky_75, 
	// //  .message = msg_75, 
	// //  .r = r_75, 
	// //  .s = s_75, 
	// //  .flag = result___75 
	// // }, 
	// { 
	//  .publicX = pkx_76, 
	//  .publicY = pky_76, 
	//  .message = msg_76, 
	//  .r = r_76, 
	//  .s = s_76, 
	//  .flag = result___76 
	// }, 
	// // { 
	// //  .publicX = pkx_77, 
	// //  .publicY = pky_77, 
	// //  .message = msg_77, 
	// //  .r = r_77, 
	// //  .s = s_77, 
	// //  .flag = result___77 
	// // }, 
	// { 
	//  .publicX = pkx_78, 
	//  .publicY = pky_78, 
	//  .message = msg_78, 
	//  .r = r_78, 
	//  .s = s_78, 
	//  .flag = result___78 
	// }, 
	// // { 
	// //  .publicX = pkx_79, 
	// //  .publicY = pky_79, 
	// //  .message = msg_79, 
	// //  .r = r_79, 
	// //  .s = s_79, 
	// //  .flag = result___79 
	// // }, 
	// { 
	//  .publicX = pkx_80, 
	//  .publicY = pky_80, 
	//  .message = msg_80, 
	//  .r = r_80, 
	//  .s = s_80, 
	//  .flag = result___80 
	// }, 
	// // { 
	// //  .publicX = pkx_81, 
	// //  .publicY = pky_81, 
	// //  .message = msg_81, 
	// //  .r = r_81, 
	// //  .s = s_81, 
	// //  .flag = result___81 
	// // }, 
	// { 
	//  .publicX = pkx_82, 
	//  .publicY = pky_82, 
	//  .message = msg_82, 
	//  .r = r_82, 
	//  .s = s_82, 
	//  .flag = result___82 
	// }, 
	// // { 
	// //  .publicX = pkx_83, 
	// //  .publicY = pky_83, 
	// //  .message = msg_83, 
	// //  .r = r_83, 
	// //  .s = s_83, 
	// //  .flag = result___83 
	// // }, 
	// { 
	//  .publicX = pkx_84, 
	//  .publicY = pky_84, 
	//  .message = msg_84, 
	//  .r = r_84, 
	//  .s = s_84, 
	//  .flag = result___84 
	// }, 
	// // { 
	// //  .publicX = pkx_85, 
	// //  .publicY = pky_85, 
	// //  .message = msg_85, 
	// //  .r = r_85, 
	// //  .s = s_85, 
	// //  .flag = result___85 
	// // }, 
	// { 
	//  .publicX = pkx_86, 
	//  .publicY = pky_86, 
	//  .message = msg_86, 
	//  .r = r_86, 
	//  .s = s_86, 
	//  .flag = result___86 
	// }, 
	// // { 
	// //  .publicX = pkx_87, 
	// //  .publicY = pky_87, 
	// //  .message = msg_87, 
	// //  .r = r_87, 
	// //  .s = s_87, 
	// //  .flag = result___87 
	// // }, 
	// { 
	//  .publicX = pkx_88, 
	//  .publicY = pky_88, 
	//  .message = msg_88, 
	//  .r = r_88, 
	//  .s = s_88, 
	//  .flag = result___88 
	// }, 
	// // { 
	// //  .publicX = pkx_89, 
	// //  .publicY = pky_89, 
	// //  .message = msg_89, 
	// //  .r = r_89, 
	// //  .s = s_89, 
	// //  .flag = result___89 
	// // }, 
	// { 
	//  .publicX = pkx_90, 
	//  .publicY = pky_90, 
	//  .message = msg_90, 
	//  .r = r_90, 
	//  .s = s_90, 
	//  .flag = result___90 
	// }, 
	// { 
	//  .publicX = pkx_91, 
	//  .publicY = pky_91, 
	//  .message = msg_91, 
	//  .r = r_91, 
	//  .s = s_91, 
	//  .flag = result___91 
	// }, 
	// { 
	//  .publicX = pkx_92, 
	//  .publicY = pky_92, 
	//  .message = msg_92, 
	//  .r = r_92, 
	//  .s = s_92, 
	//  .flag = result___92 
	// }, 
	// { 
	//  .publicX = pkx_93, 
	//  .publicY = pky_93, 
	//  .message = msg_93, 
	//  .r = r_93, 
	//  .s = s_93, 
	//  .flag = result___93 
	// }, 
	// { 
	//  .publicX = pkx_94, 
	//  .publicY = pky_94, 
	//  .message = msg_94, 
	//  .r = r_94, 
	//  .s = s_94, 
	//  .flag = result___94 
	// }, 
	// { 
	//  .publicX = pkx_95, 
	//  .publicY = pky_95, 
	//  .message = msg_95, 
	//  .r = r_95, 
	//  .s = s_95, 
	//  .flag = result___95 
	// }, 
	// { 
	//  .publicX = pkx_96, 
	//  .publicY = pky_96, 
	//  .message = msg_96, 
	//  .r = r_96, 
	//  .s = s_96, 
	//  .flag = result___96 
	// }, 
	// // { 
	// //  .publicX = pkx_97, 
	// //  .publicY = pky_97, 
	// //  .message = msg_97, 
	// //  .r = r_97, 
	// //  .s = s_97, 
	// //  .flag = result___97 
	// // }, 
	// { 
	//  .publicX = pkx_98, 
	//  .publicY = pky_98, 
	//  .message = msg_98, 
	//  .r = r_98, 
	//  .s = s_98, 
	//  .flag = result___98 
	// }, 
	// { 
	//  .publicX = pkx_99, 
	//  .publicY = pky_99, 
	//  .message = msg_99, 
	//  .r = r_99, 
	//  .s = s_99, 
	//  .flag = result___99 
	// }, 
	// { 
	//  .publicX = pkx_100, 
	//  .publicY = pky_100, 
	//  .message = msg_100, 
	//  .r = r_100, 
	//  .s = s_100, 
	//  .flag = result___100 
	// }, 
	// { 
	//  .publicX = pkx_101, 
	//  .publicY = pky_101, 
	//  .message = msg_101, 
	//  .r = r_101, 
	//  .s = s_101, 
	//  .flag = result___101 
	// }, 
	// { 
	//  .publicX = pkx_102, 
	//  .publicY = pky_102, 
	//  .message = msg_102, 
	//  .r = r_102, 
	//  .s = s_102, 
	//  .flag = result___102 
	// }, 
	// { 
	//  .publicX = pkx_103, 
	//  .publicY = pky_103, 
	//  .message = msg_103, 
	//  .r = r_103, 
	//  .s = s_103, 
	//  .flag = result___103 
	// }, 
	// { 
	//  .publicX = pkx_104, 
	//  .publicY = pky_104, 
	//  .message = msg_104, 
	//  .r = r_104, 
	//  .s = s_104, 
	//  .flag = result___104 
	// }, 
	// { 
	//  .publicX = pkx_105, 
	//  .publicY = pky_105, 
	//  .message = msg_105, 
	//  .r = r_105, 
	//  .s = s_105, 
	//  .flag = result___105 
	// }, 
	// { 
	//  .publicX = pkx_106, 
	//  .publicY = pky_106, 
	//  .message = msg_106, 
	//  .r = r_106, 
	//  .s = s_106, 
	//  .flag = result___106 
	// }, 
	// { 
	//  .publicX = pkx_107, 
	//  .publicY = pky_107, 
	//  .message = msg_107, 
	//  .r = r_107, 
	//  .s = s_107, 
	//  .flag = result___107 
	// }, 
	// { 
	//  .publicX = pkx_108, 
	//  .publicY = pky_108, 
	//  .message = msg_108, 
	//  .r = r_108, 
	//  .s = s_108, 
	//  .flag = result___108 
	// }, 
	// { 
	//  .publicX = pkx_109, 
	//  .publicY = pky_109, 
	//  .message = msg_109, 
	//  .r = r_109, 
	//  .s = s_109, 
	//  .flag = result___109 
	// }, 
	// { 
	//  .publicX = pkx_110, 
	//  .publicY = pky_110, 
	//  .message = msg_110, 
	//  .r = r_110, 
	//  .s = s_110, 
	//  .flag = result___110 
	// }, 
	// { 
	//  .publicX = pkx_111, 
	//  .publicY = pky_111, 
	//  .message = msg_111, 
	//  .r = r_111, 
	//  .s = s_111, 
	//  .flag = result___111 
	// }, 
	// { 
	//  .publicX = pkx_112, 
	//  .publicY = pky_112, 
	//  .message = msg_112, 
	//  .r = r_112, 
	//  .s = s_112, 
	//  .flag = result___112 
	// }, 
	// { 
	//  .publicX = pkx_113, 
	//  .publicY = pky_113, 
	//  .message = msg_113, 
	//  .r = r_113, 
	//  .s = s_113, 
	//  .flag = result___113 
	// }, 
	// { 
	//  .publicX = pkx_114, 
	//  .publicY = pky_114, 
	//  .message = msg_114, 
	//  .r = r_114, 
	//  .s = s_114, 
	//  .flag = result___114 
	// }, 
	// { 
	//  .publicX = pkx_115, 
	//  .publicY = pky_115, 
	//  .message = msg_115, 
	//  .r = r_115, 
	//  .s = s_115, 
	//  .flag = result___115 
	// }, 
	// { 
	//  .publicX = pkx_116, 
	//  .publicY = pky_116, 
	//  .message = msg_116, 
	//  .r = r_116, 
	//  .s = s_116, 
	//  .flag = result___116 
	// }, 
	// { 
	//  .publicX = pkx_117, 
	//  .publicY = pky_117, 
	//  .message = msg_117, 
	//  .r = r_117, 
	//  .s = s_117, 
	//  .flag = result___117 
	// }, 
	// { 
	//  .publicX = pkx_118, 
	//  .publicY = pky_118, 
	//  .message = msg_118, 
	//  .r = r_118, 
	//  .s = s_118, 
	//  .flag = result___118 
	// }, 
	// { 
	//  .publicX = pkx_119, 
	//  .publicY = pky_119, 
	//  .message = msg_119, 
	//  .r = r_119, 
	//  .s = s_119, 
	//  .flag = result___119 
	// }, 
	// { 
	//  .publicX = pkx_120, 
	//  .publicY = pky_120, 
	//  .message = msg_120, 
	//  .r = r_120, 
	//  .s = s_120, 
	//  .flag = result___120 
	// }, 
	// { 
	//  .publicX = pkx_121, 
	//  .publicY = pky_121, 
	//  .message = msg_121, 
	//  .r = r_121, 
	//  .s = s_121, 
	//  .flag = result___121 
	// }, 
	// { 
	//  .publicX = pkx_122, 
	//  .publicY = pky_122, 
	//  .message = msg_122, 
	//  .r = r_122, 
	//  .s = s_122, 
	//  .flag = result___122 
	// }, 
	// { 
	//  .publicX = pkx_123, 
	//  .publicY = pky_123, 
	//  .message = msg_123, 
	//  .r = r_123, 
	//  .s = s_123, 
	//  .flag = result___123 
	// }, 
	// { 
	//  .publicX = pkx_124, 
	//  .publicY = pky_124, 
	//  .message = msg_124, 
	//  .r = r_124, 
	//  .s = s_124, 
	//  .flag = result___124 
	// }, 
	// { 
	//  .publicX = pkx_125, 
	//  .publicY = pky_125, 
	//  .message = msg_125, 
	//  .r = r_125, 
	//  .s = s_125, 
	//  .flag = result___125 
	// }, 
	// { 
	//  .publicX = pkx_126, 
	//  .publicY = pky_126, 
	//  .message = msg_126, 
	//  .r = r_126, 
	//  .s = s_126, 
	//  .flag = result___126 
	// }, 
	// { 
	//  .publicX = pkx_127, 
	//  .publicY = pky_127, 
	//  .message = msg_127, 
	//  .r = r_127, 
	//  .s = s_127, 
	//  .flag = result___127 
	// }, 
	{ 
	 .publicX = pkx_128, 
	 .publicY = pky_128
	 , .mLen = mLen128, 
	 .message = msg_128, 
	 .r = r_128, 
	 .s = s_128, 
	 .flag = result___128 
	}, 
	{ 
	 .publicX = pkx_129, 
	 .publicY = pky_129
	 , .mLen = mLen129, 
	 .message = msg_129, 
	 .r = r_129, 
	 .s = s_129, 
	 .flag = result___129 
	}, 
	{ 
	 .publicX = pkx_130, 
	 .publicY = pky_130
	 , .mLen = mLen130, 
	 .message = msg_130, 
	 .r = r_130, 
	 .s = s_130, 
	 .flag = result___130 
	}, 
	{ 
	 .publicX = pkx_131, 
	 .publicY = pky_131
	 , .mLen = mLen131, 
	 .message = msg_131, 
	 .r = r_131, 
	 .s = s_131, 
	 .flag = result___131 
	}, 
	{ 
	 .publicX = pkx_132, 
	 .publicY = pky_132
	 , .mLen = mLen132, 
	 .message = msg_132, 
	 .r = r_132, 
	 .s = s_132, 
	 .flag = result___132 
	}, 

// Anna: tv banned because of parsing. 

	// { 
	//  .publicX = pkx_133, 
	//  .publicY = pky_133, 
	//  .message = msg_133, 
	//  .r = r_133, 
	//  .s = s_133, 
	//  .flag = result___133 
	// }, 
	{ 
	 .publicX = pkx_134, 
	 .publicY = pky_134
	 , .mLen = mLen134, 
	 .message = msg_134, 
	 .r = r_134, 
	 .s = s_134, 
	 .flag = result___134 
	}, 
	{ 
	 .publicX = pkx_135, 
	 .publicY = pky_135
	 , .mLen = mLen135, 
	 .message = msg_135, 
	 .r = r_135, 
	 .s = s_135, 
	 .flag = result___135 
	}, 
	{ 
	 .publicX = pkx_136, 
	 .publicY = pky_136
	 , .mLen = mLen136, 
	 .message = msg_136, 
	 .r = r_136, 
	 .s = s_136, 
	 .flag = result___136 
	}, 
	{ 
	 .publicX = pkx_137, 
	 .publicY = pky_137
	 , .mLen = mLen137, 
	 .message = msg_137, 
	 .r = r_137, 
	 .s = s_137, 
	 .flag = result___137 
	}, 
	{ 
	 .publicX = pkx_138, 
	 .publicY = pky_138
	 , .mLen = mLen138, 
	 .message = msg_138, 
	 .r = r_138, 
	 .s = s_138, 
	 .flag = result___138 
	}, 

//Anna: parsing

	// { 
	//  .publicX = pkx_139, 
	//  .publicY = pky_139, 
	//  .message = msg_139, 
	//  .r = r_139, 
	//  .s = s_139, 
	//  .flag = result___139 
	// }, 
	{ 
	 .publicX = pkx_141, 
	 .publicY = pky_141
	 , .mLen = mLen141, 
	 .message = msg_141, 
	 .r = r_141, 
	 .s = s_141, 
	 .flag = result___141 
	}, 
	{ 
	 .publicX = pkx_142, 
	 .publicY = pky_142
	 , .mLen = mLen142, 
	 .message = msg_142, 
	 .r = r_142, 
	 .s = s_142, 
	 .flag = result___142 
	}, 
	{ 
	 .publicX = pkx_143, 
	 .publicY = pky_143
	 , .mLen = mLen143, 
	 .message = msg_143, 
	 .r = r_143, 
	 .s = s_143, 
	 .flag = result___143 
	}, 
	{ 
	 .publicX = pkx_144, 
	 .publicY = pky_144
	 , .mLen = mLen144, 
	 .message = msg_144, 
	 .r = r_144, 
	 .s = s_144, 
	 .flag = result___144 
	}, 
	{ 
	 .publicX = pkx_145, 
	 .publicY = pky_145
	 , .mLen = mLen145, 
	 .message = msg_145, 
	 .r = r_145, 
	 .s = s_145, 
	 .flag = result___145 
	}, 
	{ 
	 .publicX = pkx_146, 
	 .publicY = pky_146
	 , .mLen = mLen146, 
	 .message = msg_146, 
	 .r = r_146, 
	 .s = s_146, 
	 .flag = result___146 
	}, 
	{ 
	 .publicX = pkx_147, 
	 .publicY = pky_147
	 , .mLen = mLen147, 
	 .message = msg_147, 
	 .r = r_147, 
	 .s = s_147, 
	 .flag = result___147 
	}, 
	{ 
	 .publicX = pkx_148, 
	 .publicY = pky_148
	 , .mLen = mLen148, 
	 .message = msg_148, 
	 .r = r_148, 
	 .s = s_148, 
	 .flag = result___148 
	}, 
	{ 
	 .publicX = pkx_149, 
	 .publicY = pky_149
	 , .mLen = mLen149, 
	 .message = msg_149, 
	 .r = r_149, 
	 .s = s_149, 
	 .flag = result___149 
	}, 
	{ 
	 .publicX = pkx_150, 
	 .publicY = pky_150
	 , .mLen = mLen150, 
	 .message = msg_150, 
	 .r = r_150, 
	 .s = s_150, 
	 .flag = result___150 
	}, 
	{ 
	 .publicX = pkx_151, 
	 .publicY = pky_151
	 , .mLen = mLen151, 
	 .message = msg_151, 
	 .r = r_151, 
	 .s = s_151, 
	 .flag = result___151 
	}, 
	{ 
	 .publicX = pkx_152, 
	 .publicY = pky_152
	 , .mLen = mLen152, 
	 .message = msg_152, 
	 .r = r_152, 
	 .s = s_152, 
	 .flag = result___152 
	}, 
	{ 
	 .publicX = pkx_153, 
	 .publicY = pky_153
	 , .mLen = mLen153, 
	 .message = msg_153, 
	 .r = r_153, 
	 .s = s_153, 
	 .flag = result___153 
	}, 
	{ 
	 .publicX = pkx_154, 
	 .publicY = pky_154
	 , .mLen = mLen154, 
	 .message = msg_154, 
	 .r = r_154, 
	 .s = s_154, 
	 .flag = result___154 
	}, 
	{ 
	 .publicX = pkx_155, 
	 .publicY = pky_155
	 , .mLen = mLen155, 
	 .message = msg_155, 
	 .r = r_155, 
	 .s = s_155, 
	 .flag = result___155 
	}, 
	{ 
	 .publicX = pkx_156, 
	 .publicY = pky_156
	 , .mLen = mLen156, 
	 .message = msg_156, 
	 .r = r_156, 
	 .s = s_156, 
	 .flag = result___156 
	}, 
	{ 
	 .publicX = pkx_157, 
	 .publicY = pky_157
	 , .mLen = mLen157, 
	 .message = msg_157, 
	 .r = r_157, 
	 .s = s_157, 
	 .flag = result___157 
	}, 
	{ 
	 .publicX = pkx_158, 
	 .publicY = pky_158
	 , .mLen = mLen158, 
	 .message = msg_158, 
	 .r = r_158, 
	 .s = s_158, 
	 .flag = result___158 
	}, 
	{ 
	 .publicX = pkx_159, 
	 .publicY = pky_159
	 , .mLen = mLen159, 
	 .message = msg_159, 
	 .r = r_159, 
	 .s = s_159, 
	 .flag = result___159 
	}, 
	{ 
	 .publicX = pkx_160, 
	 .publicY = pky_160
	 , .mLen = mLen160, 
	 .message = msg_160, 
	 .r = r_160, 
	 .s = s_160, 
	 .flag = result___160 
	}, 
	{ 
	 .publicX = pkx_161, 
	 .publicY = pky_161
	 , .mLen = mLen161, 
	 .message = msg_161, 
	 .r = r_161, 
	 .s = s_161, 
	 .flag = result___161 
	}, 
	{ 
	 .publicX = pkx_162, 
	 .publicY = pky_162
	 , .mLen = mLen162, 
	 .message = msg_162, 
	 .r = r_162, 
	 .s = s_162, 
	 .flag = result___162 
	}, 
	{ 
	 .publicX = pkx_163, 
	 .publicY = pky_163
	 , .mLen = mLen163, 
	 .message = msg_163, 
	 .r = r_163, 
	 .s = s_163, 
	 .flag = result___163 
	}, 
	{ 
	 .publicX = pkx_164, 
	 .publicY = pky_164
	 , .mLen = mLen164, 
	 .message = msg_164, 
	 .r = r_164, 
	 .s = s_164, 
	 .flag = result___164 
	}, 
	{ 
	 .publicX = pkx_165, 
	 .publicY = pky_165
	 , .mLen = mLen165, 
	 .message = msg_165, 
	 .r = r_165, 
	 .s = s_165, 
	 .flag = result___165 
	}, 
	{ 
	 .publicX = pkx_166, 
	 .publicY = pky_166
	 , .mLen = mLen166, 
	 .message = msg_166, 
	 .r = r_166, 
	 .s = s_166, 
	 .flag = result___166 
	}, 
	{ 
	 .publicX = pkx_167, 
	 .publicY = pky_167
	 , .mLen = mLen167, 
	 .message = msg_167, 
	 .r = r_167, 
	 .s = s_167, 
	 .flag = result___167 
	}, 
	{ 
	 .publicX = pkx_168, 
	 .publicY = pky_168
	 , .mLen = mLen168, 
	 .message = msg_168, 
	 .r = r_168, 
	 .s = s_168, 
	 .flag = result___168 
	}, 
	{ 
	 .publicX = pkx_169, 
	 .publicY = pky_169
	 , .mLen = mLen169, 
	 .message = msg_169, 
	 .r = r_169, 
	 .s = s_169, 
	 .flag = result___169 
	}, 
	{ 
	 .publicX = pkx_170, 
	 .publicY = pky_170
	 , .mLen = mLen170, 
	 .message = msg_170, 
	 .r = r_170, 
	 .s = s_170, 
	 .flag = result___170 
	}, 
	{ 
	 .publicX = pkx_171, 
	 .publicY = pky_171
	 , .mLen = mLen171, 
	 .message = msg_171, 
	 .r = r_171, 
	 .s = s_171, 
	 .flag = result___171 
	}, 
	{ 
	 .publicX = pkx_172, 
	 .publicY = pky_172
	 , .mLen = mLen172, 
	 .message = msg_172, 
	 .r = r_172, 
	 .s = s_172, 
	 .flag = result___172 
	}, 
	{ 
	 .publicX = pkx_173, 
	 .publicY = pky_173
	 , .mLen = mLen173, 
	 .message = msg_173, 
	 .r = r_173, 
	 .s = s_173, 
	 .flag = result___173 
	}, 
	{ 
	 .publicX = pkx_174, 
	 .publicY = pky_174
	 , .mLen = mLen174, 
	 .message = msg_174, 
	 .r = r_174, 
	 .s = s_174, 
	 .flag = result___174 
	}, 
	{ 
	 .publicX = pkx_175, 
	 .publicY = pky_175
	 , .mLen = mLen175, 
	 .message = msg_175, 
	 .r = r_175, 
	 .s = s_175, 
	 .flag = result___175 
	}, 
	{ 
	 .publicX = pkx_176, 
	 .publicY = pky_176
	 , .mLen = mLen176, 
	 .message = msg_176, 
	 .r = r_176, 
	 .s = s_176, 
	 .flag = result___176 
	}, 
	{ 
	 .publicX = pkx_177, 
	 .publicY = pky_177
	 , .mLen = mLen177, 
	 .message = msg_177, 
	 .r = r_177, 
	 .s = s_177, 
	 .flag = result___177 
	}, 
	{ 
	 .publicX = pkx_178, 
	 .publicY = pky_178
	 , .mLen = mLen178, 
	 .message = msg_178, 
	 .r = r_178, 
	 .s = s_178, 
	 .flag = result___178 
	}, 
	{ 
	 .publicX = pkx_179, 
	 .publicY = pky_179
	 , .mLen = mLen179, 
	 .message = msg_179, 
	 .r = r_179, 
	 .s = s_179, 
	 .flag = result___179 
	}, 
	{ 
	 .publicX = pkx_180, 
	 .publicY = pky_180
	 , .mLen = mLen180, 
	 .message = msg_180, 
	 .r = r_180, 
	 .s = s_180, 
	 .flag = result___180 
	}, 
	{ 
	 .publicX = pkx_181, 
	 .publicY = pky_181
	 , .mLen = mLen181, 
	 .message = msg_181, 
	 .r = r_181, 
	 .s = s_181, 
	 .flag = result___181 
	}, 
	{ 
	 .publicX = pkx_182, 
	 .publicY = pky_182
	 , .mLen = mLen182, 
	 .message = msg_182, 
	 .r = r_182, 
	 .s = s_182, 
	 .flag = result___182 
	}, 
	{ 
	 .publicX = pkx_183, 
	 .publicY = pky_183
	 , .mLen = mLen183, 
	 .message = msg_183, 
	 .r = r_183, 
	 .s = s_183, 
	 .flag = result___183 
	}, 
	{ 
	 .publicX = pkx_184, 
	 .publicY = pky_184
	 , .mLen = mLen184, 
	 .message = msg_184, 
	 .r = r_184, 
	 .s = s_184, 
	 .flag = result___184 
	}, 
	{ 
	 .publicX = pkx_185, 
	 .publicY = pky_185
	 , .mLen = mLen185, 
	 .message = msg_185, 
	 .r = r_185, 
	 .s = s_185, 
	 .flag = result___185 
	}, 
	{ 
	 .publicX = pkx_186, 
	 .publicY = pky_186
	 , .mLen = mLen186, 
	 .message = msg_186, 
	 .r = r_186, 
	 .s = s_186, 
	 .flag = result___186 
	}, 
	{ 
	 .publicX = pkx_187, 
	 .publicY = pky_187
	 , .mLen = mLen187, 
	 .message = msg_187, 
	 .r = r_187, 
	 .s = s_187, 
	 .flag = result___187 
	}, 
	{ 
	 .publicX = pkx_188, 
	 .publicY = pky_188
	 , .mLen = mLen188, 
	 .message = msg_188, 
	 .r = r_188, 
	 .s = s_188, 
	 .flag = result___188 
	}, 
	{ 
	 .publicX = pkx_189, 
	 .publicY = pky_189
	 , .mLen = mLen189, 
	 .message = msg_189, 
	 .r = r_189, 
	 .s = s_189, 
	 .flag = result___189 
	}, 
	{ 
	 .publicX = pkx_190, 
	 .publicY = pky_190
	 , .mLen = mLen190, 
	 .message = msg_190, 
	 .r = r_190, 
	 .s = s_190, 
	 .flag = result___190 
	}, 
	{ 
	 .publicX = pkx_191, 
	 .publicY = pky_191
	 , .mLen = mLen191, 
	 .message = msg_191, 
	 .r = r_191, 
	 .s = s_191, 
	 .flag = result___191 
	}, 
	{ 
	 .publicX = pkx_192, 
	 .publicY = pky_192
	 , .mLen = mLen192, 
	 .message = msg_192, 
	 .r = r_192, 
	 .s = s_192, 
	 .flag = result___192 
	}, 
	{ 
	 .publicX = pkx_193, 
	 .publicY = pky_193
	 , .mLen = mLen193, 
	 .message = msg_193, 
	 .r = r_193, 
	 .s = s_193, 
	 .flag = result___193 
	}, 
	{ 
	 .publicX = pkx_194, 
	 .publicY = pky_194
	 , .mLen = mLen194, 
	 .message = msg_194, 
	 .r = r_194, 
	 .s = s_194, 
	 .flag = result___194 
	}, 
	{ 
	 .publicX = pkx_195, 
	 .publicY = pky_195
	 , .mLen = mLen195, 
	 .message = msg_195, 
	 .r = r_195, 
	 .s = s_195, 
	 .flag = result___195 
	}, 
	{ 
	 .publicX = pkx_196, 
	 .publicY = pky_196
	 , .mLen = mLen196, 
	 .message = msg_196, 
	 .r = r_196, 
	 .s = s_196, 
	 .flag = result___196 
	}, 
	{ 
	 .publicX = pkx_197, 
	 .publicY = pky_197
	 , .mLen = mLen197, 
	 .message = msg_197, 
	 .r = r_197, 
	 .s = s_197, 
	 .flag = result___197 
	}, 
	{ 
	 .publicX = pkx_198, 
	 .publicY = pky_198
	 , .mLen = mLen198, 
	 .message = msg_198, 
	 .r = r_198, 
	 .s = s_198, 
	 .flag = result___198 
	}, 
	{ 
	 .publicX = pkx_199, 
	 .publicY = pky_199
	 , .mLen = mLen199, 
	 .message = msg_199, 
	 .r = r_199, 
	 .s = s_199, 
	 .flag = result___199 
	}, 
	{ 
	 .publicX = pkx_200, 
	 .publicY = pky_200
	 , .mLen = mLen200, 
	 .message = msg_200, 
	 .r = r_200, 
	 .s = s_200, 
	 .flag = result___200 
	}, 
	{ 
	 .publicX = pkx_201, 
	 .publicY = pky_201
	 , .mLen = mLen201, 
	 .message = msg_201, 
	 .r = r_201, 
	 .s = s_201, 
	 .flag = result___201 
	}, 
	{ 
	 .publicX = pkx_202, 
	 .publicY = pky_202
	 , .mLen = mLen202, 
	 .message = msg_202, 
	 .r = r_202, 
	 .s = s_202, 
	 .flag = result___202 
	}, 
	{ 
	 .publicX = pkx_203, 
	 .publicY = pky_203
	 , .mLen = mLen203, 
	 .message = msg_203, 
	 .r = r_203, 
	 .s = s_203, 
	 .flag = result___203 
	}, 
	{ 
	 .publicX = pkx_204, 
	 .publicY = pky_204
	 , .mLen = mLen204, 
	 .message = msg_204, 
	 .r = r_204, 
	 .s = s_204, 
	 .flag = result___204 
	}, 
	{ 
	 .publicX = pkx_205, 
	 .publicY = pky_205
	 , .mLen = mLen205, 
	 .message = msg_205, 
	 .r = r_205, 
	 .s = s_205, 
	 .flag = result___205 
	}, 
	{ 
	 .publicX = pkx_206, 
	 .publicY = pky_206
	 , .mLen = mLen206, 
	 .message = msg_206, 
	 .r = r_206, 
	 .s = s_206, 
	 .flag = result___206 
	}, 
	{ 
	 .publicX = pkx_207, 
	 .publicY = pky_207
	 , .mLen = mLen207, 
	 .message = msg_207, 
	 .r = r_207, 
	 .s = s_207, 
	 .flag = result___207 
	}, 
	{ 
	 .publicX = pkx_208, 
	 .publicY = pky_208
	 , .mLen = mLen208, 
	 .message = msg_208, 
	 .r = r_208, 
	 .s = s_208, 
	 .flag = result___208 
	}, 
	{ 
	 .publicX = pkx_209, 
	 .publicY = pky_209
	 , .mLen = mLen209, 
	 .message = msg_209, 
	 .r = r_209, 
	 .s = s_209, 
	 .flag = result___209 
	}, 
	{ 
	 .publicX = pkx_210, 
	 .publicY = pky_210
	 , .mLen = mLen210, 
	 .message = msg_210, 
	 .r = r_210, 
	 .s = s_210, 
	 .flag = result___210 
	}, 
	{ 
	 .publicX = pkx_211, 
	 .publicY = pky_211
	 , .mLen = mLen211, 
	 .message = msg_211, 
	 .r = r_211, 
	 .s = s_211, 
	 .flag = result___211 
	}, 
	{ 
	 .publicX = pkx_212, 
	 .publicY = pky_212
	 , .mLen = mLen212, 
	 .message = msg_212, 
	 .r = r_212, 
	 .s = s_212, 
	 .flag = result___212 
	}, 
	{ 
	 .publicX = pkx_213, 
	 .publicY = pky_213
	 , .mLen = mLen213, 
	 .message = msg_213, 
	 .r = r_213, 
	 .s = s_213, 
	 .flag = result___213 
	}, 
	{ 
	 .publicX = pkx_214, 
	 .publicY = pky_214
	 , .mLen = mLen214, 
	 .message = msg_214, 
	 .r = r_214, 
	 .s = s_214, 
	 .flag = result___214 
	}, 
	{ 
	 .publicX = pkx_215, 
	 .publicY = pky_215
	 , .mLen = mLen215, 
	 .message = msg_215, 
	 .r = r_215, 
	 .s = s_215, 
	 .flag = result___215 
	}, 
	{ 
	 .publicX = pkx_216, 
	 .publicY = pky_216
	 , .mLen = mLen216, 
	 .message = msg_216, 
	 .r = r_216, 
	 .s = s_216, 
	 .flag = result___216 
	}, 
	{ 
	 .publicX = pkx_217, 
	 .publicY = pky_217
	 , .mLen = mLen217, 
	 .message = msg_217, 
	 .r = r_217, 
	 .s = s_217, 
	 .flag = result___217 
	}, 
	{ 
	 .publicX = pkx_218, 
	 .publicY = pky_218
	 , .mLen = mLen218, 
	 .message = msg_218, 
	 .r = r_218, 
	 .s = s_218, 
	 .flag = result___218 
	}, 
	{ 
	 .publicX = pkx_219, 
	 .publicY = pky_219
	 , .mLen = mLen219, 
	 .message = msg_219, 
	 .r = r_219, 
	 .s = s_219, 
	 .flag = result___219 
	}, 
	{ 
	 .publicX = pkx_220, 
	 .publicY = pky_220
	 , .mLen = mLen220, 
	 .message = msg_220, 
	 .r = r_220, 
	 .s = s_220, 
	 .flag = result___220 
	}, 
	{ 
	 .publicX = pkx_221, 
	 .publicY = pky_221
	 , .mLen = mLen221, 
	 .message = msg_221, 
	 .r = r_221, 
	 .s = s_221, 
	 .flag = result___221 
	}, 
	{ 
	 .publicX = pkx_222, 
	 .publicY = pky_222
	 , .mLen = mLen222, 
	 .message = msg_222, 
	 .r = r_222, 
	 .s = s_222, 
	 .flag = result___222 
	}, 
	{ 
	 .publicX = pkx_223, 
	 .publicY = pky_223
	 , .mLen = mLen223, 
	 .message = msg_223, 
	 .r = r_223, 
	 .s = s_223, 
	 .flag = result___223 
	}, 
	{ 
	 .publicX = pkx_224, 
	 .publicY = pky_224
	 , .mLen = mLen224, 
	 .message = msg_224, 
	 .r = r_224, 
	 .s = s_224, 
	 .flag = result___224 
	}, 
	// { 
	//  .publicX = pkx_225, 
	//  .publicY = pky_225
	//  , .mLen = mLen225, 
	//  .message = msg_225, 
	//  .r = r_225, 
	//  .s = s_225, 
	//  .flag = result___225 
	// }, 
	{ 
	 .publicX = pkx_226, 
	 .publicY = pky_226
	 , .mLen = mLen226, 
	 .message = msg_226, 
	 .r = r_226, 
	 .s = s_226, 
	 .flag = result___226 
	}, 
	{ 
	 .publicX = pkx_227, 
	 .publicY = pky_227
	 , .mLen = mLen227, 
	 .message = msg_227, 
	 .r = r_227, 
	 .s = s_227, 
	 .flag = result___227 
	}, 
	{ 
	 .publicX = pkx_228, 
	 .publicY = pky_228
	 , .mLen = mLen228, 
	 .message = msg_228, 
	 .r = r_228, 
	 .s = s_228, 
	 .flag = result___228 
	}, 
	{ 
	 .publicX = pkx_229, 
	 .publicY = pky_229
	 , .mLen = mLen229, 
	 .message = msg_229, 
	 .r = r_229, 
	 .s = s_229, 
	 .flag = result___229 
	}, 
	{ 
	 .publicX = pkx_230, 
	 .publicY = pky_230
	 , .mLen = mLen230, 
	 .message = msg_230, 
	 .r = r_230, 
	 .s = s_230, 
	 .flag = result___230 
	}, 
	{ 
	 .publicX = pkx_231, 
	 .publicY = pky_231
	 , .mLen = mLen231, 
	 .message = msg_231, 
	 .r = r_231, 
	 .s = s_231, 
	 .flag = result___231 
	}, 
	{ 
	 .publicX = pkx_232, 
	 .publicY = pky_232
	 , .mLen = mLen232, 
	 .message = msg_232, 
	 .r = r_232, 
	 .s = s_232, 
	 .flag = result___232 
	}, 
	{ 
	 .publicX = pkx_233, 
	 .publicY = pky_233
	 , .mLen = mLen233, 
	 .message = msg_233, 
	 .r = r_233, 
	 .s = s_233, 
	 .flag = result___233 
	}, 
	{ 
	 .publicX = pkx_234, 
	 .publicY = pky_234
	 , .mLen = mLen234, 
	 .message = msg_234, 
	 .r = r_234, 
	 .s = s_234, 
	 .flag = result___234 
	}, 
	{ 
	 .publicX = pkx_235, 
	 .publicY = pky_235
	 , .mLen = mLen235, 
	 .message = msg_235, 
	 .r = r_235, 
	 .s = s_235, 
	 .flag = result___235 
	}, 
	{ 
	 .publicX = pkx_236, 
	 .publicY = pky_236
	 , .mLen = mLen236, 
	 .message = msg_236, 
	 .r = r_236, 
	 .s = s_236, 
	 .flag = result___236 
	}, 
	{ 
	 .publicX = pkx_237, 
	 .publicY = pky_237
	 , .mLen = mLen237, 
	 .message = msg_237, 
	 .r = r_237, 
	 .s = s_237, 
	 .flag = result___237 
	}, 
	{ 
	 .publicX = pkx_238, 
	 .publicY = pky_238
	 , .mLen = mLen238, 
	 .message = msg_238, 
	 .r = r_238, 
	 .s = s_238, 
	 .flag = result___238 
	}, 
	{ 
	 .publicX = pkx_239, 
	 .publicY = pky_239
	 , .mLen = mLen239, 
	 .message = msg_239, 
	 .r = r_239, 
	 .s = s_239, 
	 .flag = result___239 
	}, 
	{ 
	 .publicX = pkx_240, 
	 .publicY = pky_240
	 , .mLen = mLen240, 
	 .message = msg_240, 
	 .r = r_240, 
	 .s = s_240, 
	 .flag = result___240 
	}, 
	{ 
	 .publicX = pkx_241, 
	 .publicY = pky_241
	 , .mLen = mLen241, 
	 .message = msg_241, 
	 .r = r_241, 
	 .s = s_241, 
	 .flag = result___241 
	}, 
	{ 
	 .publicX = pkx_242, 
	 .publicY = pky_242
	 , .mLen = mLen242, 
	 .message = msg_242, 
	 .r = r_242, 
	 .s = s_242, 
	 .flag = result___242 
	}, 
	{ 
	 .publicX = pkx_243, 
	 .publicY = pky_243
	 , .mLen = mLen243, 
	 .message = msg_243, 
	 .r = r_243, 
	 .s = s_243, 
	 .flag = result___243 
	}, 
	{ 
	 .publicX = pkx_244, 
	 .publicY = pky_244
	 , .mLen = mLen244, 
	 .message = msg_244, 
	 .r = r_244, 
	 .s = s_244, 
	 .flag = result___244 
	}, 
	{ 
	 .publicX = pkx_245, 
	 .publicY = pky_245
	 , .mLen = mLen245, 
	 .message = msg_245, 
	 .r = r_245, 
	 .s = s_245, 
	 .flag = result___245 
	}, 
	{ 
	 .publicX = pkx_246, 
	 .publicY = pky_246
	 , .mLen = mLen246, 
	 .message = msg_246, 
	 .r = r_246, 
	 .s = s_246, 
	 .flag = result___246 
	}, 
	{ 
	 .publicX = pkx_247, 
	 .publicY = pky_247
	 , .mLen = mLen247, 
	 .message = msg_247, 
	 .r = r_247, 
	 .s = s_247, 
	 .flag = result___247 
	}, 
	{ 
	 .publicX = pkx_248, 
	 .publicY = pky_248
	 , .mLen = mLen248, 
	 .message = msg_248, 
	 .r = r_248, 
	 .s = s_248, 
	 .flag = result___248 
	}, 
	{ 
	 .publicX = pkx_249, 
	 .publicY = pky_249
	 , .mLen = mLen249, 
	 .message = msg_249, 
	 .r = r_249, 
	 .s = s_249, 
	 .flag = result___249 
	}, 
	{ 
	 .publicX = pkx_250, 
	 .publicY = pky_250
	 , .mLen = mLen250, 
	 .message = msg_250, 
	 .r = r_250, 
	 .s = s_250, 
	 .flag = result___250 
	}, 
	{ 
	 .publicX = pkx_251, 
	 .publicY = pky_251
	 , .mLen = mLen251, 
	 .message = msg_251, 
	 .r = r_251, 
	 .s = s_251, 
	 .flag = result___251 
	}, 
	{ 
	 .publicX = pkx_252, 
	 .publicY = pky_252
	 , .mLen = mLen252, 
	 .message = msg_252, 
	 .r = r_252, 
	 .s = s_252, 
	 .flag = result___252 
	}, 
	{ 
	 .publicX = pkx_253, 
	 .publicY = pky_253
	 , .mLen = mLen253, 
	 .message = msg_253, 
	 .r = r_253, 
	 .s = s_253, 
	 .flag = result___253 
	}, 
	{ 
	 .publicX = pkx_254, 
	 .publicY = pky_254
	 , .mLen = mLen254, 
	 .message = msg_254, 
	 .r = r_254, 
	 .s = s_254, 
	 .flag = result___254 
	}, 
	{ 
	 .publicX = pkx_255, 
	 .publicY = pky_255
	 , .mLen = mLen255, 
	 .message = msg_255, 
	 .r = r_255, 
	 .s = s_255, 
	 .flag = result___255 
	}, 
	{ 
	 .publicX = pkx_256, 
	 .publicY = pky_256
	 , .mLen = mLen256, 
	 .message = msg_256, 
	 .r = r_256, 
	 .s = s_256, 
	 .flag = result___256 
	}, 
	{ 
	 .publicX = pkx_257, 
	 .publicY = pky_257
	 , .mLen = mLen257, 
	 .message = msg_257, 
	 .r = r_257, 
	 .s = s_257, 
	 .flag = result___257 
	}, 
	{ 
	 .publicX = pkx_258, 
	 .publicY = pky_258
	 , .mLen = mLen258, 
	 .message = msg_258, 
	 .r = r_258, 
	 .s = s_258, 
	 .flag = result___258 
	}, 
	{ 
	 .publicX = pkx_259, 
	 .publicY = pky_259
	 , .mLen = mLen259, 
	 .message = msg_259, 
	 .r = r_259, 
	 .s = s_259, 
	 .flag = result___259 
	}, 
	{ 
	 .publicX = pkx_260, 
	 .publicY = pky_260
	 , .mLen = mLen260, 
	 .message = msg_260, 
	 .r = r_260, 
	 .s = s_260, 
	 .flag = result___260 
	}, 
	{ 
	 .publicX = pkx_261, 
	 .publicY = pky_261
	 , .mLen = mLen261, 
	 .message = msg_261, 
	 .r = r_261, 
	 .s = s_261, 
	 .flag = result___261 
	}, 
	{ 
	 .publicX = pkx_262, 
	 .publicY = pky_262
	 , .mLen = mLen262, 
	 .message = msg_262, 
	 .r = r_262, 
	 .s = s_262, 
	 .flag = result___262 
	}, 
	{ 
	 .publicX = pkx_263, 
	 .publicY = pky_263
	 , .mLen = mLen263, 
	 .message = msg_263, 
	 .r = r_263, 
	 .s = s_263, 
	 .flag = result___263 
	}, 
	{ 
	 .publicX = pkx_264, 
	 .publicY = pky_264
	 , .mLen = mLen264, 
	 .message = msg_264, 
	 .r = r_264, 
	 .s = s_264, 
	 .flag = result___264 
	}, 
	{ 
	 .publicX = pkx_265, 
	 .publicY = pky_265
	 , .mLen = mLen265, 
	 .message = msg_265, 
	 .r = r_265, 
	 .s = s_265, 
	 .flag = result___265 
	}, 
	{ 
	 .publicX = pkx_266, 
	 .publicY = pky_266
	 , .mLen = mLen266, 
	 .message = msg_266, 
	 .r = r_266, 
	 .s = s_266, 
	 .flag = result___266 
	}, 
	{ 
	 .publicX = pkx_267, 
	 .publicY = pky_267
	 , .mLen = mLen267, 
	 .message = msg_267, 
	 .r = r_267, 
	 .s = s_267, 
	 .flag = result___267 
	}, 
	{ 
	 .publicX = pkx_268, 
	 .publicY = pky_268
	 , .mLen = mLen268, 
	 .message = msg_268, 
	 .r = r_268, 
	 .s = s_268, 
	 .flag = result___268 
	}, 
	{ 
	 .publicX = pkx_269, 
	 .publicY = pky_269
	 , .mLen = mLen269, 
	 .message = msg_269, 
	 .r = r_269, 
	 .s = s_269, 
	 .flag = result___269 
	}, 
	{ 
	 .publicX = pkx_270, 
	 .publicY = pky_270
	 , .mLen = mLen270, 
	 .message = msg_270, 
	 .r = r_270, 
	 .s = s_270, 
	 .flag = result___270 
	}, 
	{ 
	 .publicX = pkx_271, 
	 .publicY = pky_271
	 , .mLen = mLen271, 
	 .message = msg_271, 
	 .r = r_271, 
	 .s = s_271, 
	 .flag = result___271 
	}, 
	{ 
	 .publicX = pkx_272, 
	 .publicY = pky_272
	 , .mLen = mLen272, 
	 .message = msg_272, 
	 .r = r_272, 
	 .s = s_272, 
	 .flag = result___272 
	}, 
	{ 
	 .publicX = pkx_273, 
	 .publicY = pky_273
	 , .mLen = mLen273, 
	 .message = msg_273, 
	 .r = r_273, 
	 .s = s_273, 
	 .flag = result___273 
	}, 
	{ 
	 .publicX = pkx_274, 
	 .publicY = pky_274
	 , .mLen = mLen274, 
	 .message = msg_274, 
	 .r = r_274, 
	 .s = s_274, 
	 .flag = result___274 
	}, 
	{ 
	 .publicX = pkx_275, 
	 .publicY = pky_275
	 , .mLen = mLen275, 
	 .message = msg_275, 
	 .r = r_275, 
	 .s = s_275, 
	 .flag = result___275 
	}, 
	{ 
	 .publicX = pkx_276, 
	 .publicY = pky_276
	 , .mLen = mLen276, 
	 .message = msg_276, 
	 .r = r_276, 
	 .s = s_276, 
	 .flag = result___276 
	}, 
	{ 
	 .publicX = pkx_277, 
	 .publicY = pky_277
	 , .mLen = mLen277, 
	 .message = msg_277, 
	 .r = r_277, 
	 .s = s_277, 
	 .flag = result___277 
	}, 
	{ 
	 .publicX = pkx_278, 
	 .publicY = pky_278
	 , .mLen = mLen278, 
	 .message = msg_278, 
	 .r = r_278, 
	 .s = s_278, 
	 .flag = result___278 
	}, 
	{ 
	 .publicX = pkx_279, 
	 .publicY = pky_279
	 , .mLen = mLen279, 
	 .message = msg_279, 
	 .r = r_279, 
	 .s = s_279, 
	 .flag = result___279 
	}, 
	{ 
	 .publicX = pkx_280, 
	 .publicY = pky_280
	 , .mLen = mLen280, 
	 .message = msg_280, 
	 .r = r_280, 
	 .s = s_280, 
	 .flag = result___280 
	}, 
	{ 
	 .publicX = pkx_281, 
	 .publicY = pky_281
	 , .mLen = mLen281, 
	 .message = msg_281, 
	 .r = r_281, 
	 .s = s_281, 
	 .flag = result___281 
	}, 
	{ 
	 .publicX = pkx_282, 
	 .publicY = pky_282
	 , .mLen = mLen282, 
	 .message = msg_282, 
	 .r = r_282, 
	 .s = s_282, 
	 .flag = result___282 
	}, 
	{ 
	 .publicX = pkx_283, 
	 .publicY = pky_283
	 , .mLen = mLen283, 
	 .message = msg_283, 
	 .r = r_283, 
	 .s = s_283, 
	 .flag = result___283 
	}, 
	{ 
	 .publicX = pkx_284, 
	 .publicY = pky_284
	 , .mLen = mLen284, 
	 .message = msg_284, 
	 .r = r_284, 
	 .s = s_284, 
	 .flag = result___284 
	}, 
	{ 
	 .publicX = pkx_285, 
	 .publicY = pky_285
	 , .mLen = mLen285, 
	 .message = msg_285, 
	 .r = r_285, 
	 .s = s_285, 
	 .flag = result___285 
	}, 
	{ 
	 .publicX = pkx_286, 
	 .publicY = pky_286
	 , .mLen = mLen286, 
	 .message = msg_286, 
	 .r = r_286, 
	 .s = s_286, 
	 .flag = result___286 
	}, 
	{ 
	 .publicX = pkx_287, 
	 .publicY = pky_287
	 , .mLen = mLen287, 
	 .message = msg_287, 
	 .r = r_287, 
	 .s = s_287, 
	 .flag = result___287 
	}, 
	{ 
	 .publicX = pkx_288, 
	 .publicY = pky_288
	 , .mLen = mLen288, 
	 .message = msg_288, 
	 .r = r_288, 
	 .s = s_288, 
	 .flag = result___288 
	}, 
	{ 
	 .publicX = pkx_289, 
	 .publicY = pky_289
	 , .mLen = mLen289, 
	 .message = msg_289, 
	 .r = r_289, 
	 .s = s_289, 
	 .flag = result___289 
	}, 
	{ 
	 .publicX = pkx_290, 
	 .publicY = pky_290
	 , .mLen = mLen290, 
	 .message = msg_290, 
	 .r = r_290, 
	 .s = s_290, 
	 .flag = result___290 
	}, 
	{ 
	 .publicX = pkx_291, 
	 .publicY = pky_291
	 , .mLen = mLen291, 
	 .message = msg_291, 
	 .r = r_291, 
	 .s = s_291, 
	 .flag = result___291 
	}, 
	{ 
	 .publicX = pkx_292, 
	 .publicY = pky_292
	 , .mLen = mLen292, 
	 .message = msg_292, 
	 .r = r_292, 
	 .s = s_292, 
	 .flag = result___292 
	}, 
	{ 
	 .publicX = pkx_293, 
	 .publicY = pky_293
	 , .mLen = mLen293, 
	 .message = msg_293, 
	 .r = r_293, 
	 .s = s_293, 
	 .flag = result___293 
	}, 
	{ 
	 .publicX = pkx_294, 
	 .publicY = pky_294
	 , .mLen = mLen294, 
	 .message = msg_294, 
	 .r = r_294, 
	 .s = s_294, 
	 .flag = result___294 
	}, 
	{ 
	 .publicX = pkx_295, 
	 .publicY = pky_295
	 , .mLen = mLen295, 
	 .message = msg_295, 
	 .r = r_295, 
	 .s = s_295, 
	 .flag = result___295 
	}, 
	{ 
	 .publicX = pkx_296, 
	 .publicY = pky_296
	 , .mLen = mLen296, 
	 .message = msg_296, 
	 .r = r_296, 
	 .s = s_296, 
	 .flag = result___296 
	}, 
	{ 
	 .publicX = pkx_297, 
	 .publicY = pky_297
	 , .mLen = mLen297, 
	 .message = msg_297, 
	 .r = r_297, 
	 .s = s_297, 
	 .flag = result___297 
	}, 
	{ 
	 .publicX = pkx_298, 
	 .publicY = pky_298
	 , .mLen = mLen298, 
	 .message = msg_298, 
	 .r = r_298, 
	 .s = s_298, 
	 .flag = result___298 
	}, 
	{ 
	 .publicX = pkx_299, 
	 .publicY = pky_299
	 , .mLen = mLen299, 
	 .message = msg_299, 
	 .r = r_299, 
	 .s = s_299, 
	 .flag = result___299 
	}, 
	{ 
	 .publicX = pkx_300, 
	 .publicY = pky_300
	 , .mLen = mLen300, 
	 .message = msg_300, 
	 .r = r_300, 
	 .s = s_300, 
	 .flag = result___300 
	}, 
	{ 
	 .publicX = pkx_301, 
	 .publicY = pky_301
	 , .mLen = mLen301, 
	 .message = msg_301, 
	 .r = r_301, 
	 .s = s_301, 
	 .flag = result___301 
	}, 
	{ 
	 .publicX = pkx_302, 
	 .publicY = pky_302
	 , .mLen = mLen302, 
	 .message = msg_302, 
	 .r = r_302, 
	 .s = s_302, 
	 .flag = result___302 
	}, 
	{ 
	 .publicX = pkx_303, 
	 .publicY = pky_303
	 , .mLen = mLen303, 
	 .message = msg_303, 
	 .r = r_303, 
	 .s = s_303, 
	 .flag = result___303 
	}, 
	{ 
	 .publicX = pkx_304, 
	 .publicY = pky_304
	 , .mLen = mLen304, 
	 .message = msg_304, 
	 .r = r_304, 
	 .s = s_304, 
	 .flag = result___304 
	}, 
	{ 
	 .publicX = pkx_305, 
	 .publicY = pky_305
	 , .mLen = mLen305, 
	 .message = msg_305, 
	 .r = r_305, 
	 .s = s_305, 
	 .flag = result___305 
	}, 
	{ 
	 .publicX = pkx_306, 
	 .publicY = pky_306
	 , .mLen = mLen306, 
	 .message = msg_306, 
	 .r = r_306, 
	 .s = s_306, 
	 .flag = result___306 
	}, 
	{ 
	 .publicX = pkx_307, 
	 .publicY = pky_307
	 , .mLen = mLen307, 
	 .message = msg_307, 
	 .r = r_307, 
	 .s = s_307, 
	 .flag = result___307 
	}, 
	{ 
	 .publicX = pkx_308, 
	 .publicY = pky_308
	 , .mLen = mLen308, 
	 .message = msg_308, 
	 .r = r_308, 
	 .s = s_308, 
	 .flag = result___308 
	}, 
	{ 
	 .publicX = pkx_309, 
	 .publicY = pky_309
	 , .mLen = mLen309, 
	 .message = msg_309, 
	 .r = r_309, 
	 .s = s_309, 
	 .flag = result___309 
	}, 
	{ 
	 .publicX = pkx_310, 
	 .publicY = pky_310
	 , .mLen = mLen310, 
	 .message = msg_310, 
	 .r = r_310, 
	 .s = s_310, 
	 .flag = result___310 
	}, 
	{ 
	 .publicX = pkx_311, 
	 .publicY = pky_311
	 , .mLen = mLen311, 
	 .message = msg_311, 
	 .r = r_311, 
	 .s = s_311, 
	 .flag = result___311 
	}, 
	{ 
	 .publicX = pkx_312, 
	 .publicY = pky_312
	 , .mLen = mLen312, 
	 .message = msg_312, 
	 .r = r_312, 
	 .s = s_312, 
	 .flag = result___312 
	}, 
	{ 
	 .publicX = pkx_313, 
	 .publicY = pky_313
	 , .mLen = mLen313, 
	 .message = msg_313, 
	 .r = r_313, 
	 .s = s_313, 
	 .flag = result___313 
	}, 
	{ 
	 .publicX = pkx_314, 
	 .publicY = pky_314
	 , .mLen = mLen314, 
	 .message = msg_314, 
	 .r = r_314, 
	 .s = s_314, 
	 .flag = result___314 
	}, 
	{ 
	 .publicX = pkx_315, 
	 .publicY = pky_315
	 , .mLen = mLen315, 
	 .message = msg_315, 
	 .r = r_315, 
	 .s = s_315, 
	 .flag = result___315 
	}, 
	{ 
	 .publicX = pkx_316, 
	 .publicY = pky_316
	 , .mLen = mLen316, 
	 .message = msg_316, 
	 .r = r_316, 
	 .s = s_316, 
	 .flag = result___316 
	}, 
	{ 
	 .publicX = pkx_317, 
	 .publicY = pky_317
	 , .mLen = mLen317, 
	 .message = msg_317, 
	 .r = r_317, 
	 .s = s_317, 
	 .flag = result___317 
	}, 
	{ 
	 .publicX = pkx_318, 
	 .publicY = pky_318
	 , .mLen = mLen318, 
	 .message = msg_318, 
	 .r = r_318, 
	 .s = s_318, 
	 .flag = result___318 
	}, 
	{ 
	 .publicX = pkx_319, 
	 .publicY = pky_319
	 , .mLen = mLen319, 
	 .message = msg_319, 
	 .r = r_319, 
	 .s = s_319, 
	 .flag = result___319 
	}, 
	{ 
	 .publicX = pkx_320, 
	 .publicY = pky_320
	 , .mLen = mLen320, 
	 .message = msg_320, 
	 .r = r_320, 
	 .s = s_320, 
	 .flag = result___320 
	}, 
	{ 
	 .publicX = pkx_321, 
	 .publicY = pky_321
	 , .mLen = mLen321, 
	 .message = msg_321, 
	 .r = r_321, 
	 .s = s_321, 
	 .flag = result___321 
	}, 
	{ 
	 .publicX = pkx_322, 
	 .publicY = pky_322
	 , .mLen = mLen322, 
	 .message = msg_322, 
	 .r = r_322, 
	 .s = s_322, 
	 .flag = result___322 
	}, 
	{ 
	 .publicX = pkx_323, 
	 .publicY = pky_323
	 , .mLen = mLen323, 
	 .message = msg_323, 
	 .r = r_323, 
	 .s = s_323, 
	 .flag = result___323 
	}, 
	{ 
	 .publicX = pkx_324, 
	 .publicY = pky_324
	 , .mLen = mLen324, 
	 .message = msg_324, 
	 .r = r_324, 
	 .s = s_324, 
	 .flag = result___324 
	}, 
	{ 
	 .publicX = pkx_325, 
	 .publicY = pky_325
	 , .mLen = mLen325, 
	 .message = msg_325, 
	 .r = r_325, 
	 .s = s_325, 
	 .flag = result___325 
	}, 
	{ 
	 .publicX = pkx_326, 
	 .publicY = pky_326
	 , .mLen = mLen326, 
	 .message = msg_326, 
	 .r = r_326, 
	 .s = s_326, 
	 .flag = result___326 
	}, 
	{ 
	 .publicX = pkx_327, 
	 .publicY = pky_327
	 , .mLen = mLen327, 
	 .message = msg_327, 
	 .r = r_327, 
	 .s = s_327, 
	 .flag = result___327 
	}, 
	{ 
	 .publicX = pkx_328, 
	 .publicY = pky_328
	 , .mLen = mLen328, 
	 .message = msg_328, 
	 .r = r_328, 
	 .s = s_328, 
	 .flag = result___328 
	}, 
	{ 
	 .publicX = pkx_329, 
	 .publicY = pky_329
	 , .mLen = mLen329, 
	 .message = msg_329, 
	 .r = r_329, 
	 .s = s_329, 
	 .flag = result___329 
	}, 
	{ 
	 .publicX = pkx_330, 
	 .publicY = pky_330
	 , .mLen = mLen330, 
	 .message = msg_330, 
	 .r = r_330, 
	 .s = s_330, 
	 .flag = result___330 
	}, 
	{ 
	 .publicX = pkx_331, 
	 .publicY = pky_331
	 , .mLen = mLen331, 
	 .message = msg_331, 
	 .r = r_331, 
	 .s = s_331, 
	 .flag = result___331 
	}, 
	{ 
	 .publicX = pkx_332, 
	 .publicY = pky_332
	 , .mLen = mLen332, 
	 .message = msg_332, 
	 .r = r_332, 
	 .s = s_332, 
	 .flag = result___332 
	}, 
	{ 
	 .publicX = pkx_333, 
	 .publicY = pky_333
	 , .mLen = mLen333, 
	 .message = msg_333, 
	 .r = r_333, 
	 .s = s_333, 
	 .flag = result___333 
	}, 
	{ 
	 .publicX = pkx_334, 
	 .publicY = pky_334
	 , .mLen = mLen334, 
	 .message = msg_334, 
	 .r = r_334, 
	 .s = s_334, 
	 .flag = result___334 
	}, 
	{ 
	 .publicX = pkx_335, 
	 .publicY = pky_335
	 , .mLen = mLen335, 
	 .message = msg_335, 
	 .r = r_335, 
	 .s = s_335, 
	 .flag = result___335 
	}, 
	{ 
	 .publicX = pkx_336, 
	 .publicY = pky_336
	 , .mLen = mLen336, 
	 .message = msg_336, 
	 .r = r_336, 
	 .s = s_336, 
	 .flag = result___336 
	}, 
	{ 
	 .publicX = pkx_337, 
	 .publicY = pky_337
	 , .mLen = mLen337, 
	 .message = msg_337, 
	 .r = r_337, 
	 .s = s_337, 
	 .flag = result___337 
	}, 
	{ 
	 .publicX = pkx_338, 
	 .publicY = pky_338
	 , .mLen = mLen338, 
	 .message = msg_338, 
	 .r = r_338, 
	 .s = s_338, 
	 .flag = result___338 
	}, 
	{ 
	 .publicX = pkx_339, 
	 .publicY = pky_339
	 , .mLen = mLen339, 
	 .message = msg_339, 
	 .r = r_339, 
	 .s = s_339, 
	 .flag = result___339 
	}, 
	{ 
	 .publicX = pkx_340, 
	 .publicY = pky_340
	 , .mLen = mLen340, 
	 .message = msg_340, 
	 .r = r_340, 
	 .s = s_340, 
	 .flag = result___340 
	}, 
	{ 
	 .publicX = pkx_341, 
	 .publicY = pky_341
	 , .mLen = mLen341, 
	 .message = msg_341, 
	 .r = r_341, 
	 .s = s_341, 
	 .flag = result___341 
	}, 
	{ 
	 .publicX = pkx_342, 
	 .publicY = pky_342
	 , .mLen = mLen342, 
	 .message = msg_342, 
	 .r = r_342, 
	 .s = s_342, 
	 .flag = result___342 
	}, 
	{ 
	 .publicX = pkx_343, 
	 .publicY = pky_343
	 , .mLen = mLen343, 
	 .message = msg_343, 
	 .r = r_343, 
	 .s = s_343, 
	 .flag = result___343 
	}, 
	{ 
	 .publicX = pkx_344, 
	 .publicY = pky_344
	 , .mLen = mLen344, 
	 .message = msg_344, 
	 .r = r_344, 
	 .s = s_344, 
	 .flag = result___344 
	}, 
	{ 
	 .publicX = pkx_345, 
	 .publicY = pky_345
	 , .mLen = mLen345, 
	 .message = msg_345, 
	 .r = r_345, 
	 .s = s_345, 
	 .flag = result___345 
	}, 
	{ 
	 .publicX = pkx_346, 
	 .publicY = pky_346
	 , .mLen = mLen346, 
	 .message = msg_346, 
	 .r = r_346, 
	 .s = s_346, 
	 .flag = result___346 
	}, 
	{ 
	 .publicX = pkx_347, 
	 .publicY = pky_347
	 , .mLen = mLen347, 
	 .message = msg_347, 
	 .r = r_347, 
	 .s = s_347, 
	 .flag = result___347 
	}, 
	{ 
	 .publicX = pkx_348, 
	 .publicY = pky_348
	 , .mLen = mLen348, 
	 .message = msg_348, 
	 .r = r_348, 
	 .s = s_348, 
	 .flag = result___348 
	}, 
	{ 
	 .publicX = pkx_349, 
	 .publicY = pky_349
	 , .mLen = mLen349, 
	 .message = msg_349, 
	 .r = r_349, 
	 .s = s_349, 
	 .flag = result___349 
	}, 
	{ 
	 .publicX = pkx_350, 
	 .publicY = pky_350
	 , .mLen = mLen350, 
	 .message = msg_350, 
	 .r = r_350, 
	 .s = s_350, 
	 .flag = result___350 
	}, 
	{ 
	 .publicX = pkx_351, 
	 .publicY = pky_351
	 , .mLen = mLen351, 
	 .message = msg_351, 
	 .r = r_351, 
	 .s = s_351, 
	 .flag = result___351 
	}, 
	{ 
	 .publicX = pkx_352, 
	 .publicY = pky_352
	 , .mLen = mLen352, 
	 .message = msg_352, 
	 .r = r_352, 
	 .s = s_352, 
	 .flag = result___352 
	}, 
	{ 
	 .publicX = pkx_353, 
	 .publicY = pky_353
	 , .mLen = mLen353, 
	 .message = msg_353, 
	 .r = r_353, 
	 .s = s_353, 
	 .flag = result___353 
	}, 
	{ 
	 .publicX = pkx_354, 
	 .publicY = pky_354
	 , .mLen = mLen354, 
	 .message = msg_354, 
	 .r = r_354, 
	 .s = s_354, 
	 .flag = result___354 
	}, 
	{ 
	 .publicX = pkx_355, 
	 .publicY = pky_355
	 , .mLen = mLen355, 
	 .message = msg_355, 
	 .r = r_355, 
	 .s = s_355, 
	 .flag = result___355 
	}, 
	{ 
	 .publicX = pkx_356, 
	 .publicY = pky_356
	 , .mLen = mLen356, 
	 .message = msg_356, 
	 .r = r_356, 
	 .s = s_356, 
	 .flag = result___356 
	}, 
	{ 
	 .publicX = pkx_357, 
	 .publicY = pky_357
	 , .mLen = mLen357, 
	 .message = msg_357, 
	 .r = r_357, 
	 .s = s_357, 
	 .flag = result___357 
	}, 
	{ 
	 .publicX = pkx_358, 
	 .publicY = pky_358
	 , .mLen = mLen358, 
	 .message = msg_358, 
	 .r = r_358, 
	 .s = s_358, 
	 .flag = result___358 
	}, 
	{ 
	 .publicX = pkx_359, 
	 .publicY = pky_359
	 , .mLen = mLen359, 
	 .message = msg_359, 
	 .r = r_359, 
	 .s = s_359, 
	 .flag = result___359 
	}, 
	{ 
	 .publicX = pkx_360, 
	 .publicY = pky_360
	 , .mLen = mLen360, 
	 .message = msg_360, 
	 .r = r_360, 
	 .s = s_360, 
	 .flag = result___360 
	}, 
	{ 
	 .publicX = pkx_361, 
	 .publicY = pky_361
	 , .mLen = mLen361, 
	 .message = msg_361, 
	 .r = r_361, 
	 .s = s_361, 
	 .flag = result___361 
	}, 
	{ 
	 .publicX = pkx_362, 
	 .publicY = pky_362
	 , .mLen = mLen362, 
	 .message = msg_362, 
	 .r = r_362, 
	 .s = s_362, 
	 .flag = result___362 
	}, 
	{ 
	 .publicX = pkx_363, 
	 .publicY = pky_363
	 , .mLen = mLen363, 
	 .message = msg_363, 
	 .r = r_363, 
	 .s = s_363, 
	 .flag = result___363 
	}, 
	{ 
	 .publicX = pkx_364, 
	 .publicY = pky_364
	 , .mLen = mLen364, 
	 .message = msg_364, 
	 .r = r_364, 
	 .s = s_364, 
	 .flag = result___364 
	}, 
	{ 
	 .publicX = pkx_365, 
	 .publicY = pky_365
	 , .mLen = mLen365, 
	 .message = msg_365, 
	 .r = r_365, 
	 .s = s_365, 
	 .flag = result___365 
	}, 
	{ 
	 .publicX = pkx_366, 
	 .publicY = pky_366
	 , .mLen = mLen366, 
	 .message = msg_366, 
	 .r = r_366, 
	 .s = s_366, 
	 .flag = result___366 
	}, 
	{ 
	 .publicX = pkx_367, 
	 .publicY = pky_367
	 , .mLen = mLen367, 
	 .message = msg_367, 
	 .r = r_367, 
	 .s = s_367, 
	 .flag = result___367 
	}, 
	{ 
	 .publicX = pkx_368, 
	 .publicY = pky_368
	 , .mLen = mLen368, 
	 .message = msg_368, 
	 .r = r_368, 
	 .s = s_368, 
	 .flag = result___368 
	}, 
	{ 
	 .publicX = pkx_369, 
	 .publicY = pky_369
	 , .mLen = mLen369, 
	 .message = msg_369, 
	 .r = r_369, 
	 .s = s_369, 
	 .flag = result___369 
	}, 
	{ 
	 .publicX = pkx_370, 
	 .publicY = pky_370
	 , .mLen = mLen370, 
	 .message = msg_370, 
	 .r = r_370, 
	 .s = s_370, 
	 .flag = result___370 
	}, 
	{ 
	 .publicX = pkx_371, 
	 .publicY = pky_371
	 , .mLen = mLen371, 
	 .message = msg_371, 
	 .r = r_371, 
	 .s = s_371, 
	 .flag = result___371 
	}, 
	{ 
	 .publicX = pkx_372, 
	 .publicY = pky_372
	 , .mLen = mLen372, 
	 .message = msg_372, 
	 .r = r_372, 
	 .s = s_372, 
	 .flag = result___372 
	}, 
	{ 
	 .publicX = pkx_373, 
	 .publicY = pky_373
	 , .mLen = mLen373, 
	 .message = msg_373, 
	 .r = r_373, 
	 .s = s_373, 
	 .flag = result___373 
	}, 
	{ 
	 .publicX = pkx_374, 
	 .publicY = pky_374
	 , .mLen = mLen374, 
	 .message = msg_374, 
	 .r = r_374, 
	 .s = s_374, 
	 .flag = result___374 
	}, 
	{ 
	 .publicX = pkx_375, 
	 .publicY = pky_375
	 , .mLen = mLen375, 
	 .message = msg_375, 
	 .r = r_375, 
	 .s = s_375, 
	 .flag = result___375 
	}, 
	{ 
	 .publicX = pkx_376, 
	 .publicY = pky_376
	 , .mLen = mLen376, 
	 .message = msg_376, 
	 .r = r_376, 
	 .s = s_376, 
	 .flag = result___376 
	}, 
	{ 
	 .publicX = pkx_377, 
	 .publicY = pky_377
	 , .mLen = mLen377, 
	 .message = msg_377, 
	 .r = r_377, 
	 .s = s_377, 
	 .flag = result___377 
	}, 
	{ 
	 .publicX = pkx_378, 
	 .publicY = pky_378
	 , .mLen = mLen378, 
	 .message = msg_378, 
	 .r = r_378, 
	 .s = s_378, 
	 .flag = result___378 
	}, 
	{ 
	 .publicX = pkx_379, 
	 .publicY = pky_379
	 , .mLen = mLen379, 
	 .message = msg_379, 
	 .r = r_379, 
	 .s = s_379, 
	 .flag = result___379 
	}, 
	{ 
	 .publicX = pkx_380, 
	 .publicY = pky_380
	 , .mLen = mLen380, 
	 .message = msg_380, 
	 .r = r_380, 
	 .s = s_380, 
	 .flag = result___380 
	}, 
	{ 
	 .publicX = pkx_381, 
	 .publicY = pky_381
	 , .mLen = mLen381, 
	 .message = msg_381, 
	 .r = r_381, 
	 .s = s_381, 
	 .flag = result___381 
	}, 
	{ 
	 .publicX = pkx_382, 
	 .publicY = pky_382
	 , .mLen = mLen382, 
	 .message = msg_382, 
	 .r = r_382, 
	 .s = s_382, 
	 .flag = result___382 
	}, 
	{ 
	 .publicX = pkx_383, 
	 .publicY = pky_383
	 , .mLen = mLen383, 
	 .message = msg_383, 
	 .r = r_383, 
	 .s = s_383, 
	 .flag = result___383 
	}, 
	{ 
	 .publicX = pkx_384, 
	 .publicY = pky_384
	 , .mLen = mLen384, 
	 .message = msg_384, 
	 .r = r_384, 
	 .s = s_384, 
	 .flag = result___384 
	}, 
};