# Eventbus-rs

This crate provides event bus for Rust

## Example:

```rust
use eventbus_rs::{Subscriber, EventBus};
use async_trait::async_trait;
use std::any::Any;
// Create new topic
type Topic = ();
 
// Impl our subscriber
struct SimpleSubscriber;
#[async_trait]
impl Subscriber for SimpleSubscriber {
    async fn handle(&self, message: &(dyn Any + Send + Sync)) {}
}
async fn subscribe_and_publish() {
    // Create event bus
    let mut event_bus = EventBus::new().await;
    // Subscribe on our topic
    event_bus.subscribe::<Topic>(Box::new(SimpleSubscriber {})).await;
    // Publish event
    event_bus.publish::<Topic>(&"Hello".to_string()).await;
}
```
