pub mod controller;
pub mod service;
pub mod transform;
pub mod types;

pub const EAPI_VERSION: u16 = 1;

pub mod prelude {
    pub use crate::rpc_need_ready;
    pub use crate::service::block;
    pub use crate::service::handle_default_rpc;
    pub use crate::service::init_logs;
    pub use crate::service::mark_ready;
    pub use crate::service::mark_terminating;
    pub use crate::service::read_initial;
    pub use crate::service::safe_rpc_call;
    pub use crate::service::start_signal_handlers;
    pub use crate::service::svc_is_active;
    pub use crate::service::terminate;
    pub use elbus::client::AsyncClient;
    pub use elbus::rpc::{Rpc, RpcClient, RpcError, RpcEvent, RpcHandlers, RpcResult};
    pub use elbus::{Frame, QoS};
    pub use eva_common::services::Registry;
    pub use eva_common::services::{Initial, ServiceInfo, ServiceMethod};
    pub use eva_common::tools::ErrLogger;
    pub use eva_common::{EResult, Error};
    pub use log::{debug, error, info, trace, warn};
}
