use serde::{Deserialize, Serialize};

pub const PS_ITEM_STATE_TOPIC: &str = "ST/";
pub const PS_ITEM_BULK_STATE_TOPIC: &str = "STBULK/";
pub const PS_NODE_STATE_TOPIC: &str = "NODE/ST/";

#[derive(Deserialize, Serialize)]
#[serde(rename_all = "lowercase")]
#[repr(u8)]
pub enum NodeState {
    Running = 1,
    Terminating = 0xef,
}

#[derive(Deserialize, Serialize)]
pub struct PsNodeState {
    status: NodeState,
}

impl PsNodeState {
    #[inline]
    pub fn running() -> Self {
        Self {
            status: NodeState::Running,
        }
    }
    #[inline]
    pub fn terminating() -> Self {
        Self {
            status: NodeState::Terminating,
        }
    }
}
