use clap::Parser;
use eva::node::Mode;
use eva::tools::ErrLogger;
use eva::{AUTHOR, PRODUCT_NAME, VERSION};

#[derive(Parser)]
#[clap(name = PRODUCT_NAME, version = VERSION, author = AUTHOR)]
struct Opts {
    #[clap(long = "mode", help = "registry-only mode", default_value = "normal")]
    mode: Mode,
}

#[cfg(not(feature = "std-alloc"))]
#[global_allocator]
static ALLOC: jemallocator::Jemalloc = jemallocator::Jemalloc;

fn main() {
    let opts = Opts::parse();
    eva::node::run(opts.mode).log_err().unwrap();
}
