CREATE DOMAIN i8 AS INT2 CHECK (-128 <= value AND value < 128);
CREATE DOMAIN u8 AS INT2 CHECK (0 <= value AND value < 256);
CREATE DOMAIN i16 AS INT2;
CREATE DOMAIN u16 AS INT4 CHECK (0 <= value AND value < 65536);
CREATE DOMAIN i32 AS INT4;
CREATE DOMAIN u32 AS INT8 CHECK (0 <= value AND value < 4294967296);
CREATE DOMAIN i64 AS INT8;

CREATE DOMAIN instant AS TIMESTAMP(3) WITH TIME ZONE;

CREATE DOMAIN buffer_id AS VARCHAR(32) CHECK (value ~ '^[0-9a-f]{32}$');
CREATE DOMAIN blob_id AS UUID;
CREATE DOMAIN upload_session_id AS UUID;
CREATE DOMAIN media_type AS VARCHAR(201) CHECK (value ~ '^[0-9a-z.-]{1,100}/[0-9a-z.-]{1,100}$');

ALTER TABLE blobs
  ALTER COLUMN blob_id TYPE BLOB_ID,
  ALTER COLUMN media_type TYPE MEDIA_TYPE,
  ALTER COLUMN byte_size TYPE U32,
  ALTER COLUMN created_at TYPE INSTANT,
  ALTER COLUMN updated_at TYPE INSTANT;

ALTER TABLE upload_sessions
  ALTER COLUMN upload_session_id TYPE UPLOAD_SESSION_ID,
  ALTER COLUMN media_type TYPE MEDIA_TYPE,
  ALTER COLUMN byte_size TYPE U32,
  ALTER COLUMN written_bytes TYPE U32,
  ALTER COLUMN created_at TYPE INSTANT,
  ALTER COLUMN updated_at TYPE INSTANT,
  ALTER COLUMN buffer_id TYPE BUFFER_ID,
  ALTER COLUMN blob_id TYPE BLOB_ID;

CREATE DOMAIN USER_ID AS UUID;
CREATE DOMAIN user_display_name AS VARCHAR(64);

CREATE DOMAIN DRIVE_ID AS UUID;
CREATE DOMAIN FILE_ID AS UUID;
CREATE DOMAIN DIRECTORY_ID AS UUID;
CREATE DOMAIN DRIVE_ITEM_ID AS UUID;
CREATE DOMAIN DRIVE_ITEM_DISPLAY_NAME AS VARCHAR(64);

CREATE DOMAIN SESSION_ID AS UUID;
