use anyhow::Result;
use clap::ArgEnum;
use metaquery::Dialect;
pub use metaquery::SqlType;
pub(crate) use metaquery::Statement;

#[derive(Debug, Clone, Copy, ArgEnum)]
pub enum SqlDialect {
    Ansi,
    Clickhouse,
    Generic,
    Hive,
    Mssql,
    Mysql,
    Postgres,
    Sqlite,
    Snowflake,
}

impl SqlDialect {
    fn metaquery_dialect(&self) -> Dialect {
        match self {
            Self::Ansi => Dialect::Ansi,
            Self::Clickhouse => Dialect::Clickhouse,
            Self::Generic => Dialect::Generic,
            Self::Hive => Dialect::Hive,
            Self::Mssql => Dialect::Mssql,
            Self::Mysql => Dialect::Mysql,
            Self::Postgres => Dialect::Postgres,
            Self::Sqlite => Dialect::Sqlite,
            Self::Snowflake => Dialect::Snowflake,
        }
    }
}

pub(crate) fn parse_statements(sql: &str, dialect: SqlDialect) -> Result<Vec<Statement>> {
    metaquery::parse_statements(sql, dialect.metaquery_dialect()).map_err(|err| err.into())
}
