# esquel

Create [mermaid](https://mermaid.live/) diagrams from SQL scripts.

```sh
USAGE:
    esquel [OPTIONS] --input <INPUT>

OPTIONS:
    -d, --dialect <DIALECT>    [default: generic] [possible values: ansi, clickhouse, generic, hive,
                               mssql, mysql, postgres, sqlite, snowflake]
    -f, --flow <FLOW>          Direction of the flowchart [default: tb] [possible values: tb, bt,
                               rl, lr]
    -h, --help                 Print help information
    -i, --input <INPUT>        Path to sql script or raw sql
        --no-icons             Do not show icons
    -o, --out <OUT>            Path to output file
    -V, --version              Print version information
```

Uses all **CREATE**, **INSERT**, **DELETE** and **UPDATE** statements that reference other tables.

## Example

The following SQL script

```sql
create table foo as
select * from bar;

create view baz as
select * from foo
inner join qux;

delete from foo
where exists (
  select 1 from qux
  where qux.foo_id = foo.foo_id
);
```

generates this flowchart:

```mermaid
graph TB
    A[bar]
    B[fa:fa-eye baz]
    C[fa:fa-table foo]
    D[qux]
    A --> C
    C --> B
    D --> B
    D --> C
```

## Installation

```sh
cargo install esquel
```
