pub const KEYWORDS: &[&str] = &[
    "abs",
    "abstract",
    "acos",
    "aggregate",
    "alias",
    "and",
    "andor",
    "array",
    "as",
    "asin",
    "atan",
    "bag",
    "based",
    "based_on",
    "begin",
    "binary",
    "blength",
    "boolean",
    "by",
    "case",
    "const_e",
    "constant",
    "constraint",
    "cos",
    "derive",
    "div",
    "else",
    "end",
    "end_alias",
    "end_case",
    "end_constant",
    "end_entity",
    "end_function",
    "end_if",
    "end_local",
    "end_procedure",
    "end_repeat",
    "end_rule",
    "end_schema",
    "end_subtype_constraint",
    "end_type",
    "entity",
    "enumeration",
    "escape",
    "exists",
    "exp",
    "extensible",
    "false",
    "fixed",
    "for",
    "format",
    "from",
    "function",
    "generic",
    "generic_entity",
    "hibound",
    "hiindex",
    "if",
    "in",
    "insert",
    "integer",
    "inverse",
    "length",
    "like",
    "list",
    "lobound",
    "local",
    "log",
    "log10",
    "log2",
    "logical",
    "loindex",
    "mod",
    "not",
    "number",
    "nvl",
    "odd",
    "of",
    "on",
    "oneof",
    "optional",
    "or",
    "otherwise",
    "pi",
    "procedure",
    "query",
    "real",
    "reference",
    "remove",
    "renamed",
    "repeat",
    "return",
    "rolesof",
    "rule",
    "schema",
    "select",
    "self",
    "set",
    "sin",
    "sizeof",
    "skip",
    "sqrt",
    "string",
    "subtype",
    "subtype_constraint",
    "supertype",
    "tan",
    "then",
    "to",
    "total_over",
    "true",
    "type",
    "typeof",
    "unique",
    "unknown",
    "until",
    "use",
    "usedin",
    "value",
    "value_in",
    "value_unique",
    "var",
    "where",
    "while",
    "with",
    "xor",
];

pub fn is_reserved(input: &str) -> bool {
    KEYWORDS
        .iter()
        .any(|&keyword| keyword == input.to_lowercase())
}

#[cfg(test)]
mod tests {
    #[test]
    fn is_reserved() {
        assert!(super::is_reserved("end"));
        assert!(!super::is_reserved(""));
        assert!(super::is_reserved("end_entity"));
        assert!(super::is_reserved("END_ENTITY"));
        assert!(!super::is_reserved("end_homhom"));
    }
}
