/*
 * Blockstream Esplora HTTP API
 *
 * JSON over RESTful HTTP. Amounts are always represented in satoshis.
 *
 * The version of the OpenAPI document: 1.0.1
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
pub struct Transaction {
    #[serde(rename = "txid")]
    pub txid: String,
    #[serde(rename = "version")]
    pub version: f32,
    #[serde(rename = "locktime", skip_serializing_if = "Option::is_none")]
    pub locktime: Option<f32>,
    #[serde(rename = "vin", skip_serializing_if = "Option::is_none")]
    pub vin: Option<Vec<crate::models::Vin>>,
    #[serde(rename = "vout", skip_serializing_if = "Option::is_none")]
    pub vout: Option<Vec<crate::models::VOut>>,
    #[serde(rename = "size", skip_serializing_if = "Option::is_none")]
    pub size: Option<f32>,
    #[serde(rename = "weight", skip_serializing_if = "Option::is_none")]
    pub weight: Option<f32>,
    #[serde(rename = "fee", skip_serializing_if = "Option::is_none")]
    pub fee: Option<f32>,
    #[serde(rename = "status", skip_serializing_if = "Option::is_none")]
    pub status: Option<Box<crate::models::Status>>,
}

impl Transaction {
    pub fn new(txid: String, version: f32) -> Transaction {
        Transaction {
            txid,
            version,
            locktime: None,
            vin: None,
            vout: None,
            size: None,
            weight: None,
            fee: None,
            status: None,
        }
    }
}


