/*
 * Blockstream Esplora HTTP API
 *
 * JSON over RESTful HTTP. Amounts are always represented in satoshis.
 *
 * The version of the OpenAPI document: 1.0.1
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};


/// struct for typed errors of method `get_recent_txs_by_scripthash`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetRecentTxsByScripthashError {
    DefaultResponse(Vec<crate::models::Transaction>),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `get_txs_before_txid_by_scripthash`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTxsBeforeTxidByScripthashError {
    DefaultResponse(Vec<crate::models::Transaction>),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method `get_txs_by_scripthash`
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GetTxsByScripthashError {
    DefaultResponse(Vec<crate::models::Transaction>),
    UnknownValue(serde_json::Value),
}


pub async fn get_recent_txs_by_scripthash(configuration: &configuration::Configuration, hash: &str) -> Result<Vec<crate::models::Transaction>, Error<GetRecentTxsByScripthashError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/scripthash/{hash}/txs/chain", configuration.base_path, hash=crate::apis::urlencode(hash));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetRecentTxsByScripthashError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

pub async fn get_txs_before_txid_by_scripthash(configuration: &configuration::Configuration, hash: &str, last_seen_txid: &str) -> Result<Vec<crate::models::Transaction>, Error<GetTxsBeforeTxidByScripthashError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/scripthash/{hash}/txs/chain/{lastSeenTxid}", configuration.base_path, hash=crate::apis::urlencode(hash), lastSeenTxid=crate::apis::urlencode(last_seen_txid));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTxsBeforeTxidByScripthashError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

pub async fn get_txs_by_scripthash(configuration: &configuration::Configuration, hash: &str) -> Result<Vec<crate::models::Transaction>, Error<GetTxsByScripthashError>> {

    let local_var_client = &configuration.client;

    let local_var_uri_str = format!("{}/scripthash/{hash}/txs", configuration.base_path, hash=crate::apis::urlencode(hash));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GetTxsByScripthashError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

