# \TxApi

All URIs are relative to *https://blockstream.info/api*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_all_tx_outspends**](TxApi.md#get_all_tx_outspends) | **GET** /tx/{txId}/outspends | Returns the spending status of all transaction outputs.
[**get_tx**](TxApi.md#get_tx) | **GET** /tx/{txId} | Returns information about the transaction.
[**get_tx_hex**](TxApi.md#get_tx_hex) | **GET** /tx/{txId}/hex | Returns the raw transaction in hex.
[**get_tx_merkle_block_proof**](TxApi.md#get_tx_merkle_block_proof) | **GET** /tx/{txId}/merkleblock-proof | Returns a merkle inclusion proof for the transaction using bitcoind's merkleblock format.
[**get_tx_merkle_proof**](TxApi.md#get_tx_merkle_proof) | **GET** /tx/{txId}/merkle-proof | Returns a merkle inclusion proof for the transaction using Electrum's blockchain.transaction.get_merkle format.
[**get_tx_outspend**](TxApi.md#get_tx_outspend) | **GET** /tx/{txId}/outspend/{vout} | Returns the spending status of a transaction output.
[**get_tx_raw**](TxApi.md#get_tx_raw) | **GET** /tx/{txId}/raw | Returns the raw transaction as binary data.
[**get_tx_status**](TxApi.md#get_tx_status) | **GET** /tx/{txId}/status | Returns the transaction confirmation status.
[**post_tx**](TxApi.md#post_tx) | **POST** /tx | Broadcast a raw transaction to the network.



## get_all_tx_outspends

> Vec<crate::models::Spend> get_all_tx_outspends(tx_id)
Returns the spending status of all transaction outputs.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**tx_id** | **String** |  | [required] |

### Return type

[**Vec<crate::models::Spend>**](Spend.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_tx

> crate::models::Transaction get_tx(tx_id)
Returns information about the transaction.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**tx_id** | **String** |  | [required] |

### Return type

[**crate::models::Transaction**](Transaction.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_tx_hex

> String get_tx_hex(tx_id)
Returns the raw transaction in hex.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**tx_id** | **String** |  | [required] |

### Return type

**String**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_tx_merkle_block_proof

> String get_tx_merkle_block_proof(tx_id)
Returns a merkle inclusion proof for the transaction using bitcoind's merkleblock format.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**tx_id** | **String** |  | [required] |

### Return type

**String**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_tx_merkle_proof

> crate::models::InlineResponseDefault get_tx_merkle_proof(tx_id)
Returns a merkle inclusion proof for the transaction using Electrum's blockchain.transaction.get_merkle format.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**tx_id** | **String** |  | [required] |

### Return type

[**crate::models::InlineResponseDefault**](inline_response_default.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: text/plain

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_tx_outspend

> crate::models::Spend get_tx_outspend(tx_id, vout)
Returns the spending status of a transaction output.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**tx_id** | **String** |  | [required] |
**vout** | **f32** |  | [required] |

### Return type

[**crate::models::Spend**](Spend.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_tx_raw

> std::path::PathBuf get_tx_raw(tx_id)
Returns the raw transaction as binary data.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**tx_id** | **String** |  | [required] |

### Return type

[**std::path::PathBuf**](std::path::PathBuf.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/octet-stream

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_tx_status

> crate::models::Status get_tx_status(tx_id)
Returns the transaction confirmation status.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**tx_id** | **String** |  | [required] |

### Return type

[**crate::models::Status**](Status.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## post_tx

> String post_tx(body)
Broadcast a raw transaction to the network.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**body** | **String** | The transaction should be provided as hex in the request body. | [required] |

### Return type

**String**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: text/plain
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

