# \ScripthashApi

All URIs are relative to *https://blockstream.info/api*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_recent_txs_by_scripthash**](ScripthashApi.md#get_recent_txs_by_scripthash) | **GET** /scripthash/{hash}/txs/chain | Get confirmed transaction history for the specified address/scripthash, sorted by newest first.
[**get_txs_before_txid_by_scripthash**](ScripthashApi.md#get_txs_before_txid_by_scripthash) | **GET** /scripthash/{hash}/txs/chain/{lastSeenTxid} | Get confirmed transaction history for the specified address/scripthash, sorted by newest first.
[**get_txs_by_scripthash**](ScripthashApi.md#get_txs_by_scripthash) | **GET** /scripthash/{hash}/txs | Get transaction history for the specified address/scripthash, sorted with newest first. Can be used to query by op_return



## get_recent_txs_by_scripthash

> Vec<crate::models::Transaction> get_recent_txs_by_scripthash(hash)
Get confirmed transaction history for the specified address/scripthash, sorted by newest first.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**hash** | **String** |  | [required] |

### Return type

[**Vec<crate::models::Transaction>**](Transaction.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_txs_before_txid_by_scripthash

> Vec<crate::models::Transaction> get_txs_before_txid_by_scripthash(hash, last_seen_txid)
Get confirmed transaction history for the specified address/scripthash, sorted by newest first.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**hash** | **String** |  | [required] |
**last_seen_txid** | **String** |  | [required] |

### Return type

[**Vec<crate::models::Transaction>**](Transaction.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_txs_by_scripthash

> Vec<crate::models::Transaction> get_txs_by_scripthash(hash)
Get transaction history for the specified address/scripthash, sorted with newest first. Can be used to query by op_return

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**hash** | **String** |  | [required] |

### Return type

[**Vec<crate::models::Transaction>**](Transaction.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

