# \BlockApi

All URIs are relative to *https://blockstream.info/api*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_block**](BlockApi.md#get_block) | **GET** /block/{hash} | Returns information about a block.
[**get_block_at_height**](BlockApi.md#get_block_at_height) | **GET** /block-height/{height} | Returns the hash of the block currently at height.
[**get_block_header**](BlockApi.md#get_block_header) | **GET** /block/{hash}/header | Returns the hex-encoded block header.
[**get_block_raw**](BlockApi.md#get_block_raw) | **GET** /block/{hash}/raw | Returns the raw block representation in binary.
[**get_block_status**](BlockApi.md#get_block_status) | **GET** /block/{hash}/status | Returns the block status.
[**get_block_tx_by_index**](BlockApi.md#get_block_tx_by_index) | **GET** /block/{hash}/txid/{index} | Returns the transaction at index :index within the specified block.
[**get_block_txids**](BlockApi.md#get_block_txids) | **GET** /block/{hash}/txids | Returns a list of all txids in the block.
[**get_last_block_hash**](BlockApi.md#get_last_block_hash) | **GET** /blocks/tip/hash | Returns the hash of the last block.
[**get_last_block_height**](BlockApi.md#get_last_block_height) | **GET** /blocks/tip/height | Returns the height of the last block.



## get_block

> crate::models::InlineResponseDefault2 get_block(hash)
Returns information about a block.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**hash** | **String** |  | [required] |

### Return type

[**crate::models::InlineResponseDefault2**](inline_response_default_2.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_block_at_height

> String get_block_at_height(height)
Returns the hash of the block currently at height.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**height** | **f32** |  | [required] |

### Return type

**String**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_block_header

> String get_block_header(hash)
Returns the hex-encoded block header.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**hash** | **String** |  | [required] |

### Return type

**String**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_block_raw

> std::path::PathBuf get_block_raw(hash)
Returns the raw block representation in binary.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**hash** | **String** |  | [required] |

### Return type

[**std::path::PathBuf**](std::path::PathBuf.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/octet-stream

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_block_status

> crate::models::InlineResponseDefault3 get_block_status(hash)
Returns the block status.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**hash** | **String** |  | [required] |

### Return type

[**crate::models::InlineResponseDefault3**](inline_response_default_3.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_block_tx_by_index

> String get_block_tx_by_index(hash, index)
Returns the transaction at index :index within the specified block.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**hash** | **String** |  | [required] |
**index** | **f32** |  | [required] |

### Return type

**String**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_block_txids

> Vec<String> get_block_txids(hash)
Returns a list of all txids in the block.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**hash** | **String** |  | [required] |

### Return type

**Vec<String>**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_last_block_hash

> String get_last_block_hash()
Returns the hash of the last block.

### Parameters

This endpoint does not need any parameter.

### Return type

**String**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_last_block_height

> f32 get_last_block_height()
Returns the height of the last block.

### Parameters

This endpoint does not need any parameter.

### Return type

**f32**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

