# \AddressApi

All URIs are relative to *https://blockstream.info/api*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_address**](AddressApi.md#get_address) | **GET** /address/{address} | Get information about an address.
[**get_address_tx_history**](AddressApi.md#get_address_tx_history) | **GET** /address/{address}/txs | Get transaction history for the specified address, sorted with newest first.
[**get_address_tx_mempool**](AddressApi.md#get_address_tx_mempool) | **GET** /address/{address}/txs/mempool | Get unconfirmed transaction history for the specified address.
[**get_address_utxo**](AddressApi.md#get_address_utxo) | **GET** /address/{address}/utxo | Get the list of unspent transaction outputs associated with the address.



## get_address

> crate::models::InlineResponseDefault1 get_address(address)
Get information about an address.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**address** | **String** |  | [required] |

### Return type

[**crate::models::InlineResponseDefault1**](inline_response_default_1.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_address_tx_history

> Vec<crate::models::Transaction> get_address_tx_history(address)
Get transaction history for the specified address, sorted with newest first.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**address** | **String** |  | [required] |

### Return type

[**Vec<crate::models::Transaction>**](Transaction.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_address_tx_mempool

> Vec<crate::models::Transaction> get_address_tx_mempool(address)
Get unconfirmed transaction history for the specified address.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**address** | **String** |  | [required] |

### Return type

[**Vec<crate::models::Transaction>**](Transaction.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_address_utxo

> Vec<crate::models::Utxo> get_address_utxo(address)
Get the list of unspent transaction outputs associated with the address.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**address** | **String** |  | [required] |

### Return type

[**Vec<crate::models::Utxo>**](UTXO.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

