# Rust API client for esplora-btc-api

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.RustClientCodegen

## Installation

Put the package under your project folder and add the following to `Cargo.toml` under `[dependencies]`:

```
    openapi = { path = "./generated" }
```

## Documentation for API Endpoints

All URIs are relative to *https://blockstream.info/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AddressApi* | [**get_address**](docs/AddressApi.md#get_address) | **GET** /address/{address} | Get information about an address.
*AddressApi* | [**get_address_tx_history**](docs/AddressApi.md#get_address_tx_history) | **GET** /address/{address}/txs | Get transaction history for the specified address, sorted with newest first.
*AddressApi* | [**get_address_tx_mempool**](docs/AddressApi.md#get_address_tx_mempool) | **GET** /address/{address}/txs/mempool | Get unconfirmed transaction history for the specified address.
*AddressApi* | [**get_address_utxo**](docs/AddressApi.md#get_address_utxo) | **GET** /address/{address}/utxo | Get the list of unspent transaction outputs associated with the address.
*BlockApi* | [**get_block**](docs/BlockApi.md#get_block) | **GET** /block/{hash} | Returns information about a block.
*BlockApi* | [**get_block_at_height**](docs/BlockApi.md#get_block_at_height) | **GET** /block-height/{height} | Returns the hash of the block currently at height.
*BlockApi* | [**get_block_header**](docs/BlockApi.md#get_block_header) | **GET** /block/{hash}/header | Returns the hex-encoded block header.
*BlockApi* | [**get_block_raw**](docs/BlockApi.md#get_block_raw) | **GET** /block/{hash}/raw | Returns the raw block representation in binary.
*BlockApi* | [**get_block_status**](docs/BlockApi.md#get_block_status) | **GET** /block/{hash}/status | Returns the block status.
*BlockApi* | [**get_block_tx_by_index**](docs/BlockApi.md#get_block_tx_by_index) | **GET** /block/{hash}/txid/{index} | Returns the transaction at index :index within the specified block.
*BlockApi* | [**get_block_txids**](docs/BlockApi.md#get_block_txids) | **GET** /block/{hash}/txids | Returns a list of all txids in the block.
*BlockApi* | [**get_last_block_hash**](docs/BlockApi.md#get_last_block_hash) | **GET** /blocks/tip/hash | Returns the hash of the last block.
*BlockApi* | [**get_last_block_height**](docs/BlockApi.md#get_last_block_height) | **GET** /blocks/tip/height | Returns the height of the last block.
*FeeEstimatesApi* | [**get_fee_estimates**](docs/FeeEstimatesApi.md#get_fee_estimates) | **GET** /fee-estimates | Get an object where the key is the confirmation target (in number of blocks) and the value is the estimated feerate (in sat/vB).
*MempoolApi* | [**get_mempool**](docs/MempoolApi.md#get_mempool) | **GET** /mempool | Get mempool backlog statistics.
*MempoolApi* | [**get_mempool_recent**](docs/MempoolApi.md#get_mempool_recent) | **GET** /mempool/recent | Get a list of the last 10 transactions to enter the mempool.
*MempoolApi* | [**get_mempool_txids**](docs/MempoolApi.md#get_mempool_txids) | **GET** /mempool/txids | Get the full list of txids in the mempool as an array.
*ScripthashApi* | [**get_recent_txs_by_scripthash**](docs/ScripthashApi.md#get_recent_txs_by_scripthash) | **GET** /scripthash/{hash}/txs/chain | Get confirmed transaction history for the specified address/scripthash, sorted by newest first.
*ScripthashApi* | [**get_txs_before_txid_by_scripthash**](docs/ScripthashApi.md#get_txs_before_txid_by_scripthash) | **GET** /scripthash/{hash}/txs/chain/{lastSeenTxid} | Get confirmed transaction history for the specified address/scripthash, sorted by newest first.
*ScripthashApi* | [**get_txs_by_scripthash**](docs/ScripthashApi.md#get_txs_by_scripthash) | **GET** /scripthash/{hash}/txs | Get transaction history for the specified address/scripthash, sorted with newest first. Can be used to query by op_return
*TxApi* | [**get_all_tx_outspends**](docs/TxApi.md#get_all_tx_outspends) | **GET** /tx/{txId}/outspends | Returns the spending status of all transaction outputs.
*TxApi* | [**get_tx**](docs/TxApi.md#get_tx) | **GET** /tx/{txId} | Returns information about the transaction.
*TxApi* | [**get_tx_hex**](docs/TxApi.md#get_tx_hex) | **GET** /tx/{txId}/hex | Returns the raw transaction in hex.
*TxApi* | [**get_tx_merkle_block_proof**](docs/TxApi.md#get_tx_merkle_block_proof) | **GET** /tx/{txId}/merkleblock-proof | Returns a merkle inclusion proof for the transaction using bitcoind's merkleblock format.
*TxApi* | [**get_tx_merkle_proof**](docs/TxApi.md#get_tx_merkle_proof) | **GET** /tx/{txId}/merkle-proof | Returns a merkle inclusion proof for the transaction using Electrum's blockchain.transaction.get_merkle format.
*TxApi* | [**get_tx_outspend**](docs/TxApi.md#get_tx_outspend) | **GET** /tx/{txId}/outspend/{vout} | Returns the spending status of a transaction output.
*TxApi* | [**get_tx_raw**](docs/TxApi.md#get_tx_raw) | **GET** /tx/{txId}/raw | Returns the raw transaction as binary data.
*TxApi* | [**get_tx_status**](docs/TxApi.md#get_tx_status) | **GET** /tx/{txId}/status | Returns the transaction confirmation status.
*TxApi* | [**post_tx**](docs/TxApi.md#post_tx) | **POST** /tx | Broadcast a raw transaction to the network.


## Documentation For Models

 - [InlineResponseDefault](docs/InlineResponseDefault.md)
 - [InlineResponseDefault1](docs/InlineResponseDefault1.md)
 - [InlineResponseDefault1ChainStats](docs/InlineResponseDefault1ChainStats.md)
 - [InlineResponseDefault2](docs/InlineResponseDefault2.md)
 - [InlineResponseDefault3](docs/InlineResponseDefault3.md)
 - [InlineResponseDefault4](docs/InlineResponseDefault4.md)
 - [Mempool](docs/Mempool.md)
 - [Spend](docs/Spend.md)
 - [Status](docs/Status.md)
 - [Transaction](docs/Transaction.md)
 - [Utxo](docs/Utxo.md)
 - [VOut](docs/VOut.md)
 - [Vin](docs/Vin.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author



