#[doc = "Register `SPI_CTRL` reader"]
pub struct R(crate::R<SPI_CTRL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_CTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPI_CTRL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPI_CTRL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_CTRL` writer"]
pub struct W(crate::W<SPI_CTRL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_CTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPI_CTRL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPI_CTRL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `spi_wr_bit_order` reader - In \"command\", \"address\", \"write-data\" (MOSI) phases, 1: LSB first; 0: MSB first"]
pub struct SPI_WR_BIT_ORDER_R(crate::FieldReader<bool, bool>);
impl SPI_WR_BIT_ORDER_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_WR_BIT_ORDER_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_WR_BIT_ORDER_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_wr_bit_order` writer - In \"command\", \"address\", \"write-data\" (MOSI) phases, 1: LSB first; 0: MSB first"]
pub struct SPI_WR_BIT_ORDER_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_WR_BIT_ORDER_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 26)) | ((value as u32 & 1) << 26);
        self.w
    }
}
#[doc = "Field `spi_rd_bit_order` reader - In \"read-data\" (MISO) phase, 1: LSB first; 0: MSB first"]
pub struct SPI_RD_BIT_ORDER_R(crate::FieldReader<bool, bool>);
impl SPI_RD_BIT_ORDER_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_RD_BIT_ORDER_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_RD_BIT_ORDER_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_rd_bit_order` writer - In \"read-data\" (MISO) phase, 1: LSB first; 0: MSB first"]
pub struct SPI_RD_BIT_ORDER_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_RD_BIT_ORDER_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 25)) | ((value as u32 & 1) << 25);
        self.w
    }
}
#[doc = "Field `spi_qio_mode` reader - In the read operations, \"address\" phase and \"read-data\" phase apply 4 signals"]
pub struct SPI_QIO_MODE_R(crate::FieldReader<bool, bool>);
impl SPI_QIO_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_QIO_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_QIO_MODE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_qio_mode` writer - In the read operations, \"address\" phase and \"read-data\" phase apply 4 signals"]
pub struct SPI_QIO_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_QIO_MODE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 24)) | ((value as u32 & 1) << 24);
        self.w
    }
}
#[doc = "Field `spi_dio_mode` reader - In the read operations, \"address\" phase and \"read-data\" phase apply 2 signals"]
pub struct SPI_DIO_MODE_R(crate::FieldReader<bool, bool>);
impl SPI_DIO_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_DIO_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_DIO_MODE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_dio_mode` writer - In the read operations, \"address\" phase and \"read-data\" phase apply 2 signals"]
pub struct SPI_DIO_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_DIO_MODE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 23)) | ((value as u32 & 1) << 23);
        self.w
    }
}
#[doc = "Field `spi_qout_mode` reader - In the read operations, \"read-data\" phase apply 4 signals"]
pub struct SPI_QOUT_MODE_R(crate::FieldReader<bool, bool>);
impl SPI_QOUT_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_QOUT_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_QOUT_MODE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_qout_mode` writer - In the read operations, \"read-data\" phase apply 4 signals"]
pub struct SPI_QOUT_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_QOUT_MODE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 20)) | ((value as u32 & 1) << 20);
        self.w
    }
}
#[doc = "Field `spi_dout_mode` reader - In the read operations, \"read-data\" phase apply 2 signals"]
pub struct SPI_DOUT_MODE_R(crate::FieldReader<bool, bool>);
impl SPI_DOUT_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_DOUT_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_DOUT_MODE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_dout_mode` writer - In the read operations, \"read-data\" phase apply 2 signals"]
pub struct SPI_DOUT_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_DOUT_MODE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 14)) | ((value as u32 & 1) << 14);
        self.w
    }
}
#[doc = "Field `spi_fastrd_mode` reader - this bit enable the bits: spi_qio_mode, spi_dio_mode, spi_qout_mode and spi_dout_mode"]
pub struct SPI_FASTRD_MODE_R(crate::FieldReader<bool, bool>);
impl SPI_FASTRD_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_FASTRD_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_FASTRD_MODE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_fastrd_mode` writer - this bit enable the bits: spi_qio_mode, spi_dio_mode, spi_qout_mode and spi_dout_mode"]
pub struct SPI_FASTRD_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_FASTRD_MODE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 13)) | ((value as u32 & 1) << 13);
        self.w
    }
}
#[doc = "Field `two_byte_status` reader - Enable two byte status"]
pub struct TWO_BYTE_STATUS_R(crate::FieldReader<bool, bool>);
impl TWO_BYTE_STATUS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TWO_BYTE_STATUS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWO_BYTE_STATUS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `two_byte_status` writer - Enable two byte status"]
pub struct TWO_BYTE_STATUS_W<'a> {
    w: &'a mut W,
}
impl<'a> TWO_BYTE_STATUS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 22)) | ((value as u32 & 1) << 22);
        self.w
    }
}
#[doc = "Field `wp_reg` reader - Write protect?"]
pub struct WP_REG_R(crate::FieldReader<bool, bool>);
impl WP_REG_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        WP_REG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WP_REG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `wp_reg` writer - Write protect?"]
pub struct WP_REG_W<'a> {
    w: &'a mut W,
}
impl<'a> WP_REG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 21)) | ((value as u32 & 1) << 21);
        self.w
    }
}
#[doc = "Field `share_but` reader - Share bus"]
pub struct SHARE_BUT_R(crate::FieldReader<bool, bool>);
impl SHARE_BUT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SHARE_BUT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SHARE_BUT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `share_but` writer - Share bus"]
pub struct SHARE_BUT_W<'a> {
    w: &'a mut W,
}
impl<'a> SHARE_BUT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 19)) | ((value as u32 & 1) << 19);
        self.w
    }
}
#[doc = "Field `hold_mode` reader - Hold mode"]
pub struct HOLD_MODE_R(crate::FieldReader<bool, bool>);
impl HOLD_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HOLD_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HOLD_MODE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `hold_mode` writer - Hold mode"]
pub struct HOLD_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> HOLD_MODE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 18)) | ((value as u32 & 1) << 18);
        self.w
    }
}
#[doc = "Field `enable_ahb` reader - Enable AHB"]
pub struct ENABLE_AHB_R(crate::FieldReader<bool, bool>);
impl ENABLE_AHB_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ENABLE_AHB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENABLE_AHB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `enable_ahb` writer - Enable AHB"]
pub struct ENABLE_AHB_W<'a> {
    w: &'a mut W,
}
impl<'a> ENABLE_AHB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 17)) | ((value as u32 & 1) << 17);
        self.w
    }
}
#[doc = "Field `sst_aai` reader - SST_AAI?"]
pub struct SST_AAI_R(crate::FieldReader<bool, bool>);
impl SST_AAI_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SST_AAI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SST_AAI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `sst_aai` writer - SST_AAI?"]
pub struct SST_AAI_W<'a> {
    w: &'a mut W,
}
impl<'a> SST_AAI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 16)) | ((value as u32 & 1) << 16);
        self.w
    }
}
#[doc = "Field `res_and_res` reader - 'Res and res'?"]
pub struct RES_AND_RES_R(crate::FieldReader<bool, bool>);
impl RES_AND_RES_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RES_AND_RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RES_AND_RES_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `res_and_res` writer - 'Res and res'?"]
pub struct RES_AND_RES_W<'a> {
    w: &'a mut W,
}
impl<'a> RES_AND_RES_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 15)) | ((value as u32 & 1) << 15);
        self.w
    }
}
impl R {
    #[doc = "Bit 26 - In \"command\", \"address\", \"write-data\" (MOSI) phases, 1: LSB first; 0: MSB first"]
    #[inline(always)]
    pub fn spi_wr_bit_order(&self) -> SPI_WR_BIT_ORDER_R {
        SPI_WR_BIT_ORDER_R::new(((self.bits >> 26) & 1) != 0)
    }
    #[doc = "Bit 25 - In \"read-data\" (MISO) phase, 1: LSB first; 0: MSB first"]
    #[inline(always)]
    pub fn spi_rd_bit_order(&self) -> SPI_RD_BIT_ORDER_R {
        SPI_RD_BIT_ORDER_R::new(((self.bits >> 25) & 1) != 0)
    }
    #[doc = "Bit 24 - In the read operations, \"address\" phase and \"read-data\" phase apply 4 signals"]
    #[inline(always)]
    pub fn spi_qio_mode(&self) -> SPI_QIO_MODE_R {
        SPI_QIO_MODE_R::new(((self.bits >> 24) & 1) != 0)
    }
    #[doc = "Bit 23 - In the read operations, \"address\" phase and \"read-data\" phase apply 2 signals"]
    #[inline(always)]
    pub fn spi_dio_mode(&self) -> SPI_DIO_MODE_R {
        SPI_DIO_MODE_R::new(((self.bits >> 23) & 1) != 0)
    }
    #[doc = "Bit 20 - In the read operations, \"read-data\" phase apply 4 signals"]
    #[inline(always)]
    pub fn spi_qout_mode(&self) -> SPI_QOUT_MODE_R {
        SPI_QOUT_MODE_R::new(((self.bits >> 20) & 1) != 0)
    }
    #[doc = "Bit 14 - In the read operations, \"read-data\" phase apply 2 signals"]
    #[inline(always)]
    pub fn spi_dout_mode(&self) -> SPI_DOUT_MODE_R {
        SPI_DOUT_MODE_R::new(((self.bits >> 14) & 1) != 0)
    }
    #[doc = "Bit 13 - this bit enable the bits: spi_qio_mode, spi_dio_mode, spi_qout_mode and spi_dout_mode"]
    #[inline(always)]
    pub fn spi_fastrd_mode(&self) -> SPI_FASTRD_MODE_R {
        SPI_FASTRD_MODE_R::new(((self.bits >> 13) & 1) != 0)
    }
    #[doc = "Bit 22 - Enable two byte status"]
    #[inline(always)]
    pub fn two_byte_status(&self) -> TWO_BYTE_STATUS_R {
        TWO_BYTE_STATUS_R::new(((self.bits >> 22) & 1) != 0)
    }
    #[doc = "Bit 21 - Write protect?"]
    #[inline(always)]
    pub fn wp_reg(&self) -> WP_REG_R {
        WP_REG_R::new(((self.bits >> 21) & 1) != 0)
    }
    #[doc = "Bit 19 - Share bus"]
    #[inline(always)]
    pub fn share_but(&self) -> SHARE_BUT_R {
        SHARE_BUT_R::new(((self.bits >> 19) & 1) != 0)
    }
    #[doc = "Bit 18 - Hold mode"]
    #[inline(always)]
    pub fn hold_mode(&self) -> HOLD_MODE_R {
        HOLD_MODE_R::new(((self.bits >> 18) & 1) != 0)
    }
    #[doc = "Bit 17 - Enable AHB"]
    #[inline(always)]
    pub fn enable_ahb(&self) -> ENABLE_AHB_R {
        ENABLE_AHB_R::new(((self.bits >> 17) & 1) != 0)
    }
    #[doc = "Bit 16 - SST_AAI?"]
    #[inline(always)]
    pub fn sst_aai(&self) -> SST_AAI_R {
        SST_AAI_R::new(((self.bits >> 16) & 1) != 0)
    }
    #[doc = "Bit 15 - 'Res and res'?"]
    #[inline(always)]
    pub fn res_and_res(&self) -> RES_AND_RES_R {
        RES_AND_RES_R::new(((self.bits >> 15) & 1) != 0)
    }
}
impl W {
    #[doc = "Bit 26 - In \"command\", \"address\", \"write-data\" (MOSI) phases, 1: LSB first; 0: MSB first"]
    #[inline(always)]
    pub fn spi_wr_bit_order(&mut self) -> SPI_WR_BIT_ORDER_W {
        SPI_WR_BIT_ORDER_W { w: self }
    }
    #[doc = "Bit 25 - In \"read-data\" (MISO) phase, 1: LSB first; 0: MSB first"]
    #[inline(always)]
    pub fn spi_rd_bit_order(&mut self) -> SPI_RD_BIT_ORDER_W {
        SPI_RD_BIT_ORDER_W { w: self }
    }
    #[doc = "Bit 24 - In the read operations, \"address\" phase and \"read-data\" phase apply 4 signals"]
    #[inline(always)]
    pub fn spi_qio_mode(&mut self) -> SPI_QIO_MODE_W {
        SPI_QIO_MODE_W { w: self }
    }
    #[doc = "Bit 23 - In the read operations, \"address\" phase and \"read-data\" phase apply 2 signals"]
    #[inline(always)]
    pub fn spi_dio_mode(&mut self) -> SPI_DIO_MODE_W {
        SPI_DIO_MODE_W { w: self }
    }
    #[doc = "Bit 20 - In the read operations, \"read-data\" phase apply 4 signals"]
    #[inline(always)]
    pub fn spi_qout_mode(&mut self) -> SPI_QOUT_MODE_W {
        SPI_QOUT_MODE_W { w: self }
    }
    #[doc = "Bit 14 - In the read operations, \"read-data\" phase apply 2 signals"]
    #[inline(always)]
    pub fn spi_dout_mode(&mut self) -> SPI_DOUT_MODE_W {
        SPI_DOUT_MODE_W { w: self }
    }
    #[doc = "Bit 13 - this bit enable the bits: spi_qio_mode, spi_dio_mode, spi_qout_mode and spi_dout_mode"]
    #[inline(always)]
    pub fn spi_fastrd_mode(&mut self) -> SPI_FASTRD_MODE_W {
        SPI_FASTRD_MODE_W { w: self }
    }
    #[doc = "Bit 22 - Enable two byte status"]
    #[inline(always)]
    pub fn two_byte_status(&mut self) -> TWO_BYTE_STATUS_W {
        TWO_BYTE_STATUS_W { w: self }
    }
    #[doc = "Bit 21 - Write protect?"]
    #[inline(always)]
    pub fn wp_reg(&mut self) -> WP_REG_W {
        WP_REG_W { w: self }
    }
    #[doc = "Bit 19 - Share bus"]
    #[inline(always)]
    pub fn share_but(&mut self) -> SHARE_BUT_W {
        SHARE_BUT_W { w: self }
    }
    #[doc = "Bit 18 - Hold mode"]
    #[inline(always)]
    pub fn hold_mode(&mut self) -> HOLD_MODE_W {
        HOLD_MODE_W { w: self }
    }
    #[doc = "Bit 17 - Enable AHB"]
    #[inline(always)]
    pub fn enable_ahb(&mut self) -> ENABLE_AHB_W {
        ENABLE_AHB_W { w: self }
    }
    #[doc = "Bit 16 - SST_AAI?"]
    #[inline(always)]
    pub fn sst_aai(&mut self) -> SST_AAI_W {
        SST_AAI_W { w: self }
    }
    #[doc = "Bit 15 - 'Res and res'?"]
    #[inline(always)]
    pub fn res_and_res(&mut self) -> RES_AND_RES_W {
        RES_AND_RES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SPI_CTRL\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_ctrl]
(index.html) module"]
pub struct SPI_CTRL_SPEC;
impl crate::RegisterSpec for SPI_CTRL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_ctrl::R]
(R) reader structure"]
impl crate::Readable for SPI_CTRL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_ctrl::W]
(W) writer structure"]
impl crate::Writable for SPI_CTRL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_CTRL to value 0"]
impl crate::Resettable for SPI_CTRL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
