#[doc = "Register `SLC_SDIO_ST` reader"]
pub struct R(crate::R<SLC_SDIO_ST_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SLC_SDIO_ST_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SLC_SDIO_ST_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SLC_SDIO_ST_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SLC_SDIO_ST` writer"]
pub struct W(crate::W<SLC_SDIO_ST_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SLC_SDIO_ST_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SLC_SDIO_ST_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SLC_SDIO_ST_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SLC_BUS_ST` reader - "]
pub struct SLC_BUS_ST_R(crate::FieldReader<u8, u8>);
impl SLC_BUS_ST_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SLC_BUS_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLC_BUS_ST_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLC_BUS_ST` writer - "]
pub struct SLC_BUS_ST_W<'a> {
    w: &'a mut W,
}
impl<'a> SLC_BUS_ST_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(7 << 12)) | ((value as u32 & 7) << 12);
        self.w
    }
}
#[doc = "Field `SLC_SDIO_WAKEUP` reader - "]
pub struct SLC_SDIO_WAKEUP_R(crate::FieldReader<bool, bool>);
impl SLC_SDIO_WAKEUP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SLC_SDIO_WAKEUP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLC_SDIO_WAKEUP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLC_SDIO_WAKEUP` writer - "]
pub struct SLC_SDIO_WAKEUP_W<'a> {
    w: &'a mut W,
}
impl<'a> SLC_SDIO_WAKEUP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
        self.w
    }
}
#[doc = "Field `SLC_FUNC_ST` reader - "]
pub struct SLC_FUNC_ST_R(crate::FieldReader<u8, u8>);
impl SLC_FUNC_ST_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SLC_FUNC_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLC_FUNC_ST_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLC_FUNC_ST` writer - "]
pub struct SLC_FUNC_ST_W<'a> {
    w: &'a mut W,
}
impl<'a> SLC_FUNC_ST_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `SLC_CMD_ST` reader - "]
pub struct SLC_CMD_ST_R(crate::FieldReader<u8, u8>);
impl SLC_CMD_ST_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SLC_CMD_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLC_CMD_ST_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLC_CMD_ST` writer - "]
pub struct SLC_CMD_ST_W<'a> {
    w: &'a mut W,
}
impl<'a> SLC_CMD_ST_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !7) | (value as u32 & 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 12:14"]
    #[inline(always)]
    pub fn slc_bus_st(&self) -> SLC_BUS_ST_R {
        SLC_BUS_ST_R::new(((self.bits >> 12) & 7) as u8)
    }
    #[doc = "Bit 8"]
    #[inline(always)]
    pub fn slc_sdio_wakeup(&self) -> SLC_SDIO_WAKEUP_R {
        SLC_SDIO_WAKEUP_R::new(((self.bits >> 8) & 1) != 0)
    }
    #[doc = "Bits 4:7"]
    #[inline(always)]
    pub fn slc_func_st(&self) -> SLC_FUNC_ST_R {
        SLC_FUNC_ST_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 0:2"]
    #[inline(always)]
    pub fn slc_cmd_st(&self) -> SLC_CMD_ST_R {
        SLC_CMD_ST_R::new((self.bits & 7) as u8)
    }
}
impl W {
    #[doc = "Bits 12:14"]
    #[inline(always)]
    pub fn slc_bus_st(&mut self) -> SLC_BUS_ST_W {
        SLC_BUS_ST_W { w: self }
    }
    #[doc = "Bit 8"]
    #[inline(always)]
    pub fn slc_sdio_wakeup(&mut self) -> SLC_SDIO_WAKEUP_W {
        SLC_SDIO_WAKEUP_W { w: self }
    }
    #[doc = "Bits 4:7"]
    #[inline(always)]
    pub fn slc_func_st(&mut self) -> SLC_FUNC_ST_W {
        SLC_FUNC_ST_W { w: self }
    }
    #[doc = "Bits 0:2"]
    #[inline(always)]
    pub fn slc_cmd_st(&mut self) -> SLC_CMD_ST_W {
        SLC_CMD_ST_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SLC_SDIO_ST\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [slc_sdio_st]
(index.html) module"]
pub struct SLC_SDIO_ST_SPEC;
impl crate::RegisterSpec for SLC_SDIO_ST_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [slc_sdio_st::R]
(R) reader structure"]
impl crate::Readable for SLC_SDIO_ST_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [slc_sdio_st::W]
(W) writer structure"]
impl crate::Writable for SLC_SDIO_ST_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SLC_SDIO_ST to value 0"]
impl crate::Resettable for SLC_SDIO_ST_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
