#[doc = "Register `IO_MUX_SD_DATA2` reader"]
pub struct R(crate::R<IO_MUX_SD_DATA2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<IO_MUX_SD_DATA2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<IO_MUX_SD_DATA2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<IO_MUX_SD_DATA2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `IO_MUX_SD_DATA2` writer"]
pub struct W(crate::W<IO_MUX_SD_DATA2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<IO_MUX_SD_DATA2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<IO_MUX_SD_DATA2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<IO_MUX_SD_DATA2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `Register` reader - "]
pub struct REGISTER_R(crate::FieldReader<u32, u32>);
impl REGISTER_R {
    #[inline(always)]
    pub(crate) fn new(bits: u32) -> Self {
        REGISTER_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REGISTER_R {
    type Target = crate::FieldReader<u32, u32>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Register` writer - "]
pub struct REGISTER_W<'a> {
    w: &'a mut W,
}
impl<'a> REGISTER_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u32) -> &'a mut W {
        self.w.bits = value;
        self.w
    }
}
#[doc = "Field `FUNCTION_SELECT_LOW_BITS` reader - configures IO_MUX function, bottom 2 bits"]
pub struct FUNCTION_SELECT_LOW_BITS_R(crate::FieldReader<u8, u8>);
impl FUNCTION_SELECT_LOW_BITS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        FUNCTION_SELECT_LOW_BITS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FUNCTION_SELECT_LOW_BITS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FUNCTION_SELECT_LOW_BITS` writer - configures IO_MUX function, bottom 2 bits"]
pub struct FUNCTION_SELECT_LOW_BITS_W<'a> {
    w: &'a mut W,
}
impl<'a> FUNCTION_SELECT_LOW_BITS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(3 << 4)) | ((value as u32 & 3) << 4);
        self.w
    }
}
#[doc = "Field `FUNCTION_SELECT_HIGH_BIT` reader - configures IO_MUX function, upper bit"]
pub struct FUNCTION_SELECT_HIGH_BIT_R(crate::FieldReader<bool, bool>);
impl FUNCTION_SELECT_HIGH_BIT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FUNCTION_SELECT_HIGH_BIT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FUNCTION_SELECT_HIGH_BIT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FUNCTION_SELECT_HIGH_BIT` writer - configures IO_MUX function, upper bit"]
pub struct FUNCTION_SELECT_HIGH_BIT_W<'a> {
    w: &'a mut W,
}
impl<'a> FUNCTION_SELECT_HIGH_BIT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 8)) | ((value as u32 & 1) << 8);
        self.w
    }
}
#[doc = "Field `PULLUP` reader - configures pull up"]
pub struct PULLUP_R(crate::FieldReader<bool, bool>);
impl PULLUP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PULLUP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PULLUP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PULLUP` writer - configures pull up"]
pub struct PULLUP_W<'a> {
    w: &'a mut W,
}
impl<'a> PULLUP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 7)) | ((value as u32 & 1) << 7);
        self.w
    }
}
#[doc = "Field `SLEEP_PULLUP` reader - configures pull up during sleep mode"]
pub struct SLEEP_PULLUP_R(crate::FieldReader<bool, bool>);
impl SLEEP_PULLUP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SLEEP_PULLUP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLEEP_PULLUP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLEEP_PULLUP` writer - configures pull up during sleep mode"]
pub struct SLEEP_PULLUP_W<'a> {
    w: &'a mut W,
}
impl<'a> SLEEP_PULLUP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 3)) | ((value as u32 & 1) << 3);
        self.w
    }
}
#[doc = "Field `SLEEP_ENABLE` reader - configures output enable during sleep mode"]
pub struct SLEEP_ENABLE_R(crate::FieldReader<bool, bool>);
impl SLEEP_ENABLE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SLEEP_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLEEP_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLEEP_ENABLE` writer - configures output enable during sleep mode"]
pub struct SLEEP_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> SLEEP_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !1) | (value as u32 & 1);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:31"]
    #[inline(always)]
    pub fn register(&self) -> REGISTER_R {
        REGISTER_R::new(self.bits)
    }
    #[doc = "Bits 4:5 - configures IO_MUX function, bottom 2 bits"]
    #[inline(always)]
    pub fn function_select_low_bits(&self) -> FUNCTION_SELECT_LOW_BITS_R {
        FUNCTION_SELECT_LOW_BITS_R::new(((self.bits >> 4) & 3) as u8)
    }
    #[doc = "Bit 8 - configures IO_MUX function, upper bit"]
    #[inline(always)]
    pub fn function_select_high_bit(&self) -> FUNCTION_SELECT_HIGH_BIT_R {
        FUNCTION_SELECT_HIGH_BIT_R::new(((self.bits >> 8) & 1) != 0)
    }
    #[doc = "Bit 7 - configures pull up"]
    #[inline(always)]
    pub fn pullup(&self) -> PULLUP_R {
        PULLUP_R::new(((self.bits >> 7) & 1) != 0)
    }
    #[doc = "Bit 3 - configures pull up during sleep mode"]
    #[inline(always)]
    pub fn sleep_pullup(&self) -> SLEEP_PULLUP_R {
        SLEEP_PULLUP_R::new(((self.bits >> 3) & 1) != 0)
    }
    #[doc = "Bit 0 - configures output enable during sleep mode"]
    #[inline(always)]
    pub fn sleep_enable(&self) -> SLEEP_ENABLE_R {
        SLEEP_ENABLE_R::new((self.bits & 1) != 0)
    }
}
impl W {
    #[doc = "Bits 0:31"]
    #[inline(always)]
    pub fn register(&mut self) -> REGISTER_W {
        REGISTER_W { w: self }
    }
    #[doc = "Bits 4:5 - configures IO_MUX function, bottom 2 bits"]
    #[inline(always)]
    pub fn function_select_low_bits(&mut self) -> FUNCTION_SELECT_LOW_BITS_W {
        FUNCTION_SELECT_LOW_BITS_W { w: self }
    }
    #[doc = "Bit 8 - configures IO_MUX function, upper bit"]
    #[inline(always)]
    pub fn function_select_high_bit(&mut self) -> FUNCTION_SELECT_HIGH_BIT_W {
        FUNCTION_SELECT_HIGH_BIT_W { w: self }
    }
    #[doc = "Bit 7 - configures pull up"]
    #[inline(always)]
    pub fn pullup(&mut self) -> PULLUP_W {
        PULLUP_W { w: self }
    }
    #[doc = "Bit 3 - configures pull up during sleep mode"]
    #[inline(always)]
    pub fn sleep_pullup(&mut self) -> SLEEP_PULLUP_W {
        SLEEP_PULLUP_W { w: self }
    }
    #[doc = "Bit 0 - configures output enable during sleep mode"]
    #[inline(always)]
    pub fn sleep_enable(&mut self) -> SLEEP_ENABLE_W {
        SLEEP_ENABLE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "IO_MUX_SD_DATA2\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [io_mux_sd_data2]
(index.html) module"]
pub struct IO_MUX_SD_DATA2_SPEC;
impl crate::RegisterSpec for IO_MUX_SD_DATA2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [io_mux_sd_data2::R]
(R) reader structure"]
impl crate::Readable for IO_MUX_SD_DATA2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [io_mux_sd_data2::W]
(W) writer structure"]
impl crate::Writable for IO_MUX_SD_DATA2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets IO_MUX_SD_DATA2 to value 0"]
impl crate::Resettable for IO_MUX_SD_DATA2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
