#[doc = "Register `GPIO_RTC_CALIB_VALUE` reader"]
pub struct R(crate::R<GPIO_RTC_CALIB_VALUE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GPIO_RTC_CALIB_VALUE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GPIO_RTC_CALIB_VALUE_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GPIO_RTC_CALIB_VALUE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GPIO_RTC_CALIB_VALUE` writer"]
pub struct W(crate::W<GPIO_RTC_CALIB_VALUE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GPIO_RTC_CALIB_VALUE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GPIO_RTC_CALIB_VALUE_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GPIO_RTC_CALIB_VALUE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `RTC_CALIB_RDY` reader - 0: during RTC-clock-calibration; 1: RTC-clock-calibration is done"]
pub struct RTC_CALIB_RDY_R(crate::FieldReader<bool, bool>);
impl RTC_CALIB_RDY_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RTC_CALIB_RDY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RTC_CALIB_RDY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RTC_CALIB_RDY` writer - 0: during RTC-clock-calibration; 1: RTC-clock-calibration is done"]
pub struct RTC_CALIB_RDY_W<'a> {
    w: &'a mut W,
}
impl<'a> RTC_CALIB_RDY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 31)) | ((value as u32 & 1) << 31);
        self.w
    }
}
#[doc = "Field `RTC_CALIB_RDY_REAL` reader - 0: during RTC-clock-calibration; 1: RTC-clock-calibration is done"]
pub struct RTC_CALIB_RDY_REAL_R(crate::FieldReader<bool, bool>);
impl RTC_CALIB_RDY_REAL_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RTC_CALIB_RDY_REAL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RTC_CALIB_RDY_REAL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RTC_CALIB_RDY_REAL` writer - 0: during RTC-clock-calibration; 1: RTC-clock-calibration is done"]
pub struct RTC_CALIB_RDY_REAL_W<'a> {
    w: &'a mut W,
}
impl<'a> RTC_CALIB_RDY_REAL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(1 << 30)) | ((value as u32 & 1) << 30);
        self.w
    }
}
#[doc = "Field `RTC_CALIB_VALUE` reader - The cycle number of clk_xtal (crystal clock) for the RTC_PERIOD_NUM cycles of RTC-clock"]
pub struct RTC_CALIB_VALUE_R(crate::FieldReader<u32, u32>);
impl RTC_CALIB_VALUE_R {
    #[inline(always)]
    pub(crate) fn new(bits: u32) -> Self {
        RTC_CALIB_VALUE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RTC_CALIB_VALUE_R {
    type Target = crate::FieldReader<u32, u32>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RTC_CALIB_VALUE` writer - The cycle number of clk_xtal (crystal clock) for the RTC_PERIOD_NUM cycles of RTC-clock"]
pub struct RTC_CALIB_VALUE_W<'a> {
    w: &'a mut W,
}
impl<'a> RTC_CALIB_VALUE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u32) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x000f_ffff) | (value as u32 & 0x000f_ffff);
        self.w
    }
}
impl R {
    #[doc = "Bit 31 - 0: during RTC-clock-calibration; 1: RTC-clock-calibration is done"]
    #[inline(always)]
    pub fn rtc_calib_rdy(&self) -> RTC_CALIB_RDY_R {
        RTC_CALIB_RDY_R::new(((self.bits >> 31) & 1) != 0)
    }
    #[doc = "Bit 30 - 0: during RTC-clock-calibration; 1: RTC-clock-calibration is done"]
    #[inline(always)]
    pub fn rtc_calib_rdy_real(&self) -> RTC_CALIB_RDY_REAL_R {
        RTC_CALIB_RDY_REAL_R::new(((self.bits >> 30) & 1) != 0)
    }
    #[doc = "Bits 0:19 - The cycle number of clk_xtal (crystal clock) for the RTC_PERIOD_NUM cycles of RTC-clock"]
    #[inline(always)]
    pub fn rtc_calib_value(&self) -> RTC_CALIB_VALUE_R {
        RTC_CALIB_VALUE_R::new((self.bits & 0x000f_ffff) as u32)
    }
}
impl W {
    #[doc = "Bit 31 - 0: during RTC-clock-calibration; 1: RTC-clock-calibration is done"]
    #[inline(always)]
    pub fn rtc_calib_rdy(&mut self) -> RTC_CALIB_RDY_W {
        RTC_CALIB_RDY_W { w: self }
    }
    #[doc = "Bit 30 - 0: during RTC-clock-calibration; 1: RTC-clock-calibration is done"]
    #[inline(always)]
    pub fn rtc_calib_rdy_real(&mut self) -> RTC_CALIB_RDY_REAL_W {
        RTC_CALIB_RDY_REAL_W { w: self }
    }
    #[doc = "Bits 0:19 - The cycle number of clk_xtal (crystal clock) for the RTC_PERIOD_NUM cycles of RTC-clock"]
    #[inline(always)]
    pub fn rtc_calib_value(&mut self) -> RTC_CALIB_VALUE_W {
        RTC_CALIB_VALUE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "0: during RTC-clock-calibration; 1: RTC-clock-calibration is done\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gpio_rtc_calib_value]
(index.html) module"]
pub struct GPIO_RTC_CALIB_VALUE_SPEC;
impl crate::RegisterSpec for GPIO_RTC_CALIB_VALUE_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gpio_rtc_calib_value::R]
(R) reader structure"]
impl crate::Readable for GPIO_RTC_CALIB_VALUE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gpio_rtc_calib_value::W]
(W) writer structure"]
impl crate::Writable for GPIO_RTC_CALIB_VALUE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GPIO_RTC_CALIB_VALUE to value 0"]
impl crate::Resettable for GPIO_RTC_CALIB_VALUE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
