#[doc = "Register `GPIO_ENABLE` reader"]
pub struct R(crate::R<GPIO_ENABLE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GPIO_ENABLE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GPIO_ENABLE_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GPIO_ENABLE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GPIO_ENABLE` writer"]
pub struct W(crate::W<GPIO_ENABLE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GPIO_ENABLE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GPIO_ENABLE_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GPIO_ENABLE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `GPIO_SDIO_SEL` reader - SDIO-dis selection register"]
pub struct GPIO_SDIO_SEL_R(crate::FieldReader<u8, u8>);
impl GPIO_SDIO_SEL_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        GPIO_SDIO_SEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIO_SDIO_SEL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIO_SDIO_SEL` writer - SDIO-dis selection register"]
pub struct GPIO_SDIO_SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIO_SDIO_SEL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x3f << 16)) | ((value as u32 & 0x3f) << 16);
        self.w
    }
}
#[doc = "Field `GPIO_ENABLE_DATA` reader - The output enable register."]
pub struct GPIO_ENABLE_DATA_R(crate::FieldReader<u16, u16>);
impl GPIO_ENABLE_DATA_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        GPIO_ENABLE_DATA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIO_ENABLE_DATA_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIO_ENABLE_DATA` writer - The output enable register."]
pub struct GPIO_ENABLE_DATA_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIO_ENABLE_DATA_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xffff) | (value as u32 & 0xffff);
        self.w
    }
}
impl R {
    #[doc = "Bits 16:21 - SDIO-dis selection register"]
    #[inline(always)]
    pub fn gpio_sdio_sel(&self) -> GPIO_SDIO_SEL_R {
        GPIO_SDIO_SEL_R::new(((self.bits >> 16) & 0x3f) as u8)
    }
    #[doc = "Bits 0:15 - The output enable register."]
    #[inline(always)]
    pub fn gpio_enable_data(&self) -> GPIO_ENABLE_DATA_R {
        GPIO_ENABLE_DATA_R::new((self.bits & 0xffff) as u16)
    }
}
impl W {
    #[doc = "Bits 16:21 - SDIO-dis selection register"]
    #[inline(always)]
    pub fn gpio_sdio_sel(&mut self) -> GPIO_SDIO_SEL_W {
        GPIO_SDIO_SEL_W { w: self }
    }
    #[doc = "Bits 0:15 - The output enable register."]
    #[inline(always)]
    pub fn gpio_enable_data(&mut self) -> GPIO_ENABLE_DATA_W {
        GPIO_ENABLE_DATA_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "GPIO_ENABLE\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gpio_enable]
(index.html) module"]
pub struct GPIO_ENABLE_SPEC;
impl crate::RegisterSpec for GPIO_ENABLE_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gpio_enable::R]
(R) reader structure"]
impl crate::Readable for GPIO_ENABLE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gpio_enable::W]
(W) writer structure"]
impl crate::Writable for GPIO_ENABLE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GPIO_ENABLE to value 0"]
impl crate::Resettable for GPIO_ENABLE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
