#[doc = "Register `SPI_USER` reader"]
pub struct R(crate::R<SPI_USER_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_USER_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPI_USER_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPI_USER_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_USER` writer"]
pub struct W(crate::W<SPI_USER_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_USER_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPI_USER_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPI_USER_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `spi_usr_command` reader - This bit enable the \"command\" phase of an operation."]
pub struct SPI_USR_COMMAND_R(crate::FieldReader<bool, bool>);
impl SPI_USR_COMMAND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_USR_COMMAND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_USR_COMMAND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_usr_command` writer - This bit enable the \"command\" phase of an operation."]
pub struct SPI_USR_COMMAND_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_USR_COMMAND_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
#[doc = "Field `spi_usr_addr` reader - This bit enable the \"address\" phase of an operation."]
pub struct SPI_USR_ADDR_R(crate::FieldReader<bool, bool>);
impl SPI_USR_ADDR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_USR_ADDR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_USR_ADDR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_usr_addr` writer - This bit enable the \"address\" phase of an operation."]
pub struct SPI_USR_ADDR_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_USR_ADDR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 30)) | ((value as u32 & 0x01) << 30);
        self.w
    }
}
#[doc = "Field `spi_usr_dummy` reader - This bit enable the \"dummy\" phase of an operation."]
pub struct SPI_USR_DUMMY_R(crate::FieldReader<bool, bool>);
impl SPI_USR_DUMMY_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_USR_DUMMY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_USR_DUMMY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_usr_dummy` writer - This bit enable the \"dummy\" phase of an operation."]
pub struct SPI_USR_DUMMY_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_USR_DUMMY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 29)) | ((value as u32 & 0x01) << 29);
        self.w
    }
}
#[doc = "Field `spi_usr_miso` reader - This bit enable the \"read-data\" phase of an operation."]
pub struct SPI_USR_MISO_R(crate::FieldReader<bool, bool>);
impl SPI_USR_MISO_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_USR_MISO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_USR_MISO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_usr_miso` writer - This bit enable the \"read-data\" phase of an operation."]
pub struct SPI_USR_MISO_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_USR_MISO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 28)) | ((value as u32 & 0x01) << 28);
        self.w
    }
}
#[doc = "Field `spi_usr_mosi` reader - This bit enable the \"write-data\" phase of an operation."]
pub struct SPI_USR_MOSI_R(crate::FieldReader<bool, bool>);
impl SPI_USR_MOSI_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_USR_MOSI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_USR_MOSI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_usr_mosi` writer - This bit enable the \"write-data\" phase of an operation."]
pub struct SPI_USR_MOSI_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_USR_MOSI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
#[doc = "Field `reg_usr_mosi_highpart` reader - 1: \"write-data\" phase only access to high-part of the buffer spi_w8~spi_w15"]
pub struct REG_USR_MOSI_HIGHPART_R(crate::FieldReader<bool, bool>);
impl REG_USR_MOSI_HIGHPART_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        REG_USR_MOSI_HIGHPART_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REG_USR_MOSI_HIGHPART_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `reg_usr_mosi_highpart` writer - 1: \"write-data\" phase only access to high-part of the buffer spi_w8~spi_w15"]
pub struct REG_USR_MOSI_HIGHPART_W<'a> {
    w: &'a mut W,
}
impl<'a> REG_USR_MOSI_HIGHPART_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 25)) | ((value as u32 & 0x01) << 25);
        self.w
    }
}
#[doc = "Field `reg_usr_miso_highpart` reader - 1: \"read-data\" phase only access to high-part of the buffer spi_w8~spi_w15"]
pub struct REG_USR_MISO_HIGHPART_R(crate::FieldReader<bool, bool>);
impl REG_USR_MISO_HIGHPART_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        REG_USR_MISO_HIGHPART_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REG_USR_MISO_HIGHPART_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `reg_usr_miso_highpart` writer - 1: \"read-data\" phase only access to high-part of the buffer spi_w8~spi_w15"]
pub struct REG_USR_MISO_HIGHPART_W<'a> {
    w: &'a mut W,
}
impl<'a> REG_USR_MISO_HIGHPART_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Field `spi_sio` reader - 1: mosi and miso signals share the same pin"]
pub struct SPI_SIO_R(crate::FieldReader<bool, bool>);
impl SPI_SIO_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_SIO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_SIO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_sio` writer - 1: mosi and miso signals share the same pin"]
pub struct SPI_SIO_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_SIO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `spi_fwrite_qio` reader - In the write operations, \"address\" phase and \"read-data\" phase apply 4 signals"]
pub struct SPI_FWRITE_QIO_R(crate::FieldReader<bool, bool>);
impl SPI_FWRITE_QIO_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_FWRITE_QIO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_FWRITE_QIO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_fwrite_qio` writer - In the write operations, \"address\" phase and \"read-data\" phase apply 4 signals"]
pub struct SPI_FWRITE_QIO_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_FWRITE_QIO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `spi_fwrite_dio` reader - In the write operations, \"address\" phase and \"read-data\" phase apply 2 signals"]
pub struct SPI_FWRITE_DIO_R(crate::FieldReader<bool, bool>);
impl SPI_FWRITE_DIO_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_FWRITE_DIO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_FWRITE_DIO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_fwrite_dio` writer - In the write operations, \"address\" phase and \"read-data\" phase apply 2 signals"]
pub struct SPI_FWRITE_DIO_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_FWRITE_DIO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `spi_fwrite_quad` reader - In the write operations, \"read-data\" phase apply 4 signals"]
pub struct SPI_FWRITE_QUAD_R(crate::FieldReader<bool, bool>);
impl SPI_FWRITE_QUAD_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_FWRITE_QUAD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_FWRITE_QUAD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_fwrite_quad` writer - In the write operations, \"read-data\" phase apply 4 signals"]
pub struct SPI_FWRITE_QUAD_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_FWRITE_QUAD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `spi_fwrite_dual` reader - In the write operations, \"read-data\" phase apply 2 signals"]
pub struct SPI_FWRITE_DUAL_R(crate::FieldReader<bool, bool>);
impl SPI_FWRITE_DUAL_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_FWRITE_DUAL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_FWRITE_DUAL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_fwrite_dual` writer - In the write operations, \"read-data\" phase apply 2 signals"]
pub struct SPI_FWRITE_DUAL_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_FWRITE_DUAL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `spi_wr_byte_order` reader - In \"command\", \"address\", \"write-data\" (MOSI) phases, 1: little-endian; 0: big_endian"]
pub struct SPI_WR_BYTE_ORDER_R(crate::FieldReader<bool, bool>);
impl SPI_WR_BYTE_ORDER_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_WR_BYTE_ORDER_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_WR_BYTE_ORDER_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_wr_byte_order` writer - In \"command\", \"address\", \"write-data\" (MOSI) phases, 1: little-endian; 0: big_endian"]
pub struct SPI_WR_BYTE_ORDER_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_WR_BYTE_ORDER_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `spi_rd_byte_order` reader - In \"read-data\" (MISO) phase, 1: little-endian; 0: big_endian"]
pub struct SPI_RD_BYTE_ORDER_R(crate::FieldReader<bool, bool>);
impl SPI_RD_BYTE_ORDER_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_RD_BYTE_ORDER_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_RD_BYTE_ORDER_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_rd_byte_order` writer - In \"read-data\" (MISO) phase, 1: little-endian; 0: big_endian"]
pub struct SPI_RD_BYTE_ORDER_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_RD_BYTE_ORDER_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `spi_ck_i_edge` reader - In the slave mode, 1: rising-edge; 0: falling-edge"]
pub struct SPI_CK_I_EDGE_R(crate::FieldReader<bool, bool>);
impl SPI_CK_I_EDGE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_CK_I_EDGE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CK_I_EDGE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_ck_i_edge` writer - In the slave mode, 1: rising-edge; 0: falling-edge"]
pub struct SPI_CK_I_EDGE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CK_I_EDGE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `spi_ck_o_edge` reader - In the master mode, 1: rising-edge; 0: falling-edge"]
pub struct SPI_CK_O_EDGE_R(crate::FieldReader<bool, bool>);
impl SPI_CK_O_EDGE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_CK_O_EDGE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CK_O_EDGE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_ck_o_edge` writer - In the master mode, 1: rising-edge; 0: falling-edge"]
pub struct SPI_CK_O_EDGE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CK_O_EDGE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `spi_cs_setup` reader - spi cs is enable when spi is in prepare phase. 1: enable 0: disable."]
pub struct SPI_CS_SETUP_R(crate::FieldReader<bool, bool>);
impl SPI_CS_SETUP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_CS_SETUP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CS_SETUP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_cs_setup` writer - spi cs is enable when spi is in prepare phase. 1: enable 0: disable."]
pub struct SPI_CS_SETUP_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CS_SETUP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `spi_cs_hold` reader - spi cs keep low when spi is in done phase. 1: enable 0: disable."]
pub struct SPI_CS_HOLD_R(crate::FieldReader<bool, bool>);
impl SPI_CS_HOLD_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_CS_HOLD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CS_HOLD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_cs_hold` writer - spi cs keep low when spi is in done phase. 1: enable 0: disable."]
pub struct SPI_CS_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CS_HOLD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `spi_ahb_user_command` reader - reserved"]
pub struct SPI_AHB_USER_COMMAND_R(crate::FieldReader<bool, bool>);
impl SPI_AHB_USER_COMMAND_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_AHB_USER_COMMAND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_AHB_USER_COMMAND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_ahb_user_command` writer - reserved"]
pub struct SPI_AHB_USER_COMMAND_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_AHB_USER_COMMAND_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `spi_flash_mode` reader - "]
pub struct SPI_FLASH_MODE_R(crate::FieldReader<bool, bool>);
impl SPI_FLASH_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_FLASH_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_FLASH_MODE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_flash_mode` writer - "]
pub struct SPI_FLASH_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_FLASH_MODE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `spi_ahb_user_command_4byte` reader - reserved"]
pub struct SPI_AHB_USER_COMMAND_4BYTE_R(crate::FieldReader<bool, bool>);
impl SPI_AHB_USER_COMMAND_4BYTE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_AHB_USER_COMMAND_4BYTE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_AHB_USER_COMMAND_4BYTE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_ahb_user_command_4byte` writer - reserved"]
pub struct SPI_AHB_USER_COMMAND_4BYTE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_AHB_USER_COMMAND_4BYTE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `spi_duplex` reader - set spi in full duplex mode"]
pub struct SPI_DUPLEX_R(crate::FieldReader<bool, bool>);
impl SPI_DUPLEX_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_DUPLEX_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_DUPLEX_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_duplex` writer - set spi in full duplex mode"]
pub struct SPI_DUPLEX_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_DUPLEX_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 31 - This bit enable the \"command\" phase of an operation."]
    #[inline(always)]
    pub fn spi_usr_command(&self) -> SPI_USR_COMMAND_R {
        SPI_USR_COMMAND_R::new(((self.bits >> 31) & 0x01) != 0)
    }
    #[doc = "Bit 30 - This bit enable the \"address\" phase of an operation."]
    #[inline(always)]
    pub fn spi_usr_addr(&self) -> SPI_USR_ADDR_R {
        SPI_USR_ADDR_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 29 - This bit enable the \"dummy\" phase of an operation."]
    #[inline(always)]
    pub fn spi_usr_dummy(&self) -> SPI_USR_DUMMY_R {
        SPI_USR_DUMMY_R::new(((self.bits >> 29) & 0x01) != 0)
    }
    #[doc = "Bit 28 - This bit enable the \"read-data\" phase of an operation."]
    #[inline(always)]
    pub fn spi_usr_miso(&self) -> SPI_USR_MISO_R {
        SPI_USR_MISO_R::new(((self.bits >> 28) & 0x01) != 0)
    }
    #[doc = "Bit 27 - This bit enable the \"write-data\" phase of an operation."]
    #[inline(always)]
    pub fn spi_usr_mosi(&self) -> SPI_USR_MOSI_R {
        SPI_USR_MOSI_R::new(((self.bits >> 27) & 0x01) != 0)
    }
    #[doc = "Bit 25 - 1: \"write-data\" phase only access to high-part of the buffer spi_w8~spi_w15"]
    #[inline(always)]
    pub fn reg_usr_mosi_highpart(&self) -> REG_USR_MOSI_HIGHPART_R {
        REG_USR_MOSI_HIGHPART_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 24 - 1: \"read-data\" phase only access to high-part of the buffer spi_w8~spi_w15"]
    #[inline(always)]
    pub fn reg_usr_miso_highpart(&self) -> REG_USR_MISO_HIGHPART_R {
        REG_USR_MISO_HIGHPART_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 16 - 1: mosi and miso signals share the same pin"]
    #[inline(always)]
    pub fn spi_sio(&self) -> SPI_SIO_R {
        SPI_SIO_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 15 - In the write operations, \"address\" phase and \"read-data\" phase apply 4 signals"]
    #[inline(always)]
    pub fn spi_fwrite_qio(&self) -> SPI_FWRITE_QIO_R {
        SPI_FWRITE_QIO_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - In the write operations, \"address\" phase and \"read-data\" phase apply 2 signals"]
    #[inline(always)]
    pub fn spi_fwrite_dio(&self) -> SPI_FWRITE_DIO_R {
        SPI_FWRITE_DIO_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 13 - In the write operations, \"read-data\" phase apply 4 signals"]
    #[inline(always)]
    pub fn spi_fwrite_quad(&self) -> SPI_FWRITE_QUAD_R {
        SPI_FWRITE_QUAD_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 12 - In the write operations, \"read-data\" phase apply 2 signals"]
    #[inline(always)]
    pub fn spi_fwrite_dual(&self) -> SPI_FWRITE_DUAL_R {
        SPI_FWRITE_DUAL_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - In \"command\", \"address\", \"write-data\" (MOSI) phases, 1: little-endian; 0: big_endian"]
    #[inline(always)]
    pub fn spi_wr_byte_order(&self) -> SPI_WR_BYTE_ORDER_R {
        SPI_WR_BYTE_ORDER_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - In \"read-data\" (MISO) phase, 1: little-endian; 0: big_endian"]
    #[inline(always)]
    pub fn spi_rd_byte_order(&self) -> SPI_RD_BYTE_ORDER_R {
        SPI_RD_BYTE_ORDER_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 6 - In the slave mode, 1: rising-edge; 0: falling-edge"]
    #[inline(always)]
    pub fn spi_ck_i_edge(&self) -> SPI_CK_I_EDGE_R {
        SPI_CK_I_EDGE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - In the master mode, 1: rising-edge; 0: falling-edge"]
    #[inline(always)]
    pub fn spi_ck_o_edge(&self) -> SPI_CK_O_EDGE_R {
        SPI_CK_O_EDGE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 5 - spi cs is enable when spi is in prepare phase. 1: enable 0: disable."]
    #[inline(always)]
    pub fn spi_cs_setup(&self) -> SPI_CS_SETUP_R {
        SPI_CS_SETUP_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - spi cs keep low when spi is in done phase. 1: enable 0: disable."]
    #[inline(always)]
    pub fn spi_cs_hold(&self) -> SPI_CS_HOLD_R {
        SPI_CS_HOLD_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - reserved"]
    #[inline(always)]
    pub fn spi_ahb_user_command(&self) -> SPI_AHB_USER_COMMAND_R {
        SPI_AHB_USER_COMMAND_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2"]
    #[inline(always)]
    pub fn spi_flash_mode(&self) -> SPI_FLASH_MODE_R {
        SPI_FLASH_MODE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - reserved"]
    #[inline(always)]
    pub fn spi_ahb_user_command_4byte(&self) -> SPI_AHB_USER_COMMAND_4BYTE_R {
        SPI_AHB_USER_COMMAND_4BYTE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - set spi in full duplex mode"]
    #[inline(always)]
    pub fn spi_duplex(&self) -> SPI_DUPLEX_R {
        SPI_DUPLEX_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 31 - This bit enable the \"command\" phase of an operation."]
    #[inline(always)]
    pub fn spi_usr_command(&mut self) -> SPI_USR_COMMAND_W {
        SPI_USR_COMMAND_W { w: self }
    }
    #[doc = "Bit 30 - This bit enable the \"address\" phase of an operation."]
    #[inline(always)]
    pub fn spi_usr_addr(&mut self) -> SPI_USR_ADDR_W {
        SPI_USR_ADDR_W { w: self }
    }
    #[doc = "Bit 29 - This bit enable the \"dummy\" phase of an operation."]
    #[inline(always)]
    pub fn spi_usr_dummy(&mut self) -> SPI_USR_DUMMY_W {
        SPI_USR_DUMMY_W { w: self }
    }
    #[doc = "Bit 28 - This bit enable the \"read-data\" phase of an operation."]
    #[inline(always)]
    pub fn spi_usr_miso(&mut self) -> SPI_USR_MISO_W {
        SPI_USR_MISO_W { w: self }
    }
    #[doc = "Bit 27 - This bit enable the \"write-data\" phase of an operation."]
    #[inline(always)]
    pub fn spi_usr_mosi(&mut self) -> SPI_USR_MOSI_W {
        SPI_USR_MOSI_W { w: self }
    }
    #[doc = "Bit 25 - 1: \"write-data\" phase only access to high-part of the buffer spi_w8~spi_w15"]
    #[inline(always)]
    pub fn reg_usr_mosi_highpart(&mut self) -> REG_USR_MOSI_HIGHPART_W {
        REG_USR_MOSI_HIGHPART_W { w: self }
    }
    #[doc = "Bit 24 - 1: \"read-data\" phase only access to high-part of the buffer spi_w8~spi_w15"]
    #[inline(always)]
    pub fn reg_usr_miso_highpart(&mut self) -> REG_USR_MISO_HIGHPART_W {
        REG_USR_MISO_HIGHPART_W { w: self }
    }
    #[doc = "Bit 16 - 1: mosi and miso signals share the same pin"]
    #[inline(always)]
    pub fn spi_sio(&mut self) -> SPI_SIO_W {
        SPI_SIO_W { w: self }
    }
    #[doc = "Bit 15 - In the write operations, \"address\" phase and \"read-data\" phase apply 4 signals"]
    #[inline(always)]
    pub fn spi_fwrite_qio(&mut self) -> SPI_FWRITE_QIO_W {
        SPI_FWRITE_QIO_W { w: self }
    }
    #[doc = "Bit 14 - In the write operations, \"address\" phase and \"read-data\" phase apply 2 signals"]
    #[inline(always)]
    pub fn spi_fwrite_dio(&mut self) -> SPI_FWRITE_DIO_W {
        SPI_FWRITE_DIO_W { w: self }
    }
    #[doc = "Bit 13 - In the write operations, \"read-data\" phase apply 4 signals"]
    #[inline(always)]
    pub fn spi_fwrite_quad(&mut self) -> SPI_FWRITE_QUAD_W {
        SPI_FWRITE_QUAD_W { w: self }
    }
    #[doc = "Bit 12 - In the write operations, \"read-data\" phase apply 2 signals"]
    #[inline(always)]
    pub fn spi_fwrite_dual(&mut self) -> SPI_FWRITE_DUAL_W {
        SPI_FWRITE_DUAL_W { w: self }
    }
    #[doc = "Bit 11 - In \"command\", \"address\", \"write-data\" (MOSI) phases, 1: little-endian; 0: big_endian"]
    #[inline(always)]
    pub fn spi_wr_byte_order(&mut self) -> SPI_WR_BYTE_ORDER_W {
        SPI_WR_BYTE_ORDER_W { w: self }
    }
    #[doc = "Bit 10 - In \"read-data\" (MISO) phase, 1: little-endian; 0: big_endian"]
    #[inline(always)]
    pub fn spi_rd_byte_order(&mut self) -> SPI_RD_BYTE_ORDER_W {
        SPI_RD_BYTE_ORDER_W { w: self }
    }
    #[doc = "Bit 6 - In the slave mode, 1: rising-edge; 0: falling-edge"]
    #[inline(always)]
    pub fn spi_ck_i_edge(&mut self) -> SPI_CK_I_EDGE_W {
        SPI_CK_I_EDGE_W { w: self }
    }
    #[doc = "Bit 7 - In the master mode, 1: rising-edge; 0: falling-edge"]
    #[inline(always)]
    pub fn spi_ck_o_edge(&mut self) -> SPI_CK_O_EDGE_W {
        SPI_CK_O_EDGE_W { w: self }
    }
    #[doc = "Bit 5 - spi cs is enable when spi is in prepare phase. 1: enable 0: disable."]
    #[inline(always)]
    pub fn spi_cs_setup(&mut self) -> SPI_CS_SETUP_W {
        SPI_CS_SETUP_W { w: self }
    }
    #[doc = "Bit 4 - spi cs keep low when spi is in done phase. 1: enable 0: disable."]
    #[inline(always)]
    pub fn spi_cs_hold(&mut self) -> SPI_CS_HOLD_W {
        SPI_CS_HOLD_W { w: self }
    }
    #[doc = "Bit 3 - reserved"]
    #[inline(always)]
    pub fn spi_ahb_user_command(&mut self) -> SPI_AHB_USER_COMMAND_W {
        SPI_AHB_USER_COMMAND_W { w: self }
    }
    #[doc = "Bit 2"]
    #[inline(always)]
    pub fn spi_flash_mode(&mut self) -> SPI_FLASH_MODE_W {
        SPI_FLASH_MODE_W { w: self }
    }
    #[doc = "Bit 1 - reserved"]
    #[inline(always)]
    pub fn spi_ahb_user_command_4byte(&mut self) -> SPI_AHB_USER_COMMAND_4BYTE_W {
        SPI_AHB_USER_COMMAND_4BYTE_W { w: self }
    }
    #[doc = "Bit 0 - set spi in full duplex mode"]
    #[inline(always)]
    pub fn spi_duplex(&mut self) -> SPI_DUPLEX_W {
        SPI_DUPLEX_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "This bit enable the \"command\" phase of an operation.\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_user]
(index.html) module"]
pub struct SPI_USER_SPEC;
impl crate::RegisterSpec for SPI_USER_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_user::R]
(R) reader structure"]
impl crate::Readable for SPI_USER_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_user::W]
(W) writer structure"]
impl crate::Writable for SPI_USER_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_USER to value 0"]
impl crate::Resettable for SPI_USER_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
