#[doc = "Register `SPI_CMD` reader"]
pub struct R(crate::R<SPI_CMD_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_CMD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPI_CMD_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPI_CMD_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_CMD` writer"]
pub struct W(crate::W<SPI_CMD_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_CMD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPI_CMD_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPI_CMD_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `spi_usr` reader - In the master mode, it is the start bit of a single operation. Self-clear by hardware"]
pub struct SPI_USR_R(crate::FieldReader<bool, bool>);
impl SPI_USR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_USR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_USR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_usr` writer - In the master mode, it is the start bit of a single operation. Self-clear by hardware"]
pub struct SPI_USR_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_USR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `spi_read` reader - "]
pub struct SPI_READ_R(crate::FieldReader<bool, bool>);
impl SPI_READ_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_READ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_READ_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_read` writer - "]
pub struct SPI_READ_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_READ_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
#[doc = "Field `spi_write_enable` reader - "]
pub struct SPI_WRITE_ENABLE_R(crate::FieldReader<bool, bool>);
impl SPI_WRITE_ENABLE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_WRITE_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_WRITE_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_write_enable` writer - "]
pub struct SPI_WRITE_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_WRITE_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 30)) | ((value as u32 & 0x01) << 30);
        self.w
    }
}
#[doc = "Field `spi_write_disable` reader - "]
pub struct SPI_WRITE_DISABLE_R(crate::FieldReader<bool, bool>);
impl SPI_WRITE_DISABLE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_WRITE_DISABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_WRITE_DISABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_write_disable` writer - "]
pub struct SPI_WRITE_DISABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_WRITE_DISABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 29)) | ((value as u32 & 0x01) << 29);
        self.w
    }
}
#[doc = "Field `spi_read_id` reader - "]
pub struct SPI_READ_ID_R(crate::FieldReader<bool, bool>);
impl SPI_READ_ID_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_READ_ID_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_READ_ID_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_read_id` writer - "]
pub struct SPI_READ_ID_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_READ_ID_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 28)) | ((value as u32 & 0x01) << 28);
        self.w
    }
}
#[doc = "Field `spi_read_sr` reader - "]
pub struct SPI_READ_SR_R(crate::FieldReader<bool, bool>);
impl SPI_READ_SR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_READ_SR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_READ_SR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_read_sr` writer - "]
pub struct SPI_READ_SR_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_READ_SR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
#[doc = "Field `spi_write_sr` reader - "]
pub struct SPI_WRITE_SR_R(crate::FieldReader<bool, bool>);
impl SPI_WRITE_SR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_WRITE_SR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_WRITE_SR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_write_sr` writer - "]
pub struct SPI_WRITE_SR_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_WRITE_SR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 26)) | ((value as u32 & 0x01) << 26);
        self.w
    }
}
#[doc = "Field `spi_pp` reader - "]
pub struct SPI_PP_R(crate::FieldReader<bool, bool>);
impl SPI_PP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_PP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_PP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_pp` writer - "]
pub struct SPI_PP_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_PP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 25)) | ((value as u32 & 0x01) << 25);
        self.w
    }
}
#[doc = "Field `spi_se` reader - "]
pub struct SPI_SE_R(crate::FieldReader<bool, bool>);
impl SPI_SE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_SE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_SE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_se` writer - "]
pub struct SPI_SE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_SE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Field `spi_be` reader - "]
pub struct SPI_BE_R(crate::FieldReader<bool, bool>);
impl SPI_BE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_BE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_BE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_be` writer - "]
pub struct SPI_BE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_BE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Field `spi_ce` reader - "]
pub struct SPI_CE_R(crate::FieldReader<bool, bool>);
impl SPI_CE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_CE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_ce` writer - "]
pub struct SPI_CE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Field `spi_dp` reader - "]
pub struct SPI_DP_R(crate::FieldReader<bool, bool>);
impl SPI_DP_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_DP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_DP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_dp` writer - "]
pub struct SPI_DP_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_DP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Field `spi_res` reader - "]
pub struct SPI_RES_R(crate::FieldReader<bool, bool>);
impl SPI_RES_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_RES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_RES_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_res` writer - "]
pub struct SPI_RES_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_RES_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Field `spi_hpm` reader - "]
pub struct SPI_HPM_R(crate::FieldReader<bool, bool>);
impl SPI_HPM_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_HPM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_HPM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_hpm` writer - "]
pub struct SPI_HPM_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_HPM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
impl R {
    #[doc = "Bit 18 - In the master mode, it is the start bit of a single operation. Self-clear by hardware"]
    #[inline(always)]
    pub fn spi_usr(&self) -> SPI_USR_R {
        SPI_USR_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 31"]
    #[inline(always)]
    pub fn spi_read(&self) -> SPI_READ_R {
        SPI_READ_R::new(((self.bits >> 31) & 0x01) != 0)
    }
    #[doc = "Bit 30"]
    #[inline(always)]
    pub fn spi_write_enable(&self) -> SPI_WRITE_ENABLE_R {
        SPI_WRITE_ENABLE_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 29"]
    #[inline(always)]
    pub fn spi_write_disable(&self) -> SPI_WRITE_DISABLE_R {
        SPI_WRITE_DISABLE_R::new(((self.bits >> 29) & 0x01) != 0)
    }
    #[doc = "Bit 28"]
    #[inline(always)]
    pub fn spi_read_id(&self) -> SPI_READ_ID_R {
        SPI_READ_ID_R::new(((self.bits >> 28) & 0x01) != 0)
    }
    #[doc = "Bit 27"]
    #[inline(always)]
    pub fn spi_read_sr(&self) -> SPI_READ_SR_R {
        SPI_READ_SR_R::new(((self.bits >> 27) & 0x01) != 0)
    }
    #[doc = "Bit 26"]
    #[inline(always)]
    pub fn spi_write_sr(&self) -> SPI_WRITE_SR_R {
        SPI_WRITE_SR_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 25"]
    #[inline(always)]
    pub fn spi_pp(&self) -> SPI_PP_R {
        SPI_PP_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 24"]
    #[inline(always)]
    pub fn spi_se(&self) -> SPI_SE_R {
        SPI_SE_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 23"]
    #[inline(always)]
    pub fn spi_be(&self) -> SPI_BE_R {
        SPI_BE_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 22"]
    #[inline(always)]
    pub fn spi_ce(&self) -> SPI_CE_R {
        SPI_CE_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 21"]
    #[inline(always)]
    pub fn spi_dp(&self) -> SPI_DP_R {
        SPI_DP_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 20"]
    #[inline(always)]
    pub fn spi_res(&self) -> SPI_RES_R {
        SPI_RES_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 19"]
    #[inline(always)]
    pub fn spi_hpm(&self) -> SPI_HPM_R {
        SPI_HPM_R::new(((self.bits >> 19) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 18 - In the master mode, it is the start bit of a single operation. Self-clear by hardware"]
    #[inline(always)]
    pub fn spi_usr(&mut self) -> SPI_USR_W {
        SPI_USR_W { w: self }
    }
    #[doc = "Bit 31"]
    #[inline(always)]
    pub fn spi_read(&mut self) -> SPI_READ_W {
        SPI_READ_W { w: self }
    }
    #[doc = "Bit 30"]
    #[inline(always)]
    pub fn spi_write_enable(&mut self) -> SPI_WRITE_ENABLE_W {
        SPI_WRITE_ENABLE_W { w: self }
    }
    #[doc = "Bit 29"]
    #[inline(always)]
    pub fn spi_write_disable(&mut self) -> SPI_WRITE_DISABLE_W {
        SPI_WRITE_DISABLE_W { w: self }
    }
    #[doc = "Bit 28"]
    #[inline(always)]
    pub fn spi_read_id(&mut self) -> SPI_READ_ID_W {
        SPI_READ_ID_W { w: self }
    }
    #[doc = "Bit 27"]
    #[inline(always)]
    pub fn spi_read_sr(&mut self) -> SPI_READ_SR_W {
        SPI_READ_SR_W { w: self }
    }
    #[doc = "Bit 26"]
    #[inline(always)]
    pub fn spi_write_sr(&mut self) -> SPI_WRITE_SR_W {
        SPI_WRITE_SR_W { w: self }
    }
    #[doc = "Bit 25"]
    #[inline(always)]
    pub fn spi_pp(&mut self) -> SPI_PP_W {
        SPI_PP_W { w: self }
    }
    #[doc = "Bit 24"]
    #[inline(always)]
    pub fn spi_se(&mut self) -> SPI_SE_W {
        SPI_SE_W { w: self }
    }
    #[doc = "Bit 23"]
    #[inline(always)]
    pub fn spi_be(&mut self) -> SPI_BE_W {
        SPI_BE_W { w: self }
    }
    #[doc = "Bit 22"]
    #[inline(always)]
    pub fn spi_ce(&mut self) -> SPI_CE_W {
        SPI_CE_W { w: self }
    }
    #[doc = "Bit 21"]
    #[inline(always)]
    pub fn spi_dp(&mut self) -> SPI_DP_W {
        SPI_DP_W { w: self }
    }
    #[doc = "Bit 20"]
    #[inline(always)]
    pub fn spi_res(&mut self) -> SPI_RES_W {
        SPI_RES_W { w: self }
    }
    #[doc = "Bit 19"]
    #[inline(always)]
    pub fn spi_hpm(&mut self) -> SPI_HPM_W {
        SPI_HPM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "In the master mode, it is the start bit of a single operation. Self-clear by hardware\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_cmd]
(index.html) module"]
pub struct SPI_CMD_SPEC;
impl crate::RegisterSpec for SPI_CMD_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_cmd::R]
(R) reader structure"]
impl crate::Readable for SPI_CMD_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_cmd::W]
(W) writer structure"]
impl crate::Writable for SPI_CMD_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_CMD to value 0"]
impl crate::Resettable for SPI_CMD_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
