#[doc = "Register `SPI_USER2` reader"]
pub struct R(crate::R<SPI_USER2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_USER2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPI_USER2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPI_USER2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_USER2` writer"]
pub struct W(crate::W<SPI_USER2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_USER2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPI_USER2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPI_USER2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `reg_usr_command_bitlen` reader - The length in bits of \"command\" phase. The register value shall be (bit_num-1)"]
pub struct REG_USR_COMMAND_BITLEN_R(crate::FieldReader<u8, u8>);
impl REG_USR_COMMAND_BITLEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        REG_USR_COMMAND_BITLEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REG_USR_COMMAND_BITLEN_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `reg_usr_command_bitlen` writer - The length in bits of \"command\" phase. The register value shall be (bit_num-1)"]
pub struct REG_USR_COMMAND_BITLEN_W<'a> {
    w: &'a mut W,
}
impl<'a> REG_USR_COMMAND_BITLEN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 28)) | ((value as u32 & 0x0f) << 28);
        self.w
    }
}
#[doc = "Field `reg_usr_command_value` reader - The value of \"command\" phase"]
pub struct REG_USR_COMMAND_VALUE_R(crate::FieldReader<u16, u16>);
impl REG_USR_COMMAND_VALUE_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        REG_USR_COMMAND_VALUE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REG_USR_COMMAND_VALUE_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `reg_usr_command_value` writer - The value of \"command\" phase"]
pub struct REG_USR_COMMAND_VALUE_W<'a> {
    w: &'a mut W,
}
impl<'a> REG_USR_COMMAND_VALUE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xffff) | (value as u32 & 0xffff);
        self.w
    }
}
impl R {
    #[doc = "Bits 28:31 - The length in bits of \"command\" phase. The register value shall be (bit_num-1)"]
    #[inline(always)]
    pub fn reg_usr_command_bitlen(&self) -> REG_USR_COMMAND_BITLEN_R {
        REG_USR_COMMAND_BITLEN_R::new(((self.bits >> 28) & 0x0f) as u8)
    }
    #[doc = "Bits 0:15 - The value of \"command\" phase"]
    #[inline(always)]
    pub fn reg_usr_command_value(&self) -> REG_USR_COMMAND_VALUE_R {
        REG_USR_COMMAND_VALUE_R::new((self.bits & 0xffff) as u16)
    }
}
impl W {
    #[doc = "Bits 28:31 - The length in bits of \"command\" phase. The register value shall be (bit_num-1)"]
    #[inline(always)]
    pub fn reg_usr_command_bitlen(&mut self) -> REG_USR_COMMAND_BITLEN_W {
        REG_USR_COMMAND_BITLEN_W { w: self }
    }
    #[doc = "Bits 0:15 - The value of \"command\" phase"]
    #[inline(always)]
    pub fn reg_usr_command_value(&mut self) -> REG_USR_COMMAND_VALUE_W {
        REG_USR_COMMAND_VALUE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "The length in bits of \"command\" phase. The register value shall be (bit_num-1)\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_user2]
(index.html) module"]
pub struct SPI_USER2_SPEC;
impl crate::RegisterSpec for SPI_USER2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_user2::R]
(R) reader structure"]
impl crate::Readable for SPI_USER2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_user2::W]
(W) writer structure"]
impl crate::Writable for SPI_USER2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_USER2 to value 0"]
impl crate::Resettable for SPI_USER2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
