#[doc = "Register `SPI_CTRL2` reader"]
pub struct R(crate::R<SPI_CTRL2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_CTRL2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPI_CTRL2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPI_CTRL2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_CTRL2` writer"]
pub struct W(crate::W<SPI_CTRL2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_CTRL2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPI_CTRL2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPI_CTRL2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `spi_cs_delay_num` reader - spi_cs signal is delayed by 80MHz clock cycles"]
pub struct SPI_CS_DELAY_NUM_R(crate::FieldReader<u8, u8>);
impl SPI_CS_DELAY_NUM_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPI_CS_DELAY_NUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CS_DELAY_NUM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_cs_delay_num` writer - spi_cs signal is delayed by 80MHz clock cycles"]
pub struct SPI_CS_DELAY_NUM_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CS_DELAY_NUM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 28)) | ((value as u32 & 0x0f) << 28);
        self.w
    }
}
#[doc = "Field `spi_cs_delay_mode` reader - spi_cs signal is delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
pub struct SPI_CS_DELAY_MODE_R(crate::FieldReader<u8, u8>);
impl SPI_CS_DELAY_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPI_CS_DELAY_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CS_DELAY_MODE_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_cs_delay_mode` writer - spi_cs signal is delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
pub struct SPI_CS_DELAY_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CS_DELAY_MODE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 26)) | ((value as u32 & 0x03) << 26);
        self.w
    }
}
#[doc = "Field `spi_mosi_delay_num` reader - MOSI signals are delayed by 80MHz clock cycles"]
pub struct SPI_MOSI_DELAY_NUM_R(crate::FieldReader<u8, u8>);
impl SPI_MOSI_DELAY_NUM_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPI_MOSI_DELAY_NUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_MOSI_DELAY_NUM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_mosi_delay_num` writer - MOSI signals are delayed by 80MHz clock cycles"]
pub struct SPI_MOSI_DELAY_NUM_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_MOSI_DELAY_NUM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 23)) | ((value as u32 & 0x07) << 23);
        self.w
    }
}
#[doc = "Field `spi_mosi_delay_mode` reader - MOSI signals are delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
pub struct SPI_MOSI_DELAY_MODE_R(crate::FieldReader<u8, u8>);
impl SPI_MOSI_DELAY_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPI_MOSI_DELAY_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_MOSI_DELAY_MODE_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_mosi_delay_mode` writer - MOSI signals are delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
pub struct SPI_MOSI_DELAY_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_MOSI_DELAY_MODE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 21)) | ((value as u32 & 0x03) << 21);
        self.w
    }
}
#[doc = "Field `spi_miso_delay_num` reader - MISO signals are delayed by 80MHz clock cycles"]
pub struct SPI_MISO_DELAY_NUM_R(crate::FieldReader<u8, u8>);
impl SPI_MISO_DELAY_NUM_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPI_MISO_DELAY_NUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_MISO_DELAY_NUM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_miso_delay_num` writer - MISO signals are delayed by 80MHz clock cycles"]
pub struct SPI_MISO_DELAY_NUM_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_MISO_DELAY_NUM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 18)) | ((value as u32 & 0x07) << 18);
        self.w
    }
}
#[doc = "Field `spi_miso_delay_mode` reader - MISO signals are delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
pub struct SPI_MISO_DELAY_MODE_R(crate::FieldReader<u8, u8>);
impl SPI_MISO_DELAY_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPI_MISO_DELAY_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_MISO_DELAY_MODE_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_miso_delay_mode` writer - MISO signals are delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
pub struct SPI_MISO_DELAY_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_MISO_DELAY_MODE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 16)) | ((value as u32 & 0x03) << 16);
        self.w
    }
}
impl R {
    #[doc = "Bits 28:31 - spi_cs signal is delayed by 80MHz clock cycles"]
    #[inline(always)]
    pub fn spi_cs_delay_num(&self) -> SPI_CS_DELAY_NUM_R {
        SPI_CS_DELAY_NUM_R::new(((self.bits >> 28) & 0x0f) as u8)
    }
    #[doc = "Bits 26:27 - spi_cs signal is delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
    #[inline(always)]
    pub fn spi_cs_delay_mode(&self) -> SPI_CS_DELAY_MODE_R {
        SPI_CS_DELAY_MODE_R::new(((self.bits >> 26) & 0x03) as u8)
    }
    #[doc = "Bits 23:25 - MOSI signals are delayed by 80MHz clock cycles"]
    #[inline(always)]
    pub fn spi_mosi_delay_num(&self) -> SPI_MOSI_DELAY_NUM_R {
        SPI_MOSI_DELAY_NUM_R::new(((self.bits >> 23) & 0x07) as u8)
    }
    #[doc = "Bits 21:22 - MOSI signals are delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
    #[inline(always)]
    pub fn spi_mosi_delay_mode(&self) -> SPI_MOSI_DELAY_MODE_R {
        SPI_MOSI_DELAY_MODE_R::new(((self.bits >> 21) & 0x03) as u8)
    }
    #[doc = "Bits 18:20 - MISO signals are delayed by 80MHz clock cycles"]
    #[inline(always)]
    pub fn spi_miso_delay_num(&self) -> SPI_MISO_DELAY_NUM_R {
        SPI_MISO_DELAY_NUM_R::new(((self.bits >> 18) & 0x07) as u8)
    }
    #[doc = "Bits 16:17 - MISO signals are delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
    #[inline(always)]
    pub fn spi_miso_delay_mode(&self) -> SPI_MISO_DELAY_MODE_R {
        SPI_MISO_DELAY_MODE_R::new(((self.bits >> 16) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 28:31 - spi_cs signal is delayed by 80MHz clock cycles"]
    #[inline(always)]
    pub fn spi_cs_delay_num(&mut self) -> SPI_CS_DELAY_NUM_W {
        SPI_CS_DELAY_NUM_W { w: self }
    }
    #[doc = "Bits 26:27 - spi_cs signal is delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
    #[inline(always)]
    pub fn spi_cs_delay_mode(&mut self) -> SPI_CS_DELAY_MODE_W {
        SPI_CS_DELAY_MODE_W { w: self }
    }
    #[doc = "Bits 23:25 - MOSI signals are delayed by 80MHz clock cycles"]
    #[inline(always)]
    pub fn spi_mosi_delay_num(&mut self) -> SPI_MOSI_DELAY_NUM_W {
        SPI_MOSI_DELAY_NUM_W { w: self }
    }
    #[doc = "Bits 21:22 - MOSI signals are delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
    #[inline(always)]
    pub fn spi_mosi_delay_mode(&mut self) -> SPI_MOSI_DELAY_MODE_W {
        SPI_MOSI_DELAY_MODE_W { w: self }
    }
    #[doc = "Bits 18:20 - MISO signals are delayed by 80MHz clock cycles"]
    #[inline(always)]
    pub fn spi_miso_delay_num(&mut self) -> SPI_MISO_DELAY_NUM_W {
        SPI_MISO_DELAY_NUM_W { w: self }
    }
    #[doc = "Bits 16:17 - MISO signals are delayed by spi_clk. 0: zero; 1: half cycle; 2: one cycle"]
    #[inline(always)]
    pub fn spi_miso_delay_mode(&mut self) -> SPI_MISO_DELAY_MODE_W {
        SPI_MISO_DELAY_MODE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "spi_cs signal is delayed by 80MHz clock cycles\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_ctrl2]
(index.html) module"]
pub struct SPI_CTRL2_SPEC;
impl crate::RegisterSpec for SPI_CTRL2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_ctrl2::R]
(R) reader structure"]
impl crate::Readable for SPI_CTRL2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_ctrl2::W]
(W) writer structure"]
impl crate::Writable for SPI_CTRL2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_CTRL2 to value 0"]
impl crate::Resettable for SPI_CTRL2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
