#[doc = "Register `SPI_ADDR` reader"]
pub struct R(crate::R<SPI_ADDR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_ADDR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPI_ADDR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPI_ADDR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_ADDR` writer"]
pub struct W(crate::W<SPI_ADDR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_ADDR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPI_ADDR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPI_ADDR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `iodata_start_addr` reader - In the master mode, it is the value of address in \"address\" phase."]
pub struct IODATA_START_ADDR_R(crate::FieldReader<u32, u32>);
impl IODATA_START_ADDR_R {
    #[inline(always)]
    pub(crate) fn new(bits: u32) -> Self {
        IODATA_START_ADDR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for IODATA_START_ADDR_R {
    type Target = crate::FieldReader<u32, u32>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `iodata_start_addr` writer - In the master mode, it is the value of address in \"address\" phase."]
pub struct IODATA_START_ADDR_W<'a> {
    w: &'a mut W,
}
impl<'a> IODATA_START_ADDR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u32) -> &'a mut W {
        self.w.bits = value;
        self.w
    }
}
#[doc = "Field `address` reader - "]
pub struct ADDRESS_R(crate::FieldReader<u32, u32>);
impl ADDRESS_R {
    #[inline(always)]
    pub(crate) fn new(bits: u32) -> Self {
        ADDRESS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADDRESS_R {
    type Target = crate::FieldReader<u32, u32>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `address` writer - "]
pub struct ADDRESS_W<'a> {
    w: &'a mut W,
}
impl<'a> ADDRESS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u32) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x00ff_ffff) | (value as u32 & 0x00ff_ffff);
        self.w
    }
}
#[doc = "Field `size` reader - "]
pub struct SIZE_R(crate::FieldReader<u8, u8>);
impl SIZE_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SIZE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SIZE_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `size` writer - "]
pub struct SIZE_W<'a> {
    w: &'a mut W,
}
impl<'a> SIZE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 24)) | ((value as u32 & 0xff) << 24);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:31 - In the master mode, it is the value of address in \"address\" phase."]
    #[inline(always)]
    pub fn iodata_start_addr(&self) -> IODATA_START_ADDR_R {
        IODATA_START_ADDR_R::new(self.bits)
    }
    #[doc = "Bits 0:23"]
    #[inline(always)]
    pub fn address(&self) -> ADDRESS_R {
        ADDRESS_R::new((self.bits & 0x00ff_ffff) as u32)
    }
    #[doc = "Bits 24:31"]
    #[inline(always)]
    pub fn size(&self) -> SIZE_R {
        SIZE_R::new(((self.bits >> 24) & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:31 - In the master mode, it is the value of address in \"address\" phase."]
    #[inline(always)]
    pub fn iodata_start_addr(&mut self) -> IODATA_START_ADDR_W {
        IODATA_START_ADDR_W { w: self }
    }
    #[doc = "Bits 0:23"]
    #[inline(always)]
    pub fn address(&mut self) -> ADDRESS_W {
        ADDRESS_W { w: self }
    }
    #[doc = "Bits 24:31"]
    #[inline(always)]
    pub fn size(&mut self) -> SIZE_W {
        SIZE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "In the master mode, it is the value of address in \"address\" phase.\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_addr]
(index.html) module"]
pub struct SPI_ADDR_SPEC;
impl crate::RegisterSpec for SPI_ADDR_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_addr::R]
(R) reader structure"]
impl crate::Readable for SPI_ADDR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_addr::W]
(W) writer structure"]
impl crate::Writable for SPI_ADDR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_ADDR to value 0"]
impl crate::Resettable for SPI_ADDR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
