#[doc = "Register `SLC_BRIDGE_CONF` reader"]
pub struct R(crate::R<SLC_BRIDGE_CONF_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SLC_BRIDGE_CONF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SLC_BRIDGE_CONF_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SLC_BRIDGE_CONF_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SLC_BRIDGE_CONF` writer"]
pub struct W(crate::W<SLC_BRIDGE_CONF_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SLC_BRIDGE_CONF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SLC_BRIDGE_CONF_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SLC_BRIDGE_CONF_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SLC_TX_PUSH_IDLE_NUM` reader - "]
pub struct SLC_TX_PUSH_IDLE_NUM_R(crate::FieldReader<u16, u16>);
impl SLC_TX_PUSH_IDLE_NUM_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        SLC_TX_PUSH_IDLE_NUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLC_TX_PUSH_IDLE_NUM_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLC_TX_PUSH_IDLE_NUM` writer - "]
pub struct SLC_TX_PUSH_IDLE_NUM_W<'a> {
    w: &'a mut W,
}
impl<'a> SLC_TX_PUSH_IDLE_NUM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xffff << 16)) | ((value as u32 & 0xffff) << 16);
        self.w
    }
}
#[doc = "Field `SLC_TX_DUMMY_MODE` reader - "]
pub struct SLC_TX_DUMMY_MODE_R(crate::FieldReader<bool, bool>);
impl SLC_TX_DUMMY_MODE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SLC_TX_DUMMY_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLC_TX_DUMMY_MODE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLC_TX_DUMMY_MODE` writer - "]
pub struct SLC_TX_DUMMY_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SLC_TX_DUMMY_MODE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `SLC_FIFO_MAP_ENA` reader - "]
pub struct SLC_FIFO_MAP_ENA_R(crate::FieldReader<u8, u8>);
impl SLC_FIFO_MAP_ENA_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SLC_FIFO_MAP_ENA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLC_FIFO_MAP_ENA_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLC_FIFO_MAP_ENA` writer - "]
pub struct SLC_FIFO_MAP_ENA_W<'a> {
    w: &'a mut W,
}
impl<'a> SLC_FIFO_MAP_ENA_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 8)) | ((value as u32 & 0x0f) << 8);
        self.w
    }
}
#[doc = "Field `SLC_TXEOF_ENA` reader - "]
pub struct SLC_TXEOF_ENA_R(crate::FieldReader<u8, u8>);
impl SLC_TXEOF_ENA_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SLC_TXEOF_ENA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLC_TXEOF_ENA_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLC_TXEOF_ENA` writer - "]
pub struct SLC_TXEOF_ENA_W<'a> {
    w: &'a mut W,
}
impl<'a> SLC_TXEOF_ENA_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x3f) | (value as u32 & 0x3f);
        self.w
    }
}
impl R {
    #[doc = "Bits 16:31"]
    #[inline(always)]
    pub fn slc_tx_push_idle_num(&self) -> SLC_TX_PUSH_IDLE_NUM_R {
        SLC_TX_PUSH_IDLE_NUM_R::new(((self.bits >> 16) & 0xffff) as u16)
    }
    #[doc = "Bit 12"]
    #[inline(always)]
    pub fn slc_tx_dummy_mode(&self) -> SLC_TX_DUMMY_MODE_R {
        SLC_TX_DUMMY_MODE_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bits 8:11"]
    #[inline(always)]
    pub fn slc_fifo_map_ena(&self) -> SLC_FIFO_MAP_ENA_R {
        SLC_FIFO_MAP_ENA_R::new(((self.bits >> 8) & 0x0f) as u8)
    }
    #[doc = "Bits 0:5"]
    #[inline(always)]
    pub fn slc_txeof_ena(&self) -> SLC_TXEOF_ENA_R {
        SLC_TXEOF_ENA_R::new((self.bits & 0x3f) as u8)
    }
}
impl W {
    #[doc = "Bits 16:31"]
    #[inline(always)]
    pub fn slc_tx_push_idle_num(&mut self) -> SLC_TX_PUSH_IDLE_NUM_W {
        SLC_TX_PUSH_IDLE_NUM_W { w: self }
    }
    #[doc = "Bit 12"]
    #[inline(always)]
    pub fn slc_tx_dummy_mode(&mut self) -> SLC_TX_DUMMY_MODE_W {
        SLC_TX_DUMMY_MODE_W { w: self }
    }
    #[doc = "Bits 8:11"]
    #[inline(always)]
    pub fn slc_fifo_map_ena(&mut self) -> SLC_FIFO_MAP_ENA_W {
        SLC_FIFO_MAP_ENA_W { w: self }
    }
    #[doc = "Bits 0:5"]
    #[inline(always)]
    pub fn slc_txeof_ena(&mut self) -> SLC_TXEOF_ENA_W {
        SLC_TXEOF_ENA_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SLC_BRIDGE_CONF\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [slc_bridge_conf]
(index.html) module"]
pub struct SLC_BRIDGE_CONF_SPEC;
impl crate::RegisterSpec for SLC_BRIDGE_CONF_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [slc_bridge_conf::R]
(R) reader structure"]
impl crate::Readable for SLC_BRIDGE_CONF_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [slc_bridge_conf::W]
(W) writer structure"]
impl crate::Writable for SLC_BRIDGE_CONF_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SLC_BRIDGE_CONF to value 0"]
impl crate::Resettable for SLC_BRIDGE_CONF_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
