#[doc = "Register `IOSWAP` reader"]
pub struct R(crate::R<IOSWAP_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<IOSWAP_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<IOSWAP_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<IOSWAP_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `IOSWAP` writer"]
pub struct W(crate::W<IOSWAP_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<IOSWAP_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<IOSWAP_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<IOSWAP_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `uart` reader - Swap UART"]
pub struct UART_R(crate::FieldReader<bool, bool>);
impl UART_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        UART_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UART_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `uart` writer - Swap UART"]
pub struct UART_W<'a> {
    w: &'a mut W,
}
impl<'a> UART_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `spi` reader - Swap SPI"]
pub struct SPI_R(crate::FieldReader<bool, bool>);
impl SPI_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi` writer - Swap SPI"]
pub struct SPI_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `uart0` reader - Swap UART0 pins (u0rxd <-> u0cts), (u0txd <-> u0rts)"]
pub struct UART0_R(crate::FieldReader<bool, bool>);
impl UART0_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        UART0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UART0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `uart0` writer - Swap UART0 pins (u0rxd <-> u0cts), (u0txd <-> u0rts)"]
pub struct UART0_W<'a> {
    w: &'a mut W,
}
impl<'a> UART0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `uart1` reader - Swap UART1 pins (u1rxd <-> u1cts), (u1txd <-> u1rts)"]
pub struct UART1_R(crate::FieldReader<bool, bool>);
impl UART1_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        UART1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UART1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `uart1` writer - Swap UART1 pins (u1rxd <-> u1cts), (u1txd <-> u1rts)"]
pub struct UART1_W<'a> {
    w: &'a mut W,
}
impl<'a> UART1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `hspi` reader - Set HSPI with higher priority"]
pub struct HSPI_R(crate::FieldReader<bool, bool>);
impl HSPI_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        HSPI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HSPI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `hspi` writer - Set HSPI with higher priority"]
pub struct HSPI_W<'a> {
    w: &'a mut W,
}
impl<'a> HSPI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `double_hspi` reader - Set two SPI masters on HSPI"]
pub struct DOUBLE_HSPI_R(crate::FieldReader<bool, bool>);
impl DOUBLE_HSPI_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DOUBLE_HSPI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DOUBLE_HSPI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `double_hspi` writer - Set two SPI masters on HSPI"]
pub struct DOUBLE_HSPI_W<'a> {
    w: &'a mut W,
}
impl<'a> DOUBLE_HSPI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `double_cspi` reader - Set two SPI masters on CSPI"]
pub struct DOUBLE_CSPI_R(crate::FieldReader<bool, bool>);
impl DOUBLE_CSPI_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DOUBLE_CSPI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DOUBLE_CSPI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `double_cspi` writer - Set two SPI masters on CSPI"]
pub struct DOUBLE_CSPI_W<'a> {
    w: &'a mut W,
}
impl<'a> DOUBLE_CSPI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Swap UART"]
    #[inline(always)]
    pub fn uart(&self) -> UART_R {
        UART_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Swap SPI"]
    #[inline(always)]
    pub fn spi(&self) -> SPI_R {
        SPI_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Swap UART0 pins (u0rxd <-> u0cts), (u0txd <-> u0rts)"]
    #[inline(always)]
    pub fn uart0(&self) -> UART0_R {
        UART0_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Swap UART1 pins (u1rxd <-> u1cts), (u1txd <-> u1rts)"]
    #[inline(always)]
    pub fn uart1(&self) -> UART1_R {
        UART1_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Set HSPI with higher priority"]
    #[inline(always)]
    pub fn hspi(&self) -> HSPI_R {
        HSPI_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Set two SPI masters on HSPI"]
    #[inline(always)]
    pub fn double_hspi(&self) -> DOUBLE_HSPI_R {
        DOUBLE_HSPI_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Set two SPI masters on CSPI"]
    #[inline(always)]
    pub fn double_cspi(&self) -> DOUBLE_CSPI_R {
        DOUBLE_CSPI_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Swap UART"]
    #[inline(always)]
    pub fn uart(&mut self) -> UART_W {
        UART_W { w: self }
    }
    #[doc = "Bit 1 - Swap SPI"]
    #[inline(always)]
    pub fn spi(&mut self) -> SPI_W {
        SPI_W { w: self }
    }
    #[doc = "Bit 2 - Swap UART0 pins (u0rxd <-> u0cts), (u0txd <-> u0rts)"]
    #[inline(always)]
    pub fn uart0(&mut self) -> UART0_W {
        UART0_W { w: self }
    }
    #[doc = "Bit 3 - Swap UART1 pins (u1rxd <-> u1cts), (u1txd <-> u1rts)"]
    #[inline(always)]
    pub fn uart1(&mut self) -> UART1_W {
        UART1_W { w: self }
    }
    #[doc = "Bit 5 - Set HSPI with higher priority"]
    #[inline(always)]
    pub fn hspi(&mut self) -> HSPI_W {
        HSPI_W { w: self }
    }
    #[doc = "Bit 6 - Set two SPI masters on HSPI"]
    #[inline(always)]
    pub fn double_hspi(&mut self) -> DOUBLE_HSPI_W {
        DOUBLE_HSPI_W { w: self }
    }
    #[doc = "Bit 7 - Set two SPI masters on CSPI"]
    #[inline(always)]
    pub fn double_cspi(&mut self) -> DOUBLE_CSPI_W {
        DOUBLE_CSPI_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "IO Swap register\n\nThis register you can [`read`]
(crate::generic::Reg::read), [`write_with_zero`]
(crate::generic::Reg::write_with_zero), [`reset`]
(crate::generic::Reg::reset), [`write`]
(crate::generic::Reg::write), [`modify`]
(crate::generic::Reg::modify). See [API]
(https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ioswap]
(index.html) module"]
pub struct IOSWAP_SPEC;
impl crate::RegisterSpec for IOSWAP_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [ioswap::R]
(R) reader structure"]
impl crate::Readable for IOSWAP_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ioswap::W]
(W) writer structure"]
impl crate::Writable for IOSWAP_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets IOSWAP to value 0"]
impl crate::Resettable for IOSWAP_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
