#[doc = "Register `UART_CONF0` reader"]
pub struct R(crate::R<UART_CONF0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UART_CONF0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UART_CONF0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UART_CONF0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UART_CONF0` writer"]
pub struct W(crate::W<UART_CONF0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UART_CONF0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UART_CONF0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UART_CONF0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `uart_dtr_inv` reader - Set this bit to inverse uart dtr level"]
pub struct UART_DTR_INV_R(crate::FieldReader<bool, bool>);
impl UART_DTR_INV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        UART_DTR_INV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UART_DTR_INV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `uart_dtr_inv` writer - Set this bit to inverse uart dtr level"]
pub struct UART_DTR_INV_W<'a> {
    w: &'a mut W,
}
impl<'a> UART_DTR_INV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Field `uart_rts_inv` reader - Set this bit to inverse uart rts level"]
pub struct UART_RTS_INV_R(crate::FieldReader<bool, bool>);
impl UART_RTS_INV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        UART_RTS_INV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UART_RTS_INV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `uart_rts_inv` writer - Set this bit to inverse uart rts level"]
pub struct UART_RTS_INV_W<'a> {
    w: &'a mut W,
}
impl<'a> UART_RTS_INV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Field `uart_txd_inv` reader - Set this bit to inverse uart txd level"]
pub struct UART_TXD_INV_R(crate::FieldReader<bool, bool>);
impl UART_TXD_INV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        UART_TXD_INV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UART_TXD_INV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `uart_txd_inv` writer - Set this bit to inverse uart txd level"]
pub struct UART_TXD_INV_W<'a> {
    w: &'a mut W,
}
impl<'a> UART_TXD_INV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Field `uart_dsr_inv` reader - Set this bit to inverse uart dsr level"]
pub struct UART_DSR_INV_R(crate::FieldReader<bool, bool>);
impl UART_DSR_INV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        UART_DSR_INV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UART_DSR_INV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `uart_dsr_inv` writer - Set this bit to inverse uart dsr level"]
pub struct UART_DSR_INV_W<'a> {
    w: &'a mut W,
}
impl<'a> UART_DSR_INV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Field `uart_cts_inv` reader - Set this bit to inverse uart cts level"]
pub struct UART_CTS_INV_R(crate::FieldReader<bool, bool>);
impl UART_CTS_INV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        UART_CTS_INV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UART_CTS_INV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `uart_cts_inv` writer - Set this bit to inverse uart cts level"]
pub struct UART_CTS_INV_W<'a> {
    w: &'a mut W,
}
impl<'a> UART_CTS_INV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Field `uart_rxd_inv` reader - Set this bit to inverse uart rxd level"]
pub struct UART_RXD_INV_R(crate::FieldReader<bool, bool>);
impl UART_RXD_INV_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        UART_RXD_INV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UART_RXD_INV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `uart_rxd_inv` writer - Set this bit to inverse uart rxd level"]
pub struct UART_RXD_INV_W<'a> {
    w: &'a mut W,
}
impl<'a> UART_RXD_INV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Field `txfifo_rst` reader - Set this bit to reset uart tx fifo"]
pub struct TXFIFO_RST_R(crate::FieldReader<bool, bool>);
impl TXFIFO_RST_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXFIFO_RST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXFIFO_RST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `txfifo_rst` writer - Set this bit to reset uart tx fifo"]
pub struct TXFIFO_RST_W<'a> {
    w: &'a mut W,
}
impl<'a> TXFIFO_RST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `rxfifo_rst` reader - Set this bit to reset uart rx fifo"]
pub struct RXFIFO_RST_R(crate::FieldReader<bool, bool>);
impl RXFIFO_RST_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RXFIFO_RST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXFIFO_RST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `rxfifo_rst` writer - Set this bit to reset uart rx fifo"]
pub struct RXFIFO_RST_W<'a> {
    w: &'a mut W,
}
impl<'a> RXFIFO_RST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `tx_flow_en` reader - Set this bit to enable uart tx hardware flow control"]
pub struct TX_FLOW_EN_R(crate::FieldReader<bool, bool>);
impl TX_FLOW_EN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TX_FLOW_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TX_FLOW_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `tx_flow_en` writer - Set this bit to enable uart tx hardware flow control"]
pub struct TX_FLOW_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> TX_FLOW_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `uart_loopback` reader - Set this bit to enable uart loopback test mode"]
pub struct UART_LOOPBACK_R(crate::FieldReader<bool, bool>);
impl UART_LOOPBACK_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        UART_LOOPBACK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UART_LOOPBACK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `uart_loopback` writer - Set this bit to enable uart loopback test mode"]
pub struct UART_LOOPBACK_W<'a> {
    w: &'a mut W,
}
impl<'a> UART_LOOPBACK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `txd_brk` reader - RESERVED, DO NOT CHANGE THIS BIT"]
pub struct TXD_BRK_R(crate::FieldReader<bool, bool>);
impl TXD_BRK_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TXD_BRK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXD_BRK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `txd_brk` writer - RESERVED, DO NOT CHANGE THIS BIT"]
pub struct TXD_BRK_W<'a> {
    w: &'a mut W,
}
impl<'a> TXD_BRK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `sw_dtr` reader - sw dtr"]
pub struct SW_DTR_R(crate::FieldReader<bool, bool>);
impl SW_DTR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SW_DTR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SW_DTR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `sw_dtr` writer - sw dtr"]
pub struct SW_DTR_W<'a> {
    w: &'a mut W,
}
impl<'a> SW_DTR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `sw_rts` reader - sw rts"]
pub struct SW_RTS_R(crate::FieldReader<bool, bool>);
impl SW_RTS_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SW_RTS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SW_RTS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `sw_rts` writer - sw rts"]
pub struct SW_RTS_W<'a> {
    w: &'a mut W,
}
impl<'a> SW_RTS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `stop_bit_num` reader - Set stop bit: 1:1bit 2:1.5bits 3:2bits"]
pub struct STOP_BIT_NUM_R(crate::FieldReader<u8, u8>);
impl STOP_BIT_NUM_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        STOP_BIT_NUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STOP_BIT_NUM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `stop_bit_num` writer - Set stop bit: 1:1bit 2:1.5bits 3:2bits"]
pub struct STOP_BIT_NUM_W<'a> {
    w: &'a mut W,
}
impl<'a> STOP_BIT_NUM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u32 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `bit_num` reader - Set bit num: 0:5bits 1:6bits 2:7bits 3:8bits"]
pub struct BIT_NUM_R(crate::FieldReader<u8, u8>);
impl BIT_NUM_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        BIT_NUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BIT_NUM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `bit_num` writer - Set bit num: 0:5bits 1:6bits 2:7bits 3:8bits"]
pub struct BIT_NUM_W<'a> {
    w: &'a mut W,
}
impl<'a> BIT_NUM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u32 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `parity_en` reader - Set this bit to enable uart parity check"]
pub struct PARITY_EN_R(crate::FieldReader<bool, bool>);
impl PARITY_EN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PARITY_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PARITY_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `parity_en` writer - Set this bit to enable uart parity check"]
pub struct PARITY_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> PARITY_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `parity` reader - Set parity check: 0:even 1:odd, UART CONFIG1"]
pub struct PARITY_R(crate::FieldReader<bool, bool>);
impl PARITY_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        PARITY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PARITY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `parity` writer - Set parity check: 0:even 1:odd, UART CONFIG1"]
pub struct PARITY_W<'a> {
    w: &'a mut W,
}
impl<'a> PARITY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 24 - Set this bit to inverse uart dtr level"]
    #[inline(always)]
    pub fn uart_dtr_inv(&self) -> UART_DTR_INV_R {
        UART_DTR_INV_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 23 - Set this bit to inverse uart rts level"]
    #[inline(always)]
    pub fn uart_rts_inv(&self) -> UART_RTS_INV_R {
        UART_RTS_INV_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 22 - Set this bit to inverse uart txd level"]
    #[inline(always)]
    pub fn uart_txd_inv(&self) -> UART_TXD_INV_R {
        UART_TXD_INV_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 21 - Set this bit to inverse uart dsr level"]
    #[inline(always)]
    pub fn uart_dsr_inv(&self) -> UART_DSR_INV_R {
        UART_DSR_INV_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Set this bit to inverse uart cts level"]
    #[inline(always)]
    pub fn uart_cts_inv(&self) -> UART_CTS_INV_R {
        UART_CTS_INV_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Set this bit to inverse uart rxd level"]
    #[inline(always)]
    pub fn uart_rxd_inv(&self) -> UART_RXD_INV_R {
        UART_RXD_INV_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Set this bit to reset uart tx fifo"]
    #[inline(always)]
    pub fn txfifo_rst(&self) -> TXFIFO_RST_R {
        TXFIFO_RST_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Set this bit to reset uart rx fifo"]
    #[inline(always)]
    pub fn rxfifo_rst(&self) -> RXFIFO_RST_R {
        RXFIFO_RST_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Set this bit to enable uart tx hardware flow control"]
    #[inline(always)]
    pub fn tx_flow_en(&self) -> TX_FLOW_EN_R {
        TX_FLOW_EN_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Set this bit to enable uart loopback test mode"]
    #[inline(always)]
    pub fn uart_loopback(&self) -> UART_LOOPBACK_R {
        UART_LOOPBACK_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 8 - RESERVED, DO NOT CHANGE THIS BIT"]
    #[inline(always)]
    pub fn txd_brk(&self) -> TXD_BRK_R {
        TXD_BRK_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - sw dtr"]
    #[inline(always)]
    pub fn sw_dtr(&self) -> SW_DTR_R {
        SW_DTR_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - sw rts"]
    #[inline(always)]
    pub fn sw_rts(&self) -> SW_RTS_R {
        SW_RTS_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - Set stop bit: 1:1bit 2:1.5bits 3:2bits"]
    #[inline(always)]
    pub fn stop_bit_num(&self) -> STOP_BIT_NUM_R {
        STOP_BIT_NUM_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Set bit num: 0:5bits 1:6bits 2:7bits 3:8bits"]
    #[inline(always)]
    pub fn bit_num(&self) -> BIT_NUM_R {
        BIT_NUM_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bit 1 - Set this bit to enable uart parity check"]
    #[inline(always)]
    pub fn parity_en(&self) -> PARITY_EN_R {
        PARITY_EN_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Set parity check: 0:even 1:odd, UART CONFIG1"]
    #[inline(always)]
    pub fn parity(&self) -> PARITY_R {
        PARITY_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 24 - Set this bit to inverse uart dtr level"]
    #[inline(always)]
    pub fn uart_dtr_inv(&mut self) -> UART_DTR_INV_W {
        UART_DTR_INV_W { w: self }
    }
    #[doc = "Bit 23 - Set this bit to inverse uart rts level"]
    #[inline(always)]
    pub fn uart_rts_inv(&mut self) -> UART_RTS_INV_W {
        UART_RTS_INV_W { w: self }
    }
    #[doc = "Bit 22 - Set this bit to inverse uart txd level"]
    #[inline(always)]
    pub fn uart_txd_inv(&mut self) -> UART_TXD_INV_W {
        UART_TXD_INV_W { w: self }
    }
    #[doc = "Bit 21 - Set this bit to inverse uart dsr level"]
    #[inline(always)]
    pub fn uart_dsr_inv(&mut self) -> UART_DSR_INV_W {
        UART_DSR_INV_W { w: self }
    }
    #[doc = "Bit 20 - Set this bit to inverse uart cts level"]
    #[inline(always)]
    pub fn uart_cts_inv(&mut self) -> UART_CTS_INV_W {
        UART_CTS_INV_W { w: self }
    }
    #[doc = "Bit 19 - Set this bit to inverse uart rxd level"]
    #[inline(always)]
    pub fn uart_rxd_inv(&mut self) -> UART_RXD_INV_W {
        UART_RXD_INV_W { w: self }
    }
    #[doc = "Bit 18 - Set this bit to reset uart tx fifo"]
    #[inline(always)]
    pub fn txfifo_rst(&mut self) -> TXFIFO_RST_W {
        TXFIFO_RST_W { w: self }
    }
    #[doc = "Bit 17 - Set this bit to reset uart rx fifo"]
    #[inline(always)]
    pub fn rxfifo_rst(&mut self) -> RXFIFO_RST_W {
        RXFIFO_RST_W { w: self }
    }
    #[doc = "Bit 15 - Set this bit to enable uart tx hardware flow control"]
    #[inline(always)]
    pub fn tx_flow_en(&mut self) -> TX_FLOW_EN_W {
        TX_FLOW_EN_W { w: self }
    }
    #[doc = "Bit 14 - Set this bit to enable uart loopback test mode"]
    #[inline(always)]
    pub fn uart_loopback(&mut self) -> UART_LOOPBACK_W {
        UART_LOOPBACK_W { w: self }
    }
    #[doc = "Bit 8 - RESERVED, DO NOT CHANGE THIS BIT"]
    #[inline(always)]
    pub fn txd_brk(&mut self) -> TXD_BRK_W {
        TXD_BRK_W { w: self }
    }
    #[doc = "Bit 7 - sw dtr"]
    #[inline(always)]
    pub fn sw_dtr(&mut self) -> SW_DTR_W {
        SW_DTR_W { w: self }
    }
    #[doc = "Bit 6 - sw rts"]
    #[inline(always)]
    pub fn sw_rts(&mut self) -> SW_RTS_W {
        SW_RTS_W { w: self }
    }
    #[doc = "Bits 4:5 - Set stop bit: 1:1bit 2:1.5bits 3:2bits"]
    #[inline(always)]
    pub fn stop_bit_num(&mut self) -> STOP_BIT_NUM_W {
        STOP_BIT_NUM_W { w: self }
    }
    #[doc = "Bits 2:3 - Set bit num: 0:5bits 1:6bits 2:7bits 3:8bits"]
    #[inline(always)]
    pub fn bit_num(&mut self) -> BIT_NUM_W {
        BIT_NUM_W { w: self }
    }
    #[doc = "Bit 1 - Set this bit to enable uart parity check"]
    #[inline(always)]
    pub fn parity_en(&mut self) -> PARITY_EN_W {
        PARITY_EN_W { w: self }
    }
    #[doc = "Bit 0 - Set parity check: 0:even 1:odd, UART CONFIG1"]
    #[inline(always)]
    pub fn parity(&mut self) -> PARITY_W {
        PARITY_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "UART CONFIG0(UART0 and UART1)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [uart_conf0](index.html) module"]
pub struct UART_CONF0_SPEC;
impl crate::RegisterSpec for UART_CONF0_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [uart_conf0::R](R) reader structure"]
impl crate::Readable for UART_CONF0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [uart_conf0::W](W) writer structure"]
impl crate::Writable for UART_CONF0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UART_CONF0 to value 0"]
impl crate::Resettable for UART_CONF0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
