#[doc = "Register `FRC2_CTRL` reader"]
pub struct R(crate::R<FRC2_CTRL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<FRC2_CTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<FRC2_CTRL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<FRC2_CTRL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `FRC2_CTRL` writer"]
pub struct W(crate::W<FRC2_CTRL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<FRC2_CTRL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<FRC2_CTRL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<FRC2_CTRL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `frc2_int` reader - the status of the interrupt, when the count is equal tothe alarm value"]
pub struct FRC2_INT_R(crate::FieldReader<bool, bool>);
impl FRC2_INT_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        FRC2_INT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FRC2_INT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `frc2_ctrl` reader - bit\\[7\\]: timer enable, bit\\[6\\]: automatically reload, when the counter isequal to zero, bit\\[3:2\\]: prescale-divider, 0: divided by 1, 1: dividedby 16, 2 or 3: divided by 256, bit\\[0\\]: interrupt type, 0:edge, 1:level"]
pub struct FRC2_CTRL_R(crate::FieldReader<u8, u8>);
impl FRC2_CTRL_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        FRC2_CTRL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FRC2_CTRL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `frc2_ctrl` writer - bit\\[7\\]: timer enable, bit\\[6\\]: automatically reload, when the counter isequal to zero, bit\\[3:2\\]: prescale-divider, 0: divided by 1, 1: dividedby 16, 2 or 3: divided by 256, bit\\[0\\]: interrupt type, 0:edge, 1:level"]
pub struct FRC2_CTRL_W<'a> {
    w: &'a mut W,
}
impl<'a> FRC2_CTRL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u32 & 0xff);
        self.w
    }
}
#[doc = "Field `timer_enable` reader - Enable or disable the timer"]
pub struct TIMER_ENABLE_R(crate::FieldReader<bool, bool>);
impl TIMER_ENABLE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TIMER_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `timer_enable` writer - Enable or disable the timer"]
pub struct TIMER_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `rollover` reader - Automatically reload when the counter hits zero"]
pub struct ROLLOVER_R(crate::FieldReader<bool, bool>);
impl ROLLOVER_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        ROLLOVER_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ROLLOVER_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `rollover` writer - Automatically reload when the counter hits zero"]
pub struct ROLLOVER_W<'a> {
    w: &'a mut W,
}
impl<'a> ROLLOVER_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Pre-scale divider for the timer\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PRESCALE_DIVIDER_A {
    #[doc = "0: divided by 1"]
    DEVIDED_BY_1 = 0,
    #[doc = "1: divided by 16"]
    DEVIDED_BY_16 = 1,
    #[doc = "2: divided by 256"]
    DEVIDED_BY_256 = 2,
}
impl From<PRESCALE_DIVIDER_A> for u8 {
    #[inline(always)]
    fn from(variant: PRESCALE_DIVIDER_A) -> Self {
        variant as _
    }
}
#[doc = "Field `prescale_divider` reader - Pre-scale divider for the timer"]
pub struct PRESCALE_DIVIDER_R(crate::FieldReader<u8, PRESCALE_DIVIDER_A>);
impl PRESCALE_DIVIDER_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        PRESCALE_DIVIDER_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<PRESCALE_DIVIDER_A> {
        match self.bits {
            0 => Some(PRESCALE_DIVIDER_A::DEVIDED_BY_1),
            1 => Some(PRESCALE_DIVIDER_A::DEVIDED_BY_16),
            2 => Some(PRESCALE_DIVIDER_A::DEVIDED_BY_256),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `DEVIDED_BY_1`"]
    #[inline(always)]
    pub fn is_devided_by_1(&self) -> bool {
        **self == PRESCALE_DIVIDER_A::DEVIDED_BY_1
    }
    #[doc = "Checks if the value of the field is `DEVIDED_BY_16`"]
    #[inline(always)]
    pub fn is_devided_by_16(&self) -> bool {
        **self == PRESCALE_DIVIDER_A::DEVIDED_BY_16
    }
    #[doc = "Checks if the value of the field is `DEVIDED_BY_256`"]
    #[inline(always)]
    pub fn is_devided_by_256(&self) -> bool {
        **self == PRESCALE_DIVIDER_A::DEVIDED_BY_256
    }
}
impl core::ops::Deref for PRESCALE_DIVIDER_R {
    type Target = crate::FieldReader<u8, PRESCALE_DIVIDER_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `prescale_divider` writer - Pre-scale divider for the timer"]
pub struct PRESCALE_DIVIDER_W<'a> {
    w: &'a mut W,
}
impl<'a> PRESCALE_DIVIDER_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PRESCALE_DIVIDER_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "divided by 1"]
    #[inline(always)]
    pub fn devided_by_1(self) -> &'a mut W {
        self.variant(PRESCALE_DIVIDER_A::DEVIDED_BY_1)
    }
    #[doc = "divided by 16"]
    #[inline(always)]
    pub fn devided_by_16(self) -> &'a mut W {
        self.variant(PRESCALE_DIVIDER_A::DEVIDED_BY_16)
    }
    #[doc = "divided by 256"]
    #[inline(always)]
    pub fn devided_by_256(self) -> &'a mut W {
        self.variant(PRESCALE_DIVIDER_A::DEVIDED_BY_256)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u32 & 0x03) << 2);
        self.w
    }
}
#[doc = "Configure the interrupt type\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum INTERRUPT_TYPE_A {
    #[doc = "0: edge"]
    EDGE = 0,
    #[doc = "1: level"]
    LEVEL = 1,
}
impl From<INTERRUPT_TYPE_A> for bool {
    #[inline(always)]
    fn from(variant: INTERRUPT_TYPE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `interrupt_type` reader - Configure the interrupt type"]
pub struct INTERRUPT_TYPE_R(crate::FieldReader<bool, INTERRUPT_TYPE_A>);
impl INTERRUPT_TYPE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        INTERRUPT_TYPE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> INTERRUPT_TYPE_A {
        match self.bits {
            false => INTERRUPT_TYPE_A::EDGE,
            true => INTERRUPT_TYPE_A::LEVEL,
        }
    }
    #[doc = "Checks if the value of the field is `EDGE`"]
    #[inline(always)]
    pub fn is_edge(&self) -> bool {
        **self == INTERRUPT_TYPE_A::EDGE
    }
    #[doc = "Checks if the value of the field is `LEVEL`"]
    #[inline(always)]
    pub fn is_level(&self) -> bool {
        **self == INTERRUPT_TYPE_A::LEVEL
    }
}
impl core::ops::Deref for INTERRUPT_TYPE_R {
    type Target = crate::FieldReader<bool, INTERRUPT_TYPE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `interrupt_type` writer - Configure the interrupt type"]
pub struct INTERRUPT_TYPE_W<'a> {
    w: &'a mut W,
}
impl<'a> INTERRUPT_TYPE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTERRUPT_TYPE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "edge"]
    #[inline(always)]
    pub fn edge(self) -> &'a mut W {
        self.variant(INTERRUPT_TYPE_A::EDGE)
    }
    #[doc = "level"]
    #[inline(always)]
    pub fn level(self) -> &'a mut W {
        self.variant(INTERRUPT_TYPE_A::LEVEL)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 8 - the status of the interrupt, when the count is equal tothe alarm value"]
    #[inline(always)]
    pub fn frc2_int(&self) -> FRC2_INT_R {
        FRC2_INT_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bits 0:7 - bit\\[7\\]: timer enable, bit\\[6\\]: automatically reload, when the counter isequal to zero, bit\\[3:2\\]: prescale-divider, 0: divided by 1, 1: dividedby 16, 2 or 3: divided by 256, bit\\[0\\]: interrupt type, 0:edge, 1:level"]
    #[inline(always)]
    pub fn frc2_ctrl(&self) -> FRC2_CTRL_R {
        FRC2_CTRL_R::new((self.bits & 0xff) as u8)
    }
    #[doc = "Bit 7 - Enable or disable the timer"]
    #[inline(always)]
    pub fn timer_enable(&self) -> TIMER_ENABLE_R {
        TIMER_ENABLE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Automatically reload when the counter hits zero"]
    #[inline(always)]
    pub fn rollover(&self) -> ROLLOVER_R {
        ROLLOVER_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bits 2:3 - Pre-scale divider for the timer"]
    #[inline(always)]
    pub fn prescale_divider(&self) -> PRESCALE_DIVIDER_R {
        PRESCALE_DIVIDER_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bit 0 - Configure the interrupt type"]
    #[inline(always)]
    pub fn interrupt_type(&self) -> INTERRUPT_TYPE_R {
        INTERRUPT_TYPE_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:7 - bit\\[7\\]: timer enable, bit\\[6\\]: automatically reload, when the counter isequal to zero, bit\\[3:2\\]: prescale-divider, 0: divided by 1, 1: dividedby 16, 2 or 3: divided by 256, bit\\[0\\]: interrupt type, 0:edge, 1:level"]
    #[inline(always)]
    pub fn frc2_ctrl(&mut self) -> FRC2_CTRL_W {
        FRC2_CTRL_W { w: self }
    }
    #[doc = "Bit 7 - Enable or disable the timer"]
    #[inline(always)]
    pub fn timer_enable(&mut self) -> TIMER_ENABLE_W {
        TIMER_ENABLE_W { w: self }
    }
    #[doc = "Bit 6 - Automatically reload when the counter hits zero"]
    #[inline(always)]
    pub fn rollover(&mut self) -> ROLLOVER_W {
        ROLLOVER_W { w: self }
    }
    #[doc = "Bits 2:3 - Pre-scale divider for the timer"]
    #[inline(always)]
    pub fn prescale_divider(&mut self) -> PRESCALE_DIVIDER_W {
        PRESCALE_DIVIDER_W { w: self }
    }
    #[doc = "Bit 0 - Configure the interrupt type"]
    #[inline(always)]
    pub fn interrupt_type(&mut self) -> INTERRUPT_TYPE_W {
        INTERRUPT_TYPE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "FRC2_CTRL\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [frc2_ctrl](index.html) module"]
pub struct FRC2_CTRL_SPEC;
impl crate::RegisterSpec for FRC2_CTRL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [frc2_ctrl::R](R) reader structure"]
impl crate::Readable for FRC2_CTRL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [frc2_ctrl::W](W) writer structure"]
impl crate::Writable for FRC2_CTRL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets FRC2_CTRL to value 0"]
impl crate::Resettable for FRC2_CTRL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
