#[doc = "Register `SPI_CLOCK` reader"]
pub struct R(crate::R<SPI_CLOCK_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_CLOCK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPI_CLOCK_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPI_CLOCK_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_CLOCK` writer"]
pub struct W(crate::W<SPI_CLOCK_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_CLOCK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPI_CLOCK_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPI_CLOCK_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `spi_clk_equ_sysclk` reader - In the master mode, 1: spi_clk is eqaul to 80MHz, 0: spi_clk is divided from 80 MHz clock."]
pub struct SPI_CLK_EQU_SYSCLK_R(crate::FieldReader<bool, bool>);
impl SPI_CLK_EQU_SYSCLK_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_CLK_EQU_SYSCLK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CLK_EQU_SYSCLK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_clk_equ_sysclk` writer - In the master mode, 1: spi_clk is eqaul to 80MHz, 0: spi_clk is divided from 80 MHz clock."]
pub struct SPI_CLK_EQU_SYSCLK_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CLK_EQU_SYSCLK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
#[doc = "Field `spi_clkdiv_pre` reader - In the master mode, it is pre-divider of spi_clk."]
pub struct SPI_CLKDIV_PRE_R(crate::FieldReader<u16, u16>);
impl SPI_CLKDIV_PRE_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        SPI_CLKDIV_PRE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CLKDIV_PRE_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_clkdiv_pre` writer - In the master mode, it is pre-divider of spi_clk."]
pub struct SPI_CLKDIV_PRE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CLKDIV_PRE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1fff << 18)) | ((value as u32 & 0x1fff) << 18);
        self.w
    }
}
#[doc = "Field `spi_clkcnt_N` reader - In the master mode, it is the divider of spi_clk. So spi_clk frequency is 80MHz/(spi_clkdiv_pre+1)/(spi_clkcnt_N+1)"]
pub struct SPI_CLKCNT_N_R(crate::FieldReader<u8, u8>);
impl SPI_CLKCNT_N_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPI_CLKCNT_N_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CLKCNT_N_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_clkcnt_N` writer - In the master mode, it is the divider of spi_clk. So spi_clk frequency is 80MHz/(spi_clkdiv_pre+1)/(spi_clkcnt_N+1)"]
pub struct SPI_CLKCNT_N_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CLKCNT_N_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x3f << 12)) | ((value as u32 & 0x3f) << 12);
        self.w
    }
}
#[doc = "Field `spi_clkcnt_H` reader - In the master mode, it must be floor((spi_clkcnt_N+1)/2-1). In the slave mode, it must be 0."]
pub struct SPI_CLKCNT_H_R(crate::FieldReader<u8, u8>);
impl SPI_CLKCNT_H_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPI_CLKCNT_H_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CLKCNT_H_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_clkcnt_H` writer - In the master mode, it must be floor((spi_clkcnt_N+1)/2-1). In the slave mode, it must be 0."]
pub struct SPI_CLKCNT_H_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CLKCNT_H_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x3f << 6)) | ((value as u32 & 0x3f) << 6);
        self.w
    }
}
#[doc = "Field `spi_clkcnt_L` reader - In the master mode, it must be eqaul to spi_clkcnt_N. In the slave mode, it must be 0."]
pub struct SPI_CLKCNT_L_R(crate::FieldReader<u8, u8>);
impl SPI_CLKCNT_L_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SPI_CLKCNT_L_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CLKCNT_L_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_clkcnt_L` writer - In the master mode, it must be eqaul to spi_clkcnt_N. In the slave mode, it must be 0."]
pub struct SPI_CLKCNT_L_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CLKCNT_L_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x3f) | (value as u32 & 0x3f);
        self.w
    }
}
impl R {
    #[doc = "Bit 31 - In the master mode, 1: spi_clk is eqaul to 80MHz, 0: spi_clk is divided from 80 MHz clock."]
    #[inline(always)]
    pub fn spi_clk_equ_sysclk(&self) -> SPI_CLK_EQU_SYSCLK_R {
        SPI_CLK_EQU_SYSCLK_R::new(((self.bits >> 31) & 0x01) != 0)
    }
    #[doc = "Bits 18:30 - In the master mode, it is pre-divider of spi_clk."]
    #[inline(always)]
    pub fn spi_clkdiv_pre(&self) -> SPI_CLKDIV_PRE_R {
        SPI_CLKDIV_PRE_R::new(((self.bits >> 18) & 0x1fff) as u16)
    }
    #[doc = "Bits 12:17 - In the master mode, it is the divider of spi_clk. So spi_clk frequency is 80MHz/(spi_clkdiv_pre+1)/(spi_clkcnt_N+1)"]
    #[inline(always)]
    pub fn spi_clkcnt_n(&self) -> SPI_CLKCNT_N_R {
        SPI_CLKCNT_N_R::new(((self.bits >> 12) & 0x3f) as u8)
    }
    #[doc = "Bits 6:11 - In the master mode, it must be floor((spi_clkcnt_N+1)/2-1). In the slave mode, it must be 0."]
    #[inline(always)]
    pub fn spi_clkcnt_h(&self) -> SPI_CLKCNT_H_R {
        SPI_CLKCNT_H_R::new(((self.bits >> 6) & 0x3f) as u8)
    }
    #[doc = "Bits 0:5 - In the master mode, it must be eqaul to spi_clkcnt_N. In the slave mode, it must be 0."]
    #[inline(always)]
    pub fn spi_clkcnt_l(&self) -> SPI_CLKCNT_L_R {
        SPI_CLKCNT_L_R::new((self.bits & 0x3f) as u8)
    }
}
impl W {
    #[doc = "Bit 31 - In the master mode, 1: spi_clk is eqaul to 80MHz, 0: spi_clk is divided from 80 MHz clock."]
    #[inline(always)]
    pub fn spi_clk_equ_sysclk(&mut self) -> SPI_CLK_EQU_SYSCLK_W {
        SPI_CLK_EQU_SYSCLK_W { w: self }
    }
    #[doc = "Bits 18:30 - In the master mode, it is pre-divider of spi_clk."]
    #[inline(always)]
    pub fn spi_clkdiv_pre(&mut self) -> SPI_CLKDIV_PRE_W {
        SPI_CLKDIV_PRE_W { w: self }
    }
    #[doc = "Bits 12:17 - In the master mode, it is the divider of spi_clk. So spi_clk frequency is 80MHz/(spi_clkdiv_pre+1)/(spi_clkcnt_N+1)"]
    #[inline(always)]
    pub fn spi_clkcnt_n(&mut self) -> SPI_CLKCNT_N_W {
        SPI_CLKCNT_N_W { w: self }
    }
    #[doc = "Bits 6:11 - In the master mode, it must be floor((spi_clkcnt_N+1)/2-1). In the slave mode, it must be 0."]
    #[inline(always)]
    pub fn spi_clkcnt_h(&mut self) -> SPI_CLKCNT_H_W {
        SPI_CLKCNT_H_W { w: self }
    }
    #[doc = "Bits 0:5 - In the master mode, it must be eqaul to spi_clkcnt_N. In the slave mode, it must be 0."]
    #[inline(always)]
    pub fn spi_clkcnt_l(&mut self) -> SPI_CLKCNT_L_W {
        SPI_CLKCNT_L_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "In the master mode, 1: spi_clk is eqaul to 80MHz, 0: spi_clk is divided from 80 MHz clock.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_clock](index.html) module"]
pub struct SPI_CLOCK_SPEC;
impl crate::RegisterSpec for SPI_CLOCK_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_clock::R](R) reader structure"]
impl crate::Readable for SPI_CLOCK_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_clock::W](W) writer structure"]
impl crate::Writable for SPI_CLOCK_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_CLOCK to value 0"]
impl crate::Resettable for SPI_CLOCK_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
