#[doc = "Register `SPI_SLAVE1` reader"]
pub struct R(crate::R<SPI_SLAVE1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_SLAVE1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPI_SLAVE1_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPI_SLAVE1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_SLAVE1` writer"]
pub struct W(crate::W<SPI_SLAVE1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_SLAVE1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPI_SLAVE1_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPI_SLAVE1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `slv_status_bitlen` reader - In the slave mode, it is the length in bits for \"write-status\" and \"read-status\" operations. The register valueshall be (bit_num-1)"]
pub struct SLV_STATUS_BITLEN_R(crate::FieldReader<u8, u8>);
impl SLV_STATUS_BITLEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SLV_STATUS_BITLEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_STATUS_BITLEN_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_status_bitlen` writer - In the slave mode, it is the length in bits for \"write-status\" and \"read-status\" operations. The register valueshall be (bit_num-1)"]
pub struct SLV_STATUS_BITLEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_STATUS_BITLEN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 27)) | ((value as u32 & 0x1f) << 27);
        self.w
    }
}
#[doc = "Field `slv_buf_bitlen` reader - In the slave mode, it is the length in bits for \"write-buffer\" and \"read-buffer\" operations. The register value shallbe (bit_num-1)"]
pub struct SLV_BUF_BITLEN_R(crate::FieldReader<u16, u16>);
impl SLV_BUF_BITLEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        SLV_BUF_BITLEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_BUF_BITLEN_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_buf_bitlen` writer - In the slave mode, it is the length in bits for \"write-buffer\" and \"read-buffer\" operations. The register value shallbe (bit_num-1)"]
pub struct SLV_BUF_BITLEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_BUF_BITLEN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01ff << 16)) | ((value as u32 & 0x01ff) << 16);
        self.w
    }
}
#[doc = "Field `slv_rd_addr_bitlen` reader - In the slave mode, it is the address length in bits for \"read-buffer\" operation. The register value shall be(bit_num-1)"]
pub struct SLV_RD_ADDR_BITLEN_R(crate::FieldReader<u8, u8>);
impl SLV_RD_ADDR_BITLEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SLV_RD_ADDR_BITLEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_RD_ADDR_BITLEN_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_rd_addr_bitlen` writer - In the slave mode, it is the address length in bits for \"read-buffer\" operation. The register value shall be(bit_num-1)"]
pub struct SLV_RD_ADDR_BITLEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_RD_ADDR_BITLEN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x3f << 10)) | ((value as u32 & 0x3f) << 10);
        self.w
    }
}
#[doc = "Field `slv_wr_addr_bitlen` reader - In the slave mode, it is the address length in bits for \"write-buffer\" operation. The register value shall be(bit_num-1)"]
pub struct SLV_WR_ADDR_BITLEN_R(crate::FieldReader<u8, u8>);
impl SLV_WR_ADDR_BITLEN_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        SLV_WR_ADDR_BITLEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_WR_ADDR_BITLEN_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_wr_addr_bitlen` writer - In the slave mode, it is the address length in bits for \"write-buffer\" operation. The register value shall be(bit_num-1)"]
pub struct SLV_WR_ADDR_BITLEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_WR_ADDR_BITLEN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x3f << 4)) | ((value as u32 & 0x3f) << 4);
        self.w
    }
}
#[doc = "Field `slv_wrsta_dummy_en` reader - In the slave mode, it is the enable bit of \"dummy\" phase for \"write-status\" operations."]
pub struct SLV_WRSTA_DUMMY_EN_R(crate::FieldReader<bool, bool>);
impl SLV_WRSTA_DUMMY_EN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SLV_WRSTA_DUMMY_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_WRSTA_DUMMY_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_wrsta_dummy_en` writer - In the slave mode, it is the enable bit of \"dummy\" phase for \"write-status\" operations."]
pub struct SLV_WRSTA_DUMMY_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_WRSTA_DUMMY_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `slv_rdsta_dummy_en` reader - In the slave mode, it is the enable bit of \"dummy\" phase for \"read-status\" operations."]
pub struct SLV_RDSTA_DUMMY_EN_R(crate::FieldReader<bool, bool>);
impl SLV_RDSTA_DUMMY_EN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SLV_RDSTA_DUMMY_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_RDSTA_DUMMY_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_rdsta_dummy_en` writer - In the slave mode, it is the enable bit of \"dummy\" phase for \"read-status\" operations."]
pub struct SLV_RDSTA_DUMMY_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_RDSTA_DUMMY_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `slv_wrbuf_dummy_en` reader - In the slave mode, it is the enable bit of \"dummy\" phase for \"write-buffer\" operations."]
pub struct SLV_WRBUF_DUMMY_EN_R(crate::FieldReader<bool, bool>);
impl SLV_WRBUF_DUMMY_EN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SLV_WRBUF_DUMMY_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_WRBUF_DUMMY_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_wrbuf_dummy_en` writer - In the slave mode, it is the enable bit of \"dummy\" phase for \"write-buffer\" operations."]
pub struct SLV_WRBUF_DUMMY_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_WRBUF_DUMMY_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `slv_rdbuf_dummy_en` reader - In the slave mode, it is the enable bit of \"dummy\" phase for \"read-buffer\" operations."]
pub struct SLV_RDBUF_DUMMY_EN_R(crate::FieldReader<bool, bool>);
impl SLV_RDBUF_DUMMY_EN_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SLV_RDBUF_DUMMY_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_RDBUF_DUMMY_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_rdbuf_dummy_en` writer - In the slave mode, it is the enable bit of \"dummy\" phase for \"read-buffer\" operations."]
pub struct SLV_RDBUF_DUMMY_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_RDBUF_DUMMY_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `spi_status_fast_enable` reader - Enable fast spi slave status"]
pub struct SPI_STATUS_FAST_ENABLE_R(crate::FieldReader<bool, bool>);
impl SPI_STATUS_FAST_ENABLE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_STATUS_FAST_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_STATUS_FAST_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_status_fast_enable` writer - Enable fast spi slave status"]
pub struct SPI_STATUS_FAST_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_STATUS_FAST_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 26)) | ((value as u32 & 0x01) << 26);
        self.w
    }
}
#[doc = "Field `spi_status_read` reader - Enable spi slave status"]
pub struct SPI_STATUS_READ_R(crate::FieldReader<bool, bool>);
impl SPI_STATUS_READ_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        SPI_STATUS_READ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_STATUS_READ_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_status_read` writer - Enable spi slave status"]
pub struct SPI_STATUS_READ_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_STATUS_READ_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 25)) | ((value as u32 & 0x01) << 25);
        self.w
    }
}
impl R {
    #[doc = "Bits 27:31 - In the slave mode, it is the length in bits for \"write-status\" and \"read-status\" operations. The register valueshall be (bit_num-1)"]
    #[inline(always)]
    pub fn slv_status_bitlen(&self) -> SLV_STATUS_BITLEN_R {
        SLV_STATUS_BITLEN_R::new(((self.bits >> 27) & 0x1f) as u8)
    }
    #[doc = "Bits 16:24 - In the slave mode, it is the length in bits for \"write-buffer\" and \"read-buffer\" operations. The register value shallbe (bit_num-1)"]
    #[inline(always)]
    pub fn slv_buf_bitlen(&self) -> SLV_BUF_BITLEN_R {
        SLV_BUF_BITLEN_R::new(((self.bits >> 16) & 0x01ff) as u16)
    }
    #[doc = "Bits 10:15 - In the slave mode, it is the address length in bits for \"read-buffer\" operation. The register value shall be(bit_num-1)"]
    #[inline(always)]
    pub fn slv_rd_addr_bitlen(&self) -> SLV_RD_ADDR_BITLEN_R {
        SLV_RD_ADDR_BITLEN_R::new(((self.bits >> 10) & 0x3f) as u8)
    }
    #[doc = "Bits 4:9 - In the slave mode, it is the address length in bits for \"write-buffer\" operation. The register value shall be(bit_num-1)"]
    #[inline(always)]
    pub fn slv_wr_addr_bitlen(&self) -> SLV_WR_ADDR_BITLEN_R {
        SLV_WR_ADDR_BITLEN_R::new(((self.bits >> 4) & 0x3f) as u8)
    }
    #[doc = "Bit 3 - In the slave mode, it is the enable bit of \"dummy\" phase for \"write-status\" operations."]
    #[inline(always)]
    pub fn slv_wrsta_dummy_en(&self) -> SLV_WRSTA_DUMMY_EN_R {
        SLV_WRSTA_DUMMY_EN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - In the slave mode, it is the enable bit of \"dummy\" phase for \"read-status\" operations."]
    #[inline(always)]
    pub fn slv_rdsta_dummy_en(&self) -> SLV_RDSTA_DUMMY_EN_R {
        SLV_RDSTA_DUMMY_EN_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - In the slave mode, it is the enable bit of \"dummy\" phase for \"write-buffer\" operations."]
    #[inline(always)]
    pub fn slv_wrbuf_dummy_en(&self) -> SLV_WRBUF_DUMMY_EN_R {
        SLV_WRBUF_DUMMY_EN_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - In the slave mode, it is the enable bit of \"dummy\" phase for \"read-buffer\" operations."]
    #[inline(always)]
    pub fn slv_rdbuf_dummy_en(&self) -> SLV_RDBUF_DUMMY_EN_R {
        SLV_RDBUF_DUMMY_EN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 26 - Enable fast spi slave status"]
    #[inline(always)]
    pub fn spi_status_fast_enable(&self) -> SPI_STATUS_FAST_ENABLE_R {
        SPI_STATUS_FAST_ENABLE_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 25 - Enable spi slave status"]
    #[inline(always)]
    pub fn spi_status_read(&self) -> SPI_STATUS_READ_R {
        SPI_STATUS_READ_R::new(((self.bits >> 25) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 27:31 - In the slave mode, it is the length in bits for \"write-status\" and \"read-status\" operations. The register valueshall be (bit_num-1)"]
    #[inline(always)]
    pub fn slv_status_bitlen(&mut self) -> SLV_STATUS_BITLEN_W {
        SLV_STATUS_BITLEN_W { w: self }
    }
    #[doc = "Bits 16:24 - In the slave mode, it is the length in bits for \"write-buffer\" and \"read-buffer\" operations. The register value shallbe (bit_num-1)"]
    #[inline(always)]
    pub fn slv_buf_bitlen(&mut self) -> SLV_BUF_BITLEN_W {
        SLV_BUF_BITLEN_W { w: self }
    }
    #[doc = "Bits 10:15 - In the slave mode, it is the address length in bits for \"read-buffer\" operation. The register value shall be(bit_num-1)"]
    #[inline(always)]
    pub fn slv_rd_addr_bitlen(&mut self) -> SLV_RD_ADDR_BITLEN_W {
        SLV_RD_ADDR_BITLEN_W { w: self }
    }
    #[doc = "Bits 4:9 - In the slave mode, it is the address length in bits for \"write-buffer\" operation. The register value shall be(bit_num-1)"]
    #[inline(always)]
    pub fn slv_wr_addr_bitlen(&mut self) -> SLV_WR_ADDR_BITLEN_W {
        SLV_WR_ADDR_BITLEN_W { w: self }
    }
    #[doc = "Bit 3 - In the slave mode, it is the enable bit of \"dummy\" phase for \"write-status\" operations."]
    #[inline(always)]
    pub fn slv_wrsta_dummy_en(&mut self) -> SLV_WRSTA_DUMMY_EN_W {
        SLV_WRSTA_DUMMY_EN_W { w: self }
    }
    #[doc = "Bit 2 - In the slave mode, it is the enable bit of \"dummy\" phase for \"read-status\" operations."]
    #[inline(always)]
    pub fn slv_rdsta_dummy_en(&mut self) -> SLV_RDSTA_DUMMY_EN_W {
        SLV_RDSTA_DUMMY_EN_W { w: self }
    }
    #[doc = "Bit 1 - In the slave mode, it is the enable bit of \"dummy\" phase for \"write-buffer\" operations."]
    #[inline(always)]
    pub fn slv_wrbuf_dummy_en(&mut self) -> SLV_WRBUF_DUMMY_EN_W {
        SLV_WRBUF_DUMMY_EN_W { w: self }
    }
    #[doc = "Bit 0 - In the slave mode, it is the enable bit of \"dummy\" phase for \"read-buffer\" operations."]
    #[inline(always)]
    pub fn slv_rdbuf_dummy_en(&mut self) -> SLV_RDBUF_DUMMY_EN_W {
        SLV_RDBUF_DUMMY_EN_W { w: self }
    }
    #[doc = "Bit 26 - Enable fast spi slave status"]
    #[inline(always)]
    pub fn spi_status_fast_enable(&mut self) -> SPI_STATUS_FAST_ENABLE_W {
        SPI_STATUS_FAST_ENABLE_W { w: self }
    }
    #[doc = "Bit 25 - Enable spi slave status"]
    #[inline(always)]
    pub fn spi_status_read(&mut self) -> SPI_STATUS_READ_W {
        SPI_STATUS_READ_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "In the slave mode, it is the length in bits for \"write-status\" and \"read-status\" operations. The register valueshall be (bit_num-1)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_slave1](index.html) module"]
pub struct SPI_SLAVE1_SPEC;
impl crate::RegisterSpec for SPI_SLAVE1_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_slave1::R](R) reader structure"]
impl crate::Readable for SPI_SLAVE1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_slave1::W](W) writer structure"]
impl crate::Writable for SPI_SLAVE1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_SLAVE1 to value 0"]
impl crate::Resettable for SPI_SLAVE1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
