#[doc = "Register `GPIO_RTC_CALIB_SYNC` reader"]
pub struct R(crate::R<GPIO_RTC_CALIB_SYNC_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GPIO_RTC_CALIB_SYNC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GPIO_RTC_CALIB_SYNC_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GPIO_RTC_CALIB_SYNC_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GPIO_RTC_CALIB_SYNC` writer"]
pub struct W(crate::W<GPIO_RTC_CALIB_SYNC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GPIO_RTC_CALIB_SYNC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GPIO_RTC_CALIB_SYNC_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GPIO_RTC_CALIB_SYNC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `RTC_CALIB_START` reader - Positvie edge of this bit will trigger the RTC-clock-calibration process."]
pub struct RTC_CALIB_START_R(crate::FieldReader<bool, bool>);
impl RTC_CALIB_START_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        RTC_CALIB_START_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RTC_CALIB_START_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RTC_CALIB_START` writer - Positvie edge of this bit will trigger the RTC-clock-calibration process."]
pub struct RTC_CALIB_START_W<'a> {
    w: &'a mut W,
}
impl<'a> RTC_CALIB_START_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
#[doc = "Field `RTC_PERIOD_NUM` reader - The cycle number of RTC-clock during RTC-clock-calibration"]
pub struct RTC_PERIOD_NUM_R(crate::FieldReader<u16, u16>);
impl RTC_PERIOD_NUM_R {
    #[inline(always)]
    pub(crate) fn new(bits: u16) -> Self {
        RTC_PERIOD_NUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RTC_PERIOD_NUM_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RTC_PERIOD_NUM` writer - The cycle number of RTC-clock during RTC-clock-calibration"]
pub struct RTC_PERIOD_NUM_W<'a> {
    w: &'a mut W,
}
impl<'a> RTC_PERIOD_NUM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03ff) | (value as u32 & 0x03ff);
        self.w
    }
}
impl R {
    #[doc = "Bit 31 - Positvie edge of this bit will trigger the RTC-clock-calibration process."]
    #[inline(always)]
    pub fn rtc_calib_start(&self) -> RTC_CALIB_START_R {
        RTC_CALIB_START_R::new(((self.bits >> 31) & 0x01) != 0)
    }
    #[doc = "Bits 0:9 - The cycle number of RTC-clock during RTC-clock-calibration"]
    #[inline(always)]
    pub fn rtc_period_num(&self) -> RTC_PERIOD_NUM_R {
        RTC_PERIOD_NUM_R::new((self.bits & 0x03ff) as u16)
    }
}
impl W {
    #[doc = "Bit 31 - Positvie edge of this bit will trigger the RTC-clock-calibration process."]
    #[inline(always)]
    pub fn rtc_calib_start(&mut self) -> RTC_CALIB_START_W {
        RTC_CALIB_START_W { w: self }
    }
    #[doc = "Bits 0:9 - The cycle number of RTC-clock during RTC-clock-calibration"]
    #[inline(always)]
    pub fn rtc_period_num(&mut self) -> RTC_PERIOD_NUM_W {
        RTC_PERIOD_NUM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Positvie edge of this bit will trigger the RTC-clock-calibration process.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gpio_rtc_calib_sync](index.html) module"]
pub struct GPIO_RTC_CALIB_SYNC_SPEC;
impl crate::RegisterSpec for GPIO_RTC_CALIB_SYNC_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gpio_rtc_calib_sync::R](R) reader structure"]
impl crate::Readable for GPIO_RTC_CALIB_SYNC_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gpio_rtc_calib_sync::W](W) writer structure"]
impl crate::Writable for GPIO_RTC_CALIB_SYNC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GPIO_RTC_CALIB_SYNC to value 0"]
impl crate::Resettable for GPIO_RTC_CALIB_SYNC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
