#[doc = "Register `SPI_CACHE` reader"]
pub struct R(crate::R<SPI_CACHE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_CACHE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SPI_CACHE_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SPI_CACHE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_CACHE` writer"]
pub struct W(crate::W<SPI_CACHE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_CACHE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SPI_CACHE_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SPI_CACHE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `cache_flush_start` reader - Flush cache"]
pub struct CACHE_FLUSH_START_R(crate::FieldReader<bool, bool>);
impl CACHE_FLUSH_START_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CACHE_FLUSH_START_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CACHE_FLUSH_START_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `cache_flush_start` writer - Flush cache"]
pub struct CACHE_FLUSH_START_W<'a> {
    w: &'a mut W,
}
impl<'a> CACHE_FLUSH_START_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Field `cache_empty` reader - Cache is empty"]
pub struct CACHE_EMPTY_R(crate::FieldReader<bool, bool>);
impl CACHE_EMPTY_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CACHE_EMPTY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CACHE_EMPTY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `cache_empty` writer - Cache is empty"]
pub struct CACHE_EMPTY_W<'a> {
    w: &'a mut W,
}
impl<'a> CACHE_EMPTY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `cache_enable` reader - Cache enable"]
pub struct CACHE_ENABLE_R(crate::FieldReader<bool, bool>);
impl CACHE_ENABLE_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        CACHE_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CACHE_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `cache_enable` writer - Cache enable"]
pub struct CACHE_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> CACHE_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `busy` reader - SPI busy"]
pub struct BUSY_R(crate::FieldReader<bool, bool>);
impl BUSY_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        BUSY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BUSY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `busy` writer - SPI busy"]
pub struct BUSY_W<'a> {
    w: &'a mut W,
}
impl<'a> BUSY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `block` reader - Flash memory block to map, in 2mb blocks"]
pub struct BLOCK_R(crate::FieldReader<u8, u8>);
impl BLOCK_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        BLOCK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BLOCK_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `block` writer - Flash memory block to map, in 2mb blocks"]
pub struct BLOCK_W<'a> {
    w: &'a mut W,
}
impl<'a> BLOCK_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 16)) | ((value as u32 & 0x07) << 16);
        self.w
    }
}
#[doc = "Field `offset` reader - Offset within block to map, in megabytes"]
pub struct OFFSET_R(crate::FieldReader<u8, u8>);
impl OFFSET_R {
    #[inline(always)]
    pub(crate) fn new(bits: u8) -> Self {
        OFFSET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OFFSET_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `offset` writer - Offset within block to map, in megabytes"]
pub struct OFFSET_W<'a> {
    w: &'a mut W,
}
impl<'a> OFFSET_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 24)) | ((value as u32 & 0x03) << 24);
        self.w
    }
}
#[doc = "Field `target` reader - Controls where the spi flash is mapped (unconfirmed)"]
pub struct TARGET_R(crate::FieldReader<bool, bool>);
impl TARGET_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        TARGET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TARGET_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `target` writer - Controls where the spi flash is mapped (unconfirmed)"]
pub struct TARGET_W<'a> {
    w: &'a mut W,
}
impl<'a> TARGET_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 26)) | ((value as u32 & 0x01) << 26);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Flush cache"]
    #[inline(always)]
    pub fn cache_flush_start(&self) -> CACHE_FLUSH_START_R {
        CACHE_FLUSH_START_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Cache is empty"]
    #[inline(always)]
    pub fn cache_empty(&self) -> CACHE_EMPTY_R {
        CACHE_EMPTY_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Cache enable"]
    #[inline(always)]
    pub fn cache_enable(&self) -> CACHE_ENABLE_R {
        CACHE_ENABLE_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - SPI busy"]
    #[inline(always)]
    pub fn busy(&self) -> BUSY_R {
        BUSY_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bits 16:18 - Flash memory block to map, in 2mb blocks"]
    #[inline(always)]
    pub fn block(&self) -> BLOCK_R {
        BLOCK_R::new(((self.bits >> 16) & 0x07) as u8)
    }
    #[doc = "Bits 24:25 - Offset within block to map, in megabytes"]
    #[inline(always)]
    pub fn offset(&self) -> OFFSET_R {
        OFFSET_R::new(((self.bits >> 24) & 0x03) as u8)
    }
    #[doc = "Bit 26 - Controls where the spi flash is mapped (unconfirmed)"]
    #[inline(always)]
    pub fn target(&self) -> TARGET_R {
        TARGET_R::new(((self.bits >> 26) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Flush cache"]
    #[inline(always)]
    pub fn cache_flush_start(&mut self) -> CACHE_FLUSH_START_W {
        CACHE_FLUSH_START_W { w: self }
    }
    #[doc = "Bit 1 - Cache is empty"]
    #[inline(always)]
    pub fn cache_empty(&mut self) -> CACHE_EMPTY_W {
        CACHE_EMPTY_W { w: self }
    }
    #[doc = "Bit 8 - Cache enable"]
    #[inline(always)]
    pub fn cache_enable(&mut self) -> CACHE_ENABLE_W {
        CACHE_ENABLE_W { w: self }
    }
    #[doc = "Bit 9 - SPI busy"]
    #[inline(always)]
    pub fn busy(&mut self) -> BUSY_W {
        BUSY_W { w: self }
    }
    #[doc = "Bits 16:18 - Flash memory block to map, in 2mb blocks"]
    #[inline(always)]
    pub fn block(&mut self) -> BLOCK_W {
        BLOCK_W { w: self }
    }
    #[doc = "Bits 24:25 - Offset within block to map, in megabytes"]
    #[inline(always)]
    pub fn offset(&mut self) -> OFFSET_W {
        OFFSET_W { w: self }
    }
    #[doc = "Bit 26 - Controls where the spi flash is mapped (unconfirmed)"]
    #[inline(always)]
    pub fn target(&mut self) -> TARGET_W {
        TARGET_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Controls SPI memory-mapped caching\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_cache](index.html) module"]
pub struct SPI_CACHE_SPEC;
impl crate::RegisterSpec for SPI_CACHE_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_cache::R](R) reader structure"]
impl crate::Readable for SPI_CACHE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_cache::W](W) writer structure"]
impl crate::Writable for SPI_CACHE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_CACHE to value 0"]
impl crate::Resettable for SPI_CACHE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
