#[doc = "Register `WDT_CTL` reader"]
pub struct R(crate::R<WDT_CTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<WDT_CTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<WDT_CTL_SPEC>> for R {
    fn from(reader: crate::R<WDT_CTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `WDT_CTL` writer"]
pub struct W(crate::W<WDT_CTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<WDT_CTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<WDT_CTL_SPEC>> for W {
    fn from(writer: crate::W<WDT_CTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `Register` reader - "]
pub struct REGISTER_R(crate::FieldReader<u32, u32>);
impl REGISTER_R {
    pub(crate) fn new(bits: u32) -> Self {
        REGISTER_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REGISTER_R {
    type Target = crate::FieldReader<u32, u32>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Register` writer - "]
pub struct REGISTER_W<'a> {
    w: &'a mut W,
}
impl<'a> REGISTER_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u32) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
        self.w
    }
}
#[doc = "Field `enable` reader - Enable the watchdog timer."]
pub struct ENABLE_R(crate::FieldReader<bool, bool>);
impl ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `enable` writer - Enable the watchdog timer."]
pub struct ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
        self.w
    }
}
#[doc = "Field `stage_1_no_reset` reader - When set to 1, and running in two-stage mode, it turns the watchdog into a single shot timer that doesn't reset the device."]
pub struct STAGE_1_NO_RESET_R(crate::FieldReader<bool, bool>);
impl STAGE_1_NO_RESET_R {
    pub(crate) fn new(bits: bool) -> Self {
        STAGE_1_NO_RESET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STAGE_1_NO_RESET_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `stage_1_no_reset` writer - When set to 1, and running in two-stage mode, it turns the watchdog into a single shot timer that doesn't reset the device."]
pub struct STAGE_1_NO_RESET_W<'a> {
    w: &'a mut W,
}
impl<'a> STAGE_1_NO_RESET_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `stage_1_disable` reader - Set to 1 to disable the stage 1 of the watchdog timer"]
pub struct STAGE_1_DISABLE_R(crate::FieldReader<bool, bool>);
impl STAGE_1_DISABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        STAGE_1_DISABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STAGE_1_DISABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `stage_1_disable` writer - Set to 1 to disable the stage 1 of the watchdog timer"]
pub struct STAGE_1_DISABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> STAGE_1_DISABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `unknown_3` reader - "]
pub struct UNKNOWN_3_R(crate::FieldReader<bool, bool>);
impl UNKNOWN_3_R {
    pub(crate) fn new(bits: bool) -> Self {
        UNKNOWN_3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UNKNOWN_3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `unknown_3` writer - "]
pub struct UNKNOWN_3_W<'a> {
    w: &'a mut W,
}
impl<'a> UNKNOWN_3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `unknown_4` reader - "]
pub struct UNKNOWN_4_R(crate::FieldReader<bool, bool>);
impl UNKNOWN_4_R {
    pub(crate) fn new(bits: bool) -> Self {
        UNKNOWN_4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UNKNOWN_4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `unknown_4` writer - "]
pub struct UNKNOWN_4_W<'a> {
    w: &'a mut W,
}
impl<'a> UNKNOWN_4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `unknown_5` reader - "]
pub struct UNKNOWN_5_R(crate::FieldReader<bool, bool>);
impl UNKNOWN_5_R {
    pub(crate) fn new(bits: bool) -> Self {
        UNKNOWN_5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UNKNOWN_5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `unknown_5` writer - "]
pub struct UNKNOWN_5_W<'a> {
    w: &'a mut W,
}
impl<'a> UNKNOWN_5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:31"]
    #[inline(always)]
    pub fn register(&self) -> REGISTER_R {
        REGISTER_R::new((self.bits & 0xffff_ffff) as u32)
    }
    #[doc = "Bit 0 - Enable the watchdog timer."]
    #[inline(always)]
    pub fn enable(&self) -> ENABLE_R {
        ENABLE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - When set to 1, and running in two-stage mode, it turns the watchdog into a single shot timer that doesn't reset the device."]
    #[inline(always)]
    pub fn stage_1_no_reset(&self) -> STAGE_1_NO_RESET_R {
        STAGE_1_NO_RESET_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Set to 1 to disable the stage 1 of the watchdog timer"]
    #[inline(always)]
    pub fn stage_1_disable(&self) -> STAGE_1_DISABLE_R {
        STAGE_1_DISABLE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3"]
    #[inline(always)]
    pub fn unknown_3(&self) -> UNKNOWN_3_R {
        UNKNOWN_3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4"]
    #[inline(always)]
    pub fn unknown_4(&self) -> UNKNOWN_4_R {
        UNKNOWN_4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5"]
    #[inline(always)]
    pub fn unknown_5(&self) -> UNKNOWN_5_R {
        UNKNOWN_5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:31"]
    #[inline(always)]
    pub fn register(&mut self) -> REGISTER_W {
        REGISTER_W { w: self }
    }
    #[doc = "Bit 0 - Enable the watchdog timer."]
    #[inline(always)]
    pub fn enable(&mut self) -> ENABLE_W {
        ENABLE_W { w: self }
    }
    #[doc = "Bit 1 - When set to 1, and running in two-stage mode, it turns the watchdog into a single shot timer that doesn't reset the device."]
    #[inline(always)]
    pub fn stage_1_no_reset(&mut self) -> STAGE_1_NO_RESET_W {
        STAGE_1_NO_RESET_W { w: self }
    }
    #[doc = "Bit 2 - Set to 1 to disable the stage 1 of the watchdog timer"]
    #[inline(always)]
    pub fn stage_1_disable(&mut self) -> STAGE_1_DISABLE_W {
        STAGE_1_DISABLE_W { w: self }
    }
    #[doc = "Bit 3"]
    #[inline(always)]
    pub fn unknown_3(&mut self) -> UNKNOWN_3_W {
        UNKNOWN_3_W { w: self }
    }
    #[doc = "Bit 4"]
    #[inline(always)]
    pub fn unknown_4(&mut self) -> UNKNOWN_4_W {
        UNKNOWN_4_W { w: self }
    }
    #[doc = "Bit 5"]
    #[inline(always)]
    pub fn unknown_5(&mut self) -> UNKNOWN_5_W {
        UNKNOWN_5_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "WDT_CTL\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [wdt_ctl](index.html) module"]
pub struct WDT_CTL_SPEC;
impl crate::RegisterSpec for WDT_CTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [wdt_ctl::R](R) reader structure"]
impl crate::Readable for WDT_CTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [wdt_ctl::W](W) writer structure"]
impl crate::Writable for WDT_CTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets WDT_CTL to value 0"]
impl crate::Resettable for WDT_CTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
