#[doc = "Register `UART_INT_ST` reader"]
pub struct R(crate::R<UART_INT_ST_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UART_INT_ST_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<UART_INT_ST_SPEC>> for R {
    fn from(reader: crate::R<UART_INT_ST_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `rxfifo_tout_int_st` reader - The interrupt state bit for Rx time-out event"]
pub struct RXFIFO_TOUT_INT_ST_R(crate::FieldReader<bool, bool>);
impl RXFIFO_TOUT_INT_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXFIFO_TOUT_INT_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXFIFO_TOUT_INT_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `brk_det_int_st` reader - The interrupt state bit for rx byte start error"]
pub struct BRK_DET_INT_ST_R(crate::FieldReader<bool, bool>);
impl BRK_DET_INT_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        BRK_DET_INT_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BRK_DET_INT_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `cts_chg_int_st` reader - The interrupt state bit for CTS changing level"]
pub struct CTS_CHG_INT_ST_R(crate::FieldReader<bool, bool>);
impl CTS_CHG_INT_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        CTS_CHG_INT_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CTS_CHG_INT_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `dsr_chg_int_st` reader - The interrupt state bit for DSR changing level"]
pub struct DSR_CHG_INT_ST_R(crate::FieldReader<bool, bool>);
impl DSR_CHG_INT_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        DSR_CHG_INT_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DSR_CHG_INT_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `rxfifo_ovf_int_st` reader - The interrupt state bit for RX fifo overflow"]
pub struct RXFIFO_OVF_INT_ST_R(crate::FieldReader<bool, bool>);
impl RXFIFO_OVF_INT_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXFIFO_OVF_INT_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXFIFO_OVF_INT_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `frm_err_int_st` reader - The interrupt state for other rx error"]
pub struct FRM_ERR_INT_ST_R(crate::FieldReader<bool, bool>);
impl FRM_ERR_INT_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        FRM_ERR_INT_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FRM_ERR_INT_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `parity_err_int_st` reader - The interrupt state bit for rx parity error"]
pub struct PARITY_ERR_INT_ST_R(crate::FieldReader<bool, bool>);
impl PARITY_ERR_INT_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        PARITY_ERR_INT_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PARITY_ERR_INT_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `txfifo_empty_int_st` reader - The interrupt state bit for TX fifo empty"]
pub struct TXFIFO_EMPTY_INT_ST_R(crate::FieldReader<bool, bool>);
impl TXFIFO_EMPTY_INT_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXFIFO_EMPTY_INT_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXFIFO_EMPTY_INT_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `rxfifo_full_int_st` reader - The interrupt state bit for RX fifo full event"]
pub struct RXFIFO_FULL_INT_ST_R(crate::FieldReader<bool, bool>);
impl RXFIFO_FULL_INT_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXFIFO_FULL_INT_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXFIFO_FULL_INT_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 8 - The interrupt state bit for Rx time-out event"]
    #[inline(always)]
    pub fn rxfifo_tout_int_st(&self) -> RXFIFO_TOUT_INT_ST_R {
        RXFIFO_TOUT_INT_ST_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - The interrupt state bit for rx byte start error"]
    #[inline(always)]
    pub fn brk_det_int_st(&self) -> BRK_DET_INT_ST_R {
        BRK_DET_INT_ST_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - The interrupt state bit for CTS changing level"]
    #[inline(always)]
    pub fn cts_chg_int_st(&self) -> CTS_CHG_INT_ST_R {
        CTS_CHG_INT_ST_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - The interrupt state bit for DSR changing level"]
    #[inline(always)]
    pub fn dsr_chg_int_st(&self) -> DSR_CHG_INT_ST_R {
        DSR_CHG_INT_ST_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - The interrupt state bit for RX fifo overflow"]
    #[inline(always)]
    pub fn rxfifo_ovf_int_st(&self) -> RXFIFO_OVF_INT_ST_R {
        RXFIFO_OVF_INT_ST_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - The interrupt state for other rx error"]
    #[inline(always)]
    pub fn frm_err_int_st(&self) -> FRM_ERR_INT_ST_R {
        FRM_ERR_INT_ST_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - The interrupt state bit for rx parity error"]
    #[inline(always)]
    pub fn parity_err_int_st(&self) -> PARITY_ERR_INT_ST_R {
        PARITY_ERR_INT_ST_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - The interrupt state bit for TX fifo empty"]
    #[inline(always)]
    pub fn txfifo_empty_int_st(&self) -> TXFIFO_EMPTY_INT_ST_R {
        TXFIFO_EMPTY_INT_ST_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - The interrupt state bit for RX fifo full event"]
    #[inline(always)]
    pub fn rxfifo_full_int_st(&self) -> RXFIFO_FULL_INT_ST_R {
        RXFIFO_FULL_INT_ST_R::new((self.bits & 0x01) != 0)
    }
}
#[doc = "UART INTERRUPT STATEREGISTERUART_INT_RAW&UART_INT_ENA\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [uart_int_st](index.html) module"]
pub struct UART_INT_ST_SPEC;
impl crate::RegisterSpec for UART_INT_ST_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [uart_int_st::R](R) reader structure"]
impl crate::Readable for UART_INT_ST_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets UART_INT_ST to value 0"]
impl crate::Resettable for UART_INT_ST_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
