#[doc = "Register `UART_AUTOBAUD` reader"]
pub struct R(crate::R<UART_AUTOBAUD_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UART_AUTOBAUD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<UART_AUTOBAUD_SPEC>> for R {
    fn from(reader: crate::R<UART_AUTOBAUD_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UART_AUTOBAUD` writer"]
pub struct W(crate::W<UART_AUTOBAUD_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UART_AUTOBAUD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<UART_AUTOBAUD_SPEC>> for W {
    fn from(writer: crate::W<UART_AUTOBAUD_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `glitch_filt` reader - "]
pub struct GLITCH_FILT_R(crate::FieldReader<u8, u8>);
impl GLITCH_FILT_R {
    pub(crate) fn new(bits: u8) -> Self {
        GLITCH_FILT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GLITCH_FILT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `glitch_filt` writer - "]
pub struct GLITCH_FILT_W<'a> {
    w: &'a mut W,
}
impl<'a> GLITCH_FILT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
        self.w
    }
}
#[doc = "Field `autobaud_en` reader - Set this bit to enable baudrate detect"]
pub struct AUTOBAUD_EN_R(crate::FieldReader<bool, bool>);
impl AUTOBAUD_EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        AUTOBAUD_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AUTOBAUD_EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `autobaud_en` writer - Set this bit to enable baudrate detect"]
pub struct AUTOBAUD_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> AUTOBAUD_EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bits 8:15"]
    #[inline(always)]
    pub fn glitch_filt(&self) -> GLITCH_FILT_R {
        GLITCH_FILT_R::new(((self.bits >> 8) & 0xff) as u8)
    }
    #[doc = "Bit 0 - Set this bit to enable baudrate detect"]
    #[inline(always)]
    pub fn autobaud_en(&self) -> AUTOBAUD_EN_R {
        AUTOBAUD_EN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 8:15"]
    #[inline(always)]
    pub fn glitch_filt(&mut self) -> GLITCH_FILT_W {
        GLITCH_FILT_W { w: self }
    }
    #[doc = "Bit 0 - Set this bit to enable baudrate detect"]
    #[inline(always)]
    pub fn autobaud_en(&mut self) -> AUTOBAUD_EN_W {
        AUTOBAUD_EN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "UART BAUDRATE DETECT REGISTER\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [uart_autobaud](index.html) module"]
pub struct UART_AUTOBAUD_SPEC;
impl crate::RegisterSpec for UART_AUTOBAUD_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [uart_autobaud::R](R) reader structure"]
impl crate::Readable for UART_AUTOBAUD_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [uart_autobaud::W](W) writer structure"]
impl crate::Writable for UART_AUTOBAUD_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UART_AUTOBAUD to value 0"]
impl crate::Resettable for UART_AUTOBAUD_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
