#[doc = "Register `SPI_PIN` reader"]
pub struct R(crate::R<SPI_PIN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_PIN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<SPI_PIN_SPEC>> for R {
    fn from(reader: crate::R<SPI_PIN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_PIN` writer"]
pub struct W(crate::W<SPI_PIN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_PIN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<SPI_PIN_SPEC>> for W {
    fn from(writer: crate::W<SPI_PIN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `spi_cs2_dis` reader - 1: disable CS2; 0: spi_cs signal is from/to CS2 pin"]
pub struct SPI_CS2_DIS_R(crate::FieldReader<bool, bool>);
impl SPI_CS2_DIS_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI_CS2_DIS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CS2_DIS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_cs2_dis` writer - 1: disable CS2; 0: spi_cs signal is from/to CS2 pin"]
pub struct SPI_CS2_DIS_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CS2_DIS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `spi_cs1_dis` reader - 1: disable CS1; 0: spi_cs signal is from/to CS1 pin"]
pub struct SPI_CS1_DIS_R(crate::FieldReader<bool, bool>);
impl SPI_CS1_DIS_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI_CS1_DIS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CS1_DIS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_cs1_dis` writer - 1: disable CS1; 0: spi_cs signal is from/to CS1 pin"]
pub struct SPI_CS1_DIS_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CS1_DIS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `spi_cs0_dis` reader - 1: disable CS0; 0: spi_cs signal is from/to CS0 pin"]
pub struct SPI_CS0_DIS_R(crate::FieldReader<bool, bool>);
impl SPI_CS0_DIS_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI_CS0_DIS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_CS0_DIS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_cs0_dis` writer - 1: disable CS0; 0: spi_cs signal is from/to CS0 pin"]
pub struct SPI_CS0_DIS_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_CS0_DIS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
        self.w
    }
}
#[doc = "Field `spi_idle_edge` reader - In the master mode, 1: high when idle; 0: low when idle"]
pub struct SPI_IDLE_EDGE_R(crate::FieldReader<bool, bool>);
impl SPI_IDLE_EDGE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI_IDLE_EDGE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_IDLE_EDGE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_idle_edge` writer - In the master mode, 1: high when idle; 0: low when idle"]
pub struct SPI_IDLE_EDGE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_IDLE_EDGE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
        self.w
    }
}
impl R {
    #[doc = "Bit 2 - 1: disable CS2; 0: spi_cs signal is from/to CS2 pin"]
    #[inline(always)]
    pub fn spi_cs2_dis(&self) -> SPI_CS2_DIS_R {
        SPI_CS2_DIS_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - 1: disable CS1; 0: spi_cs signal is from/to CS1 pin"]
    #[inline(always)]
    pub fn spi_cs1_dis(&self) -> SPI_CS1_DIS_R {
        SPI_CS1_DIS_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - 1: disable CS0; 0: spi_cs signal is from/to CS0 pin"]
    #[inline(always)]
    pub fn spi_cs0_dis(&self) -> SPI_CS0_DIS_R {
        SPI_CS0_DIS_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 29 - In the master mode, 1: high when idle; 0: low when idle"]
    #[inline(always)]
    pub fn spi_idle_edge(&self) -> SPI_IDLE_EDGE_R {
        SPI_IDLE_EDGE_R::new(((self.bits >> 29) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - 1: disable CS2; 0: spi_cs signal is from/to CS2 pin"]
    #[inline(always)]
    pub fn spi_cs2_dis(&mut self) -> SPI_CS2_DIS_W {
        SPI_CS2_DIS_W { w: self }
    }
    #[doc = "Bit 1 - 1: disable CS1; 0: spi_cs signal is from/to CS1 pin"]
    #[inline(always)]
    pub fn spi_cs1_dis(&mut self) -> SPI_CS1_DIS_W {
        SPI_CS1_DIS_W { w: self }
    }
    #[doc = "Bit 0 - 1: disable CS0; 0: spi_cs signal is from/to CS0 pin"]
    #[inline(always)]
    pub fn spi_cs0_dis(&mut self) -> SPI_CS0_DIS_W {
        SPI_CS0_DIS_W { w: self }
    }
    #[doc = "Bit 29 - In the master mode, 1: high when idle; 0: low when idle"]
    #[inline(always)]
    pub fn spi_idle_edge(&mut self) -> SPI_IDLE_EDGE_W {
        SPI_IDLE_EDGE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "1: disable CS2; 0: spi_cs signal is from/to CS2 pin\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_pin](index.html) module"]
pub struct SPI_PIN_SPEC;
impl crate::RegisterSpec for SPI_PIN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_pin::R](R) reader structure"]
impl crate::Readable for SPI_PIN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_pin::W](W) writer structure"]
impl crate::Writable for SPI_PIN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_PIN to value 0"]
impl crate::Resettable for SPI_PIN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
