#[doc = "Register `SPI_USER1` reader"]
pub struct R(crate::R<SPI_USER1_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_USER1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<SPI_USER1_SPEC>> for R {
    fn from(reader: crate::R<SPI_USER1_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_USER1` writer"]
pub struct W(crate::W<SPI_USER1_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_USER1_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<SPI_USER1_SPEC>> for W {
    fn from(writer: crate::W<SPI_USER1_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `reg_usr_addr_bitlen` reader - The length in bits of \"address\" phase. The register value shall be (bit_num-1)"]
pub struct REG_USR_ADDR_BITLEN_R(crate::FieldReader<u8, u8>);
impl REG_USR_ADDR_BITLEN_R {
    pub(crate) fn new(bits: u8) -> Self {
        REG_USR_ADDR_BITLEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REG_USR_ADDR_BITLEN_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `reg_usr_addr_bitlen` writer - The length in bits of \"address\" phase. The register value shall be (bit_num-1)"]
pub struct REG_USR_ADDR_BITLEN_W<'a> {
    w: &'a mut W,
}
impl<'a> REG_USR_ADDR_BITLEN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x3f << 26)) | (((value as u32) & 0x3f) << 26);
        self.w
    }
}
#[doc = "Field `reg_usr_mosi_bitlen` reader - The length in bits of \"write-data\" phase. The register value shall be (bit_num-1)"]
pub struct REG_USR_MOSI_BITLEN_R(crate::FieldReader<u16, u16>);
impl REG_USR_MOSI_BITLEN_R {
    pub(crate) fn new(bits: u16) -> Self {
        REG_USR_MOSI_BITLEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REG_USR_MOSI_BITLEN_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `reg_usr_mosi_bitlen` writer - The length in bits of \"write-data\" phase. The register value shall be (bit_num-1)"]
pub struct REG_USR_MOSI_BITLEN_W<'a> {
    w: &'a mut W,
}
impl<'a> REG_USR_MOSI_BITLEN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01ff << 17)) | (((value as u32) & 0x01ff) << 17);
        self.w
    }
}
#[doc = "Field `reg_usr_miso_bitlen` reader - The length in bits of \"read-data\" phase. The register value shall be (bit_num-1)"]
pub struct REG_USR_MISO_BITLEN_R(crate::FieldReader<u16, u16>);
impl REG_USR_MISO_BITLEN_R {
    pub(crate) fn new(bits: u16) -> Self {
        REG_USR_MISO_BITLEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REG_USR_MISO_BITLEN_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `reg_usr_miso_bitlen` writer - The length in bits of \"read-data\" phase. The register value shall be (bit_num-1)"]
pub struct REG_USR_MISO_BITLEN_W<'a> {
    w: &'a mut W,
}
impl<'a> REG_USR_MISO_BITLEN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01ff << 8)) | (((value as u32) & 0x01ff) << 8);
        self.w
    }
}
#[doc = "Field `reg_usr_dummy_cyclelen` reader - The length in spi_clk cycles of \"dummy\" phase. The register value shall be (cycle_num-1)"]
pub struct REG_USR_DUMMY_CYCLELEN_R(crate::FieldReader<u8, u8>);
impl REG_USR_DUMMY_CYCLELEN_R {
    pub(crate) fn new(bits: u8) -> Self {
        REG_USR_DUMMY_CYCLELEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REG_USR_DUMMY_CYCLELEN_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `reg_usr_dummy_cyclelen` writer - The length in spi_clk cycles of \"dummy\" phase. The register value shall be (cycle_num-1)"]
pub struct REG_USR_DUMMY_CYCLELEN_W<'a> {
    w: &'a mut W,
}
impl<'a> REG_USR_DUMMY_CYCLELEN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 26:31 - The length in bits of \"address\" phase. The register value shall be (bit_num-1)"]
    #[inline(always)]
    pub fn reg_usr_addr_bitlen(&self) -> REG_USR_ADDR_BITLEN_R {
        REG_USR_ADDR_BITLEN_R::new(((self.bits >> 26) & 0x3f) as u8)
    }
    #[doc = "Bits 17:25 - The length in bits of \"write-data\" phase. The register value shall be (bit_num-1)"]
    #[inline(always)]
    pub fn reg_usr_mosi_bitlen(&self) -> REG_USR_MOSI_BITLEN_R {
        REG_USR_MOSI_BITLEN_R::new(((self.bits >> 17) & 0x01ff) as u16)
    }
    #[doc = "Bits 8:16 - The length in bits of \"read-data\" phase. The register value shall be (bit_num-1)"]
    #[inline(always)]
    pub fn reg_usr_miso_bitlen(&self) -> REG_USR_MISO_BITLEN_R {
        REG_USR_MISO_BITLEN_R::new(((self.bits >> 8) & 0x01ff) as u16)
    }
    #[doc = "Bits 0:7 - The length in spi_clk cycles of \"dummy\" phase. The register value shall be (cycle_num-1)"]
    #[inline(always)]
    pub fn reg_usr_dummy_cyclelen(&self) -> REG_USR_DUMMY_CYCLELEN_R {
        REG_USR_DUMMY_CYCLELEN_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 26:31 - The length in bits of \"address\" phase. The register value shall be (bit_num-1)"]
    #[inline(always)]
    pub fn reg_usr_addr_bitlen(&mut self) -> REG_USR_ADDR_BITLEN_W {
        REG_USR_ADDR_BITLEN_W { w: self }
    }
    #[doc = "Bits 17:25 - The length in bits of \"write-data\" phase. The register value shall be (bit_num-1)"]
    #[inline(always)]
    pub fn reg_usr_mosi_bitlen(&mut self) -> REG_USR_MOSI_BITLEN_W {
        REG_USR_MOSI_BITLEN_W { w: self }
    }
    #[doc = "Bits 8:16 - The length in bits of \"read-data\" phase. The register value shall be (bit_num-1)"]
    #[inline(always)]
    pub fn reg_usr_miso_bitlen(&mut self) -> REG_USR_MISO_BITLEN_W {
        REG_USR_MISO_BITLEN_W { w: self }
    }
    #[doc = "Bits 0:7 - The length in spi_clk cycles of \"dummy\" phase. The register value shall be (cycle_num-1)"]
    #[inline(always)]
    pub fn reg_usr_dummy_cyclelen(&mut self) -> REG_USR_DUMMY_CYCLELEN_W {
        REG_USR_DUMMY_CYCLELEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "The length in bits of \"address\" phase. The register value shall be (bit_num-1)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_user1](index.html) module"]
pub struct SPI_USER1_SPEC;
impl crate::RegisterSpec for SPI_USER1_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_user1::R](R) reader structure"]
impl crate::Readable for SPI_USER1_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_user1::W](W) writer structure"]
impl crate::Writable for SPI_USER1_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_USER1 to value 0"]
impl crate::Resettable for SPI_USER1_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
