#[doc = "Register `SPI_SLAVE` reader"]
pub struct R(crate::R<SPI_SLAVE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_SLAVE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<SPI_SLAVE_SPEC>> for R {
    fn from(reader: crate::R<SPI_SLAVE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SPI_SLAVE` writer"]
pub struct W(crate::W<SPI_SLAVE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SPI_SLAVE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<SPI_SLAVE_SPEC>> for W {
    fn from(writer: crate::W<SPI_SLAVE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `spi_sync_reset` reader - It is the synchronous reset signal of the module. This bit is self-cleared by hardware."]
pub struct SPI_SYNC_RESET_R(crate::FieldReader<bool, bool>);
impl SPI_SYNC_RESET_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI_SYNC_RESET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_SYNC_RESET_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_sync_reset` writer - It is the synchronous reset signal of the module. This bit is self-cleared by hardware."]
pub struct SPI_SYNC_RESET_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_SYNC_RESET_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | (((value as u32) & 0x01) << 31);
        self.w
    }
}
#[doc = "Field `spi_slave_mode` reader - 1: slave mode, 0: master mode."]
pub struct SPI_SLAVE_MODE_R(crate::FieldReader<bool, bool>);
impl SPI_SLAVE_MODE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI_SLAVE_MODE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_SLAVE_MODE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_slave_mode` writer - 1: slave mode, 0: master mode."]
pub struct SPI_SLAVE_MODE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_SLAVE_MODE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 30)) | (((value as u32) & 0x01) << 30);
        self.w
    }
}
#[doc = "Field `slv_cmd_define` reader - 1: slave mode commands are defined in SPI_SLAVE3. 0: slave mode commands are fixed as 1: \"write-status\"; 4: \"read-status\"; 2: \"write-buffer\" and 3: \"read-buffer\"."]
pub struct SLV_CMD_DEFINE_R(crate::FieldReader<bool, bool>);
impl SLV_CMD_DEFINE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SLV_CMD_DEFINE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_CMD_DEFINE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_cmd_define` writer - 1: slave mode commands are defined in SPI_SLAVE3. 0: slave mode commands are fixed as 1: \"write-status\"; 4: \"read-status\"; 2: \"write-buffer\" and 3: \"read-buffer\"."]
pub struct SLV_CMD_DEFINE_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_CMD_DEFINE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | (((value as u32) & 0x01) << 27);
        self.w
    }
}
#[doc = "Field `spi_trans_cnt` reader - The operations counter in both the master mode and the slave mode."]
pub struct SPI_TRANS_CNT_R(crate::FieldReader<u8, u8>);
impl SPI_TRANS_CNT_R {
    pub(crate) fn new(bits: u8) -> Self {
        SPI_TRANS_CNT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_TRANS_CNT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_int_en` reader - Interrupt enable bits for the below 5 sources"]
pub struct SPI_INT_EN_R(crate::FieldReader<u8, u8>);
impl SPI_INT_EN_R {
    pub(crate) fn new(bits: u8) -> Self {
        SPI_INT_EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_INT_EN_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_int_en` writer - Interrupt enable bits for the below 5 sources"]
pub struct SPI_INT_EN_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_INT_EN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 5)) | (((value as u32) & 0x1f) << 5);
        self.w
    }
}
#[doc = "Field `spi_trans_done` reader - The interrupt raw bit for the completement of any operation in both the master mode and the slave mode."]
pub struct SPI_TRANS_DONE_R(crate::FieldReader<bool, bool>);
impl SPI_TRANS_DONE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI_TRANS_DONE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_TRANS_DONE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_trans_done` writer - The interrupt raw bit for the completement of any operation in both the master mode and the slave mode."]
pub struct SPI_TRANS_DONE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_TRANS_DONE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `slv_wr_sta_done` reader - The interrupt raw bit for the completement of \"write-status\" operation in the slave mode."]
pub struct SLV_WR_STA_DONE_R(crate::FieldReader<bool, bool>);
impl SLV_WR_STA_DONE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SLV_WR_STA_DONE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_WR_STA_DONE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_wr_sta_done` writer - The interrupt raw bit for the completement of \"write-status\" operation in the slave mode."]
pub struct SLV_WR_STA_DONE_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_WR_STA_DONE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `slv_rd_sta_done` reader - The interrupt raw bit for the completement of \"read-status\" operation in the slave mode."]
pub struct SLV_RD_STA_DONE_R(crate::FieldReader<bool, bool>);
impl SLV_RD_STA_DONE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SLV_RD_STA_DONE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_RD_STA_DONE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_rd_sta_done` writer - The interrupt raw bit for the completement of \"read-status\" operation in the slave mode."]
pub struct SLV_RD_STA_DONE_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_RD_STA_DONE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `slv_wr_buf_done` reader - The interrupt raw bit for the completement of \"write-buffer\" operation in the slave mode."]
pub struct SLV_WR_BUF_DONE_R(crate::FieldReader<bool, bool>);
impl SLV_WR_BUF_DONE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SLV_WR_BUF_DONE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_WR_BUF_DONE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_wr_buf_done` writer - The interrupt raw bit for the completement of \"write-buffer\" operation in the slave mode."]
pub struct SLV_WR_BUF_DONE_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_WR_BUF_DONE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `slv_rd_buf_done` reader - The interrupt raw bit for the completement of \"read-buffer\" operation in the slave mode."]
pub struct SLV_RD_BUF_DONE_R(crate::FieldReader<bool, bool>);
impl SLV_RD_BUF_DONE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SLV_RD_BUF_DONE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SLV_RD_BUF_DONE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `slv_rd_buf_done` writer - The interrupt raw bit for the completement of \"read-buffer\" operation in the slave mode."]
pub struct SLV_RD_BUF_DONE_W<'a> {
    w: &'a mut W,
}
impl<'a> SLV_RD_BUF_DONE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
        self.w
    }
}
#[doc = "Field `spi_buffer_enable` reader - Enable read/write buffer"]
pub struct SPI_BUFFER_ENABLE_R(crate::FieldReader<bool, bool>);
impl SPI_BUFFER_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI_BUFFER_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI_BUFFER_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi_buffer_enable` writer - Enable read/write buffer"]
pub struct SPI_BUFFER_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI_BUFFER_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 29)) | (((value as u32) & 0x01) << 29);
        self.w
    }
}
#[doc = "Field `sta_enable` reader - Enable read/write buffer"]
pub struct STA_ENABLE_R(crate::FieldReader<bool, bool>);
impl STA_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        STA_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STA_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `sta_enable` writer - Enable read/write buffer"]
pub struct STA_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> STA_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 28)) | (((value as u32) & 0x01) << 28);
        self.w
    }
}
#[doc = "Field `interrupt_trans_enable` reader - Enable TRANS interrupts"]
pub struct INTERRUPT_TRANS_ENABLE_R(crate::FieldReader<bool, bool>);
impl INTERRUPT_TRANS_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        INTERRUPT_TRANS_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTERRUPT_TRANS_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `interrupt_trans_enable` writer - Enable TRANS interrupts"]
pub struct INTERRUPT_TRANS_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> INTERRUPT_TRANS_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `interrupt_ws_enable` reader - Enable status write interrupts"]
pub struct INTERRUPT_WS_ENABLE_R(crate::FieldReader<bool, bool>);
impl INTERRUPT_WS_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        INTERRUPT_WS_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTERRUPT_WS_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `interrupt_ws_enable` writer - Enable status write interrupts"]
pub struct INTERRUPT_WS_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> INTERRUPT_WS_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `interrupt_rs_enable` reader - Enable status read interrupts"]
pub struct INTERRUPT_RS_ENABLE_R(crate::FieldReader<bool, bool>);
impl INTERRUPT_RS_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        INTERRUPT_RS_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTERRUPT_RS_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `interrupt_rs_enable` writer - Enable status read interrupts"]
pub struct INTERRUPT_RS_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> INTERRUPT_RS_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `interrupt_wb_enable` reader - Enable buffer write interrupts"]
pub struct INTERRUPT_WB_ENABLE_R(crate::FieldReader<bool, bool>);
impl INTERRUPT_WB_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        INTERRUPT_WB_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTERRUPT_WB_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `interrupt_wb_enable` writer - Enable buffer write interrupts"]
pub struct INTERRUPT_WB_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> INTERRUPT_WB_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `interrupt_rb_enable` reader - Enable buffer read interrupts"]
pub struct INTERRUPT_RB_ENABLE_R(crate::FieldReader<bool, bool>);
impl INTERRUPT_RB_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        INTERRUPT_RB_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTERRUPT_RB_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `interrupt_rb_enable` writer - Enable buffer read interrupts"]
pub struct INTERRUPT_RB_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> INTERRUPT_RB_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 31 - It is the synchronous reset signal of the module. This bit is self-cleared by hardware."]
    #[inline(always)]
    pub fn spi_sync_reset(&self) -> SPI_SYNC_RESET_R {
        SPI_SYNC_RESET_R::new(((self.bits >> 31) & 0x01) != 0)
    }
    #[doc = "Bit 30 - 1: slave mode, 0: master mode."]
    #[inline(always)]
    pub fn spi_slave_mode(&self) -> SPI_SLAVE_MODE_R {
        SPI_SLAVE_MODE_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bit 27 - 1: slave mode commands are defined in SPI_SLAVE3. 0: slave mode commands are fixed as 1: \"write-status\"; 4: \"read-status\"; 2: \"write-buffer\" and 3: \"read-buffer\"."]
    #[inline(always)]
    pub fn slv_cmd_define(&self) -> SLV_CMD_DEFINE_R {
        SLV_CMD_DEFINE_R::new(((self.bits >> 27) & 0x01) != 0)
    }
    #[doc = "Bits 23:26 - The operations counter in both the master mode and the slave mode."]
    #[inline(always)]
    pub fn spi_trans_cnt(&self) -> SPI_TRANS_CNT_R {
        SPI_TRANS_CNT_R::new(((self.bits >> 23) & 0x0f) as u8)
    }
    #[doc = "Bits 5:9 - Interrupt enable bits for the below 5 sources"]
    #[inline(always)]
    pub fn spi_int_en(&self) -> SPI_INT_EN_R {
        SPI_INT_EN_R::new(((self.bits >> 5) & 0x1f) as u8)
    }
    #[doc = "Bit 4 - The interrupt raw bit for the completement of any operation in both the master mode and the slave mode."]
    #[inline(always)]
    pub fn spi_trans_done(&self) -> SPI_TRANS_DONE_R {
        SPI_TRANS_DONE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - The interrupt raw bit for the completement of \"write-status\" operation in the slave mode."]
    #[inline(always)]
    pub fn slv_wr_sta_done(&self) -> SLV_WR_STA_DONE_R {
        SLV_WR_STA_DONE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - The interrupt raw bit for the completement of \"read-status\" operation in the slave mode."]
    #[inline(always)]
    pub fn slv_rd_sta_done(&self) -> SLV_RD_STA_DONE_R {
        SLV_RD_STA_DONE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - The interrupt raw bit for the completement of \"write-buffer\" operation in the slave mode."]
    #[inline(always)]
    pub fn slv_wr_buf_done(&self) -> SLV_WR_BUF_DONE_R {
        SLV_WR_BUF_DONE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - The interrupt raw bit for the completement of \"read-buffer\" operation in the slave mode."]
    #[inline(always)]
    pub fn slv_rd_buf_done(&self) -> SLV_RD_BUF_DONE_R {
        SLV_RD_BUF_DONE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 29 - Enable read/write buffer"]
    #[inline(always)]
    pub fn spi_buffer_enable(&self) -> SPI_BUFFER_ENABLE_R {
        SPI_BUFFER_ENABLE_R::new(((self.bits >> 29) & 0x01) != 0)
    }
    #[doc = "Bit 28 - Enable read/write buffer"]
    #[inline(always)]
    pub fn sta_enable(&self) -> STA_ENABLE_R {
        STA_ENABLE_R::new(((self.bits >> 28) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Enable TRANS interrupts"]
    #[inline(always)]
    pub fn interrupt_trans_enable(&self) -> INTERRUPT_TRANS_ENABLE_R {
        INTERRUPT_TRANS_ENABLE_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Enable status write interrupts"]
    #[inline(always)]
    pub fn interrupt_ws_enable(&self) -> INTERRUPT_WS_ENABLE_R {
        INTERRUPT_WS_ENABLE_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Enable status read interrupts"]
    #[inline(always)]
    pub fn interrupt_rs_enable(&self) -> INTERRUPT_RS_ENABLE_R {
        INTERRUPT_RS_ENABLE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Enable buffer write interrupts"]
    #[inline(always)]
    pub fn interrupt_wb_enable(&self) -> INTERRUPT_WB_ENABLE_R {
        INTERRUPT_WB_ENABLE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Enable buffer read interrupts"]
    #[inline(always)]
    pub fn interrupt_rb_enable(&self) -> INTERRUPT_RB_ENABLE_R {
        INTERRUPT_RB_ENABLE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 31 - It is the synchronous reset signal of the module. This bit is self-cleared by hardware."]
    #[inline(always)]
    pub fn spi_sync_reset(&mut self) -> SPI_SYNC_RESET_W {
        SPI_SYNC_RESET_W { w: self }
    }
    #[doc = "Bit 30 - 1: slave mode, 0: master mode."]
    #[inline(always)]
    pub fn spi_slave_mode(&mut self) -> SPI_SLAVE_MODE_W {
        SPI_SLAVE_MODE_W { w: self }
    }
    #[doc = "Bit 27 - 1: slave mode commands are defined in SPI_SLAVE3. 0: slave mode commands are fixed as 1: \"write-status\"; 4: \"read-status\"; 2: \"write-buffer\" and 3: \"read-buffer\"."]
    #[inline(always)]
    pub fn slv_cmd_define(&mut self) -> SLV_CMD_DEFINE_W {
        SLV_CMD_DEFINE_W { w: self }
    }
    #[doc = "Bits 5:9 - Interrupt enable bits for the below 5 sources"]
    #[inline(always)]
    pub fn spi_int_en(&mut self) -> SPI_INT_EN_W {
        SPI_INT_EN_W { w: self }
    }
    #[doc = "Bit 4 - The interrupt raw bit for the completement of any operation in both the master mode and the slave mode."]
    #[inline(always)]
    pub fn spi_trans_done(&mut self) -> SPI_TRANS_DONE_W {
        SPI_TRANS_DONE_W { w: self }
    }
    #[doc = "Bit 3 - The interrupt raw bit for the completement of \"write-status\" operation in the slave mode."]
    #[inline(always)]
    pub fn slv_wr_sta_done(&mut self) -> SLV_WR_STA_DONE_W {
        SLV_WR_STA_DONE_W { w: self }
    }
    #[doc = "Bit 2 - The interrupt raw bit for the completement of \"read-status\" operation in the slave mode."]
    #[inline(always)]
    pub fn slv_rd_sta_done(&mut self) -> SLV_RD_STA_DONE_W {
        SLV_RD_STA_DONE_W { w: self }
    }
    #[doc = "Bit 1 - The interrupt raw bit for the completement of \"write-buffer\" operation in the slave mode."]
    #[inline(always)]
    pub fn slv_wr_buf_done(&mut self) -> SLV_WR_BUF_DONE_W {
        SLV_WR_BUF_DONE_W { w: self }
    }
    #[doc = "Bit 0 - The interrupt raw bit for the completement of \"read-buffer\" operation in the slave mode."]
    #[inline(always)]
    pub fn slv_rd_buf_done(&mut self) -> SLV_RD_BUF_DONE_W {
        SLV_RD_BUF_DONE_W { w: self }
    }
    #[doc = "Bit 29 - Enable read/write buffer"]
    #[inline(always)]
    pub fn spi_buffer_enable(&mut self) -> SPI_BUFFER_ENABLE_W {
        SPI_BUFFER_ENABLE_W { w: self }
    }
    #[doc = "Bit 28 - Enable read/write buffer"]
    #[inline(always)]
    pub fn sta_enable(&mut self) -> STA_ENABLE_W {
        STA_ENABLE_W { w: self }
    }
    #[doc = "Bit 9 - Enable TRANS interrupts"]
    #[inline(always)]
    pub fn interrupt_trans_enable(&mut self) -> INTERRUPT_TRANS_ENABLE_W {
        INTERRUPT_TRANS_ENABLE_W { w: self }
    }
    #[doc = "Bit 8 - Enable status write interrupts"]
    #[inline(always)]
    pub fn interrupt_ws_enable(&mut self) -> INTERRUPT_WS_ENABLE_W {
        INTERRUPT_WS_ENABLE_W { w: self }
    }
    #[doc = "Bit 7 - Enable status read interrupts"]
    #[inline(always)]
    pub fn interrupt_rs_enable(&mut self) -> INTERRUPT_RS_ENABLE_W {
        INTERRUPT_RS_ENABLE_W { w: self }
    }
    #[doc = "Bit 6 - Enable buffer write interrupts"]
    #[inline(always)]
    pub fn interrupt_wb_enable(&mut self) -> INTERRUPT_WB_ENABLE_W {
        INTERRUPT_WB_ENABLE_W { w: self }
    }
    #[doc = "Bit 5 - Enable buffer read interrupts"]
    #[inline(always)]
    pub fn interrupt_rb_enable(&mut self) -> INTERRUPT_RB_ENABLE_W {
        INTERRUPT_RB_ENABLE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "It is the synchronous reset signal of the module. This bit is self-cleared by hardware.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_slave](index.html) module"]
pub struct SPI_SLAVE_SPEC;
impl crate::RegisterSpec for SPI_SLAVE_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_slave::R](R) reader structure"]
impl crate::Readable for SPI_SLAVE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [spi_slave::W](W) writer structure"]
impl crate::Writable for SPI_SLAVE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SPI_SLAVE to value 0"]
impl crate::Resettable for SPI_SLAVE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
