#[doc = "Register `I2SCONF` reader"]
pub struct R(crate::R<I2SCONF_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<I2SCONF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<I2SCONF_SPEC>> for R {
    fn from(reader: crate::R<I2SCONF_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `I2SCONF` writer"]
pub struct W(crate::W<I2SCONF_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<I2SCONF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<I2SCONF_SPEC>> for W {
    fn from(writer: crate::W<I2SCONF_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `I2S_BCK_DIV_NUM` reader - "]
pub struct I2S_BCK_DIV_NUM_R(crate::FieldReader<u8, u8>);
impl I2S_BCK_DIV_NUM_R {
    pub(crate) fn new(bits: u8) -> Self {
        I2S_BCK_DIV_NUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_BCK_DIV_NUM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_BCK_DIV_NUM` writer - "]
pub struct I2S_BCK_DIV_NUM_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_BCK_DIV_NUM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x3f << 22)) | (((value as u32) & 0x3f) << 22);
        self.w
    }
}
#[doc = "Field `I2S_CLKM_DIV_NUM` reader - "]
pub struct I2S_CLKM_DIV_NUM_R(crate::FieldReader<u8, u8>);
impl I2S_CLKM_DIV_NUM_R {
    pub(crate) fn new(bits: u8) -> Self {
        I2S_CLKM_DIV_NUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_CLKM_DIV_NUM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_CLKM_DIV_NUM` writer - "]
pub struct I2S_CLKM_DIV_NUM_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_CLKM_DIV_NUM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x3f << 16)) | (((value as u32) & 0x3f) << 16);
        self.w
    }
}
#[doc = "Field `I2S_BITS_MOD` reader - "]
pub struct I2S_BITS_MOD_R(crate::FieldReader<u8, u8>);
impl I2S_BITS_MOD_R {
    pub(crate) fn new(bits: u8) -> Self {
        I2S_BITS_MOD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_BITS_MOD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_BITS_MOD` writer - "]
pub struct I2S_BITS_MOD_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_BITS_MOD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 12)) | (((value as u32) & 0x0f) << 12);
        self.w
    }
}
#[doc = "Field `I2S_RECE_MSB_SHIFT` reader - "]
pub struct I2S_RECE_MSB_SHIFT_R(crate::FieldReader<bool, bool>);
impl I2S_RECE_MSB_SHIFT_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_RECE_MSB_SHIFT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_RECE_MSB_SHIFT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_RECE_MSB_SHIFT` writer - "]
pub struct I2S_RECE_MSB_SHIFT_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_RECE_MSB_SHIFT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | (((value as u32) & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `I2S_TRANS_MSB_SHIFT` reader - "]
pub struct I2S_TRANS_MSB_SHIFT_R(crate::FieldReader<bool, bool>);
impl I2S_TRANS_MSB_SHIFT_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_TRANS_MSB_SHIFT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_TRANS_MSB_SHIFT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_TRANS_MSB_SHIFT` writer - "]
pub struct I2S_TRANS_MSB_SHIFT_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_TRANS_MSB_SHIFT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `I2S_I2S_RX_START` reader - "]
pub struct I2S_I2S_RX_START_R(crate::FieldReader<bool, bool>);
impl I2S_I2S_RX_START_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_I2S_RX_START_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_I2S_RX_START_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_I2S_RX_START` writer - "]
pub struct I2S_I2S_RX_START_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_I2S_RX_START_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | (((value as u32) & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `I2S_I2S_TX_START` reader - "]
pub struct I2S_I2S_TX_START_R(crate::FieldReader<bool, bool>);
impl I2S_I2S_TX_START_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_I2S_TX_START_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_I2S_TX_START_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_I2S_TX_START` writer - "]
pub struct I2S_I2S_TX_START_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_I2S_TX_START_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | (((value as u32) & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `I2S_MSB_RIGHT` reader - "]
pub struct I2S_MSB_RIGHT_R(crate::FieldReader<bool, bool>);
impl I2S_MSB_RIGHT_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_MSB_RIGHT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_MSB_RIGHT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_MSB_RIGHT` writer - "]
pub struct I2S_MSB_RIGHT_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_MSB_RIGHT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | (((value as u32) & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `I2S_RIGHT_FIRST` reader - "]
pub struct I2S_RIGHT_FIRST_R(crate::FieldReader<bool, bool>);
impl I2S_RIGHT_FIRST_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_RIGHT_FIRST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_RIGHT_FIRST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_RIGHT_FIRST` writer - "]
pub struct I2S_RIGHT_FIRST_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_RIGHT_FIRST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | (((value as u32) & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `I2S_RECE_SLAVE_MOD` reader - "]
pub struct I2S_RECE_SLAVE_MOD_R(crate::FieldReader<bool, bool>);
impl I2S_RECE_SLAVE_MOD_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_RECE_SLAVE_MOD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_RECE_SLAVE_MOD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_RECE_SLAVE_MOD` writer - "]
pub struct I2S_RECE_SLAVE_MOD_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_RECE_SLAVE_MOD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | (((value as u32) & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `I2S_TRANS_SLAVE_MOD` reader - "]
pub struct I2S_TRANS_SLAVE_MOD_R(crate::FieldReader<bool, bool>);
impl I2S_TRANS_SLAVE_MOD_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_TRANS_SLAVE_MOD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_TRANS_SLAVE_MOD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_TRANS_SLAVE_MOD` writer - "]
pub struct I2S_TRANS_SLAVE_MOD_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_TRANS_SLAVE_MOD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | (((value as u32) & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `I2S_I2S_RX_FIFO_RESET` reader - "]
pub struct I2S_I2S_RX_FIFO_RESET_R(crate::FieldReader<bool, bool>);
impl I2S_I2S_RX_FIFO_RESET_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_I2S_RX_FIFO_RESET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_I2S_RX_FIFO_RESET_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_I2S_RX_FIFO_RESET` writer - "]
pub struct I2S_I2S_RX_FIFO_RESET_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_I2S_RX_FIFO_RESET_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | (((value as u32) & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `I2S_I2S_TX_FIFO_RESET` reader - "]
pub struct I2S_I2S_TX_FIFO_RESET_R(crate::FieldReader<bool, bool>);
impl I2S_I2S_TX_FIFO_RESET_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_I2S_TX_FIFO_RESET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_I2S_TX_FIFO_RESET_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_I2S_TX_FIFO_RESET` writer - "]
pub struct I2S_I2S_TX_FIFO_RESET_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_I2S_TX_FIFO_RESET_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `I2S_I2S_RX_RESET` reader - "]
pub struct I2S_I2S_RX_RESET_R(crate::FieldReader<bool, bool>);
impl I2S_I2S_RX_RESET_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_I2S_RX_RESET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_I2S_RX_RESET_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_I2S_RX_RESET` writer - "]
pub struct I2S_I2S_RX_RESET_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_I2S_RX_RESET_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `I2S_I2S_TX_RESET` reader - "]
pub struct I2S_I2S_TX_RESET_R(crate::FieldReader<bool, bool>);
impl I2S_I2S_TX_RESET_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_I2S_TX_RESET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_I2S_TX_RESET_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2S_I2S_TX_RESET` writer - "]
pub struct I2S_I2S_TX_RESET_W<'a> {
    w: &'a mut W,
}
impl<'a> I2S_I2S_TX_RESET_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bits 22:27"]
    #[inline(always)]
    pub fn i2s_bck_div_num(&self) -> I2S_BCK_DIV_NUM_R {
        I2S_BCK_DIV_NUM_R::new(((self.bits >> 22) & 0x3f) as u8)
    }
    #[doc = "Bits 16:21"]
    #[inline(always)]
    pub fn i2s_clkm_div_num(&self) -> I2S_CLKM_DIV_NUM_R {
        I2S_CLKM_DIV_NUM_R::new(((self.bits >> 16) & 0x3f) as u8)
    }
    #[doc = "Bits 12:15"]
    #[inline(always)]
    pub fn i2s_bits_mod(&self) -> I2S_BITS_MOD_R {
        I2S_BITS_MOD_R::new(((self.bits >> 12) & 0x0f) as u8)
    }
    #[doc = "Bit 11"]
    #[inline(always)]
    pub fn i2s_rece_msb_shift(&self) -> I2S_RECE_MSB_SHIFT_R {
        I2S_RECE_MSB_SHIFT_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10"]
    #[inline(always)]
    pub fn i2s_trans_msb_shift(&self) -> I2S_TRANS_MSB_SHIFT_R {
        I2S_TRANS_MSB_SHIFT_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9"]
    #[inline(always)]
    pub fn i2s_i2s_rx_start(&self) -> I2S_I2S_RX_START_R {
        I2S_I2S_RX_START_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8"]
    #[inline(always)]
    pub fn i2s_i2s_tx_start(&self) -> I2S_I2S_TX_START_R {
        I2S_I2S_TX_START_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7"]
    #[inline(always)]
    pub fn i2s_msb_right(&self) -> I2S_MSB_RIGHT_R {
        I2S_MSB_RIGHT_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6"]
    #[inline(always)]
    pub fn i2s_right_first(&self) -> I2S_RIGHT_FIRST_R {
        I2S_RIGHT_FIRST_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5"]
    #[inline(always)]
    pub fn i2s_rece_slave_mod(&self) -> I2S_RECE_SLAVE_MOD_R {
        I2S_RECE_SLAVE_MOD_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4"]
    #[inline(always)]
    pub fn i2s_trans_slave_mod(&self) -> I2S_TRANS_SLAVE_MOD_R {
        I2S_TRANS_SLAVE_MOD_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3"]
    #[inline(always)]
    pub fn i2s_i2s_rx_fifo_reset(&self) -> I2S_I2S_RX_FIFO_RESET_R {
        I2S_I2S_RX_FIFO_RESET_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2"]
    #[inline(always)]
    pub fn i2s_i2s_tx_fifo_reset(&self) -> I2S_I2S_TX_FIFO_RESET_R {
        I2S_I2S_TX_FIFO_RESET_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1"]
    #[inline(always)]
    pub fn i2s_i2s_rx_reset(&self) -> I2S_I2S_RX_RESET_R {
        I2S_I2S_RX_RESET_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0"]
    #[inline(always)]
    pub fn i2s_i2s_tx_reset(&self) -> I2S_I2S_TX_RESET_R {
        I2S_I2S_TX_RESET_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 22:27"]
    #[inline(always)]
    pub fn i2s_bck_div_num(&mut self) -> I2S_BCK_DIV_NUM_W {
        I2S_BCK_DIV_NUM_W { w: self }
    }
    #[doc = "Bits 16:21"]
    #[inline(always)]
    pub fn i2s_clkm_div_num(&mut self) -> I2S_CLKM_DIV_NUM_W {
        I2S_CLKM_DIV_NUM_W { w: self }
    }
    #[doc = "Bits 12:15"]
    #[inline(always)]
    pub fn i2s_bits_mod(&mut self) -> I2S_BITS_MOD_W {
        I2S_BITS_MOD_W { w: self }
    }
    #[doc = "Bit 11"]
    #[inline(always)]
    pub fn i2s_rece_msb_shift(&mut self) -> I2S_RECE_MSB_SHIFT_W {
        I2S_RECE_MSB_SHIFT_W { w: self }
    }
    #[doc = "Bit 10"]
    #[inline(always)]
    pub fn i2s_trans_msb_shift(&mut self) -> I2S_TRANS_MSB_SHIFT_W {
        I2S_TRANS_MSB_SHIFT_W { w: self }
    }
    #[doc = "Bit 9"]
    #[inline(always)]
    pub fn i2s_i2s_rx_start(&mut self) -> I2S_I2S_RX_START_W {
        I2S_I2S_RX_START_W { w: self }
    }
    #[doc = "Bit 8"]
    #[inline(always)]
    pub fn i2s_i2s_tx_start(&mut self) -> I2S_I2S_TX_START_W {
        I2S_I2S_TX_START_W { w: self }
    }
    #[doc = "Bit 7"]
    #[inline(always)]
    pub fn i2s_msb_right(&mut self) -> I2S_MSB_RIGHT_W {
        I2S_MSB_RIGHT_W { w: self }
    }
    #[doc = "Bit 6"]
    #[inline(always)]
    pub fn i2s_right_first(&mut self) -> I2S_RIGHT_FIRST_W {
        I2S_RIGHT_FIRST_W { w: self }
    }
    #[doc = "Bit 5"]
    #[inline(always)]
    pub fn i2s_rece_slave_mod(&mut self) -> I2S_RECE_SLAVE_MOD_W {
        I2S_RECE_SLAVE_MOD_W { w: self }
    }
    #[doc = "Bit 4"]
    #[inline(always)]
    pub fn i2s_trans_slave_mod(&mut self) -> I2S_TRANS_SLAVE_MOD_W {
        I2S_TRANS_SLAVE_MOD_W { w: self }
    }
    #[doc = "Bit 3"]
    #[inline(always)]
    pub fn i2s_i2s_rx_fifo_reset(&mut self) -> I2S_I2S_RX_FIFO_RESET_W {
        I2S_I2S_RX_FIFO_RESET_W { w: self }
    }
    #[doc = "Bit 2"]
    #[inline(always)]
    pub fn i2s_i2s_tx_fifo_reset(&mut self) -> I2S_I2S_TX_FIFO_RESET_W {
        I2S_I2S_TX_FIFO_RESET_W { w: self }
    }
    #[doc = "Bit 1"]
    #[inline(always)]
    pub fn i2s_i2s_rx_reset(&mut self) -> I2S_I2S_RX_RESET_W {
        I2S_I2S_RX_RESET_W { w: self }
    }
    #[doc = "Bit 0"]
    #[inline(always)]
    pub fn i2s_i2s_tx_reset(&mut self) -> I2S_I2S_TX_RESET_W {
        I2S_I2S_TX_RESET_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "I2SCONF\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [i2sconf](index.html) module"]
pub struct I2SCONF_SPEC;
impl crate::RegisterSpec for I2SCONF_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [i2sconf::R](R) reader structure"]
impl crate::Readable for I2SCONF_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [i2sconf::W](W) writer structure"]
impl crate::Writable for I2SCONF_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets I2SCONF to value 0"]
impl crate::Resettable for I2SCONF_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
