#[doc = "Register `GPIO_SIGMA_DELTA` reader"]
pub struct R(crate::R<GPIO_SIGMA_DELTA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GPIO_SIGMA_DELTA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<GPIO_SIGMA_DELTA_SPEC>> for R {
    fn from(reader: crate::R<GPIO_SIGMA_DELTA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GPIO_SIGMA_DELTA` writer"]
pub struct W(crate::W<GPIO_SIGMA_DELTA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GPIO_SIGMA_DELTA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<GPIO_SIGMA_DELTA_SPEC>> for W {
    fn from(writer: crate::W<GPIO_SIGMA_DELTA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SIGMA_DELTA_ENABLE` reader - 1: enable sigma-delta; 0: disable"]
pub struct SIGMA_DELTA_ENABLE_R(crate::FieldReader<bool, bool>);
impl SIGMA_DELTA_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        SIGMA_DELTA_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SIGMA_DELTA_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SIGMA_DELTA_ENABLE` writer - 1: enable sigma-delta; 0: disable"]
pub struct SIGMA_DELTA_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> SIGMA_DELTA_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | (((value as u32) & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `SIGMA_DELTA_PRESCALAR` reader - Clock pre-divider for sigma-delta."]
pub struct SIGMA_DELTA_PRESCALAR_R(crate::FieldReader<u8, u8>);
impl SIGMA_DELTA_PRESCALAR_R {
    pub(crate) fn new(bits: u8) -> Self {
        SIGMA_DELTA_PRESCALAR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SIGMA_DELTA_PRESCALAR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SIGMA_DELTA_PRESCALAR` writer - Clock pre-divider for sigma-delta."]
pub struct SIGMA_DELTA_PRESCALAR_W<'a> {
    w: &'a mut W,
}
impl<'a> SIGMA_DELTA_PRESCALAR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0xff << 8)) | (((value as u32) & 0xff) << 8);
        self.w
    }
}
#[doc = "Field `SIGMA_DELTA_TARGET` reader - target level of the sigma-delta. It is a signed byte."]
pub struct SIGMA_DELTA_TARGET_R(crate::FieldReader<u8, u8>);
impl SIGMA_DELTA_TARGET_R {
    pub(crate) fn new(bits: u8) -> Self {
        SIGMA_DELTA_TARGET_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SIGMA_DELTA_TARGET_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SIGMA_DELTA_TARGET` writer - target level of the sigma-delta. It is a signed byte."]
pub struct SIGMA_DELTA_TARGET_W<'a> {
    w: &'a mut W,
}
impl<'a> SIGMA_DELTA_TARGET_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | ((value as u32) & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bit 16 - 1: enable sigma-delta; 0: disable"]
    #[inline(always)]
    pub fn sigma_delta_enable(&self) -> SIGMA_DELTA_ENABLE_R {
        SIGMA_DELTA_ENABLE_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bits 8:15 - Clock pre-divider for sigma-delta."]
    #[inline(always)]
    pub fn sigma_delta_prescalar(&self) -> SIGMA_DELTA_PRESCALAR_R {
        SIGMA_DELTA_PRESCALAR_R::new(((self.bits >> 8) & 0xff) as u8)
    }
    #[doc = "Bits 0:7 - target level of the sigma-delta. It is a signed byte."]
    #[inline(always)]
    pub fn sigma_delta_target(&self) -> SIGMA_DELTA_TARGET_R {
        SIGMA_DELTA_TARGET_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bit 16 - 1: enable sigma-delta; 0: disable"]
    #[inline(always)]
    pub fn sigma_delta_enable(&mut self) -> SIGMA_DELTA_ENABLE_W {
        SIGMA_DELTA_ENABLE_W { w: self }
    }
    #[doc = "Bits 8:15 - Clock pre-divider for sigma-delta."]
    #[inline(always)]
    pub fn sigma_delta_prescalar(&mut self) -> SIGMA_DELTA_PRESCALAR_W {
        SIGMA_DELTA_PRESCALAR_W { w: self }
    }
    #[doc = "Bits 0:7 - target level of the sigma-delta. It is a signed byte."]
    #[inline(always)]
    pub fn sigma_delta_target(&mut self) -> SIGMA_DELTA_TARGET_W {
        SIGMA_DELTA_TARGET_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "GPIO_SIGMA_DELTA\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gpio_sigma_delta](index.html) module"]
pub struct GPIO_SIGMA_DELTA_SPEC;
impl crate::RegisterSpec for GPIO_SIGMA_DELTA_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gpio_sigma_delta::R](R) reader structure"]
impl crate::Readable for GPIO_SIGMA_DELTA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gpio_sigma_delta::W](W) writer structure"]
impl crate::Writable for GPIO_SIGMA_DELTA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GPIO_SIGMA_DELTA to value 0"]
impl crate::Resettable for GPIO_SIGMA_DELTA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
