#[doc = "Register `GPIO_PIN11` reader"]
pub struct R(crate::R<GPIO_PIN11_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GPIO_PIN11_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<GPIO_PIN11_SPEC>> for R {
    fn from(reader: crate::R<GPIO_PIN11_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GPIO_PIN11` writer"]
pub struct W(crate::W<GPIO_PIN11_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GPIO_PIN11_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<GPIO_PIN11_SPEC>> for W {
    fn from(writer: crate::W<GPIO_PIN11_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `GPIO_PIN11_WAKEUP_ENABLE` reader - 0: disable; 1: enable GPIO wakeup CPU, only when GPIO_PIN0_INT_TYPE is 0x4 or 0x5"]
pub struct GPIO_PIN11_WAKEUP_ENABLE_R(crate::FieldReader<bool, bool>);
impl GPIO_PIN11_WAKEUP_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIO_PIN11_WAKEUP_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GPIO_PIN11_WAKEUP_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIO_PIN11_WAKEUP_ENABLE` writer - 0: disable; 1: enable GPIO wakeup CPU, only when GPIO_PIN0_INT_TYPE is 0x4 or 0x5"]
pub struct GPIO_PIN11_WAKEUP_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIO_PIN11_WAKEUP_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | (((value as u32) & 0x01) << 10);
        self.w
    }
}
#[doc = "0: disable; 1: positive edge; 2: negative edge; 3: both types of edge; 4: low-level; 5: high-level\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum GPIO_PIN11_INT_TYPE_A {
    #[doc = "0: interrupt is disabled"]
    DISABLED = 0,
    #[doc = "1: interrupt is triggered on the positive edge"]
    POSITIVE_EDGE = 1,
    #[doc = "2: interrupt is triggered on the negative edge"]
    NEGATIVE_EDGE = 2,
    #[doc = "3: interrupt is triggered on both edges"]
    BOTH_EDGES = 3,
    #[doc = "4: interrupt is triggered on the low level"]
    LOW_LEVEL = 4,
    #[doc = "5: interrupt is triggered on the high level"]
    HIGH_LEVEL = 5,
}
impl From<GPIO_PIN11_INT_TYPE_A> for u8 {
    #[inline(always)]
    fn from(variant: GPIO_PIN11_INT_TYPE_A) -> Self {
        variant as _
    }
}
#[doc = "Field `GPIO_PIN11_INT_TYPE` reader - 0: disable; 1: positive edge; 2: negative edge; 3: both types of edge; 4: low-level; 5: high-level"]
pub struct GPIO_PIN11_INT_TYPE_R(crate::FieldReader<u8, GPIO_PIN11_INT_TYPE_A>);
impl GPIO_PIN11_INT_TYPE_R {
    pub(crate) fn new(bits: u8) -> Self {
        GPIO_PIN11_INT_TYPE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> crate::Variant<u8, GPIO_PIN11_INT_TYPE_A> {
        use crate::Variant::*;
        match self.bits {
            0 => Val(GPIO_PIN11_INT_TYPE_A::DISABLED),
            1 => Val(GPIO_PIN11_INT_TYPE_A::POSITIVE_EDGE),
            2 => Val(GPIO_PIN11_INT_TYPE_A::NEGATIVE_EDGE),
            3 => Val(GPIO_PIN11_INT_TYPE_A::BOTH_EDGES),
            4 => Val(GPIO_PIN11_INT_TYPE_A::LOW_LEVEL),
            5 => Val(GPIO_PIN11_INT_TYPE_A::HIGH_LEVEL),
            i => Res(i),
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == GPIO_PIN11_INT_TYPE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `POSITIVE_EDGE`"]
    #[inline(always)]
    pub fn is_positive_edge(&self) -> bool {
        **self == GPIO_PIN11_INT_TYPE_A::POSITIVE_EDGE
    }
    #[doc = "Checks if the value of the field is `NEGATIVE_EDGE`"]
    #[inline(always)]
    pub fn is_negative_edge(&self) -> bool {
        **self == GPIO_PIN11_INT_TYPE_A::NEGATIVE_EDGE
    }
    #[doc = "Checks if the value of the field is `BOTH_EDGES`"]
    #[inline(always)]
    pub fn is_both_edges(&self) -> bool {
        **self == GPIO_PIN11_INT_TYPE_A::BOTH_EDGES
    }
    #[doc = "Checks if the value of the field is `LOW_LEVEL`"]
    #[inline(always)]
    pub fn is_low_level(&self) -> bool {
        **self == GPIO_PIN11_INT_TYPE_A::LOW_LEVEL
    }
    #[doc = "Checks if the value of the field is `HIGH_LEVEL`"]
    #[inline(always)]
    pub fn is_high_level(&self) -> bool {
        **self == GPIO_PIN11_INT_TYPE_A::HIGH_LEVEL
    }
}
impl core::ops::Deref for GPIO_PIN11_INT_TYPE_R {
    type Target = crate::FieldReader<u8, GPIO_PIN11_INT_TYPE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIO_PIN11_INT_TYPE` writer - 0: disable; 1: positive edge; 2: negative edge; 3: both types of edge; 4: low-level; 5: high-level"]
pub struct GPIO_PIN11_INT_TYPE_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIO_PIN11_INT_TYPE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: GPIO_PIN11_INT_TYPE_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "interrupt is disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(GPIO_PIN11_INT_TYPE_A::DISABLED)
    }
    #[doc = "interrupt is triggered on the positive edge"]
    #[inline(always)]
    pub fn positive_edge(self) -> &'a mut W {
        self.variant(GPIO_PIN11_INT_TYPE_A::POSITIVE_EDGE)
    }
    #[doc = "interrupt is triggered on the negative edge"]
    #[inline(always)]
    pub fn negative_edge(self) -> &'a mut W {
        self.variant(GPIO_PIN11_INT_TYPE_A::NEGATIVE_EDGE)
    }
    #[doc = "interrupt is triggered on both edges"]
    #[inline(always)]
    pub fn both_edges(self) -> &'a mut W {
        self.variant(GPIO_PIN11_INT_TYPE_A::BOTH_EDGES)
    }
    #[doc = "interrupt is triggered on the low level"]
    #[inline(always)]
    pub fn low_level(self) -> &'a mut W {
        self.variant(GPIO_PIN11_INT_TYPE_A::LOW_LEVEL)
    }
    #[doc = "interrupt is triggered on the high level"]
    #[inline(always)]
    pub fn high_level(self) -> &'a mut W {
        self.variant(GPIO_PIN11_INT_TYPE_A::HIGH_LEVEL)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 7)) | (((value as u32) & 0x07) << 7);
        self.w
    }
}
#[doc = "1: open drain; 0: normal\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum GPIO_PIN11_DRIVER_A {
    #[doc = "0: open drain"]
    OPEN_DRAIN = 0,
    #[doc = "1: normal"]
    NORMAL = 1,
}
impl From<GPIO_PIN11_DRIVER_A> for bool {
    #[inline(always)]
    fn from(variant: GPIO_PIN11_DRIVER_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `GPIO_PIN11_DRIVER` reader - 1: open drain; 0: normal"]
pub struct GPIO_PIN11_DRIVER_R(crate::FieldReader<bool, GPIO_PIN11_DRIVER_A>);
impl GPIO_PIN11_DRIVER_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIO_PIN11_DRIVER_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> GPIO_PIN11_DRIVER_A {
        match self.bits {
            false => GPIO_PIN11_DRIVER_A::OPEN_DRAIN,
            true => GPIO_PIN11_DRIVER_A::NORMAL,
        }
    }
    #[doc = "Checks if the value of the field is `OPEN_DRAIN`"]
    #[inline(always)]
    pub fn is_open_drain(&self) -> bool {
        **self == GPIO_PIN11_DRIVER_A::OPEN_DRAIN
    }
    #[doc = "Checks if the value of the field is `NORMAL`"]
    #[inline(always)]
    pub fn is_normal(&self) -> bool {
        **self == GPIO_PIN11_DRIVER_A::NORMAL
    }
}
impl core::ops::Deref for GPIO_PIN11_DRIVER_R {
    type Target = crate::FieldReader<bool, GPIO_PIN11_DRIVER_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIO_PIN11_DRIVER` writer - 1: open drain; 0: normal"]
pub struct GPIO_PIN11_DRIVER_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIO_PIN11_DRIVER_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: GPIO_PIN11_DRIVER_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "open drain"]
    #[inline(always)]
    pub fn open_drain(self) -> &'a mut W {
        self.variant(GPIO_PIN11_DRIVER_A::OPEN_DRAIN)
    }
    #[doc = "normal"]
    #[inline(always)]
    pub fn normal(self) -> &'a mut W {
        self.variant(GPIO_PIN11_DRIVER_A::NORMAL)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | (((value as u32) & 0x01) << 2);
        self.w
    }
}
#[doc = "1: sigma-delta; 0: GPIO_DATA\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum GPIO_PIN11_SOURCE_A {
    #[doc = "0: sigma-delta"]
    SIGMA_DELTA = 0,
    #[doc = "1: gpio data"]
    GPIO_DATA = 1,
}
impl From<GPIO_PIN11_SOURCE_A> for bool {
    #[inline(always)]
    fn from(variant: GPIO_PIN11_SOURCE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `GPIO_PIN11_SOURCE` reader - 1: sigma-delta; 0: GPIO_DATA"]
pub struct GPIO_PIN11_SOURCE_R(crate::FieldReader<bool, GPIO_PIN11_SOURCE_A>);
impl GPIO_PIN11_SOURCE_R {
    pub(crate) fn new(bits: bool) -> Self {
        GPIO_PIN11_SOURCE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> GPIO_PIN11_SOURCE_A {
        match self.bits {
            false => GPIO_PIN11_SOURCE_A::SIGMA_DELTA,
            true => GPIO_PIN11_SOURCE_A::GPIO_DATA,
        }
    }
    #[doc = "Checks if the value of the field is `SIGMA_DELTA`"]
    #[inline(always)]
    pub fn is_sigma_delta(&self) -> bool {
        **self == GPIO_PIN11_SOURCE_A::SIGMA_DELTA
    }
    #[doc = "Checks if the value of the field is `GPIO_DATA`"]
    #[inline(always)]
    pub fn is_gpio_data(&self) -> bool {
        **self == GPIO_PIN11_SOURCE_A::GPIO_DATA
    }
}
impl core::ops::Deref for GPIO_PIN11_SOURCE_R {
    type Target = crate::FieldReader<bool, GPIO_PIN11_SOURCE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GPIO_PIN11_SOURCE` writer - 1: sigma-delta; 0: GPIO_DATA"]
pub struct GPIO_PIN11_SOURCE_W<'a> {
    w: &'a mut W,
}
impl<'a> GPIO_PIN11_SOURCE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: GPIO_PIN11_SOURCE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "sigma-delta"]
    #[inline(always)]
    pub fn sigma_delta(self) -> &'a mut W {
        self.variant(GPIO_PIN11_SOURCE_A::SIGMA_DELTA)
    }
    #[doc = "gpio data"]
    #[inline(always)]
    pub fn gpio_data(self) -> &'a mut W {
        self.variant(GPIO_PIN11_SOURCE_A::GPIO_DATA)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 10 - 0: disable; 1: enable GPIO wakeup CPU, only when GPIO_PIN0_INT_TYPE is 0x4 or 0x5"]
    #[inline(always)]
    pub fn gpio_pin11_wakeup_enable(&self) -> GPIO_PIN11_WAKEUP_ENABLE_R {
        GPIO_PIN11_WAKEUP_ENABLE_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bits 7:9 - 0: disable; 1: positive edge; 2: negative edge; 3: both types of edge; 4: low-level; 5: high-level"]
    #[inline(always)]
    pub fn gpio_pin11_int_type(&self) -> GPIO_PIN11_INT_TYPE_R {
        GPIO_PIN11_INT_TYPE_R::new(((self.bits >> 7) & 0x07) as u8)
    }
    #[doc = "Bit 2 - 1: open drain; 0: normal"]
    #[inline(always)]
    pub fn gpio_pin11_driver(&self) -> GPIO_PIN11_DRIVER_R {
        GPIO_PIN11_DRIVER_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 0 - 1: sigma-delta; 0: GPIO_DATA"]
    #[inline(always)]
    pub fn gpio_pin11_source(&self) -> GPIO_PIN11_SOURCE_R {
        GPIO_PIN11_SOURCE_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 10 - 0: disable; 1: enable GPIO wakeup CPU, only when GPIO_PIN0_INT_TYPE is 0x4 or 0x5"]
    #[inline(always)]
    pub fn gpio_pin11_wakeup_enable(&mut self) -> GPIO_PIN11_WAKEUP_ENABLE_W {
        GPIO_PIN11_WAKEUP_ENABLE_W { w: self }
    }
    #[doc = "Bits 7:9 - 0: disable; 1: positive edge; 2: negative edge; 3: both types of edge; 4: low-level; 5: high-level"]
    #[inline(always)]
    pub fn gpio_pin11_int_type(&mut self) -> GPIO_PIN11_INT_TYPE_W {
        GPIO_PIN11_INT_TYPE_W { w: self }
    }
    #[doc = "Bit 2 - 1: open drain; 0: normal"]
    #[inline(always)]
    pub fn gpio_pin11_driver(&mut self) -> GPIO_PIN11_DRIVER_W {
        GPIO_PIN11_DRIVER_W { w: self }
    }
    #[doc = "Bit 0 - 1: sigma-delta; 0: GPIO_DATA"]
    #[inline(always)]
    pub fn gpio_pin11_source(&mut self) -> GPIO_PIN11_SOURCE_W {
        GPIO_PIN11_SOURCE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "GPIO_PIN11\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gpio_pin11](index.html) module"]
pub struct GPIO_PIN11_SPEC;
impl crate::RegisterSpec for GPIO_PIN11_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gpio_pin11::R](R) reader structure"]
impl crate::Readable for GPIO_PIN11_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gpio_pin11::W](W) writer structure"]
impl crate::Writable for GPIO_PIN11_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GPIO_PIN11 to value 0"]
impl crate::Resettable for GPIO_PIN11_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
