#[doc = "Register `SPI_INTERRUPT_TYPE` reader"]
pub struct R(crate::R<SPI_INTERRUPT_TYPE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SPI_INTERRUPT_TYPE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<SPI_INTERRUPT_TYPE_SPEC>> for R {
    fn from(reader: crate::R<SPI_INTERRUPT_TYPE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `spi0` reader - SPI0 interrupt"]
pub struct SPI0_R(crate::FieldReader<bool, bool>);
impl SPI0_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `spi1` reader - SPI1 interrupt"]
pub struct SPI1_R(crate::FieldReader<bool, bool>);
impl SPI1_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `i2s` reader - I2S interrupt"]
pub struct I2S_R(crate::FieldReader<bool, bool>);
impl I2S_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2S_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for I2S_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 4 - SPI0 interrupt"]
    #[inline(always)]
    pub fn spi0(&self) -> SPI0_R {
        SPI0_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 7 - SPI1 interrupt"]
    #[inline(always)]
    pub fn spi1(&self) -> SPI1_R {
        SPI1_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 9 - I2S interrupt"]
    #[inline(always)]
    pub fn i2s(&self) -> I2S_R {
        I2S_R::new(((self.bits >> 9) & 0x01) != 0)
    }
}
#[doc = "SPI interrupt type register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [spi_interrupt_type](index.html) module"]
pub struct SPI_INTERRUPT_TYPE_SPEC;
impl crate::RegisterSpec for SPI_INTERRUPT_TYPE_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [spi_interrupt_type::R](R) reader structure"]
impl crate::Readable for SPI_INTERRUPT_TYPE_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets SPI_INTERRUPT_TYPE to value 0"]
impl crate::Resettable for SPI_INTERRUPT_TYPE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
