#[doc = "Register `EDGE_INT_ENABLE` reader"]
pub struct R(crate::R<EDGE_INT_ENABLE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EDGE_INT_ENABLE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<EDGE_INT_ENABLE_SPEC>> for R {
    fn from(reader: crate::R<EDGE_INT_ENABLE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EDGE_INT_ENABLE` writer"]
pub struct W(crate::W<EDGE_INT_ENABLE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EDGE_INT_ENABLE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<EDGE_INT_ENABLE_SPEC>> for W {
    fn from(writer: crate::W<EDGE_INT_ENABLE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `Register` reader - "]
pub struct REGISTER_R(crate::FieldReader<u32, u32>);
impl REGISTER_R {
    pub(crate) fn new(bits: u32) -> Self {
        REGISTER_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REGISTER_R {
    type Target = crate::FieldReader<u32, u32>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `Register` writer - "]
pub struct REGISTER_W<'a> {
    w: &'a mut W,
}
impl<'a> REGISTER_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u32) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xffff_ffff) | ((value as u32) & 0xffff_ffff);
        self.w
    }
}
#[doc = "Field `wdt_edge_int_enable` reader - Enable the watchdog timer edge interrupt"]
pub struct WDT_EDGE_INT_ENABLE_R(crate::FieldReader<bool, bool>);
impl WDT_EDGE_INT_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        WDT_EDGE_INT_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WDT_EDGE_INT_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `wdt_edge_int_enable` writer - Enable the watchdog timer edge interrupt"]
pub struct WDT_EDGE_INT_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> WDT_EDGE_INT_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | ((value as u32) & 0x01);
        self.w
    }
}
#[doc = "Field `timer1_edge_int_enable` reader - Enable the timer1 edge interrupt"]
pub struct TIMER1_EDGE_INT_ENABLE_R(crate::FieldReader<bool, bool>);
impl TIMER1_EDGE_INT_ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TIMER1_EDGE_INT_ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER1_EDGE_INT_ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `timer1_edge_int_enable` writer - Enable the timer1 edge interrupt"]
pub struct TIMER1_EDGE_INT_ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER1_EDGE_INT_ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | (((value as u32) & 0x01) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:31"]
    #[inline(always)]
    pub fn register(&self) -> REGISTER_R {
        REGISTER_R::new((self.bits & 0xffff_ffff) as u32)
    }
    #[doc = "Bit 0 - Enable the watchdog timer edge interrupt"]
    #[inline(always)]
    pub fn wdt_edge_int_enable(&self) -> WDT_EDGE_INT_ENABLE_R {
        WDT_EDGE_INT_ENABLE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Enable the timer1 edge interrupt"]
    #[inline(always)]
    pub fn timer1_edge_int_enable(&self) -> TIMER1_EDGE_INT_ENABLE_R {
        TIMER1_EDGE_INT_ENABLE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:31"]
    #[inline(always)]
    pub fn register(&mut self) -> REGISTER_W {
        REGISTER_W { w: self }
    }
    #[doc = "Bit 0 - Enable the watchdog timer edge interrupt"]
    #[inline(always)]
    pub fn wdt_edge_int_enable(&mut self) -> WDT_EDGE_INT_ENABLE_W {
        WDT_EDGE_INT_ENABLE_W { w: self }
    }
    #[doc = "Bit 1 - Enable the timer1 edge interrupt"]
    #[inline(always)]
    pub fn timer1_edge_int_enable(&mut self) -> TIMER1_EDGE_INT_ENABLE_W {
        TIMER1_EDGE_INT_ENABLE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "EDGE_INT_ENABLE\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [edge_int_enable](index.html) module"]
pub struct EDGE_INT_ENABLE_SPEC;
impl crate::RegisterSpec for EDGE_INT_ENABLE_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [edge_int_enable::R](R) reader structure"]
impl crate::Readable for EDGE_INT_ENABLE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [edge_int_enable::W](W) writer structure"]
impl crate::Writable for EDGE_INT_ENABLE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EDGE_INT_ENABLE to value 0"]
impl crate::Resettable for EDGE_INT_ENABLE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
