#![doc = "Peripheral access API for ESP32-S3 microcontrollers (generated using svd2rust v0.22.2 ( ))\n\nYou can find an overview of the generated API [here]
.\n\nAPI features to be included in the [next]
 svd2rust release can be generated by cloning the svd2rust [repository]
, checking out the above commit, and running `cargo doc --open`.\n\n[here]
: https://docs.rs/svd2rust/0.22.2/svd2rust/#peripheral-api\n[next]
: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]
: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 3;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn I2C_MST();
    fn UHCI0();
    fn GPIO();
    fn GPIO_NMI();
    fn SPI1();
    fn SPI2();
    fn SPI3();
    fn I2S0();
    fn I2S1();
    fn UART0();
    fn UART1();
    fn UART2();
    fn PWM0();
    fn PWM1();
    fn LEDC();
    fn EFUSE();
    fn RTC_CORE();
    fn PCNT();
    fn I2C_EXT0();
    fn I2C_EXT1();
    fn TG0_T0_LEVEL();
    fn TG0_T1_LEVEL();
    fn TG0_WDT_LEVEL();
    fn TG1_T0_LEVEL();
    fn TG1_T1_LEVEL();
    fn TG1_WDT_LEVEL();
    fn SPI_MEM_REJECT();
    fn APB_ADC();
    fn DMA_IN_CH0();
    fn DMA_IN_CH1();
    fn DMA_IN_CH2();
    fn DMA_IN_CH3();
    fn DMA_IN_CH4();
    fn DMA_OUT_CH0();
    fn DMA_OUT_CH1();
    fn DMA_OUT_CH2();
    fn DMA_OUT_CH3();
    fn DMA_OUT_CH4();
    fn RSA();
    fn AES();
    fn SHA();
    fn ASSIST_DEBUG();
    fn APB_PMS_MONITOR_VIOLATE();
    fn CORE_0_IRAM0_PMS_MONITOR_VIOLATE();
    fn CORE_0_DRAM0_PMS_MONITOR_VIOLATE();
    fn CORE_0_PIF_PMS_MONITOR_VIOLATE();
    fn CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE();
    fn CORE_1_IRAM0_PMS_MONITOR_VIOLATE();
    fn CORE_1_DRAM0_PMS_MONITOR_VIOLATE();
    fn CORE_1_PIF_PMS_MONITOR_VIOLATE();
    fn CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE();
    fn CACHE_CORE0_ACS();
    fn CACHE_CORE1_ACS();
    fn USB_DEVICE();
    fn PERI_BACKUP();
    fn DMA_EXTMEM_REJECT();
}
#[doc(hidden)]
pub union Vector {
    pub _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
pub static __INTERRUPTS: [Vector; 99] = [
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: I2C_MST },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: UHCI0 },
    Vector { _reserved: 0 },
    Vector { _handler: GPIO },
    Vector { _handler: GPIO_NMI },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: SPI1 },
    Vector { _handler: SPI2 },
    Vector { _handler: SPI3 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: I2S0 },
    Vector { _handler: I2S1 },
    Vector { _handler: UART0 },
    Vector { _handler: UART1 },
    Vector { _handler: UART2 },
    Vector { _reserved: 0 },
    Vector { _handler: PWM0 },
    Vector { _handler: PWM1 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: LEDC },
    Vector { _handler: EFUSE },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: RTC_CORE },
    Vector { _reserved: 0 },
    Vector { _handler: PCNT },
    Vector { _handler: I2C_EXT0 },
    Vector { _handler: I2C_EXT1 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: TG0_T0_LEVEL,
    },
    Vector {
        _handler: TG0_T1_LEVEL,
    },
    Vector {
        _handler: TG0_WDT_LEVEL,
    },
    Vector {
        _handler: TG1_T0_LEVEL,
    },
    Vector {
        _handler: TG1_T1_LEVEL,
    },
    Vector {
        _handler: TG1_WDT_LEVEL,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: SPI_MEM_REJECT,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: APB_ADC },
    Vector {
        _handler: DMA_IN_CH0,
    },
    Vector {
        _handler: DMA_IN_CH1,
    },
    Vector {
        _handler: DMA_IN_CH2,
    },
    Vector {
        _handler: DMA_IN_CH3,
    },
    Vector {
        _handler: DMA_IN_CH4,
    },
    Vector {
        _handler: DMA_OUT_CH0,
    },
    Vector {
        _handler: DMA_OUT_CH1,
    },
    Vector {
        _handler: DMA_OUT_CH2,
    },
    Vector {
        _handler: DMA_OUT_CH3,
    },
    Vector {
        _handler: DMA_OUT_CH4,
    },
    Vector { _handler: RSA },
    Vector { _handler: AES },
    Vector { _handler: SHA },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: ASSIST_DEBUG,
    },
    Vector {
        _handler: APB_PMS_MONITOR_VIOLATE,
    },
    Vector {
        _handler: CORE_0_IRAM0_PMS_MONITOR_VIOLATE,
    },
    Vector {
        _handler: CORE_0_DRAM0_PMS_MONITOR_VIOLATE,
    },
    Vector {
        _handler: CORE_0_PIF_PMS_MONITOR_VIOLATE,
    },
    Vector {
        _handler: CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE,
    },
    Vector {
        _handler: CORE_1_IRAM0_PMS_MONITOR_VIOLATE,
    },
    Vector {
        _handler: CORE_1_DRAM0_PMS_MONITOR_VIOLATE,
    },
    Vector {
        _handler: CORE_1_PIF_PMS_MONITOR_VIOLATE,
    },
    Vector {
        _handler: CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE,
    },
    Vector { _reserved: 0 },
    Vector {
        _handler: CACHE_CORE0_ACS,
    },
    Vector {
        _handler: CACHE_CORE1_ACS,
    },
    Vector {
        _handler: USB_DEVICE,
    },
    Vector {
        _handler: PERI_BACKUP,
    },
    Vector {
        _handler: DMA_EXTMEM_REJECT,
    },
];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
#[repr(u16)]
pub enum Interrupt {
    #[doc = "11 - I2C_MST"]
    I2C_MST = 11,
    #[doc = "14 - UHCI0"]
    UHCI0 = 14,
    #[doc = "16 - GPIO"]
    GPIO = 16,
    #[doc = "17 - GPIO_NMI"]
    GPIO_NMI = 17,
    #[doc = "20 - SPI1"]
    SPI1 = 20,
    #[doc = "21 - SPI2"]
    SPI2 = 21,
    #[doc = "22 - SPI3"]
    SPI3 = 22,
    #[doc = "25 - I2S0"]
    I2S0 = 25,
    #[doc = "26 - I2S1"]
    I2S1 = 26,
    #[doc = "27 - UART0"]
    UART0 = 27,
    #[doc = "28 - UART1"]
    UART1 = 28,
    #[doc = "29 - UART2"]
    UART2 = 29,
    #[doc = "31 - PWM0"]
    PWM0 = 31,
    #[doc = "32 - PWM1"]
    PWM1 = 32,
    #[doc = "35 - LEDC"]
    LEDC = 35,
    #[doc = "36 - EFUSE"]
    EFUSE = 36,
    #[doc = "39 - RTC_CORE"]
    RTC_CORE = 39,
    #[doc = "41 - PCNT"]
    PCNT = 41,
    #[doc = "42 - I2C_EXT0"]
    I2C_EXT0 = 42,
    #[doc = "43 - I2C_EXT1"]
    I2C_EXT1 = 43,
    #[doc = "50 - TG0_T0_LEVEL"]
    TG0_T0_LEVEL = 50,
    #[doc = "51 - TG0_T1_LEVEL"]
    TG0_T1_LEVEL = 51,
    #[doc = "52 - TG0_WDT_LEVEL"]
    TG0_WDT_LEVEL = 52,
    #[doc = "53 - TG1_T0_LEVEL"]
    TG1_T0_LEVEL = 53,
    #[doc = "54 - TG1_T1_LEVEL"]
    TG1_T1_LEVEL = 54,
    #[doc = "55 - TG1_WDT_LEVEL"]
    TG1_WDT_LEVEL = 55,
    #[doc = "60 - SPI_MEM_REJECT"]
    SPI_MEM_REJECT = 60,
    #[doc = "65 - APB_ADC"]
    APB_ADC = 65,
    #[doc = "66 - DMA_IN_CH0"]
    DMA_IN_CH0 = 66,
    #[doc = "67 - DMA_IN_CH1"]
    DMA_IN_CH1 = 67,
    #[doc = "68 - DMA_IN_CH2"]
    DMA_IN_CH2 = 68,
    #[doc = "69 - DMA_IN_CH3"]
    DMA_IN_CH3 = 69,
    #[doc = "70 - DMA_IN_CH4"]
    DMA_IN_CH4 = 70,
    #[doc = "71 - DMA_OUT_CH0"]
    DMA_OUT_CH0 = 71,
    #[doc = "72 - DMA_OUT_CH1"]
    DMA_OUT_CH1 = 72,
    #[doc = "73 - DMA_OUT_CH2"]
    DMA_OUT_CH2 = 73,
    #[doc = "74 - DMA_OUT_CH3"]
    DMA_OUT_CH3 = 74,
    #[doc = "75 - DMA_OUT_CH4"]
    DMA_OUT_CH4 = 75,
    #[doc = "76 - RSA"]
    RSA = 76,
    #[doc = "77 - AES"]
    AES = 77,
    #[doc = "78 - SHA"]
    SHA = 78,
    #[doc = "83 - ASSIST_DEBUG"]
    ASSIST_DEBUG = 83,
    #[doc = "84 - APB_PMS_MONITOR_VIOLATE"]
    APB_PMS_MONITOR_VIOLATE = 84,
    #[doc = "85 - CORE_0_IRAM0_PMS_MONITOR_VIOLATE"]
    CORE_0_IRAM0_PMS_MONITOR_VIOLATE = 85,
    #[doc = "86 - CORE_0_DRAM0_PMS_MONITOR_VIOLATE"]
    CORE_0_DRAM0_PMS_MONITOR_VIOLATE = 86,
    #[doc = "87 - CORE_0_PIF_PMS_MONITOR_VIOLATE"]
    CORE_0_PIF_PMS_MONITOR_VIOLATE = 87,
    #[doc = "88 - CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE"]
    CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE = 88,
    #[doc = "89 - CORE_1_IRAM0_PMS_MONITOR_VIOLATE"]
    CORE_1_IRAM0_PMS_MONITOR_VIOLATE = 89,
    #[doc = "90 - CORE_1_DRAM0_PMS_MONITOR_VIOLATE"]
    CORE_1_DRAM0_PMS_MONITOR_VIOLATE = 90,
    #[doc = "91 - CORE_1_PIF_PMS_MONITOR_VIOLATE"]
    CORE_1_PIF_PMS_MONITOR_VIOLATE = 91,
    #[doc = "92 - CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE"]
    CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE = 92,
    #[doc = "94 - CACHE_CORE0_ACS"]
    CACHE_CORE0_ACS = 94,
    #[doc = "95 - CACHE_CORE1_ACS"]
    CACHE_CORE1_ACS = 95,
    #[doc = "96 - USB_DEVICE"]
    USB_DEVICE = 96,
    #[doc = "97 - PERI_BACKUP"]
    PERI_BACKUP = 97,
    #[doc = "98 - DMA_EXTMEM_REJECT"]
    DMA_EXTMEM_REJECT = 98,
}
unsafe impl xtensa_lx::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        self as u16
    }
}
#[doc = r" TryFromInterruptError"]
#[derive(Debug, Copy, Clone)]
pub struct TryFromInterruptError(());
impl Interrupt {
    #[doc = r" Attempt to convert a given value into an `Interrupt`"]
    #[inline]
    pub fn try_from(value: u16) -> Result<Self, TryFromInterruptError> {
        match value {
            11 => Ok(Interrupt::I2C_MST),
            14 => Ok(Interrupt::UHCI0),
            16 => Ok(Interrupt::GPIO),
            17 => Ok(Interrupt::GPIO_NMI),
            20 => Ok(Interrupt::SPI1),
            21 => Ok(Interrupt::SPI2),
            22 => Ok(Interrupt::SPI3),
            25 => Ok(Interrupt::I2S0),
            26 => Ok(Interrupt::I2S1),
            27 => Ok(Interrupt::UART0),
            28 => Ok(Interrupt::UART1),
            29 => Ok(Interrupt::UART2),
            31 => Ok(Interrupt::PWM0),
            32 => Ok(Interrupt::PWM1),
            35 => Ok(Interrupt::LEDC),
            36 => Ok(Interrupt::EFUSE),
            39 => Ok(Interrupt::RTC_CORE),
            41 => Ok(Interrupt::PCNT),
            42 => Ok(Interrupt::I2C_EXT0),
            43 => Ok(Interrupt::I2C_EXT1),
            50 => Ok(Interrupt::TG0_T0_LEVEL),
            51 => Ok(Interrupt::TG0_T1_LEVEL),
            52 => Ok(Interrupt::TG0_WDT_LEVEL),
            53 => Ok(Interrupt::TG1_T0_LEVEL),
            54 => Ok(Interrupt::TG1_T1_LEVEL),
            55 => Ok(Interrupt::TG1_WDT_LEVEL),
            60 => Ok(Interrupt::SPI_MEM_REJECT),
            65 => Ok(Interrupt::APB_ADC),
            66 => Ok(Interrupt::DMA_IN_CH0),
            67 => Ok(Interrupt::DMA_IN_CH1),
            68 => Ok(Interrupt::DMA_IN_CH2),
            69 => Ok(Interrupt::DMA_IN_CH3),
            70 => Ok(Interrupt::DMA_IN_CH4),
            71 => Ok(Interrupt::DMA_OUT_CH0),
            72 => Ok(Interrupt::DMA_OUT_CH1),
            73 => Ok(Interrupt::DMA_OUT_CH2),
            74 => Ok(Interrupt::DMA_OUT_CH3),
            75 => Ok(Interrupt::DMA_OUT_CH4),
            76 => Ok(Interrupt::RSA),
            77 => Ok(Interrupt::AES),
            78 => Ok(Interrupt::SHA),
            83 => Ok(Interrupt::ASSIST_DEBUG),
            84 => Ok(Interrupt::APB_PMS_MONITOR_VIOLATE),
            85 => Ok(Interrupt::CORE_0_IRAM0_PMS_MONITOR_VIOLATE),
            86 => Ok(Interrupt::CORE_0_DRAM0_PMS_MONITOR_VIOLATE),
            87 => Ok(Interrupt::CORE_0_PIF_PMS_MONITOR_VIOLATE),
            88 => Ok(Interrupt::CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE),
            89 => Ok(Interrupt::CORE_1_IRAM0_PMS_MONITOR_VIOLATE),
            90 => Ok(Interrupt::CORE_1_DRAM0_PMS_MONITOR_VIOLATE),
            91 => Ok(Interrupt::CORE_1_PIF_PMS_MONITOR_VIOLATE),
            92 => Ok(Interrupt::CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE),
            94 => Ok(Interrupt::CACHE_CORE0_ACS),
            95 => Ok(Interrupt::CACHE_CORE1_ACS),
            96 => Ok(Interrupt::USB_DEVICE),
            97 => Ok(Interrupt::PERI_BACKUP),
            98 => Ok(Interrupt::DMA_EXTMEM_REJECT),
            _ => Err(TryFromInterruptError(())),
        }
    }
}
#[doc = "AES (Advanced Encryption Standard) Accelerator"]
pub struct AES {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for AES {}
impl AES {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const aes::RegisterBlock = 0x6003_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const aes::RegisterBlock {
        Self::PTR
    }
}
impl Deref for AES {
    type Target = aes::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for AES {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("AES").finish()
    }
}
#[doc = "AES (Advanced Encryption Standard) Accelerator"]
pub mod aes;
#[doc = "Advanced Peripheral Bus Controller"]
pub struct APB_CTRL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for APB_CTRL {}
impl APB_CTRL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const apb_ctrl::RegisterBlock = 0x6002_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const apb_ctrl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for APB_CTRL {
    type Target = apb_ctrl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for APB_CTRL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("APB_CTRL").finish()
    }
}
#[doc = "Advanced Peripheral Bus Controller"]
pub mod apb_ctrl;
#[doc = "Successive Approximation Register Analog to Digital Converter"]
pub struct APB_SARADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for APB_SARADC {}
impl APB_SARADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const apb_saradc::RegisterBlock = 0x6004_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const apb_saradc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for APB_SARADC {
    type Target = apb_saradc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for APB_SARADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("APB_SARADC").finish()
    }
}
#[doc = "Successive Approximation Register Analog to Digital Converter"]
pub mod apb_saradc;
#[doc = "Debug Assist"]
pub struct DEBUG_ASSIST {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DEBUG_ASSIST {}
impl DEBUG_ASSIST {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const debug_assist::RegisterBlock = 0x600c_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const debug_assist::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DEBUG_ASSIST {
    type Target = debug_assist::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DEBUG_ASSIST {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DEBUG_ASSIST").finish()
    }
}
#[doc = "Debug Assist"]
pub mod debug_assist;
#[doc = "DMA (Direct Memory Access) Controller"]
pub struct DMA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMA {}
impl DMA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dma::RegisterBlock = 0x6003_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dma::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMA {
    type Target = dma::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMA").finish()
    }
}
#[doc = "DMA (Direct Memory Access) Controller"]
pub mod dma;
#[doc = "Digital Signature"]
pub struct DS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DS {}
impl DS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ds::RegisterBlock = 0x6003_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ds::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DS {
    type Target = ds::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DS").finish()
    }
}
#[doc = "Digital Signature"]
pub mod ds;
#[doc = "eFuse Controller"]
pub struct EFUSE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EFUSE {}
impl EFUSE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const efuse::RegisterBlock = 0x6000_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const efuse::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EFUSE {
    type Target = efuse::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EFUSE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EFUSE").finish()
    }
}
#[doc = "eFuse Controller"]
pub mod efuse;
#[doc = "External Memory"]
pub struct EXTMEM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EXTMEM {}
impl EXTMEM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const extmem::RegisterBlock = 0x600c_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const extmem::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EXTMEM {
    type Target = extmem::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EXTMEM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EXTMEM").finish()
    }
}
#[doc = "External Memory"]
pub mod extmem;
#[doc = "General Purpose Input/Output"]
pub struct GPIO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO {}
impl GPIO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio::RegisterBlock = 0x6000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO {
    type Target = gpio::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO").finish()
    }
}
#[doc = "General Purpose Input/Output"]
pub mod gpio;
#[doc = "Sigma-Delta Modulation"]
pub struct GPIOSD {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIOSD {}
impl GPIOSD {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpiosd::RegisterBlock = 0x6000_4f00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpiosd::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIOSD {
    type Target = gpiosd::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIOSD {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIOSD").finish()
    }
}
#[doc = "Sigma-Delta Modulation"]
pub mod gpiosd;
#[doc = "HMAC (Hash-based Message Authentication Code) Accelerator"]
pub struct HMAC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for HMAC {}
impl HMAC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const hmac::RegisterBlock = 0x6003_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const hmac::RegisterBlock {
        Self::PTR
    }
}
impl Deref for HMAC {
    type Target = hmac::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for HMAC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("HMAC").finish()
    }
}
#[doc = "HMAC (Hash-based Message Authentication Code) Accelerator"]
pub mod hmac;
#[doc = "I2C (Inter-Integrated Circuit) Controller"]
pub struct I2C0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C0 {}
impl I2C0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x6001_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C0 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C0").finish()
    }
}
#[doc = "I2C (Inter-Integrated Circuit) Controller"]
pub mod i2c0;
#[doc = "I2C (Inter-Integrated Circuit) Controller"]
pub struct I2C1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C1 {}
impl I2C1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c0::RegisterBlock = 0x6002_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C1 {
    type Target = i2c0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C1").finish()
    }
}
#[doc = "I2C (Inter-Integrated Circuit) Controller"]
pub use i2c0 as i2c1;
#[doc = "I2S (Inter-IC Sound) Controller"]
pub struct I2S0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S0 {}
impl I2S0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s0::RegisterBlock = 0x6000_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S0 {
    type Target = i2s0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S0").finish()
    }
}
#[doc = "I2S (Inter-IC Sound) Controller"]
pub mod i2s0;
#[doc = "I2S (Inter-IC Sound) Controller"]
pub struct I2S1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S1 {}
impl I2S1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s1::RegisterBlock = 0x6002_d000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S1 {
    type Target = i2s1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S1").finish()
    }
}
#[doc = "I2S (Inter-IC Sound) Controller"]
pub mod i2s1;
#[doc = "Interrupt Core"]
pub struct INTERRUPT_CORE0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for INTERRUPT_CORE0 {}
impl INTERRUPT_CORE0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const interrupt_core0::RegisterBlock = 0x600c_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const interrupt_core0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for INTERRUPT_CORE0 {
    type Target = interrupt_core0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for INTERRUPT_CORE0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("INTERRUPT_CORE0").finish()
    }
}
#[doc = "Interrupt Core"]
pub mod interrupt_core0;
#[doc = "Interrupt Core"]
pub struct INTERRUPT_CORE1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for INTERRUPT_CORE1 {}
impl INTERRUPT_CORE1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const interrupt_core1::RegisterBlock = 0x600c_2800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const interrupt_core1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for INTERRUPT_CORE1 {
    type Target = interrupt_core1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for INTERRUPT_CORE1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("INTERRUPT_CORE1").finish()
    }
}
#[doc = "Interrupt Core"]
pub mod interrupt_core1;
#[doc = "Input/Output Multiplexer"]
pub struct IO_MUX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IO_MUX {}
impl IO_MUX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const io_mux::RegisterBlock = 0x6000_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const io_mux::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IO_MUX {
    type Target = io_mux::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IO_MUX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IO_MUX").finish()
    }
}
#[doc = "Input/Output Multiplexer"]
pub mod io_mux;
#[doc = "Peripheral LCD_CAM"]
pub struct LCD_CAM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LCD_CAM {}
impl LCD_CAM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const lcd_cam::RegisterBlock = 0x6004_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const lcd_cam::RegisterBlock {
        Self::PTR
    }
}
impl Deref for LCD_CAM {
    type Target = lcd_cam::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for LCD_CAM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("LCD_CAM").finish()
    }
}
#[doc = "Peripheral LCD_CAM"]
pub mod lcd_cam;
#[doc = "LED PWM (Pulse Width Modulation) Controller"]
pub struct LEDC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LEDC {}
impl LEDC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ledc::RegisterBlock = 0x6001_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ledc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for LEDC {
    type Target = ledc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for LEDC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("LEDC").finish()
    }
}
#[doc = "LED PWM (Pulse Width Modulation) Controller"]
pub mod ledc;
#[doc = "Pulse Count Controller"]
pub struct PCNT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PCNT {}
impl PCNT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pcnt::RegisterBlock = 0x6001_7000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pcnt::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PCNT {
    type Target = pcnt::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PCNT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PCNT").finish()
    }
}
#[doc = "Pulse Count Controller"]
pub mod pcnt;
#[doc = "Peripheral PERI_BACKUP"]
pub struct PERI_BACKUP {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PERI_BACKUP {}
impl PERI_BACKUP {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const peri_backup::RegisterBlock = 0x6002_a000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const peri_backup::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PERI_BACKUP {
    type Target = peri_backup::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PERI_BACKUP {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PERI_BACKUP").finish()
    }
}
#[doc = "Peripheral PERI_BACKUP"]
pub mod peri_backup;
#[doc = "Peripheral PWM0"]
pub struct PWM0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM0 {}
impl PWM0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm0::RegisterBlock = 0x6001_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM0 {
    type Target = pwm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM0").finish()
    }
}
#[doc = "Peripheral PWM0"]
pub mod pwm0;
#[doc = "Peripheral PWM0"]
pub struct PWM1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM1 {}
impl PWM1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm0::RegisterBlock = 0x6002_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM1 {
    type Target = pwm0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM1").finish()
    }
}
#[doc = "Peripheral PWM0"]
pub use pwm0 as pwm1;
#[doc = "Hardware random number generator"]
pub struct RNG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RNG {}
impl RNG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rng::RegisterBlock = 0x6003_4f6c as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rng::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RNG {
    type Target = rng::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RNG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RNG").finish()
    }
}
#[doc = "Hardware random number generator"]
pub mod rng;
#[doc = "RSA (Rivest Shamir Adleman) Accelerator"]
pub struct RSA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RSA {}
impl RSA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rsa::RegisterBlock = 0x6003_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rsa::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RSA {
    type Target = rsa::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RSA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RSA").finish()
    }
}
#[doc = "RSA (Rivest Shamir Adleman) Accelerator"]
pub mod rsa;
#[doc = "Real Time Controller"]
pub struct RTC_CNTL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC_CNTL {}
impl RTC_CNTL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc_cntl::RegisterBlock = 0x6000_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc_cntl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC_CNTL {
    type Target = rtc_cntl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC_CNTL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC_CNTL").finish()
    }
}
#[doc = "Real Time Controller"]
pub mod rtc_cntl;
#[doc = "Peripheral RTC_I2C"]
pub struct RTC_I2C {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC_I2C {}
impl RTC_I2C {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc_i2c::RegisterBlock = 0x6000_8c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc_i2c::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC_I2C {
    type Target = rtc_i2c::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC_I2C {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC_I2C").finish()
    }
}
#[doc = "Peripheral RTC_I2C"]
pub mod rtc_i2c;
#[doc = "Peripheral RTC_IO"]
pub struct RTC_IO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC_IO {}
impl RTC_IO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc_io::RegisterBlock = 0x6000_8400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc_io::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC_IO {
    type Target = rtc_io::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC_IO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC_IO").finish()
    }
}
#[doc = "Peripheral RTC_IO"]
pub mod rtc_io;
#[doc = "Peripheral SENSITIVE"]
pub struct SENSITIVE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SENSITIVE {}
impl SENSITIVE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sensitive::RegisterBlock = 0x600c_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sensitive::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SENSITIVE {
    type Target = sensitive::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SENSITIVE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SENSITIVE").finish()
    }
}
#[doc = "Peripheral SENSITIVE"]
pub mod sensitive;
#[doc = "SHA (Secure Hash Algorithm) Accelerator"]
pub struct SHA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SHA {}
impl SHA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sha::RegisterBlock = 0x6003_b000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sha::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SHA {
    type Target = sha::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SHA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SHA").finish()
    }
}
#[doc = "SHA (Secure Hash Algorithm) Accelerator"]
pub mod sha;
#[doc = "SPI (Serial Peripheral Interface) Controller"]
pub struct SPI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI0 {}
impl SPI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x6000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI0 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI0").finish()
    }
}
#[doc = "SPI (Serial Peripheral Interface) Controller"]
pub mod spi0;
#[doc = "SPI (Serial Peripheral Interface) Controller"]
pub struct SPI1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI1 {}
impl SPI1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi1::RegisterBlock = 0x6000_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI1 {
    type Target = spi1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI1").finish()
    }
}
#[doc = "SPI (Serial Peripheral Interface) Controller"]
pub mod spi1;
#[doc = "SPI (Serial Peripheral Interface) Controller"]
pub struct SPI2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI2 {}
impl SPI2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi2::RegisterBlock = 0x6002_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi2::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI2 {
    type Target = spi2::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI2").finish()
    }
}
#[doc = "SPI (Serial Peripheral Interface) Controller"]
pub mod spi2;
#[doc = "SPI (Serial Peripheral Interface) Controller"]
pub struct SPI3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI3 {}
impl SPI3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi2::RegisterBlock = 0x6002_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi2::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI3 {
    type Target = spi2::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI3").finish()
    }
}
#[doc = "SPI (Serial Peripheral Interface) Controller"]
pub use spi2 as spi3;
#[doc = "System"]
pub struct SYSTEM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSTEM {}
impl SYSTEM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const system::RegisterBlock = 0x600c_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const system::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSTEM {
    type Target = system::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSTEM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSTEM").finish()
    }
}
#[doc = "System"]
pub mod system;
#[doc = "Timer Group"]
pub struct TIMG0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMG0 {}
impl TIMG0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timg0::RegisterBlock = 0x6001_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timg0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMG0 {
    type Target = timg0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMG0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMG0").finish()
    }
}
#[doc = "Timer Group"]
pub mod timg0;
#[doc = "Timer Group"]
pub struct TIMG1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMG1 {}
impl TIMG1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timg0::RegisterBlock = 0x6002_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timg0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMG1 {
    type Target = timg0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMG1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMG1").finish()
    }
}
#[doc = "Timer Group"]
pub use timg0 as timg1;
#[doc = "UART (Universal Asynchronous Receiver-Transmitter) Controller"]
pub struct UART0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART0 {}
impl UART0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x6000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART0 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART0").finish()
    }
}
#[doc = "UART (Universal Asynchronous Receiver-Transmitter) Controller"]
pub mod uart0;
#[doc = "UART (Universal Asynchronous Receiver-Transmitter) Controller"]
pub struct UART1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART1 {}
impl UART1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x6001_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART1 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART1").finish()
    }
}
#[doc = "UART (Universal Asynchronous Receiver-Transmitter) Controller"]
pub use uart0 as uart1;
#[doc = "UART (Universal Asynchronous Receiver-Transmitter) Controller"]
pub struct UART2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART2 {}
impl UART2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x6002_e000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART2 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART2").finish()
    }
}
#[doc = "UART (Universal Asynchronous Receiver-Transmitter) Controller"]
pub use uart0 as uart2;
#[doc = "Universal Host Controller Interface"]
pub struct UHCI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UHCI0 {}
impl UHCI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uhci0::RegisterBlock = 0x6001_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uhci0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UHCI0 {
    type Target = uhci0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UHCI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UHCI0").finish()
    }
}
#[doc = "Universal Host Controller Interface"]
pub mod uhci0;
#[doc = "Universal Host Controller Interface"]
pub struct UHCI1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UHCI1 {}
impl UHCI1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uhci0::RegisterBlock = 0x6000_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uhci0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UHCI1 {
    type Target = uhci0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UHCI1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UHCI1").finish()
    }
}
#[doc = "Universal Host Controller Interface"]
pub use uhci0 as uhci1;
#[doc = "Peripheral USB_DEVICE"]
pub struct USB_DEVICE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB_DEVICE {}
impl USB_DEVICE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb_device::RegisterBlock = 0x6003_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb_device::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB_DEVICE {
    type Target = usb_device::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB_DEVICE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB_DEVICE").finish()
    }
}
#[doc = "Peripheral USB_DEVICE"]
pub mod usb_device;
#[doc = "Peripheral USB_WRAP"]
pub struct USB_WRAP {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB_WRAP {}
impl USB_WRAP {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb_wrap::RegisterBlock = 0x6003_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb_wrap::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB_WRAP {
    type Target = usb_wrap::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB_WRAP {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB_WRAP").finish()
    }
}
#[doc = "Peripheral USB_WRAP"]
pub mod usb_wrap;
#[doc = "Peripheral WCL"]
pub struct WCL {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WCL {}
impl WCL {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wcl::RegisterBlock = 0x600d_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wcl::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WCL {
    type Target = wcl::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WCL {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WCL").finish()
    }
}
#[doc = "Peripheral WCL"]
pub mod wcl;
#[doc = "XTS-AES-128 Flash Encryption"]
pub struct XTS_AES {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for XTS_AES {}
impl XTS_AES {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const xts_aes::RegisterBlock = 0x600c_c000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const xts_aes::RegisterBlock {
        Self::PTR
    }
}
impl Deref for XTS_AES {
    type Target = xts_aes::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for XTS_AES {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("XTS_AES").finish()
    }
}
#[doc = "XTS-AES-128 Flash Encryption"]
pub mod xts_aes;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "AES"]
    pub AES: AES,
    #[doc = "APB_CTRL"]
    pub APB_CTRL: APB_CTRL,
    #[doc = "APB_SARADC"]
    pub APB_SARADC: APB_SARADC,
    #[doc = "DEBUG_ASSIST"]
    pub DEBUG_ASSIST: DEBUG_ASSIST,
    #[doc = "DMA"]
    pub DMA: DMA,
    #[doc = "DS"]
    pub DS: DS,
    #[doc = "EFUSE"]
    pub EFUSE: EFUSE,
    #[doc = "EXTMEM"]
    pub EXTMEM: EXTMEM,
    #[doc = "GPIO"]
    pub GPIO: GPIO,
    #[doc = "GPIOSD"]
    pub GPIOSD: GPIOSD,
    #[doc = "HMAC"]
    pub HMAC: HMAC,
    #[doc = "I2C0"]
    pub I2C0: I2C0,
    #[doc = "I2C1"]
    pub I2C1: I2C1,
    #[doc = "I2S0"]
    pub I2S0: I2S0,
    #[doc = "I2S1"]
    pub I2S1: I2S1,
    #[doc = "INTERRUPT_CORE0"]
    pub INTERRUPT_CORE0: INTERRUPT_CORE0,
    #[doc = "INTERRUPT_CORE1"]
    pub INTERRUPT_CORE1: INTERRUPT_CORE1,
    #[doc = "IO_MUX"]
    pub IO_MUX: IO_MUX,
    #[doc = "LCD_CAM"]
    pub LCD_CAM: LCD_CAM,
    #[doc = "LEDC"]
    pub LEDC: LEDC,
    #[doc = "PCNT"]
    pub PCNT: PCNT,
    #[doc = "PERI_BACKUP"]
    pub PERI_BACKUP: PERI_BACKUP,
    #[doc = "PWM0"]
    pub PWM0: PWM0,
    #[doc = "PWM1"]
    pub PWM1: PWM1,
    #[doc = "RNG"]
    pub RNG: RNG,
    #[doc = "RSA"]
    pub RSA: RSA,
    #[doc = "RTC_CNTL"]
    pub RTC_CNTL: RTC_CNTL,
    #[doc = "RTC_I2C"]
    pub RTC_I2C: RTC_I2C,
    #[doc = "RTC_IO"]
    pub RTC_IO: RTC_IO,
    #[doc = "SENSITIVE"]
    pub SENSITIVE: SENSITIVE,
    #[doc = "SHA"]
    pub SHA: SHA,
    #[doc = "SPI0"]
    pub SPI0: SPI0,
    #[doc = "SPI1"]
    pub SPI1: SPI1,
    #[doc = "SPI2"]
    pub SPI2: SPI2,
    #[doc = "SPI3"]
    pub SPI3: SPI3,
    #[doc = "SYSTEM"]
    pub SYSTEM: SYSTEM,
    #[doc = "TIMG0"]
    pub TIMG0: TIMG0,
    #[doc = "TIMG1"]
    pub TIMG1: TIMG1,
    #[doc = "UART0"]
    pub UART0: UART0,
    #[doc = "UART1"]
    pub UART1: UART1,
    #[doc = "UART2"]
    pub UART2: UART2,
    #[doc = "UHCI0"]
    pub UHCI0: UHCI0,
    #[doc = "UHCI1"]
    pub UHCI1: UHCI1,
    #[doc = "USB_DEVICE"]
    pub USB_DEVICE: USB_DEVICE,
    #[doc = "USB_WRAP"]
    pub USB_WRAP: USB_WRAP,
    #[doc = "WCL"]
    pub WCL: WCL,
    #[doc = "XTS_AES"]
    pub XTS_AES: XTS_AES,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        xtensa_lx::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            AES: AES {
                _marker: PhantomData,
            },
            APB_CTRL: APB_CTRL {
                _marker: PhantomData,
            },
            APB_SARADC: APB_SARADC {
                _marker: PhantomData,
            },
            DEBUG_ASSIST: DEBUG_ASSIST {
                _marker: PhantomData,
            },
            DMA: DMA {
                _marker: PhantomData,
            },
            DS: DS {
                _marker: PhantomData,
            },
            EFUSE: EFUSE {
                _marker: PhantomData,
            },
            EXTMEM: EXTMEM {
                _marker: PhantomData,
            },
            GPIO: GPIO {
                _marker: PhantomData,
            },
            GPIOSD: GPIOSD {
                _marker: PhantomData,
            },
            HMAC: HMAC {
                _marker: PhantomData,
            },
            I2C0: I2C0 {
                _marker: PhantomData,
            },
            I2C1: I2C1 {
                _marker: PhantomData,
            },
            I2S0: I2S0 {
                _marker: PhantomData,
            },
            I2S1: I2S1 {
                _marker: PhantomData,
            },
            INTERRUPT_CORE0: INTERRUPT_CORE0 {
                _marker: PhantomData,
            },
            INTERRUPT_CORE1: INTERRUPT_CORE1 {
                _marker: PhantomData,
            },
            IO_MUX: IO_MUX {
                _marker: PhantomData,
            },
            LCD_CAM: LCD_CAM {
                _marker: PhantomData,
            },
            LEDC: LEDC {
                _marker: PhantomData,
            },
            PCNT: PCNT {
                _marker: PhantomData,
            },
            PERI_BACKUP: PERI_BACKUP {
                _marker: PhantomData,
            },
            PWM0: PWM0 {
                _marker: PhantomData,
            },
            PWM1: PWM1 {
                _marker: PhantomData,
            },
            RNG: RNG {
                _marker: PhantomData,
            },
            RSA: RSA {
                _marker: PhantomData,
            },
            RTC_CNTL: RTC_CNTL {
                _marker: PhantomData,
            },
            RTC_I2C: RTC_I2C {
                _marker: PhantomData,
            },
            RTC_IO: RTC_IO {
                _marker: PhantomData,
            },
            SENSITIVE: SENSITIVE {
                _marker: PhantomData,
            },
            SHA: SHA {
                _marker: PhantomData,
            },
            SPI0: SPI0 {
                _marker: PhantomData,
            },
            SPI1: SPI1 {
                _marker: PhantomData,
            },
            SPI2: SPI2 {
                _marker: PhantomData,
            },
            SPI3: SPI3 {
                _marker: PhantomData,
            },
            SYSTEM: SYSTEM {
                _marker: PhantomData,
            },
            TIMG0: TIMG0 {
                _marker: PhantomData,
            },
            TIMG1: TIMG1 {
                _marker: PhantomData,
            },
            UART0: UART0 {
                _marker: PhantomData,
            },
            UART1: UART1 {
                _marker: PhantomData,
            },
            UART2: UART2 {
                _marker: PhantomData,
            },
            UHCI0: UHCI0 {
                _marker: PhantomData,
            },
            UHCI1: UHCI1 {
                _marker: PhantomData,
            },
            USB_DEVICE: USB_DEVICE {
                _marker: PhantomData,
            },
            USB_WRAP: USB_WRAP {
                _marker: PhantomData,
            },
            WCL: WCL {
                _marker: PhantomData,
            },
            XTS_AES: XTS_AES {
                _marker: PhantomData,
            },
        }
    }
}
